/*
 *  
 *  $Id: herramientamarcado.cpp 4869 2012-04-19 11:47:15Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/menu.h>
#include <api/globals.h>


#include <api/iwidgetsmanager.h>
#include "herramientamarcado.h"
#include <widgets/wflecha.h>
#include <widgets/welipse.h>
#include <widgets/wpunto.h>
#include <widgets/wtrapezoide.h>
#include <widgets/wpoligono.h>
#include <resources/ginkgoresourcemanager.h>


#include <iostream>
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>
#include <wx/xml/xml.h>

#define USAR_FLECHA     1451
#define USAR_ELIPSE     1452
#define USAR_TRAPEZOIDE 1453
#define USAR_POLIGONO   1454
#define USAR_PUNTO      1455

namespace GNC {
	namespace GUI {
		class EventHandlerMarkingTools: public wxEvtHandler {
		public:
			EventHandlerMarkingTools(wxWindow* pParent, GNC::HerramientaMarcado* pHerramienta):wxEvtHandler()
			{
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;
				// Connect Events
				m_pParent->Connect(USAR_PUNTO, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerMarkingTools::OnHerramientaPuntoClick),NULL,this);
				m_pParent->Connect(USAR_FLECHA, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerMarkingTools::OnHerramientaFlechaClick),NULL,this);
				m_pParent->Connect(USAR_ELIPSE, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerMarkingTools::OnHerramientaElipseClick),NULL,this);
				m_pParent->Connect(USAR_TRAPEZOIDE, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerMarkingTools::OnHerramientaTrapezoideClick),NULL,this);
				m_pParent->Connect(USAR_POLIGONO,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerMarkingTools::OnHerramientaPoligonoClick),NULL,this);
			}

			~EventHandlerMarkingTools()
			{
				m_pParent->Disconnect(USAR_PUNTO, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerMarkingTools::OnHerramientaPuntoClick),NULL,this);
				m_pParent->Disconnect(USAR_FLECHA, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerMarkingTools::OnHerramientaFlechaClick),NULL,this);
				m_pParent->Disconnect(USAR_ELIPSE, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerMarkingTools::OnHerramientaElipseClick),NULL,this);
				m_pParent->Disconnect(USAR_TRAPEZOIDE, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerMarkingTools::OnHerramientaTrapezoideClick),NULL,this);
				m_pParent->Disconnect(USAR_POLIGONO,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerMarkingTools::OnHerramientaPoligonoClick),NULL,this);
				m_pParent = NULL;
				m_pHerramienta = NULL;
			}

			
			virtual void OnHerramientaPuntoClick( wxCommandEvent& event ){
				m_pHerramienta->SetTipoMarcado(GNC::HerramientaMarcado::TW_Punto);
				event.Skip(false);
			}

			virtual void OnHerramientaFlechaClick( wxCommandEvent& event ){
				m_pHerramienta->SetTipoMarcado(GNC::HerramientaMarcado::TW_Flecha);
				event.Skip(false);
			}

			virtual void OnHerramientaElipseClick( wxCommandEvent& event ){
				m_pHerramienta->SetTipoMarcado(GNC::HerramientaMarcado::TW_Elipse);
				event.Skip(false);
			}

			virtual void OnHerramientaTrapezoideClick( wxCommandEvent& event ){
				m_pHerramienta->SetTipoMarcado(GNC::HerramientaMarcado::TW_Trapezoide);
				event.Skip(false);
			}

			virtual void OnHerramientaPoligonoClick( wxCommandEvent& event ){
				m_pHerramienta->SetTipoMarcado(GNC::HerramientaMarcado::TW_Poligono);
				event.Skip(false);
			}			

			GNC::HerramientaMarcado* m_pHerramienta;
			wxWindow* m_pParent;
		};

		class MenuItemMarking : public wxMenuItem {
		public:
			MenuItemMarking(wxWindow* pParent, long id, const wxString& nombre, const wxBitmap& bitmap, wxMenu* pMenuPadre, GNC::HerramientaMarcado* pHerramienta):wxMenuItem(pMenuPadre,id,nombre,nombre,wxITEM_NORMAL) {
				pEventHandler = new EventHandlerMarkingTools(pParent,pHerramienta);
#ifdef __WXMSW__
				SetBitmaps(bitmap);
				//#else
				//	SetBitmap(GinkgoResourcesManager::BarraRejilla::GetIcoVerRejilla());
#endif
			}

			~MenuItemMarking() {
				if(pEventHandler != NULL) {
					delete pEventHandler;
					pEventHandler = NULL;
				}
			}

			EventHandlerMarkingTools* pEventHandler;
		};
	}
}

GNC::HerramientaMarcado::HerramientaMarcado() {
	m_Activa = false;
	m_pContratoActivo = NULL;
	m_pBuilder = NULL;
	m_IsDropDown = true;
	m_MarcadoActivo = TW_Punto;
	m_Descripcion = _Std("Marking Tools\tCtrl+M");
	m_AcceleratorCode = m_Descripcion[m_Descripcion.size() - 1];
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoMarcado();
}

GNC::HerramientaMarcado::~HerramientaMarcado()
{
}

wxXmlNode* GNC::HerramientaMarcado::Serializar(GNC::GCS::IVista* pVista, long vid, const std::string nombreMedicoSerializa)
{
	//se cogen todas los widgets regla de los contratos con ese vid
	typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;
	//se cogen todas los widgets regla de los contratos con ese vid
	GNC::GCS::ListaWidgets listaWidgets;
	for (ICConcreto::IteradorMapaContratos it = ICConcreto::m_Contratos.begin(); it != ICConcreto::m_Contratos.end(); it++) {
		if((*it).first == pVista){
			for (ICConcreto::IteradorListaContratos it2 = (*it).second->begin(); it2 != (*it).second->end(); it2++) {
				GNC::GCS::IContratoWidgets* pC = (*it2);
				GNC::GCS::ListaWidgets listaWidgetsTmp;
				if(pC->GetManager() != NULL){
					pC->GetManager()->GetListaWidgetsSubVista(vid,listaWidgetsTmp);
					listaWidgets.splice(listaWidgets.begin(),listaWidgetsTmp);
				}
			}
		}
	}

	wxXmlNode* resultado = NULL;
	if(listaWidgets.size()>0){
		resultado = new wxXmlNode(NULL,wxXML_ELEMENT_NODE,wxT("marcado"));
		resultado->AddProperty(wxT("id"),wxString::Format(wxT("%d"),this->ID));
		for (GNC::GCS::IWidgetsManager::IteradorListaWidgets it = listaWidgets.begin();  it!= listaWidgets.end(); it++){
			GNC::GCS::Widgets::WPunto* pPunto = dynamic_cast<GNC::GCS::Widgets::WPunto*>((*it));
			if( pPunto != NULL && pPunto->EsMarcador()){ //semillas
				//se pillan las del grupo
				if((*it)->GetGID() == (long)(this)){
					resultado->AddChild(pPunto->Serializar(nombreMedicoSerializa));
				}
			} else {
				GNC::GCS::Widgets::WFlecha* pFlecha = dynamic_cast<GNC::GCS::Widgets::WFlecha*>((*it));
				if( pFlecha != NULL && pFlecha->EsMarcador()){ //flechas
					resultado->AddChild(pFlecha->Serializar(nombreMedicoSerializa));
				} else {
					GNC::GCS::Widgets::WElipse* pElipse = dynamic_cast<GNC::GCS::Widgets::WElipse*>((*it));
					if( pElipse != NULL && pElipse->EsMarcador()){ //elipse
						resultado->AddChild(pElipse->Serializar(nombreMedicoSerializa));
					} else {
						GNC::GCS::Widgets::WPoligono* pPoligono = dynamic_cast<GNC::GCS::Widgets::WPoligono*>((*it));
						if( pPoligono != NULL && pPoligono->EsMarcador()){ //poligono
							resultado->AddChild(pPoligono->Serializar(nombreMedicoSerializa));
						} else {
							GNC::GCS::Widgets::WTrapezoide* pTrapezoide = dynamic_cast<GNC::GCS::Widgets::WTrapezoide*>((*it));
							if( pTrapezoide != NULL && pTrapezoide->EsMarcador()){ //trapezoide
								resultado->AddChild(pTrapezoide->Serializar(nombreMedicoSerializa));
							}
						}
					}
				}
			}
		}
	}
	return resultado;
}

void GNC::HerramientaMarcado::Deserializar(GNC::GCS::IVista* pVista, long vid, wxXmlNode* nodo)
{
	if(nodo->GetPropVal(wxT("id"),wxT("")) != wxString::Format(wxT("%d"),this->ID)){
		std::cerr<< "Ha ocurrido un error al desserializar la herramienta marcado"<<std::endl;
	}

	typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;

	for (ICConcreto::IteradorMapaContratos it = ICConcreto::m_Contratos.begin(); it != ICConcreto::m_Contratos.end(); it++) {
		if((*it).first == pVista){

			for (ICConcreto::IteradorListaContratos it2 = (*it).second->begin(); it2 != (*it).second->end(); it2++) {
				GNC::GCS::IContratoWidgets* pC = (*it2);

				GNC::GCS::ListaWidgets listaWidgets;

				wxXmlNode *child = nodo->GetChildren();
				while (child) {
					if(child->GetName() == wxT("punto_widget")){
						GNC::GCS::Widgets::WPunto* pWidget = new GNC::GCS::Widgets::WPunto(pC->GetManager(), vid, (long)this, child);
						listaWidgets.push_back(pWidget);
					} else if (child->GetName() == wxT("flecha_widget")){
						GNC::GCS::Widgets::WFlecha* pWidget = new GNC::GCS::Widgets::WFlecha(pC->GetManager(), vid, child);
						listaWidgets.push_back(pWidget);
					} else if (child->GetName() == wxT("elipse_widget")){
						GNC::GCS::Widgets::WElipse* pWidget = new GNC::GCS::Widgets::WElipse(pC->GetManager(), vid, (long)this, child);
						listaWidgets.push_back(pWidget);
					} else if (child->GetName() == wxT("poligono_widget")){
						GNC::GCS::Widgets::WPoligono* pWidget = new GNC::GCS::Widgets::WPoligono(pC->GetManager(), vid, child);
						listaWidgets.push_back(pWidget);
					} else if (child->GetName() == wxT("trapezoide_widget")){
						GNC::GCS::Widgets::WTrapezoide* pWidget = new GNC::GCS::Widgets::WTrapezoide(pC->GetManager(), vid, (long)this, child);
						listaWidgets.push_back(pWidget);
					}
					child = child->GetNext();
				}

				for (GNC::GCS::IWidgetsManager::IteradorListaWidgets itWidgets = listaWidgets.begin();  itWidgets!= listaWidgets.end(); itWidgets++){
					pC->GetManager()->InsertarWidget((*itWidgets),false);
				}
			}
		}
	}
}

//region "Realizacion de la interfaz IHerramienta"
void GNC::HerramientaMarcado::CrearPaneles( wxPanel* /*panel*/ )
{
	m_pAbstractPanelHerramientaOpciones =  NULL;
}
bool GNC::HerramientaMarcado::AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent)
{
	pMenuParent->Append(new GNC::GUI::MenuItemMarking(pParent,USAR_PUNTO,_("Point"), GinkgoResourcesManager::BarraMarcado::GetIcoPunto(),pMenuParent,this));
	pMenuParent->Append(new GNC::GUI::MenuItemMarking(pParent,USAR_FLECHA,_("Arrow"), GinkgoResourcesManager::BarraMarcado::GetIcoFlecha(),pMenuParent,this));
	pMenuParent->Append(new GNC::GUI::MenuItemMarking(pParent,USAR_ELIPSE,_("Ellipse"), GinkgoResourcesManager::BarraMarcado::GetIcoElipse(),pMenuParent,this));
	pMenuParent->Append(new GNC::GUI::MenuItemMarking(pParent,USAR_TRAPEZOIDE,_("Trapezoid"), GinkgoResourcesManager::BarraMarcado::GetIcoTrapezoide(),pMenuParent,this));
	pMenuParent->Append(new GNC::GUI::MenuItemMarking(pParent,USAR_POLIGONO,_("Polygon"), GinkgoResourcesManager::BarraMarcado::GetIcoPoligono(),pMenuParent,this));
	return true;
}

wxBitmap GNC::HerramientaMarcado::GetIcono()
{
	switch (m_MarcadoActivo) {
		case TW_Flecha:
			return GinkgoResourcesManager::BarraMarcado::GetIcoFlecha();
		case TW_Elipse:
			return GinkgoResourcesManager::BarraMarcado::GetIcoElipse();
		case TW_Trapezoide:
			return GinkgoResourcesManager::BarraMarcado::GetIcoTrapezoide();
		case TW_Poligono:
			return GinkgoResourcesManager::BarraMarcado::GetIcoPoligono();
		case TW_Punto:
			return GinkgoResourcesManager::BarraMarcado::GetIcoPunto();
		default:
			return GinkgoResourcesManager::BarraMarcado::GetIcoPunto();
	}
}

void GNC::HerramientaMarcado::ConectarContratoFalso(bool activar) {
	typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;
	if (ICConcreto::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	for (ICConcreto::IteradorListaContratos it = ICConcreto::m_pListaActiva->begin(); it != ICConcreto::m_pListaActiva->end(); it++) {
		GNC::GCS::IContratoWidgets* pC = (*it);
		if (pC->Inicializado()) {
			if (activar) {
				GTRACE("HerramientaMarcado: Conectando contrato falso de vista " << ICConcreto::m_pVistaActiva);
				pC->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);

			} else {
				GTRACE("HerramientaMarcado: Desconectando contrato falso de vista " << ICConcreto::m_pVistaActiva);
				pC->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			}
		}
	}
}

void GNC::HerramientaMarcado::SetVistaActiva(GNC::GCS::IVista* pVista) {
	GNC::GCS::IContratable<GNC::GCS::IContratoWidgets>::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaMarcado::SetVistaActiva(" <<  pVista << ")");
}

void GNC::HerramientaMarcado::ConectarContratos(bool activar) {

	if (ICConcreto::m_pListaActiva == NULL) {
		if (activar) {
			std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		} else {
			if (m_pBuilder != NULL) {
				delete m_pBuilder;
				m_pBuilder = NULL;
			}
		}
		return;
	}

	for (ICConcreto::IteradorListaContratos it = ICConcreto::m_pListaActiva->begin(); it != ICConcreto::m_pListaActiva->end(); it++) {
		GNC::GCS::IContratoWidgets* pC = (*it);
		if (pC->Inicializado()) {
			if (activar) {
				GTRACE("HerramientaMarcado: Conectando contratos de vista " << ICConcreto::m_pVistaActiva);
				m_pContratoActivo = pC;
				SetTipoMarcado(m_MarcadoActivo);
				pC->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				if (m_pBuilder != NULL) {
					pC->GetManager()->SetCursor(m_pBuilder->GetCursor());
				}
				else {
					pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				}

			} else {
				m_pContratoActivo = NULL;
				GTRACE( "HerramientaMarcado: Desconectando contratos de vista " << ICConcreto::m_pVistaActiva );
				pC->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				if (m_pBuilder != NULL) {
					delete m_pBuilder;
					m_pBuilder = NULL;
				}
			}
		}
	}
}

//endregion

//region "Eventos refinados desde los paneles"
void GNC::HerramientaMarcado::SetTipoMarcado(TipoMarcado tipo)
{
	if (m_MarcadoActivo == tipo && m_pBuilder != NULL) {
		return;
	}
	else {
		if (m_pBuilder != NULL) {
			delete m_pBuilder;
			m_pBuilder = NULL;
		}
		m_MarcadoActivo = tipo;
		if (m_Activa) {
			switch (m_MarcadoActivo) {
				case TW_Flecha:
					m_pBuilder = new GNC::GCS::Widgets::WFlechaBuilder(m_pContratoActivo->GetManager(), GetTriggerButton());
					break;
				case TW_Elipse:
					m_pBuilder = new GNC::GCS::Widgets::WElipseBuilder(m_pContratoActivo->GetManager(), GetTriggerButton(), (unsigned long)this);
					break;
				case TW_Trapezoide:
					m_pBuilder = new GNC::GCS::Widgets::WTrapezoideBuilder(m_pContratoActivo->GetManager(), GetTriggerButton(), (unsigned long)this);
					break;
				case TW_Poligono:
					m_pBuilder = new GNC::GCS::Widgets::WPoligonoBuilder(GNC::GCS::Widgets::MP_Normal, m_pContratoActivo->GetManager(), GetTriggerButton());
					break;
				case TW_Punto:
					{
						GNC::GCS::Widgets::WPuntoBuilder* pPuntoBuilder = new GNC::GCS::Widgets::WPuntoBuilder(m_pContratoActivo->GetManager(), GetTriggerButton(), (unsigned long)this);
						m_pBuilder = pPuntoBuilder;
					}
					break;
				default:
					std::cerr << "Error, Elemento de marcado no soportado." << std::endl;
					break;
				}
				if (m_pBuilder != NULL) {
					m_pContratoActivo->GetManager()->SetCursor(m_pBuilder->GetCursor());
				}
				else {
					m_pContratoActivo->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				}
		}
	}
}
//endregion
