/*
 *  
 *  $Id: importationdata.h 4784 2012-03-08 12:05:06Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <string>
#include <vector>
#include <yasper/yasper.h>
#include <api/imodelointegracion.h>


namespace GNC {
	namespace GUI {
		class EXTAPI ImportationData {
		public:
			typedef std::list<std::string> TListOfFiles;
			GnkPtr<GIL::IModeloIntegracion> m_pIntegrationModel;
			GIL::DICOM::TipoJerarquia baseImages;
			TListOfFiles m_SourceFiles;

			ImportationData()
			{
				m_pIntegrationModel = GnkPtr<GIL::IModeloIntegracion>(new GIL::IModeloIntegracion());
			}

			ImportationData(GnkPtr<GIL::IModeloIntegracion>& pModeloIntegracion)
			{
				if (pModeloIntegracion.IsValid()) {
					m_pIntegrationModel = pModeloIntegracion;
				} else {
					m_pIntegrationModel = GnkPtr<GIL::IModeloIntegracion>(new GIL::IModeloIntegracion());
				}
			}

			virtual ~ImportationData()
			{
			}			
		};
	};
};
