/*
 *  
 *  $Id: ipanelhistorial.h 3521 2011-03-16 14:54:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <vector>
#include <list>
#include <map>

#include <api/ievento.h>
#include <yasper/yasper.h>
#include <api/imodelointegracion.h>
#include <api/icontroladorhistorial.h>

#define ginkgoEVT_Core_HistorialSeleccionar         100
#define ginkgoEVT_Core_HistorialLayout              101
#define ginkgoEVT_Core_HistorialAbribleEliminado    102
#define ginkgoEVT_Core_HistorialRecargarHistorial   103
#define ginkgoEVT_Core_AddModeloHistorial           104
#define ginkgoEVT_Core_LimpiarHistorial             105
#define ginkgoEVT_Core_SetFocus                     106


class wxWindow;
namespace GNC {
	namespace GUI {
		//nodo seleccionable
		class ISeleccionableHistorial {
		protected:
			bool m_seleccionado;
		public:			
			ISeleccionableHistorial(){
				m_seleccionado = false;
			}
			~ISeleccionableHistorial(){
			}
			bool EstaSeleccionado()
			{
				return m_seleccionado;
			}
			virtual void Seleccionar(bool seleccionar, bool force=false) = 0;
		};

		//nodo abrible
		class IAbribleHistorial {
		protected:
			bool m_abierto;
		public:			
			IAbribleHistorial(){
				m_abierto = false;
			}
			~IAbribleHistorial(){
			}
			bool EstaAbierto()
			{
				return m_abierto;
			}
			virtual void Abrir(bool forzarEstudio = false) = 0;
			virtual void AddVista(GNC::GCS::IVista* pVista) = 0;
			virtual void VistaModificada(GNC::GCS::IVista* pVista) = 0;
			virtual void VistaGuardada(GNC::GCS::IVista* pVista) = 0;
			virtual void RemoveVista(GNC::GCS::IVista* pVista) = 0;
		};

		class INodoHistorial {
		public:
			typedef std::map<std::string,GNC::GUI::INodoHistorial*> TMapaHijos;
			INodoHistorial(INodoHistorial* pPadre,const std::string& clave) 
			{
				m_pPadre = pPadre;
				m_clave = clave;
			}
			~INodoHistorial() 
			{
				m_pPadre = NULL;
			}
			INodoHistorial* GetParentNode()
			{
				return m_pPadre;
			}

			bool Eliminar(INodoHistorial* pHijo) 
			{
				TMapaHijos::iterator it = m_mapaHijos.find(pHijo->GetClave());
				if(it != m_mapaHijos.end()){
					m_mapaHijos.erase(it);
					if(m_mapaHijos.size() == 0) {
						Eliminar();
						return false;
					}
				} 
				return true;
			}
			virtual void Detach(wxWindow* pHijo) = 0;
			virtual void Eliminar() = 0;
			const std::string& GetClave() 
			{
				return m_clave;
			}
			bool HayNodosAbiertos()
			{
				IAbribleHistorial* pAbrible = dynamic_cast<IAbribleHistorial*>(this);
				if (pAbrible != NULL)
				{
					if (pAbrible->EstaAbierto()) {
						return true;
					}
				}
				for(TMapaHijos::iterator it=m_mapaHijos.begin(); it!= m_mapaHijos.end(); it++) {
					pAbrible = dynamic_cast<IAbribleHistorial*>((*it).second);
					if (pAbrible != NULL)
					{
						if (pAbrible->EstaAbierto()) {
							return true;
						}
					} else {
						if ((*it).second->HayNodosAbiertos()) {
							return true;
						}
					}
				}
				return false;
			}

			void EliminarNodosNoAbiertos() {
				//se hace esto para evitar borrar elementos de un mapa que estamos recorriendo
				std::list<GNC::GUI::INodoHistorial*> listaHijos;

				for(TMapaHijos::iterator it=m_mapaHijos.begin(); it!= m_mapaHijos.end(); it++) {
					listaHijos.push_back((*it).second);
				}

				for (std::list<GNC::GUI::INodoHistorial*>::iterator it = listaHijos.begin(); it != listaHijos.end(); ++it) {
					IAbribleHistorial* pAbrible = dynamic_cast<IAbribleHistorial*>((*it));
					if (pAbrible != NULL)
					{
						if (!pAbrible->EstaAbierto()) {
							//se elimina
							(*it)->Eliminar();
						}
					} else {
						(*it)->EliminarNodosNoAbiertos();
					}
				}
			}
		protected:
			TMapaHijos m_mapaHijos;
			INodoHistorial* m_pPadre;
			std::string m_clave;
		};

		//eventos variados...
		//evento de seleccion
		namespace Eventos {
			class EventoSeleccionarHistorial: public GNC::GCS::Eventos::IEvento
			{
			public:
				EventoSeleccionarHistorial():GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_HistorialSeleccionar)
				{
					m_Nombre = "SeleccionarHistorial";
					m_pSeleccionable=NULL;
				}

				EventoSeleccionarHistorial(ISeleccionableHistorial* pSeleccionable ):GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_HistorialSeleccionar)
				{
					m_pSeleccionable = pSeleccionable;
				}

				~EventoSeleccionarHistorial()
				{
				}

				ISeleccionableHistorial* GetSeleccionable()
				{
					return m_pSeleccionable;
				}

			protected:
				ISeleccionableHistorial* m_pSeleccionable;
			};

			class EventoLayoutHistorial: public GNC::GCS::Eventos::IEvento
			{
			public:

				EventoLayoutHistorial():GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_HistorialLayout)
				{
					m_Nombre = "LayoutHistorial";
				}

				~EventoLayoutHistorial()
				{
				}
			protected:
			};

			class EventoSetFocusHistorial: public GNC::GCS::Eventos::IEvento
			{
			public:

				EventoSetFocusHistorial():GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_SetFocus)
				{
					m_Nombre = "SetFocusHistorial";
				}

				~EventoSetFocusHistorial()
				{
				}
			protected:
			};

			class EventoAbribleEliminado: public GNC::GCS::Eventos::IEvento
			{
				public:
				EventoAbribleEliminado():GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_HistorialAbribleEliminado)
				{
					m_Nombre = "SeleccionarHistorial";
				}

				EventoAbribleEliminado( const std::list<std::string>& UIDS ):GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_HistorialAbribleEliminado)
				{
					m_UIDS = UIDS;
				}

				~EventoAbribleEliminado()
				{
				}

				const std::list<std::string>& GetUIDs() {
					return m_UIDS;
				}

			protected:
				std::list<std::string> m_UIDS;
			};

		class EventoRecargarHistorial: public GNC::GCS::Eventos::IEvento
			{
				public:
				EventoRecargarHistorial():GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_HistorialRecargarHistorial)
				{
					m_Nombre = "EventoRecargarHistorial";
				}

				~EventoRecargarHistorial()
				{
				}


			protected:
			};

		class EventoAddModeloHistorial: public GNC::GCS::Eventos::IEvento
			{
			public:
				EventoAddModeloHistorial(GNC::GCS::IControladorHistorial::ListaModelosDCM* pListaModelos = NULL, bool abrirDespuesDeCargar = true, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion=NULL ):GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_AddModeloHistorial)
				{
					m_pListaModelos        = pListaModelos;
					m_abrirDespuesDeCargar = abrirDespuesDeCargar;
					m_pModeloIntegracion   = pModeloIntegracion;
					m_Nombre               = "AddModeloHistorial";
				}

				~EventoAddModeloHistorial()
				{
					m_pListaModelos = NULL;
				}

				GNC::GCS::IControladorHistorial::ListaModelosDCM* GetListaModelos()
				{
					return m_pListaModelos;
				}

				bool GetAbrirDespuesDeCargar(){
					return m_abrirDespuesDeCargar;
				}

				virtual void pushInfo(std::ostream& out) const {
					out << "Rutas = [ ";
					out << " ]";
				}

				GnkPtr<GIL::IModeloIntegracion> GetModeloIntegracion() {
					return m_pModeloIntegracion;
				}

			protected:
				bool                                              m_abrirDespuesDeCargar;
				GNC::GCS::IControladorHistorial::ListaModelosDCM* m_pListaModelos;
				GnkPtr<GIL::IModeloIntegracion>                   m_pModeloIntegracion;
			};

			class EventoLimpiarHistorial: public GNC::GCS::Eventos::IEvento
			{
			public:

				EventoLimpiarHistorial():GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_LimpiarHistorial)
				{
					m_Nombre = "LimpiarHistorial";
				}

				~EventoLimpiarHistorial()
				{
				}
			protected:
			};
		};//eventos		

		class IPanelHistorial {
		public:			
			IPanelHistorial() { }

			~IPanelHistorial() { }
			
		//	virtual void CargarDICOM( const std::vector<std::string>& rutas, bool abrirDespuesDeCargar )=0;

			virtual void DICOMActivado( GNC::GCS::IVista* pVista )=0;

			virtual void DICOMDesactivado( GNC::GCS::IVista* pVista )=0;
		};
	};
};
