/*
*
*  $Id: controladorherramientas.cpp 4612 2012-01-26 11:49:38Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#include <api/globals.h>
#include <api/ientorno.h>
#include <wx/aui/aui.h>
#include <wx/dc.h>
#include <wx/aui/auibar.h>
#include <wx/menu.h>
#include <wx/xml/xml.h>
#include <api/icontroladorvistas.h>
#include <main/barraherramientasderecha.h>
#include <main/entorno.h>
#include "controladorherramientas.h"
#include <api/ientorno.h>
#include <resources/ginkgoresourcemanager.h>
#include <api/icontextoestudio.h>
#include "controladorherramientas.h"


#include <main/entorno.h>
#include <main/gui/mainwindow/ventanaprincipal.h>

//region "Patron singleton"
// <editor-fold defaultstate="collapsed" desc="patron singleton">
#define ID_WX_HERRAMIENTA 1001

class GinkgoToolBarArt : public AUI_NAMESPACE wxAuiDefaultToolBarArt {
public:

	GinkgoToolBarArt(GNC::ControladorHerramientas* pControlador) {
		m_pControlador = pControlador;
	}

	virtual ~GinkgoToolBarArt() {}

	void SetCustomBaseColor(const wxColor& color) {
		m_base_colour = color;
	}

	wxColor GetCustomBaseColor() {
		return m_base_colour;
	}


	////////////////////////////////////////////////////begin draw drowpdown////////////////////////////////////////
	//WXWIDGETS DOESN'T SUPPORT DRAW CHECKED + DROPDOWN
	// wxAuiBlendColour is used by wxAuiStepColour
	unsigned char wxAuiBlendColour(unsigned char fg, unsigned char bg, double alpha)
	{
		double result = bg + (alpha * (fg - bg));
		if (result < 0.0)
			result = 0.0;
		if (result > 255)
			result = 255;
		return (unsigned char)result;
	}

	// wxAuiStepColour() it a utility function that simply darkens
	// or lightens a color, based on the specified percentage
	// ialpha of 0 would be completely black, 100 completely white
	// an ialpha of 100 returns the same colour
	wxColor wxAuiStepColour(const wxColor& c, int ialpha)
	{
		if (ialpha == 100)
			return c;

		unsigned char r = c.Red(),
			g = c.Green(),
			b = c.Blue();
		unsigned char bg;

		// ialpha is 0..200 where 0 is completely black
		// and 200 is completely white and 100 is the same
		// convert that to normal alpha 0.0 - 1.0
		ialpha = wxMin(ialpha, 200);
		ialpha = wxMax(ialpha, 0);
		double alpha = ((double)(ialpha - 100.0))/100.0;

		if (ialpha > 100)
		{
			// blend with white
			bg = 255;
			alpha = 1.0 - alpha;  // 0 = transparent fg; 1 = opaque fg
		}
		else
		{
			// blend with black
			bg = 0;
			alpha += 1.0;         // 0 = transparent fg; 1 = opaque fg
		}

		r = wxAuiBlendColour(r, bg, alpha);
		g = wxAuiBlendColour(g, bg, alpha);
		b = wxAuiBlendColour(b, bg, alpha);

		return wxColour(r, g, b);
	}

	void DrawDropDownButton(
		wxDC& dc,
		wxWindow* WXUNUSED(wnd),
		const wxAuiToolBarItem& item,
		const wxRect& rect)
	{
		//
		const int BUTTON_DROPDOWN_WIDTH = 10;
		const unsigned char
			DISABLED_TEXT_GREY_HUE = wxAuiBlendColour(0, 255, 0.4);
		const wxColour DISABLED_TEXT_COLOR(DISABLED_TEXT_GREY_HUE,
			DISABLED_TEXT_GREY_HUE,
			DISABLED_TEXT_GREY_HUE);
		//

		int text_width = 0, text_height = 0, text_x = 0, text_y = 0;
		int bmp_x = 0, bmp_y = 0, dropbmp_x = 0, dropbmp_y = 0;

		wxRect button_rect = wxRect(rect.x,
			rect.y,
			rect.width-BUTTON_DROPDOWN_WIDTH,
			rect.height);
		wxRect dropdown_rect = wxRect(rect.x+rect.width-BUTTON_DROPDOWN_WIDTH-1,
			rect.y,
			BUTTON_DROPDOWN_WIDTH+1,
			rect.height);

		if (m_flags & wxAUI_TB_TEXT)
		{
			dc.SetFont(m_font);

			int tx, ty;
			if (m_flags & wxAUI_TB_TEXT)
			{
				dc.GetTextExtent(wxT("ABCDHgj"), &tx, &text_height);
				text_width = 0;
			}

			dc.GetTextExtent(item.GetLabel(), &text_width, &ty);
		}



		dropbmp_x = dropdown_rect.x +
			(dropdown_rect.width/2) -
			(m_button_dropdown_bmp.GetWidth()/2);
		dropbmp_y = dropdown_rect.y +
			(dropdown_rect.height/2) -
			(m_button_dropdown_bmp.GetHeight()/2);


		if (m_text_orientation == wxAUI_TBTOOL_TEXT_BOTTOM)
		{
			bmp_x = button_rect.x +
				(button_rect.width/2) -
				(item.GetBitmap().GetWidth()/2);
			bmp_y = button_rect.y +
				((button_rect.height-text_height)/2) -
				(item.GetBitmap().GetHeight()/2);

			text_x = rect.x + (rect.width/2) - (text_width/2) + 1;
			text_y = rect.y + rect.height - text_height - 1;
		}
		else if (m_text_orientation == wxAUI_TBTOOL_TEXT_RIGHT)
		{
			bmp_x = rect.x + 3;

			bmp_y = rect.y +
				(rect.height/2) -
				(item.GetBitmap().GetHeight()/2);

			text_x = bmp_x + 3 + item.GetBitmap().GetWidth();
			text_y = rect.y +
				(rect.height/2) -
				(text_height/2);
		}


		if (item.GetState() & wxAUI_BUTTON_STATE_PRESSED)
		{
			dc.SetPen(wxPen(m_highlight_colour));
			dc.SetBrush(wxBrush(wxAuiStepColour(m_highlight_colour, 140)));
			dc.DrawRectangle(button_rect);
			dc.DrawRectangle(dropdown_rect);
		}
		else if (item.GetState() & wxAUI_BUTTON_STATE_HOVER ||
			item.IsSticky())
		{
			dc.SetPen(wxPen(m_highlight_colour));
			dc.SetBrush(wxBrush(wxAuiStepColour(m_highlight_colour, 170)));
			dc.DrawRectangle(button_rect);
			dc.DrawRectangle(dropdown_rect);
		}
		//MODIFIED
		else if (item.GetState() & wxAUI_BUTTON_STATE_CHECKED)
		{
			// it's important to put this code in an else statment after the
			// hover, otherwise hovers won't draw properly for checked items
			dc.SetPen(wxPen(m_highlight_colour));
			dc.SetBrush(wxBrush(wxAuiStepColour(m_highlight_colour, 170)));
			dc.DrawRectangle(rect);
		}
		///END MODIFIED

		wxBitmap bmp;
		wxBitmap dropbmp;
		if (item.GetState() & wxAUI_BUTTON_STATE_DISABLED)
		{
			bmp = item.GetDisabledBitmap();
			dropbmp = m_disabled_button_dropdown_bmp;
		}
		else
		{
			bmp = item.GetBitmap();
			dropbmp = m_button_dropdown_bmp;
		}

		if (!bmp.IsOk())
			return;

		dc.DrawBitmap(bmp, bmp_x, bmp_y, true);
		dc.DrawBitmap(dropbmp, dropbmp_x, dropbmp_y, true);

		// set the item's text color based on if it is disabled
		dc.SetTextForeground(*wxBLACK);
		if (item.GetState() & wxAUI_BUTTON_STATE_DISABLED)
			dc.SetTextForeground(DISABLED_TEXT_COLOR);

		if ( (m_flags & wxAUI_TB_TEXT) && !item.GetLabel().empty() )
		{
			dc.DrawText(item.GetLabel(), text_x, text_y);
		}
	}
	////////////////////////////////////////////////////end draw drowpdown////////////////////////////////////////

	virtual void DrawButton(
		wxDC& dc,
		wxWindow* wnd,
		const wxAuiToolBarItem& item,
		const wxRect& rect)
	{
		if (item.HasDropDown()) {
			//we have modified default draw function to draw checked + drop down (not supported in wxWidgets)
			DrawDropDownButton(dc, wnd, item, rect);
		} else {
			AUI_NAMESPACE wxAuiDefaultToolBarArt::DrawButton(dc, wnd, item, rect);
		}
		if (item.IsActive() && ( (item.GetState() & wxAUI_BUTTON_STATE_CHECKED) != 0) ) {

			GNC::GCS::IHerramienta* pHerramienta = m_pControlador->ObtenerHerramienta(m_pControlador->GetId(item.GetId()));
			if (pHerramienta != NULL && pHerramienta->Activada()) {
				wxBitmap bmp;
				if ( pHerramienta->GetTriggerButton().IsLeftEnabled() && pHerramienta->GetTriggerButton().IsRightEnabled()) {
					//l+r
					bmp = GinkgoResourcesManager::IconosHerramientas::GetIcoMouseRL();
				} else if ( pHerramienta->GetTriggerButton().IsLeftEnabled() ) {
					//l
					bmp = GinkgoResourcesManager::IconosHerramientas::GetIcoMouseL();
				} else {
					//r
					bmp = GinkgoResourcesManager::IconosHerramientas::GetIcoMouseR();
				}

				if ( pHerramienta->GetTriggerButton().IsLeftEnabled() ||  pHerramienta->GetTriggerButton().IsRightEnabled()) {
					wxPoint point(rect.x, rect.height - bmp.GetHeight()+7);
					dc.DrawBitmap(bmp, point);
				}
			}
		}
	}

private:
	GNC::ControladorHerramientas* m_pControlador;

};

class BarraHerramientasControlador:public AUI_NAMESPACE wxAuiToolBar{
public:
	BarraHerramientasControlador(wxWindow* pParent,GNC::ControladorHerramientas* pControlador,const GNC::GCS::IHerramienta::TFamiliasHerramientas& familia):AUI_NAMESPACE wxAuiToolBar(pParent,wxID_ANY, wxDefaultPosition, wxDefaultSize,AUI_NAMESPACE wxAUI_TB_DEFAULT_STYLE )
	{
		this->Connect(wxID_ANY,wxEVT_LEFT_UP, wxMouseEventHandler( BarraHerramientasControlador::OnLeftUp) );
		this->Connect(wxID_ANY,wxEVT_RIGHT_UP, wxMouseEventHandler( BarraHerramientasControlador::OnRightUp) );
		this->Connect(wxID_ANY, wxEVT_COMMAND_AUITOOLBAR_TOOL_DROPDOWN,  wxAuiToolBarEventHandler(BarraHerramientasControlador::OnDropDownTool) );

		SetToolBitmapSize(wxSize(16,16));
		m_pControlador = pControlador;
		GinkgoToolBarArt* pToolArt = new GinkgoToolBarArt(m_pControlador);
#if !defined(__WXOSX__)
		wxColor color = pToolArt->GetCustomBaseColor();
		switch(familia) {
case GNC::GCS::IHerramienta::TFamiliaGlobal:
case GNC::GCS::IHerramienta::TFamiliaVisualizacion:
	color = wxColor(255,255,186);
	break;
case GNC::GCS::IHerramienta::TFamiliaAnotacion:
	color = wxColor(255,186,186);
	break;
case GNC::GCS::IHerramienta::TFamiliaMedicion:
	color = wxColor(217,255,186);
	break;
case GNC::GCS::IHerramienta::TFamiliaVision:
	color = wxColor(186,230,255);
	break;
case GNC::GCS::IHerramienta::TFamiliaChroma:
	color = wxColor(230,181,242);
	break;
case GNC::GCS::IHerramienta::TMenuVer:
	break;
case GNC::GCS::IHerramienta::TMenuImagen:
	break;
case GNC::GCS::IHerramienta::TMenuHerramientas:
	break;
case GNC::GCS::IHerramienta::TMenuExport:
	break;
case GNC::GCS::IHerramienta::TMenuEdicion:
	break;
case GNC::GCS::IHerramienta::TMenu3D:
	break;
		}
		pToolArt->SetCustomBaseColor(color);
#endif

		SetArtProvider(pToolArt);
	}

	~BarraHerramientasControlador()
	{
		this->Disconnect(wxID_ANY,wxEVT_COMMAND_TOOL_CLICKED, wxMouseEventHandler( BarraHerramientasControlador::OnLeftUp));
		this->Disconnect(wxID_ANY,wxEVT_COMMAND_TOOL_CLICKED, wxMouseEventHandler( BarraHerramientasControlador::OnRightUp));
		this->Disconnect(wxID_ANY, wxEVT_COMMAND_AUITOOLBAR_TOOL_DROPDOWN,  wxAuiToolBarEventHandler(BarraHerramientasControlador::OnDropDownTool) );
		m_pControlador=NULL;
	}

	virtual void OnRightUp(wxMouseEvent& evt)
	{
		wxAuiToolBarItem* hit_item;
		hit_item = FindToolByPosition(evt.GetX(), evt.GetY());
		if (hit_item != NULL && hit_item->IsActive() && hit_item->GetKind() == wxITEM_CHECK) {
			m_pControlador->OnActivarHerramienta(hit_item->GetId(), GNC::GCS::TriggerButton().EnableRight());
		}
		evt.Skip(false);
	}

	virtual void OnLeftUp(wxMouseEvent& evt)
	{
		wxAuiToolBarItem* hit_item;
		hit_item = FindToolByPosition(evt.GetX(), evt.GetY());
		if (hit_item != NULL && hit_item->IsActive() && hit_item->GetKind() == wxITEM_CHECK) {
			m_pControlador->OnActivarHerramienta(hit_item->GetId(), GNC::GCS::TriggerButton().EnableLeft());
		}
		evt.Skip(false);
	}

	virtual void OnDropDownTool(wxAuiToolBarEvent& evt)
	{
		if (evt.IsDropDownClicked()){
			wxAuiToolBarItem* hit_item;
			hit_item = FindToolByPosition(evt.GetClickPoint().x, evt.GetClickPoint().y);
			if (hit_item != NULL && hit_item->IsActive() && hit_item->GetKind() == wxITEM_CHECK) {
				//Activate...
				m_pControlador->OnActivarHerramienta(hit_item->GetId(), GNC::GCS::TriggerButton().EnableLeft());
				//
				wxMenu menuPopup;
				GNC::GCS::IHerramienta* pHerramienta = m_pControlador->ObtenerHerramientaWx(hit_item->GetId());
				if (pHerramienta != NULL) {
					pHerramienta->AppendInMenu(this,&menuPopup);
					// line up our menu with the button
					wxRect rect = this->GetToolRect(evt.GetId());
					wxPoint pt = this->ClientToScreen(rect.GetBottomLeft());
					pt = ScreenToClient(pt);


					PopupMenu(&menuPopup, pt);
					// make sure the button is "un-stuck"
					this->SetToolSticky(evt.GetId(), false);
					//refresh icon
					hit_item->SetBitmap(pHerramienta->GetIcono());
					Refresh(true);
				}
			}
			evt.Skip(false);
		}
	}

private:
	GNC::ControladorHerramientas* m_pControlador;

};

namespace GNC {
	namespace GUI {
		class EventHandlerKeyToolsController: public wxEvtHandler {
		public:
			EventHandlerKeyToolsController(GNC::ControladorHerramientas* pController): wxEvtHandler()
			{
				m_pController = pController;
				m_pParent = NULL;
			}
			~EventHandlerKeyToolsController() 
			{
				Disconnect();
			}

			void OnKeyEvent(wxKeyEvent& event) {
				//tools accelerators are ctrl + keycode
				if (event.ControlDown() && event.GetKeyCode() != WXK_CONTROL) {
					m_pController->OnKeyAccelerator(event);
#if defined(__WXGTK__)
					if (m_pParent != NULL) {
						m_pParent->SetFocus();
					}
#endif
				} else {
					event.ResumePropagation(1);
					event.Skip(true);
				}

			}

			void Connect(wxWindow* pParent) {
				if (m_pParent != NULL) {
					m_pParent->Disconnect(wxEVT_KEY_DOWN, wxKeyEventHandler( EventHandlerKeyToolsController::OnKeyEvent ), NULL, this);
				}
				m_pParent = pParent;
				m_pParent->Connect(wxEVT_KEY_DOWN, wxKeyEventHandler( EventHandlerKeyToolsController::OnKeyEvent ), NULL, this);
			}

			void Disconnect() {
				if (m_pParent != NULL) {
					m_pParent->Disconnect(wxEVT_KEY_DOWN, wxKeyEventHandler( EventHandlerKeyToolsController::OnKeyEvent ), NULL, this);
					m_pParent = NULL;
				}
			}

			GNC::ControladorHerramientas* m_pController;
			wxWindow* m_pParent;
		};
	}
}

GNC::ControladorHerramientas::ControladorHerramientas()
{
	m_pVistaActiva = NULL;
	m_pModuloActivo = NULL;
	GNC::Entorno* pEntorno = GNC::Entorno::Instance();

	pEntorno->ObservadoresExtensiones.push_back(this);
	pEntorno->ObservadoresVistas.push_back(this);

	m_contadorHerramientas = ID_WX_HERRAMIENTA;

	//ñapa para que se inserten en orden las barras de herramientas
	for(int familia = GNC::GCS::IHerramienta::TFamiliaGlobal; familia <= GNC::GCS::IHerramienta::TFamiliaVision; ++familia)
	{
		BarraHerramientasControlador* pBarraHerramientas = new BarraHerramientasControlador(pEntorno->GetPanelHerramientasSuperior(),this,(GNC::GCS::IHerramienta::TFamiliasHerramientas)familia);
		pBarraHerramientas->SetAutoLayout(true);
		pEntorno->GetSizerHerramientas()->Add(pBarraHerramientas, 0, wxEXPAND, 0);
		m_MapaBarrasHerramientas[(GNC::GCS::IHerramienta::TFamiliasHerramientas)familia] = pBarraHerramientas;
	}

	m_pBarraHerramientasDerecha = new GNC::GUI::BarraHerramientasDerecha(pEntorno->GetPanelHerramientasSuperior(), pEntorno->GetVentanaPrincipal());

	pEntorno->GetPanelHerramientasSuperior()->GetSizer()->Add( m_pBarraHerramientasDerecha, 1, wxEXPAND, 0 );

	m_pKeyEventHandler = new GNC::GUI::EventHandlerKeyToolsController(this);
}

GNC::ControladorHerramientas::~ControladorHerramientas()
{
	bool found;

	GNC::Entorno* pEntorno = GNC::Entorno::Instance();

	GNC::Entorno::ListaObservadoresVistas::iterator it1;
	GNC::Entorno::ListaObservadoresExtensiones::iterator it2;

	found = false;
	for (it1 = pEntorno->ObservadoresVistas.begin(); !found && it1 != pEntorno->ObservadoresVistas.end(); it1++) {
		if (*it1 == this) {
			pEntorno->ObservadoresVistas.erase(it1);
			break;
		}
	}
	found = false;
	for (it2 = pEntorno->ObservadoresExtensiones.begin(); !found && it2 != pEntorno->ObservadoresExtensiones.end(); it2++) {
		if (*it2 == this) {
			pEntorno->ObservadoresExtensiones.erase(it2);
			break;
		}
	}

	for(MapaHerramientas::iterator it = m_Herramientas.begin(); it!= m_Herramientas.end(); it++) {
		delete (*it).second;
	}
	m_Herramientas.clear();
	m_MapaIdsHerramientas.clear();

	if (m_pKeyEventHandler != NULL)
	{
		delete m_pKeyEventHandler;
	}
}

GNC::ControladorHerramientas* GNC::ControladorHerramientas::Instance()
{
	if (m_pInstance == NULL) {
		m_pInstance = new GNC::ControladorHerramientas();
	}
	return m_pInstance;
}

void GNC::ControladorHerramientas::FreeInstance()
{
	if (m_pInstance != NULL) {
		delete m_pInstance;
		m_pInstance = NULL;
	}

}

GNC::ControladorHerramientas* GNC::ControladorHerramientas::m_pInstance = 0;

// </editor-fold>
//endregion

//------------------------------------------------------------------------------
//region "Realizacion de la interfaz IControladorHerramientas"
// <editor-fold defaultstate="collapsed" desc="gestion de herramientas">

/* Registra una herramienta */
void GNC::ControladorHerramientas::RegistrarHerramienta(GNC::GCS::IHerramienta* pHerramienta)
{

	GTRACE("GNC::ControladorHerramientas::RegistrarHerramienta( Herramienta = " << pHerramienta << ")");
	if (pHerramienta == NULL) {
		throw GNC::GCS::ControladorHerramientasException(_Std("Null Tool"));
	}

	MapaHerramientas::const_iterator it = m_Herramientas.find(pHerramienta->ID);

	if (it != m_Herramientas.end()) {
		throw GNC::GCS::ControladorHerramientasException(_Std("Duplicate Tool"));
	}
	m_Herramientas[pHerramienta->ID] = pHerramienta;

	//m_Herramientas.put(pHerramienta->ID, pHerramienta);

	//Se le da un id wxWidgets y se mete en el mapa
	int idWx = m_contadorHerramientas++;
	m_MapaIdsHerramientas[idWx++] = pHerramienta->ID;

	pHerramienta->SetSolicitadorCambioHerramienta(this);
	pHerramienta->DoCrearPaneles(GNC::Entorno::Instance()->GetPanelHerramientasSuperior(), GNC::Entorno::Instance()->GetSizerHerramientasOpciones());

	RefrescarHerramientas();
}

/* Des-Registra una herramienta */
void GNC::ControladorHerramientas::DesRegistrarHerramienta(GNC::GCS::IHerramienta* pHerramienta)
{
	for (MapaIdsHerramientas::iterator it = m_MapaIdsHerramientas.begin(); it != m_MapaIdsHerramientas.end(); it++) {
		if ((*it).second == pHerramienta->ID) {
			m_MapaIdsHerramientas.erase(it);
			break;
		}
	}
	//GTRACE("GNC::ControladorHerramientas::DesRegistrarHerramienta( Herramienta = " << pHerramienta << ")");
	for (MapaHerramientas::iterator it = m_Herramientas.begin(); it != m_Herramientas.end(); it++) {
		if ((*it).second == pHerramienta) {
			pHerramienta->Activar(false);
			pHerramienta->SetSolicitadorCambioHerramienta(NULL);
			m_Herramientas.erase(it);
			break;
		}
	}
}

GNC::GCS::IHerramienta* GNC::ControladorHerramientas::ObtenerHerramientaWx(long id)
{
	if(m_MapaIdsHerramientas.find(id) != m_MapaIdsHerramientas.end()){
		int idHerramienta = m_MapaIdsHerramientas[id];
		return ObtenerHerramienta(idHerramienta);
	} else {
		return NULL;
	}
}

GNC::GCS::IHerramienta* GNC::ControladorHerramientas::ObtenerHerramienta(GNC::GCS::IHerramienta::UID id)
{
	GNC::GCS::IHerramienta* pHerramienta = NULL;
	MapaHerramientas::iterator it = m_Herramientas.find(id);
	if (it != m_Herramientas.end()) {
		pHerramienta = (*it).second;
	}
	return pHerramienta;
}

bool GNC::ControladorHerramientas::MostrarHerramientaBarra(GNC::GCS::IHerramienta* pHerramienta, bool mostrar)
{
	AUI_NAMESPACE wxAuiToolBar* pBarraHerramientas = GetBarraHerramientasFamilia(pHerramienta->IDFamilia);
	const int idWx = GetIdWx(pHerramienta->ID);
	if(mostrar){
		if(pBarraHerramientas->FindTool(idWx)==NULL && !pHerramienta->IsMenu()){
			//si no esta metida...
			pBarraHerramientas->AddTool(idWx,wxString::FromUTF8(pHerramienta->Nombre.c_str()),pHerramienta->GetIcono(),wxString::FromUTF8(pHerramienta->GetDescripcion().c_str()),wxITEM_CHECK);
			if (pHerramienta->IsDropDown()) {
				pBarraHerramientas->SetToolDropDown(idWx, true);
			}
			return true;
		}
	}
	else{
		if(pBarraHerramientas->FindTool(idWx)!=NULL){
			//si esta metida...
			pBarraHerramientas->DeleteTool(idWx);
			return true;
		}
	}
	return false;
}

void GNC::ControladorHerramientas::HabilitarHerramientaBarra(GNC::GCS::IHerramienta* pHerramienta, bool habilitar)
{
	AUI_NAMESPACE wxAuiToolBar* pBarraHerramientas = GetBarraHerramientasFamilia(pHerramienta->IDFamilia);
	const int idWx = GetIdWx(pHerramienta->ID);
	pBarraHerramientas->EnableTool(idWx,habilitar);
}
void GNC::ControladorHerramientas::ActivarHerramientaBarra(GNC::GCS::IHerramienta* pHerramienta, bool activar)
{
	AUI_NAMESPACE wxAuiToolBar* pBarraHerramientas = GetBarraHerramientasFamilia(pHerramienta->IDFamilia);
	AUI_NAMESPACE wxAuiToolBar* barraOpciones = pHerramienta->GetPanelHerramientaOpciones();
	const int idWx = GetIdWx(pHerramienta->ID);
	pBarraHerramientas->ToggleTool(idWx,activar);
	if(barraOpciones!=NULL){
		barraOpciones->Show(activar);
		if (activar) {
			//barraOpciones->Layout();
			//barraOpciones->Refresh(true);
		}
	} else {		
	}
}

unsigned long GNC::ControladorHerramientas::GetIdWx(unsigned long idHerramienta)
{
	for (MapaIdsHerramientas::iterator it = m_MapaIdsHerramientas.begin(); it != m_MapaIdsHerramientas.end(); it++) {
		if ((*it).second == idHerramienta) {
			return (*it).first;
		}
	}
	std::cerr << "Error al registrar herramientas se ha pedido la herramienta no registrada con id: " << idHerramienta << std::endl;
	return 0;
}

unsigned long GNC::ControladorHerramientas::GetId(unsigned long id)
{
	if(m_MapaIdsHerramientas.find(id) != m_MapaIdsHerramientas.end()){
		return m_MapaIdsHerramientas[id];		
	}
	return 0;
}


/* Refresca las propiedades (visibilidad, etc) de las herramientas frente a cambios de estado */
void GNC::ControladorHerramientas::RefrescarHerramientas()
{
	GTRACE("GNC::ControladorHerramientas::RefrescarHerramientas()");
	// Obtenemos la herramienta activa en el módulo
	GNC::GCS::IHerramienta* pActiveLeftTool = NULL;
	GNC::GCS::IHerramienta* pActiveRightTool = NULL;
	if (m_pModuloActivo != NULL && m_pVistaActiva != NULL) {
		pActiveLeftTool = m_HerramientaActivaBotonIzquierdo[m_pModuloActivo];
		pActiveRightTool = m_HerramientaActivaBotonDerecho[m_pModuloActivo];
	}

#ifdef _GINKGO_TRACE
	std::cout << "RefrescarHerramientas() HerramientaActivaEnModulo = ";
	if (pHerramientaActivaEnModulo != NULL ) {
		std::cout << pHerramientaActivaEnModulo->Nombre.c_str();
	}
	else {
		std::cout << "NULL";
	}
	std::cout << std::endl;
#endif
	//si se ha añadido/eliminado alguna pues habra que hacer rebuild...
	bool rebuild=false;


	for (MapaHerramientas::iterator it = m_Herramientas.begin(); it != m_Herramientas.end(); it++) {
		GNC::GCS::IHerramienta* pHerramienta = (*it).second;
		pHerramienta->SetVistaActiva(m_pVistaActiva);
		pHerramienta->Conectar(false);
		//pHerramienta->GetTriggerButton().ResetTriggerButtonMask();

		if (pHerramienta->ValidaContratos(m_pVistaActiva)) {
			pHerramienta->Habilitar(true);
			pHerramienta->Mostrar(true);
			rebuild |= MostrarHerramientaBarra(pHerramienta, true);			
		}
		else {
			pHerramienta->Habilitar(false);
			pHerramienta->Mostrar(false);
			rebuild |= MostrarHerramientaBarra(pHerramienta, false);
		}
	}


	if (m_pModuloActivo != NULL && m_pVistaActiva != NULL) {

		// Select first right tool available
		if (pActiveRightTool == NULL) {
			for (MapaHerramientas::iterator it = m_Herramientas.begin(); pActiveRightTool == NULL && it != m_Herramientas.end(); it++) {
				GNC::GCS::IHerramienta* pTool = (*it).second;
				if (pTool->IDFamilia == GNC::GCS::IHerramienta::TFamiliaVisualizacion && pTool->Habilitada() && m_pVistaActiva->SoportaHerramienta(pTool) ) {
					pActiveRightTool = pTool;
				}
			}
		}
		if (pActiveRightTool != NULL) {
			pActiveRightTool->GetTriggerButton().EnableRight();
			if (pActiveRightTool->Habilitada()) {
				if (m_pVistaActiva->SoportaHerramienta(pActiveRightTool)) {
					pActiveRightTool->Activar(true);
					pActiveRightTool->Conectar(true);
					HabilitarHerramientaBarra(pActiveRightTool,true);
					ActivarHerramientaBarra(pActiveRightTool,true);
					rebuild |= MostrarHerramientaBarra(pActiveRightTool,true);
				}
				else {
					pActiveRightTool->Activar(true);
					pActiveRightTool->Conectar(false);
					HabilitarHerramientaBarra(pActiveRightTool,false);
					ActivarHerramientaBarra(pActiveRightTool,false);
					rebuild |= MostrarHerramientaBarra(pActiveRightTool, false);
				}
			}
			else {
				pActiveRightTool->Activar(false);
				pActiveRightTool->Habilitar(false);
				pActiveRightTool->Mostrar(false);
				HabilitarHerramientaBarra(pActiveRightTool,false);
				ActivarHerramientaBarra(pActiveRightTool,false);
				rebuild |= MostrarHerramientaBarra(pActiveRightTool,false);
			}
		}


		// Select first left tool available
		if (pActiveLeftTool == NULL) {
			for (MapaHerramientas::iterator it = m_Herramientas.begin(); pActiveLeftTool == NULL && it != m_Herramientas.end(); it++) {
				GNC::GCS::IHerramienta* pTool = (*it).second;
				if (pTool->IDFamilia != GNC::GCS::IHerramienta::TFamiliaVisualizacion && pTool->Habilitada() && m_pVistaActiva->SoportaHerramienta(pTool) ) {
					pActiveLeftTool = pTool;
				}
			}
		}
		if (pActiveLeftTool != NULL) {
			pActiveLeftTool->GetTriggerButton().EnableLeft();
			if (pActiveLeftTool->Habilitada()) {
				if (m_pVistaActiva->SoportaHerramienta(pActiveLeftTool)) {
					pActiveLeftTool->Activar(true);
					pActiveLeftTool->Conectar(true);
					HabilitarHerramientaBarra(pActiveLeftTool,true);
					ActivarHerramientaBarra(pActiveLeftTool,true);
					rebuild |= MostrarHerramientaBarra(pActiveLeftTool,true);
				}
				else {
					pActiveLeftTool->Activar(true);
					pActiveLeftTool->Conectar(false);
					HabilitarHerramientaBarra(pActiveLeftTool,false);
					ActivarHerramientaBarra(pActiveLeftTool,false);
					rebuild |= MostrarHerramientaBarra(pActiveLeftTool, false);
				}
			}
			else {
				pActiveLeftTool->Activar(false);
				pActiveLeftTool->Habilitar(false);
				pActiveLeftTool->Mostrar(false);
				HabilitarHerramientaBarra(pActiveLeftTool,false);
				ActivarHerramientaBarra(pActiveLeftTool,false);
				rebuild |= MostrarHerramientaBarra(pActiveLeftTool,false);
			}
		}


	}
	else {

	}

	if (m_pModuloActivo != NULL && m_pVistaActiva != NULL) {
		m_HerramientaActivaBotonDerecho[m_pModuloActivo] = pActiveRightTool;
		m_HerramientaActivaBotonIzquierdo[m_pModuloActivo] = pActiveLeftTool;
	}


	//si no tiene opciones hay q darle otro toque
	if(m_pVistaActiva == NULL)
	{
		//m_pBarraHerramientasDerecha->Show(false);
	} else {
		//m_pBarraHerramientasDerecha->Show(true);
	}

	ReconstruirBarrasHerramientas(rebuild);
	GNC::Entorno::Instance()->GetPanelHerramientasSuperior()->Layout();

#ifdef _GINKGO_TRACE
	std::cout << "--" << std::endl;
#endif
}

GNC::ControladorHerramientas::ListaHerramientas GNC::ControladorHerramientas::GetHerramientas(){
	ListaHerramientas lista;
	for(MapaHerramientas::iterator it = m_Herramientas.begin(); it!= m_Herramientas.end(); it++){
		lista.push_back((*it).second);
	}
	return lista;
}

GNC::ControladorHerramientas::TMapaHerramientasOrdenadas GNC::ControladorHerramientas::GetHerramientasOrdenadas(){
	TMapaHerramientasOrdenadas mapa;
	for(MapaHerramientas::iterator it = m_Herramientas.begin(); it!= m_Herramientas.end(); it++){
		GNC::GCS::IHerramienta * pHerramienta = (*it).second;
		if(mapa.find(pHerramienta->IDFamilia) == mapa.end()) {
			mapa[pHerramienta->IDFamilia] = TMapaSubConjuntosHerramientas();
		}
		mapa[pHerramienta->IDFamilia][pHerramienta->IDSubFamilia].push_back(pHerramienta);
	}

	return mapa;
}

void GNC::ControladorHerramientas::Deserializar(GNC::GCS::IVista* pVista, int posicion, wxXmlNode* root, const std::string& sopInstanceUID)
{
	wxXmlNode *child = root->GetChildren();
	wxString wxSopInstance = wxString::FromUTF8(sopInstanceUID.c_str());
	wxString propVal;

	while(child) {
		if(child->GetName() == wxT("tools")){
			propVal = child->GetPropVal(wxT("sop_instance_uid"), wxEmptyString);
			if (propVal == wxSopInstance)
				break;
		}
		child = child->GetNext();
	}

	if(child == NULL){
		//se buscan nodos tools sin identificar (deprecated)
		child = root->GetChildren();
		while(child) {
			if(child->GetName() == wxT("tools")){
				propVal = child->GetPropVal(wxT("sop_instance_uid"), wxT("undefined"));
				if (propVal == wxEmptyString)
					break;
			}
			child = child->GetNext();
		}
		if (child == NULL)
			return;
	}

	child = child->GetChildren();
	while (child) {
		//se pilla el id de la herramienta
		wxString strTmp = child->GetPropVal(wxT("id"),wxT(""));
		double doubleTmp;
		if(strTmp.ToDouble(&doubleTmp)){
			int id = (int) doubleTmp;
			//se busca la herramienta con ese id y se desserializa
			GNC::GCS::IHerramienta* pH = ObtenerHerramienta(id);
			if(pH != NULL) {
				pH->Deserializar(pVista, posicion,child);
			}
		}
		child = child->GetNext();
	}

}

/*Serializa las herramientas asociadas a la vista y posicion que se le pasa como parametro y lo agrega al nodo*/
void GNC::ControladorHerramientas::Serializar(GNC::GCS::IVista* pVista, int posicion, wxXmlNode* root, const std::string& nombreMedicoSerializa, const std::string& sopInstanceUID)
{
	wxString propVal;
	wxString wxSopInstance = wxString::FromUTF8(sopInstanceUID.c_str());

	//se busca en la raiz un nodo "tools" con sop_instance_uid == al que nos pasan y se borra
	for (wxXmlNode* nodo = root->GetChildren(); nodo != NULL; nodo = nodo->GetNext()) {
		if (nodo->GetName() == wxT("tools")) {
			propVal = nodo->GetPropVal(wxT("sop_instance_uid"), wxEmptyString);
			if( propVal == wxSopInstance ) {
				root->RemoveChild(nodo);
				break;
			}
		}
	}

	wxXmlNode* nodoHerramientas = new wxXmlNode(NULL,wxXML_ELEMENT_NODE,wxT("tools"));
	nodoHerramientas->AddProperty(wxT("sop_instance_uid"), wxSopInstance);

	/*se recorren todas las herramientas y se les pide que serialicen para la vista que se le pasa como parametro*/
	for(MapaHerramientas::iterator it = m_Herramientas.begin(); it != m_Herramientas.end(); it++){
		wxXmlNode* nodo = (*it).second->Serializar(pVista,posicion,nombreMedicoSerializa);
		if(nodo!=NULL){
			nodoHerramientas->AddChild(nodo);
		}
	}
	root->AddChild(nodoHerramientas);
}

// </editor-fold>
//endregion

//region "Realizacion de interfaz de observacion de extensiones"
// <editor-fold defaultstate="collapsed" desc="Realizacion de interfaz IObservadorExtensiones...">

void GNC::ControladorHerramientas::OnModuloCargado(GNC::GCS::IControladorModulo* pModulo)
{
	GTRACE("GNC::ControladorHerramientas::OnModuloCargado(" << pModulo << ")");
	m_HerramientaActivaBotonIzquierdo[pModulo] = NULL;
}

void GNC::ControladorHerramientas::OnModuloDescargado(GNC::GCS::IControladorModulo* pModulo)
{
	GTRACE("GNC::ControladorHerramientas::OnModuloDescargado(" << pModulo << ")");
	HerramientaActivas::iterator it = m_HerramientaActivaBotonIzquierdo.find(pModulo);
	if (it != m_HerramientaActivaBotonIzquierdo.end()) {
		m_HerramientaActivaBotonIzquierdo.erase(it);
	}
}

// </editor-fold>
//endregion

//------------------------------------------------------------------------------
//region "Realizacion de interfaz de observacion de vistas"
// <editor-fold defaultstate="collapsed" desc="Realizacion de interfaz de observacion de vistas...">

void GNC::ControladorHerramientas::OnVistaActivada(GNC::GCS::IVista* pVista)
{

	wxWindowDisabler dis;
	GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperFreeze();

	//antes de activar... desactivar si es preciso
	if (m_pVistaActiva != NULL)
	{
#ifdef _GINKGO_TRACE
		std::cout << "OnVistaDesactivada( " << pVista->GetTitulo().c_str() << ") Modulo = " << pVista->GetControlador()->GetModulo()->GetNombre().c_str() << std::endl;
		std::cout << "  ANT: VistaActiva = " << pVista->GetTitulo().c_str() << ", ModuloActivo = " << m_pModuloActivo->GetNombre().c_str() << std::endl;
#endif

		//disconnect key events...
		m_pKeyEventHandler->Disconnect();
		//

		GNC::GCS::IHerramienta* pH = NULL;

		pH = m_HerramientaActivaBotonIzquierdo[m_pModuloActivo];
		if (pH != NULL) {
			pH->SetVistaActiva(pVista);
			pH->Conectar(false);
			pH->Activar(false);
			ActivarHerramientaBarra(pH,false);
		}

		pH = m_HerramientaActivaBotonDerecho[m_pModuloActivo];
		if (pH != NULL) {
			pH->SetVistaActiva(pVista);
			pH->Conectar(false);
			pH->Activar(false);
			ActivarHerramientaBarra(pH,false);
		}

		m_pVistaActiva = NULL;
		m_pModuloActivo = NULL;

#ifdef _GINKGO_TRACE
		std::cout << "  DES: VistaActiva = NULL, ModuloActivo = NULL" << std::endl;
#endif

		RefrescarHerramientas();

		m_pVistaActiva = NULL;
	}


#ifdef _GINKGO_TRACE
	std::cout << "OnVistaActivada( " << pVista->GetTitulo().c_str() << " ) Modulo = " << pVista->GetControlador()->GetModulo()->GetNombre().c_str() << std::endl;
	std::cout << "  ANT: VistaActiva = ";
	if (m_pVistaActiva != NULL) {
		std::cout << m_pVistaActiva->GetTitulo().c_str();
	}
	else {
		std::cout << "NULL";
	}
	std::cout << ", ModuloActivo = ";
	if (m_pModuloActivo != NULL) {
		m_pModuloActivo->GetNombre().c_str();
	}
	else {
		std::cout << "NULL";
	}
	std::cout << std::endl;
#endif

	m_pVistaActiva = pVista;
	if(m_pVistaActiva !=NULL){
		m_pModuloActivo = m_pVistaActiva->GetModulo();

		//connect key events
		m_pKeyEventHandler->Connect(m_pVistaActiva->GetWindow());
		//
	}else{
		m_pModuloActivo = NULL;
	}

#ifdef _GINKGO_TRACE
	std::cout << "  DES: VistaActiva = " << m_pVistaActiva->GetTitulo().c_str() << ", ModuloActivo = " << m_pModuloActivo->GetNombre().c_str() << std::endl;
#endif

	RefrescarHerramientas();


	GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperThaw();
}

/*
void GNC::ControladorHerramientas::OnVistaDesactivada(GNC::GCS::IVista* pVista)
{
#ifdef _GINKGO_TRACE
std::cout << "OnVistaDesactivada( " << pVista->GetTitulo().c_str() << ") Modulo = " << pVista->GetControlador()->GetModulo()->GetNombre().c_str() << std::endl;
std::cout << "  ANT: VistaActiva = " << pVista->GetTitulo().c_str() << ", ModuloActivo = " << m_pModuloActivo->GetNombre().c_str() << std::endl;
#endif

if (m_pVistaActiva == pVista) {
GNC::GCS::IHerramienta* pH = m_HerramientaActivaBotonIzquierdo[m_pModuloActivo];
if (pH != NULL) {
pH->SetVistaActiva(pVista);
pH->Conectar(false);
pH->Activar(false);
ActivarHerramientaBarra(pH,false);
}
m_pVistaActiva = NULL;
m_pModuloActivo = NULL;

#ifdef _GINKGO_TRACE
std::cout << "  DES: VistaActiva = NULL, ModuloActivo = NULL" << std::endl;
#endif

RefrescarHerramientas();
}
}*/

// </editor-fold>
//endregion

//------------------------------------------------------------------------------
//region "Interactuacion con herramientas"
// <editor-fold defaultstate="collapsed" desc="Interactuacion con herramientas...">

void GNC::ControladorHerramientas::ActivarHerramientaPorDefecto(GNC::GCS::IControladorModulo* )
{
	;
}

/* Activa la herramienta especificada al módulo especificado. pHerramienta puede ser NULL */
void GNC::ControladorHerramientas::ActivarHerramienta(GNC::GCS::IControladorModulo* , GNC::GCS::IHerramienta::UID, int )
{
}

// </editor-fold>
//endregion

//------------------------------------------------------------------------------
//region "Interfaz de ISolicitadorCambioHerramienta"
// <editor-fold defaultstate="collapsed" desc="Realizacion de interfaz ISolicitadorCambioHerramienta...">

/* Recepción de solicitud de cambio de herramienta */
void GNC::ControladorHerramientas::SolicitarActivacion(GNC::GCS::IHerramienta* pTool, const GNC::GCS::TriggerButton& buttonMask)
{
	GNC::Entorno* pEntorno = GNC::Entorno::Instance();

	wxWindowDisabler dis;

	pEntorno->GetVentanaPrincipal()->SuperFreeze();

#ifdef _GINKGO_TRACE
	std::cout << "SolicitarActivacion( " << herramienta->Nombre.c_str() << " ). Modulo activo = ";
	if (m_pModuloActivo != NULL) {
		std::cout << m_pModuloActivo->GetNombre().c_str();
	}
	else {
		std::cout << "NULL";
	}
	std::cout  << std::endl;
	if (m_pModuloActivo == NULL) {
		std::cerr << "Aviso: ModuloActivo == NULL. Solicitud ignorada" << std::endl;
		return;
	}
#endif

	if (pTool != NULL && (!pTool->Habilitada() || !pTool->Mostrada()) ) { // No permitimos activar herramientas no habilitadas u ocultas
		std::cerr << "Herramienta no activada u oculta: " << pTool->Nombre.c_str() << std::endl;
		pEntorno->GetVentanaPrincipal()->SuperFreeze();
		return;
	}

	// Disable other tool using current button
	if ( buttonMask.IsLeftEnabled() ) {
		HerramientaActivas::iterator it = m_HerramientaActivaBotonIzquierdo.find(m_pModuloActivo);
		if (it != m_HerramientaActivaBotonIzquierdo.end()) {
			GNC::GCS::IHerramienta* pOtherTool = (*it).second;
			if (pOtherTool != NULL && pOtherTool != pTool) {
				pOtherTool->GetTriggerButton().DisableLeft();
				if (pOtherTool->GetTriggerButton().IsEmpty()) {
					pOtherTool->Conectar(false);
					pOtherTool->Activar(false);
					ActivarHerramientaBarra(pOtherTool, false);
				}
				else {
					pOtherTool->Conectar(false);
					pOtherTool->Conectar(true);
				}
			}
		}
		pTool->GetTriggerButton().EnableLeft();
		m_HerramientaActivaBotonIzquierdo[m_pModuloActivo] = pTool;
	}
	if ( buttonMask.IsRightEnabled() ) {

		HerramientaActivas::iterator it = m_HerramientaActivaBotonDerecho.find(m_pModuloActivo);
		if (it != m_HerramientaActivaBotonDerecho.end()) {
			GNC::GCS::IHerramienta* pOtherTool = (*it).second;
			if (pOtherTool != NULL && pOtherTool != pTool) {				
				pOtherTool->GetTriggerButton().DisableRight();
				if (pOtherTool->GetTriggerButton().IsEmpty()) {
					pOtherTool->Conectar(false);
					pOtherTool->Activar(false);
					ActivarHerramientaBarra(pOtherTool, false);
				}
				else {
					pOtherTool->Conectar(false);
					pOtherTool->Conectar(true);
				}				
			}
		}
		pTool->GetTriggerButton().EnableRight();
		m_HerramientaActivaBotonDerecho[m_pModuloActivo] = pTool;
	}

	if (pTool != NULL) {
		if (pTool->Habilitada()) {			
			pTool->Activar(true);
			ActivarHerramientaBarra(pTool, true);
		}
		pTool->Conectar(false);
		pTool->Conectar(true);

		GNC::GCS::ControladorVistas::Instance()->GetVistaActiva()->Activar();
	}

	//pEntorno->GetPanelHerramientasSuperior()->GetParent()->Layout();
	pEntorno->GetPanelHerramientasSuperior()->Layout();
	// pEntorno->GetPanelHerramientasSuperior()->GetParent()->Refresh();

	pEntorno->GetVentanaPrincipal()->SuperThaw();

#ifdef _GINKGO_TRACE
	std::cout << "--" << std::endl;
#endif

}


void GNC::ControladorHerramientas::OnActivarHerramienta(long toolId, const GNC::GCS::TriggerButton& buttonmask)
{

	if(m_MapaIdsHerramientas.find(toolId) != m_MapaIdsHerramientas.end()){
		int idHerramienta = m_MapaIdsHerramientas[toolId];
		SolicitarActivacion(m_Herramientas[idHerramienta], buttonmask);
	}
}

void GNC::ControladorHerramientas::OnKeyAccelerator(wxKeyEvent& event)
{
	//find tool with accelerator = event.GetKeyCode()
	int keyCode = event.GetKeyCode();
	for (MapaHerramientas::iterator it = m_Herramientas.begin(); it != m_Herramientas.end(); it++) {
		GNC::GCS::IHerramienta* pHerramienta = (*it).second;

		if (pHerramienta != NULL) {
			if (pHerramienta->Habilitada() && !pHerramienta->Activada() && pHerramienta->GetAcceleratorCode() == keyCode) {
				GNC::GCS::TriggerButton buttonMask;
				if (event.ShiftDown()) {
					buttonMask.EnableRight();
				}
				else {
					buttonMask.EnableLeft();
				}
				SolicitarActivacion(pHerramienta, buttonMask);
				event.Skip(false);
				break;
			}
		}
	}
}

// </editor-fold>
//endregion

//------------------------------------------------------------------------------
//region "Helpers"
// <editor-fold defaultstate="collapsed" desc="Helpers privados...">
AUI_NAMESPACE wxAuiToolBar* GNC::ControladorHerramientas::GetBarraHerramientasFamilia(GNC::GCS::IHerramienta::TFamiliasHerramientas familia)
{
	if(m_MapaBarrasHerramientas.find(familia) == m_MapaBarrasHerramientas.end()) {
		GNC::GCS::IEntorno* pEntorno = GNC::Entorno::Instance();
		BarraHerramientasControlador* pBarraHerramientas = new BarraHerramientasControlador(pEntorno->GetPanelHerramientasSuperior(),this,familia);
		pBarraHerramientas->SetAutoLayout(true);
		GNC::Entorno::Instance()->GetSizerHerramientas()->Add(pBarraHerramientas, 0, wxEXPAND, 0);
		m_MapaBarrasHerramientas[familia] = pBarraHerramientas;
		return pBarraHerramientas;
	} else {
		return (*m_MapaBarrasHerramientas.find(familia)).second;
	}
}

void GNC::ControladorHerramientas::FreezeBarrasHerramientas()
{
	/*
	for(MapaBarrasHerramientas::iterator it = m_MapaBarrasHerramientas.begin(); it!= m_MapaBarrasHerramientas.end(); it++) {
	(*it).second->Freeze();
	}
	*/
}

void GNC::ControladorHerramientas::ThawBarrasHerramientas()
{
	/*
	for(MapaBarrasHerramientas::iterator it = m_MapaBarrasHerramientas.begin(); it!= m_MapaBarrasHerramientas.end(); it++) {
	if((*it).second->IsFrozen()) {
	(*it).second->Thaw();
	}
	}
	*/
}
void GNC::ControladorHerramientas::ReconstruirBarrasHerramientas(bool rebuild)
{
	for(MapaBarrasHerramientas::iterator it = m_MapaBarrasHerramientas.begin(); it!= m_MapaBarrasHerramientas.end(); it++) {
		if((*it).second->GetToolCount() == 0){
			(*it).second->Show(false);
		} else {
			if(rebuild)
			{
				(*it).second->Realize();
			} else {
				(*it).second->Refresh(true);
			}
			(*it).second->Show(true);
		}
	}
	if (rebuild) {
		m_pBarraHerramientasDerecha->Refresh(true);
	}
}
// </editor-fold>
//endregion
