/*
 *  
 *  $Id: dicomizecommand.h 4708 2012-02-16 08:21:53Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/globals.h>
#include <api/api.h>
#include <api/icomando.h>
#include <api/ientorno.h>
#include <api/icontroladoreventos.h>
#include <api/imodelointegracion.h>
#include <main/gui/import/importationdata.h>

#include <wx/xml/xml.h>
#include <wx/thread.h>

class wxCriticalSectionLocker;
namespace GADAPI {
	class EXTAPI DicomizeCommandParams : public GNC::GCS::IComandoParams {
	public:
		DicomizeCommandParams(const GnkPtr<GNC::GUI::ImportationData>& pDatosPersistentes, const std::string& dirTemporal = "") ;

		DicomizeCommandParams( const DicomizeCommandParams& o);
		DicomizeCommandParams& operator = (const DicomizeCommandParams& o);

		virtual ~DicomizeCommandParams() ;

	public:
		GnkPtr<GNC::GUI::ImportationData> m_pImportData;
		std::string m_dirTemporal;
		std::list<std::string> m_listOfFiles;

		std::string m_mensajeError;
		bool m_importacionCorrecta;
		bool m_copiadoCorrecto;
		bool m_subirCorrecto;
		bool m_sendCorrect;
		wxSemaphore m_SemaforoEsperarComando;
		
		GNC::GCS::IComando*	m_pComandoEspera;
		GNC::GCS::IComandoParams*	m_pParamsEspera;
	};


	class EXTAPI DicomizeCommand : public GNC::GCS::IComando, public GNC::GCS::IObservador {
	public:
		DicomizeCommand(DicomizeCommandParams* pParams);

		typedef struct {
					wxString campoLista;
					wxString loincCodigoCampo;
					wxString loincDescCampo;
					wxString valor;
		} tValoracion;

		typedef std::list<tValoracion> listaValoraciones;

	 protected:
		virtual void Execute();
		virtual void Update();

		  virtual void OnAbort();

		void LiberarRecursos();

	protected:
		virtual bool ImportarFicherosOriginales();
		virtual GIL::ISeriesModel ImportOriginalFiles(bool pdfFiles);

		virtual bool CopiarDicom();

		virtual bool SubirPACS();

		virtual bool SendHL7Message();

		virtual void LanzarYEsperar(GNC::GCS::IComando* pCmd, GNC::GCS::IComandoParams* pCmdParams);

		virtual bool  BorrarArchivosTemporales(wxString dirPath);

		virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt) ;

		DicomizeCommandParams* m_pIntegracionParams;
	};
}
