/*
*  
*  $Id: comandochroma.cpp 3830 2011-05-06 13:30:18Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
//#define _GINKGO_TRACE
//#define DUMP_IMAGENES
#include <api/globals.h>
#include "comandochroma.h"
#include <api/inotificadoresherramientas.h>
#include <api/icacheimagenes.h>
#include <main/controllers/controladorlog.h>
#include <widgets/wpoligono.h>
#include <map>
#include <wx/thread.h>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif

#include <itkImage.h>
#include <itkImageRegionIterator.h>
#include <itkConnectedThresholdImageFilter.h>
#include <itkThresholdImageFilter.h>

#include <itkBinaryThresholdImageFilter.h>
#include <itkNumericTraits.h>
#include <itkImageFileWriter.h>

#include "../itk/itkVTKImageToImageFilter.h"
#include <itkExceptionObject.h>
#include <itkRGBToLuminanceImageFilter.h>
#include <itkNormalizeImageFilter.h>
#include <itkCastImageFilter.h>
#include <itkRGBPixel.h>
#include <itkSmartPointer.h>
#include <vtkImageData.h>
#include <vtkPointData.h>
#include <vtkFloatArray.h>
#include <vtkImageReslice.h>
#include <vtk/vtkginkgoimageviewer.h>

#define IDC_CHROMA_RESETEAR              51
#define IDC_CHROMA_SEGMENTAR_PUNTO       52
#define IDC_CHROMA_CANCELAR_SEGMENTACION 53
#define IDC_CHROMA_INSERTAR_REGION       54
#define IDC_CHROMA_ELIMINAR_REGION       55
#define IDC_CHROMA_TODO	                 57
#define IDC_CHROMA_INVERTIR              58
#define IDC_CHROMA_SEGMENTAR_LAZO                  59

// Singleton de persistencia
namespace GADAPI
{
	//callback de itk para el progreso
	class ChromaItkProgressCallback : public itk::Command
	{

	 public:
	  typedef ChromaItkProgressCallback Self;
	  typedef itk::Command                Superclass;

	  typedef itk::SmartPointer<Self>          Pointer;
	  typedef itk::SmartPointer<const Self>    ConstPointer;

	  itkTypeMacro (ChromaItkProgressCallback, itk::Command);
	  itkNewMacro (Self);

	  /** Standard Command virtual methods */
	  void Execute(itk::Object *caller, const itk::EventObject &event){
		  itk::ProcessObject* po = dynamic_cast<itk::ProcessObject*>(caller);
		  if( !po || !m_pComando )
			  return;

		  if( typeid(event) == typeid ( itk::ProgressEvent)  )
		  {
			  try{
				  if(!m_stop){
					  if (!m_pComando->NotificarProgreso(po->GetProgress(),m_texto))
					  {
						  po->SetAbortGenerateData(true);
					  }
				  }
			  }catch(std::exception& /*ex*/){
				  po->SetAbortGenerateData(true);
				  return;
			  }
		  }
	  }

	  void Execute(const itk::Object *caller, const itk::EventObject &event){
		  itk::ProcessObject* po = dynamic_cast<itk::ProcessObject*>( const_cast<itk::Object*>(caller));

		  if( !po || !m_pComando ) return;

		  if( typeid(event) == typeid ( itk::ProgressEvent)  )
		  {
			  try{
				  if(!m_stop){
					  if (!m_pComando->NotificarProgreso(po->GetProgress(),m_texto))
					  {
						  po->SetAbortGenerateData(true);
					  }
				  }
			  }catch(std::exception& /*ex*/){
				  po->SetAbortGenerateData(true);
				  return;
			  }
		  }
	  }

	  void SetCommand (GNC::GCS::IComando* cmd)
	  {
		  m_pComando=cmd;
	  }

	  void SetTexto  (std::string str)
	  {
		  m_texto=str;
	  }

	 protected:
		 ChromaItkProgressCallback(){
			m_pComando=NULL;
			m_stop=false;
		 }

		 ~ChromaItkProgressCallback(){
			m_pComando=NULL;
		 }

	 private:
		GNC::GCS::IComando* m_pComando;
		std::string m_texto;
		bool m_stop;
	};

	////////////////////////////////////////////////////////////
	ComandoChromaParams::ComandoChromaParams(GNC::GCS::IElementoCache* pImagen,
		vtkSmartPointer<vtkImageData> pMapaValoracion,
		GADAPI::Chroma::TipoAccion tipoAccion,
		wxCriticalSection* pMEF_CriticalSection,
		INotificadorChroma*  pNotificador,
		float sensibilidad,
		GADAPI::Chroma::TipoAmbito tipoAmbito)
	{
		m_pImagen = pImagen;
		m_pMapaValoracion = pMapaValoracion;
		m_pNotificador=pNotificador;
		m_sensibilidad=sensibilidad;
		m_pMEFCriticalSection=pMEF_CriticalSection;

		GTRACE(">> ComandoChromaParams::ComandoChromaParams(): " << this);
		m_TipoAccion = tipoAccion;
		m_TipoAmbito = tipoAmbito;
		m_pVista = NULL;

		x = 0;
		y = 0;
		GTRACE("<< ComandoChromaParams::ComandoChromaParams(): " << this);
	}

	ComandoChromaParams::ComandoChromaParams( GNC::GCS::IElementoCache* pImagen,
		vtkSmartPointer<vtkImageData> pMapaValoracion,
		wxCriticalSection* pMEF_CriticalSection,
		INotificadorChroma*  pNotificador,
		const TVerticesLazo& vertices, vtkGinkgoImageViewer* pVista) 
	{
		m_pImagen = pImagen;
		m_pMapaValoracion = pMapaValoracion;
		m_pNotificador=pNotificador;
		m_sensibilidad=0.0f;
		m_pMEFCriticalSection=pMEF_CriticalSection;

		GTRACE(">> ComandoChromaParams::ComandoChromaParams(): " << this);
		m_TipoAccion = GADAPI::Chroma::TAC_SegmentarLazo;
		m_Vertices = vertices;
		m_pVista = pVista;

		x = 0;
		y = 0;
		GTRACE("<< ComandoChromaParams::ComandoChromaParams(): " << this);
	}

	ComandoChromaParams::~ComandoChromaParams()
	{
		m_pMEFCriticalSection = NULL;
		m_pNotificador = NULL;
		m_pVista = NULL;
	}
	//////////////////////////////////////////////////////////////

	ComandoChroma::ComandoChroma(ComandoChromaParams* pParams) : IComando(pParams)
	{
		GTRACE(">> ComandoChroma::ComandoChroma(): " << this);
		m_pChromaParams = pParams;
		switch (m_pChromaParams->m_TipoAccion) {
			case GADAPI::Chroma::TAC_Resetear :
				SetId(IDC_CHROMA_RESETEAR);
				CancelaA(IDC_CHROMA_SEGMENTAR_PUNTO);
				CancelaA(IDC_CHROMA_SEGMENTAR_LAZO);
				CancelaA(IDC_CHROMA_INSERTAR_REGION);
				CancelaA(IDC_CHROMA_ELIMINAR_REGION);
				CancelaA(IDC_CHROMA_TODO);
				CancelaA(IDC_CHROMA_INVERTIR);
				AbortaSi(IDC_CHROMA_RESETEAR);
				break;
			case GADAPI::Chroma::TAC_Todo :
				SetId(IDC_CHROMA_TODO);
				CancelaA(IDC_CHROMA_SEGMENTAR_PUNTO);
				CancelaA(IDC_CHROMA_SEGMENTAR_LAZO);
				CancelaA(IDC_CHROMA_INSERTAR_REGION);
				CancelaA(IDC_CHROMA_ELIMINAR_REGION);
				CancelaA(IDC_CHROMA_INVERTIR);
				CancelaA(IDC_CHROMA_RESETEAR);
				AbortaSi(IDC_CHROMA_TODO);
				break;
			case GADAPI::Chroma::TAC_Invertir :
				SetId(IDC_CHROMA_INVERTIR);
				EsperaA(IDC_CHROMA_INSERTAR_REGION);
				EsperaA(IDC_CHROMA_ELIMINAR_REGION);
				EsperaA(IDC_CHROMA_INVERTIR);
				EsperaA(IDC_CHROMA_TODO);
				EsperaA(IDC_CHROMA_RESETEAR);
				EsperaA(IDC_CHROMA_INVERTIR);
				break;
			case GADAPI::Chroma::TAC_SegmentarPunto :
				SetId(IDC_CHROMA_SEGMENTAR_PUNTO);
				EsperaA(IDC_CHROMA_CANCELAR_SEGMENTACION);
				EsperaA(IDC_CHROMA_INSERTAR_REGION);
				EsperaA(IDC_CHROMA_ELIMINAR_REGION);
				EsperaA(IDC_CHROMA_INVERTIR);
				EsperaA(IDC_CHROMA_TODO);
				CancelaA(IDC_CHROMA_SEGMENTAR_PUNTO);
				CancelaA(IDC_CHROMA_SEGMENTAR_LAZO);
				break;
			case GADAPI::Chroma::TAC_CancelarSegmentacion :
				SetId(IDC_CHROMA_CANCELAR_SEGMENTACION);
				CancelaA(IDC_CHROMA_SEGMENTAR_PUNTO);
				CancelaA(IDC_CHROMA_SEGMENTAR_LAZO);
				AbortaSi(IDC_CHROMA_CANCELAR_SEGMENTACION);
				break;
			case GADAPI::Chroma::TAC_InsertarRegion :
				SetId(IDC_CHROMA_INSERTAR_REGION);
				EsperaA(IDC_CHROMA_RESETEAR);
				EsperaA(IDC_CHROMA_SEGMENTAR_PUNTO);
				EsperaA(IDC_CHROMA_SEGMENTAR_LAZO);
				AbortaSi(IDC_CHROMA_CANCELAR_SEGMENTACION);
				CancelaA(IDC_CHROMA_ELIMINAR_REGION);
				CancelaA(IDC_CHROMA_INSERTAR_REGION);
				EsperaA(IDC_CHROMA_TODO);
				EsperaA(IDC_CHROMA_INVERTIR);
				break;
			case GADAPI::Chroma::TAC_EliminarRegion :
				SetId(IDC_CHROMA_ELIMINAR_REGION);
				AbortaSi(IDC_CHROMA_RESETEAR);
				EsperaA(IDC_CHROMA_SEGMENTAR_PUNTO);
				EsperaA(IDC_CHROMA_SEGMENTAR_LAZO);
				AbortaSi(IDC_CHROMA_CANCELAR_SEGMENTACION);
				CancelaA(IDC_CHROMA_INSERTAR_REGION);
				CancelaA(IDC_CHROMA_ELIMINAR_REGION);
				AbortaSi(IDC_CHROMA_TODO);
				EsperaA(IDC_CHROMA_INVERTIR);
				break;
			case GADAPI::Chroma::TAC_SegmentarLazo :
				SetId(IDC_CHROMA_SEGMENTAR_LAZO);
				EsperaA(IDC_CHROMA_CANCELAR_SEGMENTACION);
				EsperaA(IDC_CHROMA_INSERTAR_REGION);
				EsperaA(IDC_CHROMA_ELIMINAR_REGION);
				EsperaA(IDC_CHROMA_INVERTIR);
				EsperaA(IDC_CHROMA_TODO);
				CancelaA(IDC_CHROMA_SEGMENTAR_PUNTO);
				CancelaA(IDC_CHROMA_SEGMENTAR_LAZO);
				break;
		}
		GTRACE("<< ComandoChroma::ComandoChroma(): " << this);
	}

	void ComandoChroma::Execute()
	{
		std::string tarea;

		//------------------RESETEAR=>TODO NO CHROMA-----------------------------//
		if (m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_Resetear) {
			wxCriticalSectionLocker* pLockerChroma = new wxCriticalSectionLocker(*(m_pChromaParams->m_pMEFCriticalSection));

			const unsigned char mascara = MASCARA_UNSET_CHROMA & MASCARA_UNSET_PRESELECCION;//un cero en el chroma y en la preseleccion
			unsigned char * data = (unsigned char*)m_pChromaParams->m_pMapaValoracion->GetScalarPointer();
			unsigned int numberOfTuples = m_pChromaParams->m_pMapaValoracion->GetPointData()->GetScalars()->GetNumberOfTuples();
			for (unsigned int off = 0; off < numberOfTuples; ++off) {
				data[off] =  data[off] & mascara; //se pone
			}

			delete pLockerChroma;
		}
		//------------------TODO CHROMA-----------------------------//
		else if (m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_Todo) {
			wxCriticalSectionLocker* pLockerChroma = new wxCriticalSectionLocker(*(m_pChromaParams->m_pMEFCriticalSection));

			unsigned char * data = (unsigned char*)m_pChromaParams->m_pMapaValoracion->GetScalarPointer();
			unsigned int numberOfTuples = m_pChromaParams->m_pMapaValoracion->GetPointData()->GetScalars()->GetNumberOfTuples();
			for (unsigned int off = 0; off < numberOfTuples; ++off) {
				data[off] =  (data[off] | MASCARA_SET_CHROMA) & MASCARA_UNSET_PRESELECCION; //se pone
			}

			delete pLockerChroma;
		}
		//------------------INVERTIR-----------------------------//
		else if (m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_Invertir) {
			wxCriticalSectionLocker* pLockerChroma = new wxCriticalSectionLocker(*(m_pChromaParams->m_pMEFCriticalSection));

			unsigned char * data = (unsigned char*)m_pChromaParams->m_pMapaValoracion->GetScalarPointer();
			unsigned int numberOfTuples = m_pChromaParams->m_pMapaValoracion->GetPointData()->GetScalars()->GetNumberOfTuples();
			for (unsigned int off = 0; off < numberOfTuples; ++off) {
				data[off] &= MASCARA_UNSET_PRESELECCION;
				if(data[off] < 0x80) { //no enmascarado
					data[off] |= MASCARA_SET_CHROMA;
				} else {
					data[off] &= MASCARA_UNSET_CHROMA;
				}
			}

			delete pLockerChroma;
		}
		//------------------SEGMENTAR PUNTO-----------------------------//
		else if (m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_SegmentarPunto) {
			if(m_pChromaParams->m_TipoAmbito==GADAPI::Chroma::TAC_Contiguo){
				tarea = _Std("Segmenting Chroma Local ...");
			}else{
				tarea = _Std("Chroma Segmenting Global ...");
			}
			NotificarProgreso(0.0f, tarea);
			//lo primero hacer el cast a I
			GNC::GCS::IElementoCacheConcreto<float>* pImagen = dynamic_cast<GNC::GCS::IElementoCacheConcreto<float>*>(m_pChromaParams->m_pImagen);
			if(pImagen == NULL){
				GINKGOLOGERROR("Se ha recibido en el comando chroma-Segmentar punto una imagen que no es float");
				return;
			}

			// Comprobación de limites
			if (m_pChromaParams->x < 0 ||
				m_pChromaParams->x >= pImagen->GetAncho() ||
					m_pChromaParams->y < 0 ||
					m_pChromaParams->y >= pImagen->GetAlto()) {

				#ifdef _GINKGO_DEBUG
					std::cerr << "Punto fuera de límites: " << m_pChromaParams->x << ", " << m_pChromaParams->y << std::endl;
					#endif
				return;

			}

			//se crea la imagen itk
			typedef float TPixelValoracion;
			typedef unsigned char TPixelSalida;
			typedef itk::Image< TPixelValoracion, 2 > TImagenValoracion;
			typedef itk::Image< TPixelSalida, 2 > TImagenSalida;
			typedef itk::ImageRegionIterator<TImagenValoracion> TIteradorValoracion;
			typedef itk::ImageRegionIterator<TImagenSalida> TIteradorSalida;

			typedef itk::ImageFileWriter<TImagenSalida> TEscritor;

			TImagenValoracion::Pointer imagenValoracion = TImagenValoracion::New();
			//se copia el pixeldata
			TImagenValoracion::IndexType start;
			start[0] = 0; // first index on X
			start[1] = 0; // first index on Y

			TImagenValoracion::SizeType size;

			size[0] = pImagen->GetAncho();
			size[1] = pImagen->GetAlto();

			TImagenValoracion::RegionType region;
			region.SetSize(size);
			region.SetIndex(start);
			imagenValoracion->SetRegions(region);
			imagenValoracion->Allocate();

			TIteradorValoracion it(imagenValoracion,imagenValoracion->GetLargestPossibleRegion());
			unsigned int off = 0;
			float* data = pImagen->GetPixelData();
			for (it.GoToBegin(); !it.IsAtEnd(); ++it) {
				it.Set(data[off++]);
			}

			GTRACE("ComandoChroma::Execute(): Semilla: " << m_pChromaParams->x << ", " << m_pChromaParams->y);

			if(m_pChromaParams->m_TipoAmbito==GADAPI::Chroma::TAC_Contiguo){
				typedef itk::ConnectedThresholdImageFilter< TImagenValoracion, TImagenSalida > TConnectedFilter;

				TConnectedFilter::Pointer segmentador = TConnectedFilter::New();
				segmentador->SetInput(imagenValoracion);

				TConnectedFilter::InputImageType::IndexType index;
				index[0] = m_pChromaParams->x;
				index[1] = m_pChromaParams->y;
				TConnectedFilter::InputImageType::PixelType threshold = imagenValoracion->GetPixel(index);

				const float nivelConfianza = (1.0f - m_pChromaParams->m_sensibilidad) / 2.0f;

				// Itervalo de Confianza del threshold%
				ChromaItkProgressCallback::Pointer cb = ChromaItkProgressCallback::New();
				cb->SetTexto(tarea);
				cb->SetCommand(this);

				segmentador->SetLower(std::max(0.0f, threshold - nivelConfianza ) );
				segmentador->SetUpper(std::min(1.0f, threshold + nivelConfianza ) );
				segmentador->SetReplaceValue(255);
				segmentador->SetSeed(index);

				segmentador->AddObserver (itk::ProgressEvent(), cb);

				segmentador->Update();
				if (segmentador->GetAbortGenerateData()) {
					segmentador->ResetPipeline();
					return;
				}

	#ifdef DUMP_IMAGENES
				{
					try{
						TEscritor::Pointer writer = TEscritor::New();
						writer->SetInput(segmentador->GetOutput());
						writer->SetFileName("imagenItk.jpg");
						writer->Update();
					} catch (itk::ExceptionObject ex) {
						std::cerr << ex.GetDescription() << std::endl;
					}
				}
	#endif


				TIteradorSalida it2(segmentador->GetOutput(), segmentador->GetOutput()->GetLargestPossibleRegion());

				wxCriticalSectionLocker* pLockerChroma = new wxCriticalSectionLocker(*(m_pChromaParams->m_pMEFCriticalSection));

				unsigned char * data = (unsigned char*)m_pChromaParams->m_pMapaValoracion->GetScalarPointer();
				unsigned int numberOfTuples = m_pChromaParams->m_pMapaValoracion->GetPointData()->GetScalars()->GetNumberOfTuples();
				it2.GoToBegin();
				for (unsigned int off = 0; off < numberOfTuples && !it2.IsAtEnd(); ++it2,++off) {
					if(it2.Get() == 0) { //no preseleccionado
						data[off] &= MASCARA_UNSET_PRESELECCION;
					} else {
						data[off] |= MASCARA_SET_PRESELECCION;
					}
				}
				delete pLockerChroma;
			}
			/////////////////////////GLOBAL//////////////////////////
			else{
				typedef itk::ThresholdImageFilter< TImagenValoracion > TThresholdFilter;
					TThresholdFilter::Pointer segmentador = TThresholdFilter::New();
					segmentador->SetInput(imagenValoracion);

					TThresholdFilter::InputImageType::IndexType index;
					index[0] = m_pChromaParams->x;
					index[1] = m_pChromaParams->y;
					TThresholdFilter::InputImageType::PixelType threshold = imagenValoracion->GetPixel(index);

					const float nivelConfianza = (1.0f - m_pChromaParams->m_sensibilidad) / 2.0f;

					// Itervalo de Confianza del threshold
					ChromaItkProgressCallback::Pointer cb = ChromaItkProgressCallback::New();
					cb->SetTexto(tarea);
					cb->SetCommand(this);

					segmentador->SetLower(std::max(0.0f, threshold - nivelConfianza ) );
					segmentador->SetUpper(std::min(1.0f, threshold + nivelConfianza ) );

					segmentador->AddObserver (itk::ProgressEvent(), cb);

					segmentador->Update();
					if (segmentador->GetAbortGenerateData()) {
						segmentador->ResetPipeline();
						//delete pLockerChroma;
						return;
					}


		#ifdef DUMP_IMAGENES
					try{
						itk::ImageFileWriter<TThresholdFilter::OutputImageType>::Pointer writer = itk::ImageFileWriter<TThresholdFilter::OutputImageType>::New();

						writer->SetInput(segmentador->GetOutput());
						writer->SetFileName("segmentacion_global.bmp");
						writer->Update();
					} catch (itk::ExceptionObject ex) {
						std::cerr << ex.GetDescription() << std::endl;
					}
		#endif

					TIteradorValoracion it2(segmentador->GetOutput(), segmentador->GetOutput()->GetLargestPossibleRegion());
					wxCriticalSectionLocker* pLockerChroma = new wxCriticalSectionLocker(*(m_pChromaParams->m_pMEFCriticalSection));

					unsigned char * data = (unsigned char*)m_pChromaParams->m_pMapaValoracion->GetScalarPointer();
					unsigned int numberOfTuples = m_pChromaParams->m_pMapaValoracion->GetPointData()->GetScalars()->GetNumberOfTuples();
					it2.GoToBegin();
					const float noPreselecc = segmentador->GetOutsideValue();
					for (unsigned int off = 0; off < numberOfTuples && !it2.IsAtEnd(); ++it2,++off) {
						if(it2.Get() == noPreselecc) { //no preseleccionado
							data[off] &= MASCARA_UNSET_PRESELECCION;
						} else {
							data[off] |= MASCARA_SET_PRESELECCION;
						}
					}
					delete pLockerChroma;
				}

				NotificarProgreso(1.0f, tarea);
		}
		//------------------CANCELAR SEGMENTACION-----------------------------//
		else if (m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_CancelarSegmentacion) {
			wxCriticalSectionLocker* pLockerChroma = new wxCriticalSectionLocker(*(m_pChromaParams->m_pMEFCriticalSection));

			unsigned char * data = (unsigned char*)m_pChromaParams->m_pMapaValoracion->GetScalarPointer();
			unsigned int numberOfTuples = m_pChromaParams->m_pMapaValoracion->GetPointData()->GetScalars()->GetNumberOfTuples();
			for (unsigned int off = 0; off < numberOfTuples; ++off) {
				data[off] &= MASCARA_UNSET_PRESELECCION;
			}
			delete pLockerChroma;
		}
		//------------------INSERTAR REGION-----------------------------//
		else if (m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_InsertarRegion) {
			wxCriticalSectionLocker* pLockerChroma = new wxCriticalSectionLocker(*(m_pChromaParams->m_pMEFCriticalSection));

			unsigned char * data = (unsigned char*)m_pChromaParams->m_pMapaValoracion->GetScalarPointer();
			unsigned int numberOfTuples = m_pChromaParams->m_pMapaValoracion->GetPointData()->GetScalars()->GetNumberOfTuples();
			for (unsigned int off = 0; off < numberOfTuples; ++off) {
				if((data[off] & MASCARA_SET_PRESELECCION) != 0) { //preseleccionado
					data[off] |= MASCARA_SET_CHROMA;
					data[off] &= MASCARA_UNSET_PRESELECCION; //se quita preseleccion
				}
			}
			delete pLockerChroma;

		}
		//------------------ELIMINAR REGION-----------------------------//
		else if (m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_EliminarRegion) {
			wxCriticalSectionLocker* pLockerChroma = new wxCriticalSectionLocker(*(m_pChromaParams->m_pMEFCriticalSection));

			unsigned char * data = (unsigned char*)m_pChromaParams->m_pMapaValoracion->GetScalarPointer();
			unsigned int numberOfTuples = m_pChromaParams->m_pMapaValoracion->GetPointData()->GetScalars()->GetNumberOfTuples();
			unsigned char mascara = MASCARA_UNSET_CHROMA & MASCARA_UNSET_PRESELECCION; // se quita el chroma y la preseleccion
			for (unsigned int off = 0; off < numberOfTuples; ++off) {
				if((data[off] & MASCARA_SET_PRESELECCION) != 0) { //preseleccionado
					data[off] &= mascara;
				}
			}
			delete pLockerChroma;
		}
		//------------------SEGMENTAR LAZO-----------------------------//
		else if (m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_SegmentarLazo) {

			const std::string tarea = _Std("Extracting cut ...");
			NotificarProgreso(0.0f, tarea);
			const int* dims;
			const double* origin;
			const double* spacing;

			GNC::GCS::Vector BoundingBoxROI[2];
			GNC::GCS::Vector BoundingBoxTriangulo[2];

			ComandoChromaParams::TVerticesLazo vertices = m_pChromaParams->m_Vertices;

			GNC::GCS::Vector pv; // Vector de posicion en la imagen.

			wxCriticalSectionLocker* pLockerChroma = new wxCriticalSectionLocker(*(m_pChromaParams->m_pMEFCriticalSection));

			spacing = m_pChromaParams->m_pMapaValoracion->GetSpacing();
			origin  = m_pChromaParams->m_pMapaValoracion->GetOrigin();
			dims    = m_pChromaParams->m_pMapaValoracion->GetDimensions();

			if (dims[0] == 0 || dims[1] == 0 || vertices.size() < 3) {
				delete pLockerChroma;
				return;
			}

			unsigned char* scalars = (unsigned char*)(m_pChromaParams->m_pMapaValoracion->GetScalarPointer());

			// Transformacion a coordenadas imagen e inicializacion del ROI (Bounding box del poligono)

			{
				GNC::GCS::Vector BoundingBoxImagen[2];
				BoundingBoxImagen[1].Asignar(dims[0]-1, dims[1]-1);

				ComandoChromaParams::TVerticesLazo::iterator nodo = vertices.begin();
				{
					GNC::GCS::Nodo& n = (*nodo);
					m_pChromaParams->m_pVista->CoordenadasMundoACoordenadasImagen(n.x, n.y, n.x, n.y);

					n.IniciarBoundingBox(BoundingBoxROI );
				}

				for (nodo++; nodo != vertices.end(); nodo++) {
					GNC::GCS::Nodo& n = (*nodo);
					m_pChromaParams->m_pVista->CoordenadasMundoACoordenadasImagen(n.x, n.y, n.x, n.y);
					n.ExtenderBoundingBox(BoundingBoxROI );
				}
				BoundingBoxROI[0].Redondear();
				BoundingBoxROI[1].Redondear();

				GNC::GCS::Vector::IntersectarBoundingBox(BoundingBoxROI, BoundingBoxImagen, BoundingBoxROI);
			}

			ComandoChromaParams::TVerticesLazo::iterator nodo1 = vertices.begin();
			ComandoChromaParams::TVerticesLazo::iterator nodo2 = nodo1;
			nodo2++;
			ComandoChromaParams::TVerticesLazo::iterator nodo3 = nodo2;
			nodo3++;

			const unsigned long stride = dims[0];
			unsigned long x   = 0;
			unsigned long y   = 0;
			unsigned long ox  = 0;

			//==============================================
			#if defined(CURVAS_JORDAN) // Metodo del teorema de las curvas de jordan

			if (GNC::GCS::Vector::BoundingBoxValido(BoundingBoxROI)) {
				unsigned long ipx[2] = { BoundingBoxROI[0].x, BoundingBoxROI[1].x };
				unsigned long ipy[2] = { BoundingBoxROI[0].y, BoundingBoxROI[1].y };
				float step = 1.0f / (ipy[1] - ipy[0]);
				float progress = 0.0f;

				unsigned long off = (ipy[0] * dims[0]) + ipx[0];

				for (y = ipy[0]; y <= ipy[1]; ++y) {
					ox = 0;
					pv.y = y;
					for (x = ipx[0]; x <= ipx[1]; ++x) {
						pv.x = x;
						if ( pv.DentroDePoligono2(vertices) ) {
							scalars[off + (ox++)] |= MASCARA_SET_PRESELECCION;
						}
						else {
							scalars[off + (ox++)] &= MASCARA_UNSET_PRESELECCION;
						}
					}
					off += stride;
					try {
						progress += step;
						NotificarProgreso(progress, tarea);
					}
					catch(std::exception& ex){
						delete pLockerChroma;
						throw ex;
					}
				}
			}

			//==============================================
			#else // Metodo de las curvas de jordan con optimizacion por triangulacion

			float step = 1.0f / std::max(1.0f, (float)vertices.size() - 3.0f);
			float progress = 0.0f;
			while (nodo3 != vertices.end()) {

				GNC::GCS::Vector triangulo[3] = { (*nodo1).Redondeado(), (*nodo2).Redondeado(), (*nodo3).Redondeado() };

				triangulo[0].IniciarBoundingBox(BoundingBoxTriangulo);
				triangulo[1].ExtenderBoundingBox(BoundingBoxTriangulo);
				triangulo[2].ExtenderBoundingBox(BoundingBoxTriangulo);

				GNC::GCS::Vector::IntersectarBoundingBox(BoundingBoxTriangulo, BoundingBoxROI, BoundingBoxTriangulo);

				if ( GNC::GCS::Vector::BoundingBoxValido(BoundingBoxTriangulo) ) {

					unsigned long ipx[2] = { BoundingBoxTriangulo[0].x, BoundingBoxTriangulo[1].x };
					unsigned long ipy[2] = { BoundingBoxTriangulo[0].y, BoundingBoxTriangulo[1].y };

					unsigned long off = (ipy[0] * dims[0]) + ipx[0];

					for (y = ipy[0]; y <= ipy[1]; ++y) {
						ox = 0;
						pv.y = y;
						for (x = ipx[0]; x <= ipx[1]; ++x) {
							pv.x = x;
							if ( pv.DentroDePoligono2(triangulo, 3) ) {
								if(( scalars[off + ox] & MASCARA_SET_PRESELECCION) == 0) {
									scalars[off + ox] |= MASCARA_SET_PRESELECCION;
								} else {
									scalars[off + ox] &= MASCARA_UNSET_PRESELECCION;
								}
							}
							ox++;
						}
						off += stride;

					}
				}
				try {
					progress += step;
					NotificarProgreso(progress, tarea);
				}
				catch(std::exception& ex){
					delete pLockerChroma;
					throw ex;
				}
				nodo2++;
				nodo3++;
			}
			#endif

			delete pLockerChroma;
		}
	}

	void ComandoChroma::Update()
	{
		wxCriticalSectionLocker* pLockerChroma = new wxCriticalSectionLocker(*(m_pChromaParams->m_pMEFCriticalSection));

		if (m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_Resetear ||
			m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_Todo ||
			m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_Invertir ||
			m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_InsertarRegion ||
			m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_EliminarRegion) {
			m_pChromaParams->m_pMapaValoracion->Update();
			if (m_pChromaParams->m_pNotificador != NULL) {
				m_pChromaParams->m_pNotificador->ActualizarVistaChroma(true);
			}
		}else if(m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_SegmentarPunto ||
			m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_SegmentarLazo ||
			m_pChromaParams->m_TipoAccion == GADAPI::Chroma::TAC_CancelarSegmentacion ){
			if (m_pChromaParams->m_pNotificador != NULL) {
				m_pChromaParams->m_pNotificador->ActualizarVistaChroma(false);
			}

		}
		delete pLockerChroma;

	}

}
