/*
*  
*  $Id: comandoactualizaciones.h 4410 2011-11-18 08:34:07Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/icomando.h>
#include <yasper/yasper.h>

namespace GNC {
	namespace GCS {
		class IVista;
	}
}
class wxHTTPBuilder;
namespace GNC {
	class ComandoComprobarActualizaciones;

	class ComandoComprobarActualizacionesParams : public GNC::GCS::IComandoParams {
	public:
		ComandoComprobarActualizacionesParams(const std::string& url, bool informar = false);

		virtual ~ComandoComprobarActualizacionesParams();

		std::string                     m_URL;
		bool                            m_Informar;
		wxHTTPBuilder*						  m_pBuilder;

	};

	class ComandoComprobarActualizaciones : public GNC::GCS::IComando {
	public:

		ComandoComprobarActualizaciones(ComandoComprobarActualizacionesParams* pParams);

    protected:

		virtual void Execute();
		virtual void Update();
		virtual void OnAbort();

	protected:

		ComandoComprobarActualizacionesParams* m_pComprobarActualizacionesParams;
		std::string                            m_Error;

	private:
		std::string m_VersionStr;
		std::string m_VersionCheckStr;
		std::string m_Description;
		std::string m_URL;
		int         m_Version;
		int         m_SubVersion;
		int         m_Release;
		int         m_Build;
		std::string m_CodeName;
	};
}
