/*
 *  
 *  $Id: icontroladorprogreso.h 3698 2011-04-14 12:38:49Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <string>
#include <api/ilock.h>

namespace GNC {
	class EXTAPI IControladorProgreso {
	public:

		IControladorProgreso() { }

		~IControladorProgreso() { }

		virtual void InsertarTarea(long taskId, const std::string& texto) = 0;

		virtual void EliminarTarea(long taskId) = 0;

		virtual void SetProgresoTarea(long taskId, float normalizedProgress, const std::string& texto) = 0;

	};

	class EXTAPI INotificadorProgreso : public GNC::GCS::ILockable {

	public:

		INotificadorProgreso() {
			m_ProgresoNormalizado = 0;
		}

		~INotificadorProgreso() {}

		virtual bool NotificarProgreso(float progresoNormalizado, const std::string& texto) = 0;

		/** Cuidado! hay que proteger estos accesos con un cerrojo **/
		float GetProgresoNormalizado() {
			return m_ProgresoNormalizado;
		}

		/** Cuidado! hay que proteger estos accesos con un cerrojo **/
		std::string GetTextoProgreso() {
			return m_Texto;
		}

		/** Cuidado! hay que proteger estos accesos con un cerrojo **/
		void SetProgresoNormalizado(float progresoNormalizado)
		{
			m_ProgresoNormalizado = progresoNormalizado;
		}

		/** Cuidado! hay que proteger estos accesos con un cerrojo **/
		void SetTextoProgreso(const std::string& texto)
		{
			m_Texto = texto;
		}

		void LockProgreso(const std::string& loc)
		{
			this->Lock(loc);
		}

		void UnLockProgreso(const std::string& loc)
		{
			this->UnLock(loc);
		}

	private:
		std::string m_Texto;
		float m_ProgresoNormalizado;
	};
}
