/*
 *  
 *  $Id: ibutton.h 4482 2011-12-13 14:01:29Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once

namespace GNC {
	namespace GCS {

		const int EMPTYBUTTONMASK = 0x00;
		const int LBUTTONMASK = 0x01;
		const int RBUTTONMASK = 0x02;
		const int MBUTTONMASK = 0x04;

		class EXTAPI TriggerButton {

		public:

			inline TriggerButton() {
				ResetTriggerButtonMask();
			}

			inline TriggerButton(const TriggerButton& o) {
				*this = o;
			}

			/** Resets the activation button mask
			**/
			inline void ResetTriggerButtonMask() {
				m_TriggerButtonMask = GNC::GCS::EMPTYBUTTONMASK;
			}

			/** Enable activation button mask
			**/
			inline void EnableTriggerButton(int mask) {
				m_TriggerButtonMask |= mask;
			}

			inline TriggerButton& EnableLeft() {
				EnableTriggerButton(LBUTTONMASK);
				return *this;
			}

			inline TriggerButton& EnableRight() {
				EnableTriggerButton(RBUTTONMASK);
				return *this;
			}

			inline TriggerButton& EnableMiddle() {
				EnableTriggerButton(MBUTTONMASK);
				return *this;
			}

			/** Disable activation button mask
			**/
			inline void DisableTriggerButton(int mask) {
				m_TriggerButtonMask &= ~mask;
			}

			inline TriggerButton& DisableLeft() {
				DisableTriggerButton(LBUTTONMASK);
				return *this;
			}

			inline TriggerButton& DisableRight() {
				DisableTriggerButton(RBUTTONMASK);
				return *this;
			}

			inline TriggerButton& DisableMiddle() {
				DisableTriggerButton(MBUTTONMASK);
				return *this;
			}

			/** Checks activation button mask is applied
			**/
			inline bool IsTriggerButtonEnabled(int mask) const {
				return (0 != (m_TriggerButtonMask & mask));
			}

			inline bool IsLeftEnabled() const {
				return IsTriggerButtonEnabled(LBUTTONMASK);
			}

			inline bool IsRightEnabled() const {
				return IsTriggerButtonEnabled(RBUTTONMASK);
			}

			inline bool IsMiddleEnabled() const {
				return IsTriggerButtonEnabled(MBUTTONMASK);
			}

			inline TriggerButton& operator=(const TriggerButton& o) {
				this->m_TriggerButtonMask = o.m_TriggerButtonMask;
				return *this;
			}

			inline bool IsEmpty() const {
				return this->m_TriggerButtonMask == EMPTYBUTTONMASK;
			}

			

		protected:
			int m_TriggerButtonMask;
		};
	}
}