%define name GiNaC
%define version 1.0.8
%define release 1

Summary: C++ library for symbolic calculations
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: System Environment/Libraries
Source: ftp://ftpthep.physik.uni-mainz.de/pub/GiNaC/%{name}-%{version}.tar.gz
URL: http://www.ginac.de/
Packager: Christian Bauer <cbauer@ginac.de>
Prereq: /sbin/install-info
BuildRoot: %{_tmppath}/%{name}-root
Prefix: %{_prefix}

Requires: cln >= 1.1

%description
GiNaC (which stands for "GiNaC is Not a CAS (Computer Algebra System)") is an
open framework for symbolic computation within the C++ programming language.


%package devel
Summary: GiNaC development libraries and header files
Group: Development/Libraries
Requires: %{name} = %{version}

%description devel
GiNaC (which stands for "GiNaC is Not a CAS (Computer Algebra System)") is an
open framework for symbolic computation within the C++ programming language.

This package contains the libraries, include files and other resources you
use to develop GiNaC applications.


%package utils
Summary: GiNaC-related utilities
Group: System Environment/Libraries
Requires: %{name} = %{version}

%description utils
GiNaC (which stands for "GiNaC is Not a CAS (Computer Algebra System)") is an
open framework for symbolic computation within the C++ programming language.

This package includes the ginsh ("GiNaC interactive shell") which provides a
simple and easy-to-use CAS-like interface to GiNaC for non-programmers, and
the tool "viewgar" which displays the contents of GiNaC archives.


%prep
%setup -q

%build
CFLAGS=${RPM_OPT_FLAGS} CXXFLAGS=${RPM_OPT_FLAGS} ./configure --prefix=%{_prefix} --mandir=%{_mandir} --infodir=%{_infodir}
if [ -x /usr/bin/getconf ] ; then
  NCPU=$(/usr/bin/getconf _NPROCESSORS_ONLN)
  if [ $NCPU -eq 0 ] ; then
    NCPU=1
  fi
else  
  NCPU=1
fi
PARL=$[ $NCPU + 1 ]
(make -k -j $PARL; exit 0)
make

%install
rm -rf ${RPM_BUILD_ROOT}
make DESTDIR=${RPM_BUILD_ROOT} install
gzip -9nf ${RPM_BUILD_ROOT}%{_infodir}/ginac.info*

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%post devel
/sbin/install-info %{_infodir}/ginac.info.gz %{_infodir}/dir

%preun devel
if [ "$1" = 0 ]; then
  /sbin/install-info --delete %{_infodir}/ginac.info.gz %{_infodir}/dir
fi

%files
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog NEWS README
%{_libdir}/*.so.*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/*.la
%{_libdir}/*.so
%{_includedir}/ginac/*.h
%{_infodir}/*.info*
%{_mandir}/man1/ginac-config.1*
%{_bindir}/ginac-config
%{_datadir}/aclocal/*

%files utils
%defattr(-,root,root)
%{_bindir}/ginsh
%{_bindir}/viewgar
%{_mandir}/man1/ginsh.1*
%{_mandir}/man1/viewgar.1*

%changelog
* Thu Nov  1 2001 Christian Bauer <Christian.Bauer@uni-mainz.de>
- moved ginsh and viewgar to "utils" package

* Thu Oct  5 2000 Christian Bauer <Christian.Bauer@uni-mainz.de>
- cleaned up a bit

* Wed Jan 26 2000 Christian Bauer <Christian.Bauer@uni-mainz.de>
- split into user and devel packages

* Wed Dec  1 1999 Christian Bauer <Christian.Bauer@uni-mainz.de>
- aclocal macros get installed
