/* gap_enc_ffmpeg_gui.c
 * 2003.01.07 hof (Wolfgang Hofer)
 *
 * GAP ... Gimp Animation Plugins
 *
 * This Module contains FFMPEG specific Video Encoder GUI Procedures
 */
/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* revision history:
 * version 2.1.0a;  2004/11/05   hof: replaced deprecated option menu by gimp_int_combo_box
 *                                    reorganized the GUI code.
 *                                    (the origial code-monster was generated by an old version of glade
 *                                     and was harder to read by humans)
 * version 2.1.0a;  2004.06.05   hof: update params from ffmpeg 0.4.6 to 0.4.8
 * version 2.1.0a;  2004.05.12   hof: integration into gimp-gap project
 * version 1.2.2c;  2003.05.29   hof: dont_recode_flag
 * version 1.2.2c;  2003.01.07   hof: created
 */

#include <config.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>



#include "gap_libgapvidutil.h"
#include "gap-intl.h"

#include "gap_libgapvidutil.h"
#include "gap_libgimpgap.h"

#include "gap_enc_ffmpeg_main.h"
#include "gap_enc_ffmpeg_gui.h"
#include "gap_enc_ffmpeg_callbacks.h"

/* Includes for encoder specific extra LIBS */
#include "avformat.h"
#include "avcodec.h"



typedef struct
{
  char *name;
  gint  menu_idx;
  void *next;
} t_string_combo_elem;

static GtkWidget * p_ff_cmp_func_combo_box_new(void);
static void     p_replace_combo_file_format(GapGveFFMpegGlobalParams *gpp);
static void     p_replace_combo_vid_codec(GapGveFFMpegGlobalParams *gpp);
static void     p_replace_combo_aud_codec(GapGveFFMpegGlobalParams *gpp);
static void     p_init_spinbuttons(GapGveFFMpegGlobalParams *gpp);
static void     p_init_vid_checkbuttons(GapGveFFMpegGlobalParams *gpp);
static void     p_init_entry_widgets(GapGveFFMpegGlobalParams *gpp);
static char*    p_init_combo_actual_nameidx(GapGveFFMpegGlobalParams *gpp, GtkWidget *wgt, t_string_combo_elem *list, char *name);
static gint32   p_init_gint_combo_active(GapGveFFMpegGlobalParams *gpp, GtkWidget *widget, gint *gtab_ptr, gint val, gint maxidx);
static gint     p_init_gdouble_combo_actual_idx(GapGveFFMpegGlobalParams *gpp, GtkWidget *widget, gdouble *gtab_ptr, gdouble val, gint maxidx);



GtkWidget*      p_create_basic_options_frame (GapGveFFMpegGlobalParams *gpp);
GtkWidget*      p_create_expert_algortihms_frame (GapGveFFMpegGlobalParams *gpp);
GtkWidget*      p_create_expert_flags_frame (GapGveFFMpegGlobalParams *gpp);
GtkWidget*      p_create_expert_flags2_frame (GapGveFFMpegGlobalParams *gpp);
GtkWidget*      p_create_expert_options_frame (GapGveFFMpegGlobalParams *gpp);
GtkWidget*      p_create_2pass_options_frame (GapGveFFMpegGlobalParams *gpp);
GtkWidget*      p_create_file_comment_frame (GapGveFFMpegGlobalParams *gpp);



static gint     gtab_motion_est[GAP_GVE_FFMPEG_MOTION_ESTIMATION_MAX_ELEMENTS] =  { 1, 2, 3, 4, 5, 6 };
static gint     gtab_dct_algo[GAP_GVE_FFMPEG_DCT_ALGO_MAX_ELEMENTS] =  { 0, 1, 2, 3, 4, 5, 6 };
static gint     gtab_idct_algo[GAP_GVE_FFMPEG_IDCT_ALGO_MAX_ELEMENTS] =  { 0, 1, 2, 3, 4, 5, 6, 7, 8 };
static gint     gtab_mb_decision[GAP_GVE_FFMPEG_MB_DECISION_MAX_ELEMENTS] =  { FF_MB_DECISION_SIMPLE, FF_MB_DECISION_BITS, FF_MB_DECISION_RD };
static gint     gtab_audio_krate[GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_MAX_ELEMENTS] = { 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320 };
static gdouble  gtab_aspect[GAP_GVE_FFMPEG_ASPECT_MAX_ELEMENTS] =  { 0.0, 1.5, 1.333333333, 1.777777778 };

static gint     gtab_coder[GAP_GVE_FFMPEG_CODER_TYPE_MAX_ELEMENTS] =
                 { GAP_GVE_FFMPEG_CODER_TYPE_00_VLC
                 , GAP_GVE_FFMPEG_CODER_TYPE_01_AC
                 };

static gint     gtab_predictor[GAP_GVE_FFMPEG_PREDICTOR_MAX_ELEMENTS] =
                 { GAP_GVE_FFMPEG_PREDICTOR_00_LEFT
                 , GAP_GVE_FFMPEG_PREDICTOR_01_PLANE
                 , GAP_GVE_FFMPEG_PREDICTOR_02_MEDIAN
                 };

static gint     gtab_cmp_func[GAP_GVE_FFMPEG_CMP_MAX_ELEMENTS] =
                 { GAP_GVE_FFMPEG_CMP_00_SAD
                 , GAP_GVE_FFMPEG_CMP_01_SSE
                 , GAP_GVE_FFMPEG_CMP_02_SATD
                 , GAP_GVE_FFMPEG_CMP_03_DCT
                 , GAP_GVE_FFMPEG_CMP_04_PSNR
                 , GAP_GVE_FFMPEG_CMP_05_BIT
                 , GAP_GVE_FFMPEG_CMP_06_RD
                 , GAP_GVE_FFMPEG_CMP_07_ZERO
                 , GAP_GVE_FFMPEG_CMP_08_VSAD
                 , GAP_GVE_FFMPEG_CMP_09_VSSE
                 , GAP_GVE_FFMPEG_CMP_10_NSSE
                 , GAP_GVE_FFMPEG_CMP_11_W53
                 , GAP_GVE_FFMPEG_CMP_12_W97
                 , GAP_GVE_FFMPEG_CMP_13_DCTMAX
                 , GAP_GVE_FFMPEG_CMP_14_CHROMA
                 };

/* lists of all available fileformats and codecs
 * (lists are built at runtime by ffmpeg specific query)
 */
t_string_combo_elem  *glist_vid_codec = NULL;
t_string_combo_elem  *glist_aud_codec = NULL;
t_string_combo_elem  *glist_fileformat = NULL;


/* --------------------------------
 * p_ff_cmp_func_combo_box_new
 * --------------------------------
 * create a new gimp_int_combo_box
 * with items for the ffmpeg compare funtions
 */
GtkWidget *
p_ff_cmp_func_combo_box_new(void)
{
  GtkWidget *combo;

  combo = gimp_int_combo_box_new (_("0 sad"),            GAP_GVE_FFMPEG_CMP_00_SAD,
                                  _("1 sse"),            GAP_GVE_FFMPEG_CMP_01_SSE,
                                  _("2 satd"),           GAP_GVE_FFMPEG_CMP_02_SATD,
                                  _("3 dct"),            GAP_GVE_FFMPEG_CMP_03_DCT,
                                  _("4 psnr"),           GAP_GVE_FFMPEG_CMP_04_PSNR,
                                  _("5 bit"),            GAP_GVE_FFMPEG_CMP_05_BIT,
                                  _("6 rd"),             GAP_GVE_FFMPEG_CMP_06_RD,
                                  _("7 zero"),           GAP_GVE_FFMPEG_CMP_07_ZERO,
                                  _("8 vsad"),           GAP_GVE_FFMPEG_CMP_08_VSAD,
                                  _("9 vsse"),           GAP_GVE_FFMPEG_CMP_09_VSSE,
                                  _("10 nsse"),          GAP_GVE_FFMPEG_CMP_10_NSSE,
                                  _("11 w53"),           GAP_GVE_FFMPEG_CMP_11_W53,
                                  _("12 w97"),           GAP_GVE_FFMPEG_CMP_12_W97,
                                  _("13 dctmax"),        GAP_GVE_FFMPEG_CMP_13_DCTMAX,
                                  _("256 chroma"),       GAP_GVE_FFMPEG_CMP_14_CHROMA,
                                  NULL);
  return (combo);
}  /* end p_ff_cmp_func_combo_box_new */


/* --------------------------------
 * p_replace_combo_file_format
 * --------------------------------
 * replace the fileformat combo by dynamic menu
 * (we get the format names from the FFMPEG Lib)
 */

static void
p_replace_combo_file_format(GapGveFFMpegGlobalParams *gpp)
{
  gint  l_active_idx;
  gint  l_idx;
  AVOutputFormat *ofmt;
  t_string_combo_elem  *elem_fileformat;


  if(gap_debug) printf("p_replace_combo_file_format: START\n");

  glist_fileformat = NULL;


  l_idx = 0;
  l_active_idx = 0;

  for(ofmt = first_oformat; ofmt != NULL; ofmt = ofmt->next)
  {
     char *menu_name;
     char *object_data;

     object_data = (char*)ofmt->name;

     menu_name = g_strdup_printf("[%s] %s", object_data, ofmt->long_name);

     if(gap_debug)
     {
        printf("p_replace_combo_file_format: val[%d]: %s\n", (int)l_idx, menu_name);

        printf("MIME_TYPE: %s\n", ofmt->mime_type);
        printf("EXTENSIONS: %s\n", ofmt->extensions);
        printf("Default VID_CODEC ID: %d\n", ofmt->video_codec);
        printf("Default AUD_CODEC ID: %d\n", ofmt->audio_codec);
        printf("flags: %d\n", (int)ofmt->flags );
     }

     /* Filter filefromats (not interested in audio and single image fileformats, pipe ...)
      * - mime_type must be != NULL and should start with "video"
      * - format must support video codec  (codec_id != 0)
      * - formats that support both video_codec and audio_code are accepted
      *   (even if the mime type is not "video")
      */
     if((ofmt->mime_type != NULL) && (ofmt->video_codec != 0))
     {
       if((strncmp(ofmt->mime_type, "video", 5) == 0) || (ofmt->audio_codec != 0))
       {
         elem_fileformat = (t_string_combo_elem *) g_malloc0(sizeof(t_string_combo_elem));
         elem_fileformat->menu_idx = l_idx;
         elem_fileformat->name     = g_strdup(object_data);
         elem_fileformat->next     = glist_fileformat;
         glist_fileformat = elem_fileformat;

         gimp_int_combo_box_append (GIMP_INT_COMBO_BOX (gpp->ff_fileformat_combo),
                                 GIMP_INT_STORE_VALUE, l_idx,
                                 GIMP_INT_STORE_LABEL, menu_name,
                                 -1);

         if(strcmp(object_data, gpp->evl.format_name) == 0)
         {
             l_active_idx = l_idx;
         }
         l_idx++;
       }
     }
  }

  g_object_set_data (G_OBJECT (gpp->ff_fileformat_combo)
                    , GAP_ENC_FFGUI_COMBO_STRLIST
                    , (gpointer)glist_fileformat
                    );

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (gpp->ff_fileformat_combo)
                             , l_active_idx,
                              G_CALLBACK (on_ff_fileformat_combo),
                              gpp);

  /* gimp_int_combo_box_set_active (GIMP_INT_COMBO_BOX (gpp->ff_fileformat_combo)
   *                              , l_active_idx);
   */
}  /* end p_replace_combo_file_format */


/* --------------------------------
 * p_replace_combo_vid_codec
 * --------------------------------
 * replace the vid_codec combo by dynamic menu
 * (we get the video codecs from the FFMPEG Lib)
 */
static void
p_replace_combo_vid_codec(GapGveFFMpegGlobalParams *gpp)
{
  gint  l_active_idx;
  gint  l_idx;
  AVCodec *avcodec;
  t_string_combo_elem  *elem_vid_codec;


  if(gap_debug) printf("p_replace_combo_vid_codec: START\n");

  glist_vid_codec = NULL;

  l_idx = 0;
  l_active_idx = 0;

  for(avcodec = av_codec_next(NULL); avcodec != NULL; avcodec = av_codec_next(avcodec))
  {
     char *menu_name;
     char *object_data;
     if ((avcodec->encode) && (avcodec->type == CODEC_TYPE_VIDEO))
     {
       object_data = (char *)avcodec->name;

       menu_name = g_strdup(object_data);

       if(gap_debug)
       {
          printf("p_replace_combo_vid_codec: val[%d]: %s\n"
                 , (int)l_idx
                 , menu_name
                 );
       }
       elem_vid_codec = (t_string_combo_elem *) g_malloc0(sizeof(t_string_combo_elem));
       elem_vid_codec->menu_idx = l_idx;
       elem_vid_codec->name     = g_strdup(object_data);
       elem_vid_codec->next     = glist_vid_codec;
       glist_vid_codec = elem_vid_codec;

       gimp_int_combo_box_append (GIMP_INT_COMBO_BOX (gpp->ff_vid_codec_combo),
                                 GIMP_INT_STORE_VALUE, l_idx,
                                 GIMP_INT_STORE_LABEL, menu_name,
                                 -1);

       if(strcmp(object_data, gpp->evl.vcodec_name) == 0)
       {
           l_active_idx = l_idx;
       }
       l_idx++;
     }
  }

  g_object_set_data (G_OBJECT (gpp->ff_vid_codec_combo)
                    , GAP_ENC_FFGUI_COMBO_STRLIST
                    , (gpointer)glist_vid_codec
                    );
  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (gpp->ff_vid_codec_combo)
                             , l_active_idx,
                              G_CALLBACK (on_ff_vid_codec_combo),
                              gpp);

  /* gimp_int_combo_box_set_active (GIMP_INT_COMBO_BOX (gpp->ff_vid_codec_combo)
   *                              , l_active_idx);
   */

}  /* end p_replace_combo_vid_codec */


/* --------------------------------
 * p_replace_combo_aud_codec
 * --------------------------------
 * replace the aud_codec combo by dynamic menu
 * (we get the audio codecs from the FFMPEG Lib)
 */
static void
p_replace_combo_aud_codec(GapGveFFMpegGlobalParams *gpp)
{
  gint  l_active_idx;
  gint  l_idx;
  AVCodec *avcodec;
  t_string_combo_elem  *elem_aud_codec;


  if(gap_debug) printf("p_replace_combo_aud_codec: START\n");

  glist_aud_codec = NULL;

  l_idx = 0;
  l_active_idx = 0;

  for(avcodec = av_codec_next(NULL); avcodec != NULL; avcodec = av_codec_next(avcodec))
  {
     char *menu_name;
     char *object_data;
     if ((avcodec->encode) && (avcodec->type == CODEC_TYPE_AUDIO))
     {
       object_data = (char *)avcodec->name;

       menu_name = g_strdup(object_data);

       if(gap_debug)
       {
          printf("p_replace_combo_aud_codec: val[%d]: %s\n"
                , (int)l_idx
                , menu_name
                );
       }
       elem_aud_codec = (t_string_combo_elem *) g_malloc0(sizeof(t_string_combo_elem));
       elem_aud_codec->menu_idx = l_idx;
       elem_aud_codec->name     = g_strdup(object_data);
       elem_aud_codec->next     = glist_aud_codec;
       glist_aud_codec = elem_aud_codec;

       gimp_int_combo_box_append (GIMP_INT_COMBO_BOX (gpp->ff_aud_codec_combo),
                                 GIMP_INT_STORE_VALUE, l_idx,
                                 GIMP_INT_STORE_LABEL, menu_name,
                                 -1);

       if(strcmp(object_data, gpp->evl.acodec_name) == 0)
       {
           l_active_idx = l_idx;
       }
       l_idx++;
     }
  }

  g_object_set_data (G_OBJECT (gpp->ff_aud_codec_combo)
                    , GAP_ENC_FFGUI_COMBO_STRLIST
                    , (gpointer)glist_aud_codec
                    );
  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (gpp->ff_aud_codec_combo)
                             , l_active_idx,
                              G_CALLBACK (on_ff_aud_codec_combo),
                              gpp);

  /* gimp_int_combo_box_set_active (GIMP_INT_COMBO_BOX (gpp->ff_aud_codec_combo)
   *                              , l_active_idx);
   */

}  /* end p_replace_combo_aud_codec */



/* ----------------------------
 * gap_enc_ffgui_set_default_codecs
 * ----------------------------
 * - findout the default CODECS and Extensions for the current selected fileformat
 *   and show this informations in the info label widget.
 * - optional (if set_codec_menus == TRUE)
 *   set both VIDEO_CODEC and AUDIO_CODEC combo to these default CODECS
 */
void
gap_enc_ffgui_set_default_codecs(GapGveFFMpegGlobalParams *gpp, gboolean set_codec_menus)
{
   AVOutputFormat *ofmt;
   AVCodec *aud_codec;
   AVCodec *vid_codec;
   char *name;
   char *l_ext_one;
   guint l_ii;

   if(gpp == NULL) return;
   if(gpp->shell_window == NULL) return;

   ofmt = guess_format(gpp->evl.format_name, NULL, NULL);

   if(ofmt)
   {
     char *info_msg;
     char *default_vid_codec;
     char *default_aud_codec;

     /* find default CODECS for the fileformat */
     vid_codec = avcodec_find_encoder(ofmt->video_codec);
     aud_codec = avcodec_find_encoder(ofmt->audio_codec);

     if(vid_codec)
     {
       default_vid_codec = g_strdup(vid_codec->name);
       if(set_codec_menus)
       {
         /* set combo */
         name = p_init_combo_actual_nameidx(gpp, gpp->ff_vid_codec_combo, glist_vid_codec, default_vid_codec);

         if (name)
         {
            g_snprintf(gpp->evl.vcodec_name, sizeof(gpp->evl.vcodec_name), "%s", name);
         }
       }
     }
     else
     {
       default_vid_codec = g_strdup(_("NOT SUPPORTED"));
     }
     if(aud_codec)
     {
       default_aud_codec = g_strdup(aud_codec->name);
       if(set_codec_menus)
       {
         /* set combo */
         name = p_init_combo_actual_nameidx(gpp, gpp->ff_aud_codec_combo, glist_aud_codec, default_aud_codec);
         if (name)
         {
            g_snprintf(gpp->evl.acodec_name, sizeof(gpp->evl.acodec_name), "%s", name);
         }
       }
     }
     else
     {
       default_aud_codec = g_strdup(_("NOT SUPPORTED"));
     }

     {
       char *recomand_size;

       recomand_size = NULL;
       if((gpp->evl.ntsc_width  > 0)
       && (gpp->evl.ntsc_height > 0)
       && (gpp->evl.pal_width   > 0)
       && (gpp->evl.pal_height  > 0))
       {
         recomand_size = g_strdup_printf("   Recommanded Framesize : %d x %d (PAL)  %d x %d (NTSC)"
                                          ,(int)gpp->evl.pal_width
                                          ,(int)gpp->evl.pal_height
                                          ,(int)gpp->evl.ntsc_width
                                          ,(int)gpp->evl.ntsc_height
                                          );
       }
       else
       {
         recomand_size = g_strdup_printf(" ");
       }
       info_msg = g_strdup_printf(_("Selected Fileformat : [%s] %s\n"
                                  "Recommanded Video CODEC : %s\n"
                                  "Recommanded Audio CODEC : %s\n"
                                  "Extension(s): %s %s"
                                 )
                               , ofmt->name
                               , ofmt->long_name
                               , default_vid_codec
                               , default_aud_codec
                               , ofmt->extensions
                               , recomand_size
                               );
       g_free(recomand_size);
     }

     /* store the current video extension
      * ofmt->extensions may contain more than 1 extension (comma separated)
      * but we always use only the 1.st one.
      */
     if(ofmt->extensions)
     {
       l_ext_one = g_strdup_printf(".%s", ofmt->extensions);
     }
     else
     {
       /* mpeg1 system format (VCD) has no extensions (is that a bug in the lib ?)
        * assume .mpg for videoformats without extensions as workaround
        */
       l_ext_one = g_strdup(".mpg");
     }

     for(l_ii=0; l_ii < sizeof(gpp->evl.current_vid_extension)-2; l_ii++)
     {
          if ((l_ext_one[l_ii] == '\0')
          ||  (l_ext_one[l_ii] == ';')
          ||  (l_ext_one[l_ii] == ',')
          ||  (l_ext_one[l_ii] == ':'))
          {
            gpp->evl.current_vid_extension[l_ii] = '\0';
            break;
          }
          gpp->evl.current_vid_extension[l_ii] = l_ext_one[l_ii];
     }
     g_free(l_ext_one);

     /* update info label with default codec names and extensions
      * for the selected fileformat
      */
     gtk_label_set_text(GTK_LABEL(gpp->ff_basic_info_label), info_msg);

     g_free(info_msg);
     g_free(default_vid_codec);
     g_free(default_aud_codec);
   }

}  /* end gap_enc_ffgui_set_default_codecs */


/* --------------------------------
 * gap_get_combo_string_by_idx
 * --------------------------------
 */
const char *
gap_get_combo_string_by_idx(gpointer string_combo_elem_list, gint idx)
{
  t_string_combo_elem  *list;
  t_string_combo_elem  *elem;

  list = (t_string_combo_elem *)string_combo_elem_list;

  if(gap_debug)
  {
    if(string_combo_elem_list == (gpointer)glist_vid_codec)
    {
      printf("gap_get_combo_string_by_idx: glist_vid_codec  ptr:%d\n"
            ,(int)string_combo_elem_list
            );
    }
    if(string_combo_elem_list == (gpointer)glist_aud_codec)
    {
      printf("gap_get_combo_string_by_idx: glist_aud_codec  ptr:%d\n"
            ,(int)string_combo_elem_list
            );
    }
    if(string_combo_elem_list == (gpointer)glist_fileformat)
    {
      printf("gap_get_combo_string_by_idx: glist_fileformat  ptr:%d\n"
            ,(int)string_combo_elem_list
            );
    }
  }

  for(elem = list; elem != NULL; elem = (t_string_combo_elem  *)elem->next)
  {
    if (idx == elem->menu_idx)
    {
      return (elem->name);
    }
  }


  printf("gap_get_combo_string_by_idx: ** ERROR no list elem found at index:%d\n"
        ,(int)idx
        );
  return (NULL);

}  /* end gap_get_combo_string_by_idx */


/* --------------------------------
 * p_init_combo_actual_nameidx
 * --------------------------------
 */
static char *
p_init_combo_actual_nameidx(GapGveFFMpegGlobalParams *gpp, GtkWidget *widget, t_string_combo_elem *list, char *name)
{
  t_string_combo_elem  *elem;


  if(gap_debug) printf("p_init_combo_actual_nameidx START search: %s\n", name);
  for(elem = list; elem != NULL; elem = (t_string_combo_elem  *)elem->next)
  {
    if(strcmp(name, elem->name) == 0)
    {
      if(widget)
      {
        gimp_int_combo_box_set_active (GIMP_INT_COMBO_BOX (widget), elem->menu_idx);
      }
      if(gap_debug) printf("p_init_combo_actual_nameidx START found: %s\n", name);
      return(elem->name);
    }
  }
  return (NULL);
}  /* end p_init_combo_actual_nameidx */

/* ---------------------------------
 * p_init_gint_combo_active
 * ---------------------------------
 */
static gint32
p_init_gint_combo_active(GapGveFFMpegGlobalParams *gpp, GtkWidget *widget, gint *gtab_ptr, gint val, gint maxidx)
{
  gint l_idx;

  for(l_idx = 0; l_idx < maxidx; l_idx++)
  {
    if(val == gtab_ptr[l_idx])
    {
      if(widget)
      {
        gimp_int_combo_box_set_active (GIMP_INT_COMBO_BOX (widget), gtab_ptr[l_idx]);
      }
      return (gtab_ptr[l_idx]);
    }
  }

  return(gtab_ptr[0]);
}  /* end p_init_gint_combo_active */

/* ------------------------------------
 * p_init_gdouble_combo_actual_idx
 * ------------------------------------
 */
static gint
p_init_gdouble_combo_actual_idx(GapGveFFMpegGlobalParams *gpp, GtkWidget *widget, gdouble *gtab_ptr, gdouble val, gint maxidx)
{
  gint l_idx;

  for(l_idx = 0; l_idx < maxidx; l_idx++)
  {
    if(val == gtab_ptr[l_idx])
    {
      if(widget)
      {
        gimp_int_combo_box_set_active (GIMP_INT_COMBO_BOX (widget), l_idx);
      }
      return (l_idx);
    }
  }
  return(0);
}  /* end p_init_gdouble_combo_actual_idx */

/* --------------------------------
 * p_init_combo_vals
 * --------------------------------
 */
static void
p_init_combo_vals(GapGveFFMpegGlobalParams *gpp)
{
  char *name;

  p_init_gint_combo_active(gpp, gpp->ff_motion_estimation_combo
                              , &gtab_motion_est[0]
                              , gpp->evl.motion_estimation
                              , GAP_GVE_FFMPEG_MOTION_ESTIMATION_MAX_ELEMENTS
                              );
  p_init_gint_combo_active(gpp, gpp->ff_dct_algo_combo
                              , &gtab_dct_algo[0]
                              , gpp->evl.dct_algo
                              , GAP_GVE_FFMPEG_DCT_ALGO_MAX_ELEMENTS
                              );
  p_init_gint_combo_active(gpp, gpp->ff_idct_algo_combo
                              , &gtab_idct_algo[0]
                              , gpp->evl.idct_algo
                              , GAP_GVE_FFMPEG_IDCT_ALGO_MAX_ELEMENTS
                              );
  p_init_gint_combo_active(gpp, gpp->ff_mb_decision_combo
                              , &gtab_mb_decision[0]
                              , gpp->evl.mb_decision
                              , GAP_GVE_FFMPEG_MB_DECISION_MAX_ELEMENTS
                              );

  p_init_gint_combo_active(gpp, gpp->ff_aud_bitrate_combo
                              , &gtab_audio_krate[0]
                              , gpp->evl.audio_bitrate
                              , GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_MAX_ELEMENTS
                              );



  p_init_gint_combo_active(gpp, gpp->ff_mb_cmp_combo
                              , &gtab_cmp_func[0]
                              , gpp->evl.mb_cmp
                              , GAP_GVE_FFMPEG_CMP_MAX_ELEMENTS
                              );
  p_init_gint_combo_active(gpp, gpp->ff_ildct_cmp_combo
                              , &gtab_cmp_func[0]
                              , gpp->evl.ildct_cmp
                              , GAP_GVE_FFMPEG_CMP_MAX_ELEMENTS
                              );
  p_init_gint_combo_active(gpp, gpp->ff_sub_cmp_combo
                              , &gtab_cmp_func[0]
                              , gpp->evl.sub_cmp
                              , GAP_GVE_FFMPEG_CMP_MAX_ELEMENTS
                              );
  p_init_gint_combo_active(gpp, gpp->ff_cmp_combo
                              , &gtab_cmp_func[0]
                              , gpp->evl.cmp
                              , GAP_GVE_FFMPEG_CMP_MAX_ELEMENTS
                              );
  p_init_gint_combo_active(gpp, gpp->ff_pre_cmp_combo
                              , &gtab_cmp_func[0]
                              , gpp->evl.pre_cmp
                              , GAP_GVE_FFMPEG_CMP_MAX_ELEMENTS
                              );
  p_init_gint_combo_active(gpp, gpp->ff_frame_skip_cmp_combo
                              , &gtab_cmp_func[0]
                              , gpp->evl.frame_skip_cmp
                              , GAP_GVE_FFMPEG_CMP_MAX_ELEMENTS
                              );
  p_init_gint_combo_active(gpp, gpp->ff_coder_combo
                              , &gtab_coder[0]
                              , gpp->evl.coder
                              , GAP_GVE_FFMPEG_CODER_TYPE_MAX_ELEMENTS
                              );
  p_init_gint_combo_active(gpp, gpp->ff_predictor_combo
                              , &gtab_predictor[0]
                              , gpp->evl.predictor
                              , GAP_GVE_FFMPEG_PREDICTOR_MAX_ELEMENTS
                              );

  p_init_gdouble_combo_actual_idx(gpp, gpp->ff_aspect_combo
                              , &gtab_aspect[0]
                              , gpp->evl.factor_aspect_ratio
                              , GAP_GVE_FFMPEG_ASPECT_MAX_ELEMENTS
                              );

  name = p_init_combo_actual_nameidx(gpp, gpp->ff_fileformat_combo, glist_fileformat, gpp->evl.format_name);
  name = p_init_combo_actual_nameidx(gpp, gpp->ff_vid_codec_combo,  glist_vid_codec,  gpp->evl.vcodec_name);
  name = p_init_combo_actual_nameidx(gpp, gpp->ff_aud_codec_combo,  glist_aud_codec,  gpp->evl.acodec_name);

}  /* end p_init_combo_vals */


/* --------------------------------
 * p_set_combo_box_callbacks
 * --------------------------------
 */
static void
p_set_combo_box_callbacks(GapGveFFMpegGlobalParams *gpp)
{
  /* dynamic combos
   * the entries for available fileformats and codecs
   * are set up by queries to the FFMPEG avcodec library
   */

  av_register_all();  /* register all fileformats and codecs before we can use the lib */

  p_replace_combo_file_format(gpp);
  p_replace_combo_vid_codec(gpp);
  p_replace_combo_aud_codec(gpp);

}  /* end p_set_combo_box_callbacks */



/* --------------------------------
 * p_init_spinbuttons
 * --------------------------------
 */
static void
p_init_spinbuttons(GapGveFFMpegGlobalParams *gpp)
{
  GtkAdjustment *adj;

  if(gap_debug) printf("p_init_spinbuttons\n");

  if(gpp->startup)
  {
    return;
  }

  adj = GTK_ADJUSTMENT(gpp->ff_aud_bitrate_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.audio_bitrate);

  adj = GTK_ADJUSTMENT(gpp->ff_vid_bitrate_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.video_bitrate);

  adj = GTK_ADJUSTMENT(gpp->ff_qscale_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.qscale);

  adj = GTK_ADJUSTMENT(gpp->ff_qmin_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.qmin);

  adj = GTK_ADJUSTMENT(gpp->ff_qmax_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.qmax);

  adj = GTK_ADJUSTMENT(gpp->ff_qdiff_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.qdiff);


  adj = GTK_ADJUSTMENT(gpp->ff_gop_size_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.gop_size);



  adj = GTK_ADJUSTMENT(gpp->ff_qblur_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.qblur);

  adj = GTK_ADJUSTMENT(gpp->ff_qcomp_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.qcomp);

  adj = GTK_ADJUSTMENT(gpp->ff_rc_init_cplx_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.rc_init_cplx);

  adj = GTK_ADJUSTMENT(gpp->ff_b_qfactor_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.b_qfactor);

  adj = GTK_ADJUSTMENT(gpp->ff_i_qfactor_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.i_qfactor);

  adj = GTK_ADJUSTMENT(gpp->ff_b_qoffset_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.b_qoffset);

  adj = GTK_ADJUSTMENT(gpp->ff_i_qoffset_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.i_qoffset);

  adj = GTK_ADJUSTMENT(gpp->ff_bitrate_tol_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.bitrate_tol);

  adj = GTK_ADJUSTMENT(gpp->ff_maxrate_tol_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.maxrate_tol);

  adj = GTK_ADJUSTMENT(gpp->ff_minrate_tol_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.minrate_tol);

  adj = GTK_ADJUSTMENT(gpp->ff_bufsize_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.bufsize);

  adj = GTK_ADJUSTMENT(gpp->ff_strict_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.strict);

  adj = GTK_ADJUSTMENT(gpp->ff_mb_qmin_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.mb_qmin);

  adj = GTK_ADJUSTMENT(gpp->ff_mb_qmax_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.mb_qmax);

  adj = GTK_ADJUSTMENT(gpp->ff_b_frames_spinbutton_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.b_frames);


  adj = GTK_ADJUSTMENT(gpp->ff_mux_rate_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.mux_rate);

  adj = GTK_ADJUSTMENT(gpp->ff_mux_packet_size_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.mux_packet_size);

  adj = GTK_ADJUSTMENT(gpp->ff_mux_preload_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.mux_preload);

  adj = GTK_ADJUSTMENT(gpp->ff_mux_max_delay_adj);
  gtk_adjustment_set_value(adj, (gfloat)gpp->evl.mux_max_delay);

}  /* end p_init_spinbuttons */


/* --------------------------------
 * p_init_vid_checkbuttons
 * --------------------------------
 */
static void
p_init_vid_checkbuttons(GapGveFFMpegGlobalParams *gpp)
{
  if(gpp->startup)
  {
    return;
  }

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_intra_checkbutton)
                               , gpp->evl.intra);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_bitexact_checkbutton)
                               , gpp->evl.bitexact);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_aspect_checkbutton)
                               , gpp->evl.set_aspect_ratio);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_aic_checkbutton)
                               , gpp->evl.aic);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_umv_checkbutton)
                               , gpp->evl.umv);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_mv4_checkbutton)
                               , gpp->evl.mv4);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_partitioning_checkbutton)
                               , gpp->evl.partitioning);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_pass_checkbutton)
                               , gpp->evl.twoPassFlag);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_dont_recode_checkbutton)
                               , gpp->evl.dont_recode_flag);


  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_closed_gop_checkbutton)
                                 , gpp->evl.closed_gop);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_do_interlace_dct_checkbutton)
                                 , gpp->evl.do_interlace_dct);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_use_ss_checkbutton)
                                 , gpp->evl.use_ss);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_use_alt_scan_checkbutton)
                                 , gpp->evl.use_alt_scan);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_do_interlace_me_checkbutton)
                                 , gpp->evl.do_interlace_me);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_use_aiv_checkbutton)
                                 , gpp->evl.use_aiv);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_use_obmc_checkbutton)
                                 , gpp->evl.use_obmc);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_use_qpel_checkbutton)
                                 , gpp->evl.use_qpel);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_use_loop_checkbutton)
                                 , gpp->evl.use_loop);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_use_qprd_checkbutton)
                                 , gpp->evl.use_qprd);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_use_cbprd_checkbutton)
                                 , gpp->evl.use_cbprd);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_use_mv0_checkbutton)
                                 , gpp->evl.use_mv0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_do_normalize_aqp_checkbutton)
                                 , gpp->evl.do_normalize_aqp);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_use_scan_offset_checkbutton)
                                 , gpp->evl.use_scan_offset);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_strict_gop_checkbutton)
                                 , gpp->evl.strict_gop);
  if(gpp->ff_no_output_checkbutton)
  {
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_no_output_checkbutton)
                                 , gpp->evl.no_output);
  }

  /* new flags */
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG_GMC_checkbutton)
                               , gpp->evl.codec_FLAG_GMC);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG_INPUT_PRESERVED_checkbutton)
                               , gpp->evl.codec_FLAG_INPUT_PRESERVED);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG_GRAY_checkbutton)
                               , gpp->evl.codec_FLAG_GRAY);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG_EMU_EDGE_checkbutton)
                               , gpp->evl.codec_FLAG_EMU_EDGE);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG_TRUNCATED_checkbutton)
                               , gpp->evl.codec_FLAG_TRUNCATED);

  /* new flags2 */
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_FAST_checkbutton)
                               , gpp->evl.codec_FLAG2_FAST);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_LOCAL_HEADER_checkbutton)
                               , gpp->evl.codec_FLAG2_LOCAL_HEADER);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_BPYRAMID_checkbutton)
                               , gpp->evl.codec_FLAG2_BPYRAMID);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_WPRED_checkbutton)
                               , gpp->evl.codec_FLAG2_WPRED);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_MIXED_REFS_checkbutton)
                               , gpp->evl.codec_FLAG2_MIXED_REFS);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_8X8DCT_checkbutton)
                               , gpp->evl.codec_FLAG2_8X8DCT);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_FASTPSKIP_checkbutton)
                               , gpp->evl.codec_FLAG2_FASTPSKIP);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_AUD_checkbutton)
                               , gpp->evl.codec_FLAG2_AUD);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_BRDO_checkbutton)
                               , gpp->evl.codec_FLAG2_BRDO);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_INTRA_VLC_checkbutton)
                               , gpp->evl.codec_FLAG2_INTRA_VLC);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_MEMC_ONLY_checkbutton)
                               , gpp->evl.codec_FLAG2_MEMC_ONLY);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_DROP_FRAME_TIMECODE_checkbutton)
                               , gpp->evl.codec_FLAG2_DROP_FRAME_TIMECODE);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_SKIP_RD_checkbutton)
                               , gpp->evl.codec_FLAG2_SKIP_RD);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_CHUNKS_checkbutton)
                               , gpp->evl.codec_FLAG2_CHUNKS);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_NON_LINEAR_QUANT_checkbutton)
                               , gpp->evl.codec_FLAG2_NON_LINEAR_QUANT);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpp->ff_codec_FLAG2_BIT_RESERVOIR_checkbutton)
                               , gpp->evl.codec_FLAG2_BIT_RESERVOIR);

}   /* end p_init_vid_checkbuttons */

/* --------------------------------
 * p_init_entry_widgets
 * --------------------------------
 */
static void
p_init_entry_widgets(GapGveFFMpegGlobalParams *gpp)
{
  if(gap_debug)
  {
    printf("p_init_entry_widgets gpp:%d  adr of evl: %d\n"
          , (int)gpp
          , (int)(&gpp->evl)
          );
    printf("gpp->evl.passlogfile %s\n", gpp->evl.passlogfile);
  }

  if(gpp->startup)
  {
    return;
  }

  gtk_entry_set_text(GTK_ENTRY(gpp->ff_passlogfile_entry), gpp->evl.passlogfile);
  gtk_entry_set_text(GTK_ENTRY(gpp->ff_title_entry), gpp->evl.title);
  gtk_entry_set_text(GTK_ENTRY(gpp->ff_author_entry), gpp->evl.author);
  gtk_entry_set_text(GTK_ENTRY(gpp->ff_copyright_entry), gpp->evl.copyright);
  gtk_entry_set_text(GTK_ENTRY(gpp->ff_comment_entry), gpp->evl.comment);

}  /* end p_init_entry_widgets */

/* --------------------------------
 * gap_enc_ffgui_init_main_dialog_widgets
 * --------------------------------
 */
void
gap_enc_ffgui_init_main_dialog_widgets(GapGveFFMpegGlobalParams *gpp)
{
  if(gap_debug)
  {
    printf("gap_enc_ffgui_init_main_dialog_widgets: Start INIT\n");
  }

  /* put initial values to the widgets */

  p_init_spinbuttons(gpp);
  p_init_entry_widgets(gpp);
  p_init_vid_checkbuttons(gpp);
  p_init_combo_vals(gpp);

  gap_enc_ffgui_set_default_codecs(gpp, FALSE);               /* update info labels but DONT set CODEC combos */
}  /* end gap_enc_ffgui_init_main_dialog_widgets */




/* --------------------------------
 * gap_enc_ffgui_gettab_audio_krate
 * --------------------------------
 */
gint
gap_enc_ffgui_gettab_audio_krate(gint idx)
{
 if((idx >= GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_MAX_ELEMENTS) || (idx < 1))
 {
    idx = 0;
 }

 return(gtab_audio_krate[idx]);

}  /* end gap_enc_ffgui_gettab_audio_krate */




/* --------------------------------
 * gap_enc_ffgui_gettab_aspect
 * --------------------------------
 */
gdouble
gap_enc_ffgui_gettab_aspect(gint idx)
{
 if((idx >= GAP_GVE_FFMPEG_ASPECT_MAX_ELEMENTS) || (idx < 1))
 {
    idx = 0;
 }

 return(gtab_aspect[idx]);

}  /* end gap_enc_ffgui_gettab_aspect */


/* ---------------------------------------
 * gap_enc_ffgui_create_fsb__fileselection
 * ---------------------------------------
 */
GtkWidget*
gap_enc_ffgui_create_fsb__fileselection (GapGveFFMpegGlobalParams *gpp)
{
  GtkWidget *fsb__fileselection;
  GtkWidget *fsb__ok_button;
  GtkWidget *fsb__cancel_button;

  fsb__fileselection = gtk_file_selection_new (_("Select File"));
  gtk_container_set_border_width (GTK_CONTAINER (fsb__fileselection), 10);

  fsb__ok_button = GTK_FILE_SELECTION (fsb__fileselection)->ok_button;
  gtk_widget_show (fsb__ok_button);
  GTK_WIDGET_SET_FLAGS (fsb__ok_button, GTK_CAN_DEFAULT);

  fsb__cancel_button = GTK_FILE_SELECTION (fsb__fileselection)->cancel_button;
  gtk_widget_show (fsb__cancel_button);
  GTK_WIDGET_SET_FLAGS (fsb__cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect (G_OBJECT (fsb__fileselection), "destroy",
                      G_CALLBACK (on_fsb__fileselection_destroy),
                      gpp);
  g_signal_connect (G_OBJECT (fsb__ok_button), "clicked",
                      G_CALLBACK (on_fsb__ok_button_clicked),
                      gpp);
  g_signal_connect (G_OBJECT (fsb__cancel_button), "clicked",
                      G_CALLBACK (on_fsb__cancel_button_clicked),
                      gpp);

  return fsb__fileselection;
}  /* end gap_enc_ffgui_create_fsb__fileselection */



/* --------------------------------
 * p_create_basic_options_frame
 * --------------------------------
 */
GtkWidget*
p_create_basic_options_frame (GapGveFFMpegGlobalParams *gpp)
{
  GtkWidget *frame;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *combo;
  GtkObject *adj;
  GtkWidget *spinbutton;
  GtkWidget *checkbutton;

  gint       row;
  gint       inital_value;



  frame = gimp_frame_new (_("FFMpeg Basic Encoder Options"));

  table = gtk_table_new (11, 3, FALSE);
  gtk_widget_show (table);
  gtk_container_add (GTK_CONTAINER (frame), table);
  gtk_container_set_border_width (GTK_CONTAINER (table), 2);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 4);


  row = 0;

  /* the fileformat label */
  label = gtk_label_new (_("Fileformat:           "));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the fileformat combo box */
  combo = g_object_new (GIMP_TYPE_INT_COMBO_BOX, NULL);
  gpp->ff_fileformat_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo
                           , _("The output multimedia fileformat")
                           , NULL);

  /* ff_fileformat_combo_menu and callback are replaced later
   * in procedure p_replace_combo_file_format
   */


  row++;

  /* the video codec label */
  label = gtk_label_new (_("Video CODEC:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the video codec  combo box */
  combo = g_object_new (GIMP_TYPE_INT_COMBO_BOX, NULL);
  gpp->ff_vid_codec_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("The video codec"), NULL);

  /* ff_vid_codec_combo is replaced later
   * in procedure p_replace_combo_vid_codec
   */

  row++;

  /* the audio codec label */
  label = gtk_label_new (_("Audio CODEC:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the audio codec  combo box */
  combo = g_object_new (GIMP_TYPE_INT_COMBO_BOX, NULL);
  gpp->ff_aud_codec_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("The audio codec"), NULL);

  /* ff_aud_codec_combo is replaced later
   * in procedure p_replace_combo_aud_codec
   */

  row++;

  /* the audio bitrate label */
  label = gtk_label_new (_("Audio Bitrate:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the audio bitrate spinbutton */
  adj = gtk_adjustment_new (160, 0, 500, 10, 100, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_aud_bitrate_spinbutton_adj = adj;
  gpp->ff_aud_bitrate_spinbutton     = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Audio bitrate in kBit/sec"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.audio_bitrate);

  /* the audio bitrate combo */
  combo = gimp_int_combo_box_new ("32",   GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_00_32,
                                  "40",   GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_01_40,
                                  "48",   GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_02_48,
                                  "56",   GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_03_56,
                                  "64",   GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_04_64,
                                  "80",   GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_05_80,
                                  "96",   GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_06_96,
                                  "112",  GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_07_112,
                                  "128",  GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_08_128,
                                  "160",  GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_09_160,
                                  "192",  GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_10_192,
                                  "224",  GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_11_224,
                                  "256",  GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_12_256,
                                  "320",  GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_13_320,
                                  NULL);

  gpp->ff_aud_bitrate_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table), combo, 2, 3, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Commonly-used used audio bitrates"), NULL);
  inital_value = p_init_gint_combo_active(gpp
                              , combo
                              , &gtab_audio_krate[0]
                              , gpp->evl.audio_bitrate
                              , GAP_GVE_FFMPEG_AUDIO_KBIT_RATE_MAX_ELEMENTS
                              );

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              inital_value,
                              G_CALLBACK (on_ff_aud_bitrate_combo),
                              gpp);


  row++;

  /* the video bitrate label */
  label = gtk_label_new (_("Video Bitrate:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the video bitrate spinbutton */
  adj = gtk_adjustment_new (1000, 0, 10000, 100, 1000, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_vid_bitrate_spinbutton_adj = adj;
  gpp->ff_vid_bitrate_spinbutton     = spinbutton;

  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Video bitrate kBit/sec"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.video_bitrate);


  row++;


  /* the qscale label */
  label = gtk_label_new (_("qscale:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the qscale spinbutton */
  adj = gtk_adjustment_new (0, 0, 255, 1, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 2);
  gpp->ff_qscale_spinbutton_adj = adj;
  gpp->ff_qscale_spinbutton     = spinbutton;

  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Use fixed video quantiser scale (VBR) (0=const bitrate)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gdouble_spinbutton_changed),
                      &gpp->evl.qscale);

  row++;


  /* the qmin label */
  label = gtk_label_new (_("qmin:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);



  /* the qmin spinbutton */
  adj = gtk_adjustment_new (1, 0, 31, 1, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_qmin_spinbutton_adj = adj;
  gpp->ff_qmin_spinbutton     = spinbutton;

  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("min video quantiser scale (VBR)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.qmin);

  row++;


  /* the qmax label */
  label = gtk_label_new (_("qmax:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the qmax spinbutton */
  adj = gtk_adjustment_new (1, 0, 31, 1, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_qmax_spinbutton_adj = adj;
  gpp->ff_qmax_spinbutton     = spinbutton;

  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("max video quantiser scale (VBR)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.qmax);


  row++;

  /* the qdiff label */
  label = gtk_label_new (_("qdiff:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the qdiff spinbutton */
  adj = gtk_adjustment_new (3, 0, 100, 1, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_qdiff_spinbutton_adj = adj;
  gpp->ff_qdiff_spinbutton     = spinbutton;

  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("max difference between the quantiser scale (VBR)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.qdiff);


  row++;

  /* the Frametype label */
  label = gtk_label_new (_("Frametype:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the intra only checkbutton */
  checkbutton = gtk_check_button_new_with_label (_("Intra Only"));
  gpp->ff_intra_checkbutton = checkbutton;
  gtk_widget_show (checkbutton);
  gtk_table_attach (GTK_TABLE (table), checkbutton, 1, 2, row, row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (checkbutton, _("use only intra frames (I)"), NULL);
  g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.intra);

  row++;

  /* the GOP label */
  label = gtk_label_new (_("GOP:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);



  /* the GOP spinbutton */
  adj = gtk_adjustment_new (12, 0, 512, 1, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_gop_size_spinbutton_adj = adj;
  gpp->ff_gop_size_spinbutton     = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Group of picture size"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                    G_CALLBACK (on_ff_gint32_spinbutton_changed),
                    &gpp->evl.gop_size);

  row++;

  /* the B_frames label */
  label = gtk_label_new (_("B-Frames:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the B_frames spinbutton */
  adj = gtk_adjustment_new (0, 0, (gdouble)FF_MAX_B_FRAMES, 1, 1, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_b_frames_spinbutton_adj = adj;
  gpp->ff_b_frames_spinbutton     = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Max number of B-frames in sequence"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                    G_CALLBACK (on_ff_gint32_spinbutton_changed),
                    &gpp->evl.b_frames);

  row++;

  /* the qdiff label */
  label = gtk_label_new (_("Aspect:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the Set Aspectratio checkbutton */
  checkbutton = gtk_check_button_new_with_label (_("Set Aspectratio"));
  gpp->ff_aspect_checkbutton = checkbutton;
  gtk_widget_show (checkbutton);
  gtk_table_attach (GTK_TABLE (table), checkbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (checkbutton, _("store aspectratio information (width/height) in the output video"), NULL);
  g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (checkbutton), "toggled",
                    G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                    &gpp->evl.set_aspect_ratio);


  /* the ASPECT combo */
  combo = gimp_int_combo_box_new (_("auto"),   GAP_GVE_FFMPEG_ASPECT_00_AUTO,
                                  _("3:2"),    GAP_GVE_FFMPEG_ASPECT_01_3_2,
                                  _("4:3"),    GAP_GVE_FFMPEG_ASPECT_02_4_3,
                                  _("16:9"),   GAP_GVE_FFMPEG_ASPECT_03_16_9,
                                  NULL);

  gpp->ff_aspect_combo = combo;
  gtk_widget_show (combo);

  gtk_table_attach (GTK_TABLE (table), combo, 2, 3, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Select aspect ratio"), NULL);

  inital_value =  p_init_gdouble_combo_actual_idx(gpp
                            , combo
                            , &gtab_aspect[0]
                            , gpp->evl.factor_aspect_ratio
                            , GAP_GVE_FFMPEG_ASPECT_MAX_ELEMENTS
                            );

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                            inital_value,
                            G_CALLBACK (on_ff_aspect_combo),
                            gpp);


  return(frame);
}  /* end  p_create_basic_options_frame */



/* --------------------------------
 * p_create_expert_algortihms_frame
 * --------------------------------
 */
GtkWidget*
p_create_expert_algortihms_frame (GapGveFFMpegGlobalParams *gpp)
{
  GtkWidget *frame;
  GtkWidget *table2;
  GtkWidget *label;
  GtkWidget *combo;

  gint       row;
  gint       inital_value;

  frame = gimp_frame_new (_("FFMpeg Expert Encoder Algorithms"));

  table2 = gtk_table_new (7, 3, FALSE);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (frame), table2);
  gtk_container_set_border_width (GTK_CONTAINER (table2), 2);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 4);

  row = 0;

  /* the motion estimation label */
  label = gtk_label_new (_("Motion estimation:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table2), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the motion estimation combo box */
  combo = gimp_int_combo_box_new (_("1 zero (fastest)"),          GAP_GVE_FFMPEG_MOTION_ESTIMATION_01_ZERO,
                                  _("2 full (best)"),             GAP_GVE_FFMPEG_MOTION_ESTIMATION_02_FULL,
                                  _("3 log"),                     GAP_GVE_FFMPEG_MOTION_ESTIMATION_03_LOG,
                                  _("4 phods"),                   GAP_GVE_FFMPEG_MOTION_ESTIMATION_04_PHODS,
                                  _("5 epzs (recommended)"),      GAP_GVE_FFMPEG_MOTION_ESTIMATION_05_EPZS,
                                  _("6 x1"),                      GAP_GVE_FFMPEG_MOTION_ESTIMATION_06_X1,
                                  _("7 hex (x264 specific)"),     GAP_GVE_FFMPEG_MOTION_ESTIMATION_07_HEX,
                                  _("8 umh (x264 specific)"),     GAP_GVE_FFMPEG_MOTION_ESTIMATION_08_UMH,
                                  _("9 iter (snow specific)"),    GAP_GVE_FFMPEG_MOTION_ESTIMATION_09_ITER,
                                  _("10 tesa (x264 specific)"),   GAP_GVE_FFMPEG_MOTION_ESTIMATION_10_TESA,
                                  NULL);
  gpp->ff_motion_estimation_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table2), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Select algorithm for motion estimation"), NULL);

  inital_value =  p_init_gint_combo_active(gpp
                              , combo
                              , &gtab_motion_est[0]
                              , gpp->evl.motion_estimation
                              , GAP_GVE_FFMPEG_MOTION_ESTIMATION_MAX_ELEMENTS
                              );
  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              inital_value,
                              G_CALLBACK (on_ff_gint32_combo),
                              &gpp->evl.motion_estimation);


  row++;


  /* the DCT algorithm label */
  label = gtk_label_new (_("DCT algorithm:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table2), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the DCT algorithm combo */
  combo = gimp_int_combo_box_new (_("0 auto"),         GAP_GVE_FFMPEG_DCT_ALGO_00_AUTO,
                                  _("1 fast int"),     GAP_GVE_FFMPEG_DCT_ALGO_01_FASTINT,
                                  _("2 int"),          GAP_GVE_FFMPEG_DCT_ALGO_02_INT,
                                  _("3 mmx"),          GAP_GVE_FFMPEG_DCT_ALGO_03_MMX,
                                  _("4 mlib"),         GAP_GVE_FFMPEG_DCT_ALGO_04_MLIB,
                                  _("5 altivec"),      GAP_GVE_FFMPEG_DCT_ALGO_05_ALTIVEC,
                                  _("6 faan"),         GAP_GVE_FFMPEG_DCT_ALGO_06_FAAN,
                                  NULL);
  gpp->ff_dct_algo_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table2), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Select algorithm for DCT"), NULL);

  inital_value =  p_init_gint_combo_active(gpp
                              , combo
                              , &gtab_dct_algo[0]
                              , gpp->evl.dct_algo
                              , GAP_GVE_FFMPEG_DCT_ALGO_MAX_ELEMENTS
                              );
  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              inital_value,
                              G_CALLBACK (on_ff_gint32_combo),
                              &gpp->evl.dct_algo);

  row++;


  /* the IDCT algorithm label */
  label = gtk_label_new (_("IDCT algorithm:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table2), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the IDCT algorithm combo */
  combo = gimp_int_combo_box_new (_("0 auto"),             GAP_GVE_FFMPEG_IDCT_ALGO_00_AUTO,
                                  _("1 int"),              GAP_GVE_FFMPEG_IDCT_ALGO_01_INT,
                                  _("2 simple"),           GAP_GVE_FFMPEG_IDCT_ALGO_02_SIMPLE,
                                  _("3 simple mmx"),       GAP_GVE_FFMPEG_IDCT_ALGO_03_SIMPLEMMX,
                                  _("4 libmpeg2mmx"),      GAP_GVE_FFMPEG_IDCT_ALGO_04_LIBMPEG2MMX,
                                  _("5 ps2"),              GAP_GVE_FFMPEG_IDCT_ALGO_05_PS2,
                                  _("6 mlib"),             GAP_GVE_FFMPEG_IDCT_ALGO_06_MLIB,
                                  _("7 arm"),              GAP_GVE_FFMPEG_IDCT_ALGO_07_ARM,
                                  _("8 altivec"),          GAP_GVE_FFMPEG_IDCT_ALGO_08_ALTIVEC,
                                  _("9 sh4"),              GAP_GVE_FFMPEG_IDCT_ALGO_09_SH4,
                                  _("10 simplearm"),       GAP_GVE_FFMPEG_IDCT_ALGO_10_SIMPLEARM,
                                  _("11 h264"),            GAP_GVE_FFMPEG_IDCT_ALGO_11_H264,
                                  _("12 vp3"),             GAP_GVE_FFMPEG_IDCT_ALGO_12_VP3,
                                  _("13 ipp"),             GAP_GVE_FFMPEG_IDCT_ALGO_13_IPP,
                                  _("14 xvidmmx"),         GAP_GVE_FFMPEG_IDCT_ALGO_14_XVIDMMX,
                                  _("15 cavs"),            GAP_GVE_FFMPEG_IDCT_ALGO_15_CAVS,
                                  _("16 simplearmv5te"),   GAP_GVE_FFMPEG_IDCT_ALGO_16_SIMPLEARMV5TE,
                                  _("17 simplearmv6"),     GAP_GVE_FFMPEG_IDCT_ALGO_17_SIMPLEARMV6,
                                  _("18 simplevis"),       GAP_GVE_FFMPEG_IDCT_ALGO_18_SIMPLEVIS,
                                  _("19 wmv2"),            GAP_GVE_FFMPEG_IDCT_ALGO_19_WMV2,
                                  _("20 faan"),            GAP_GVE_FFMPEG_IDCT_ALGO_20_FAAN,
                                  _("21 ea"),              GAP_GVE_FFMPEG_IDCT_ALGO_21_EA,
                                  _("22 simpleneon"),      GAP_GVE_FFMPEG_IDCT_ALGO_22_SIMPLENEON,
                                  _("23 simplealpha"),      GAP_GVE_FFMPEG_IDCT_ALGO_23_SIMPLEALPHA,
                                  NULL);

  gpp->ff_idct_algo_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table2), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Select algorithm for IDCT"), NULL);

  inital_value = p_init_gint_combo_active(gpp
                              , combo
                              , &gtab_idct_algo[0]
                              , gpp->evl.idct_algo
                              , GAP_GVE_FFMPEG_IDCT_ALGO_MAX_ELEMENTS
                              );

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              inital_value,
                              G_CALLBACK (on_ff_gint32_combo),
                              &gpp->evl.idct_algo);


  row++;

  /* the MB_DECISION label */
  label = gtk_label_new (_("MB Decision:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table2), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the MB_DECISION combo */
  combo = gimp_int_combo_box_new (_("simple (use mb_cmp)"),                      GAP_GVE_FFMPEG_MB_DECISION_00_SIMPLE,
                                  _("bits (the one which needs fewest bits)"),   GAP_GVE_FFMPEG_MB_DECISION_01_BITS,
                                  _("rate distortion"),                         GAP_GVE_FFMPEG_MB_DECISION_02_RD,
                                  NULL);

  gpp->ff_mb_decision_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table2), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Select algorithm for macroblock decision"), NULL);

  inital_value = p_init_gint_combo_active(gpp
                              , combo
                              , &gtab_mb_decision[0]
                              , gpp->evl.mb_decision
                              , GAP_GVE_FFMPEG_MB_DECISION_MAX_ELEMENTS
                              );

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              inital_value,
                              G_CALLBACK (on_ff_gint32_combo),
                              &gpp->evl.mb_decision);


  row++;

  /* the Coder Type label */
  label = gtk_label_new (_("Coder Type:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table2), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the MB_DECISION combo */
  combo = gimp_int_combo_box_new (_("0 vlc"),        GAP_GVE_FFMPEG_CODER_TYPE_00_VLC,
                                  _("1 ac"),         GAP_GVE_FFMPEG_CODER_TYPE_01_AC,
                                  NULL);

  gpp->ff_coder_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table2), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Coder type"), NULL);

  inital_value = p_init_gint_combo_active(gpp
                              , combo
                              , &gtab_coder[0]
                              , gpp->evl.coder
                              , GAP_GVE_FFMPEG_CODER_TYPE_MAX_ELEMENTS
                              );

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              inital_value,
                              G_CALLBACK (on_ff_gint32_combo),
                              &gpp->evl.coder);


  row++;

  /* the Predictor label */
  label = gtk_label_new (_("Predictor:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table2), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the MB_DECISION combo */
  combo = gimp_int_combo_box_new (_("0 left"),         GAP_GVE_FFMPEG_PREDICTOR_00_LEFT,
                                  _("1 plane"),        GAP_GVE_FFMPEG_PREDICTOR_01_PLANE,
                                  _("2 median"),       GAP_GVE_FFMPEG_PREDICTOR_02_MEDIAN,
                                  NULL);

  gpp->ff_predictor_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table2), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Prediction method"), NULL);

  inital_value = p_init_gint_combo_active(gpp
                              , combo
                              , &gtab_predictor[0]
                              , gpp->evl.predictor
                              , GAP_GVE_FFMPEG_PREDICTOR_MAX_ELEMENTS
                              );

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              inital_value,
                              G_CALLBACK (on_ff_gint32_combo),
                              &gpp->evl.predictor);


  row++;

  /* the Macroblock compare function label */
  label = gtk_label_new (_("Macroblock cmp:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table2), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the Macroblock compare function combo */
  combo = p_ff_cmp_func_combo_box_new ();

  gpp->ff_mb_cmp_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table2), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Select macroblock compare function "), NULL);

  inital_value = p_init_gint_combo_active(gpp
                              , combo
                              , &gtab_cmp_func[0]
                              , gpp->evl.mb_cmp
                              , GAP_GVE_FFMPEG_CMP_MAX_ELEMENTS
                              );

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              inital_value,
                              G_CALLBACK (on_ff_gint32_combo),
                              &gpp->evl.mb_cmp);


  row++;

  /* the ildct compare function label */
  label = gtk_label_new (_("ildct cmp:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table2), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the ildct compare function combo */
  combo = p_ff_cmp_func_combo_box_new ();

  gpp->ff_ildct_cmp_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table2), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Select ildct compare function "), NULL);

  inital_value = p_init_gint_combo_active(gpp
                              , combo
                              , &gtab_cmp_func[0]
                              , gpp->evl.ildct_cmp
                              , GAP_GVE_FFMPEG_CMP_MAX_ELEMENTS
                              );

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              inital_value,
                              G_CALLBACK (on_ff_gint32_combo),
                              &gpp->evl.ildct_cmp);



  row++;

  /* the fullpel compare function label */
  label = gtk_label_new (_("Fullpel cmp:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table2), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the fullpel compare function combo */
  combo = p_ff_cmp_func_combo_box_new ();

  gpp->ff_cmp_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table2), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Select fullpel compare function "), NULL);

  inital_value = p_init_gint_combo_active(gpp
                              , combo
                              , &gtab_cmp_func[0]
                              , gpp->evl.cmp
                              , GAP_GVE_FFMPEG_CMP_MAX_ELEMENTS
                              );

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              inital_value,
                              G_CALLBACK (on_ff_gint32_combo),
                              &gpp->evl.cmp);


  row++;

  /* the subpel compare function label */
  label = gtk_label_new (_("Subpel cmp:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table2), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the subpel compare function combo */
  combo = p_ff_cmp_func_combo_box_new ();

  gpp->ff_sub_cmp_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table2), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Select subpel compare function"), NULL);

  inital_value = p_init_gint_combo_active(gpp
                              , combo
                              , &gtab_cmp_func[0]
                              , gpp->evl.sub_cmp
                              , GAP_GVE_FFMPEG_CMP_MAX_ELEMENTS
                              );

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              inital_value,
                              G_CALLBACK (on_ff_gint32_combo),
                              &gpp->evl.sub_cmp);


  row++;

  /* the pre motion estimation compare function label */
  label = gtk_label_new (_("Pre motion estimation cmp:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table2), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the pre motion estimation compare function combo */
  combo = p_ff_cmp_func_combo_box_new ();

  gpp->ff_pre_cmp_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table2), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Select pre motion estimation compare function "), NULL);

  inital_value = p_init_gint_combo_active(gpp
                              , combo
                              , &gtab_cmp_func[0]
                              , gpp->evl.pre_cmp
                              , GAP_GVE_FFMPEG_CMP_MAX_ELEMENTS
                              );

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              inital_value,
                              G_CALLBACK (on_ff_gint32_combo),
                              &gpp->evl.pre_cmp);


  row++;

  /* the frame skip compare function label */
  label = gtk_label_new (_("Frame skip cmp:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table2), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);



  /* the frame skip compare function combo */
  combo = p_ff_cmp_func_combo_box_new ();

  gpp->ff_frame_skip_cmp_combo = combo;
  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table2), combo, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Select pre motion estimation compare function "), NULL);

  inital_value = p_init_gint_combo_active(gpp
                              , combo
                              , &gtab_cmp_func[0]
                              , gpp->evl.frame_skip_cmp
                              , GAP_GVE_FFMPEG_CMP_MAX_ELEMENTS
                              );

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              inital_value,
                              G_CALLBACK (on_ff_gint32_combo),
                              &gpp->evl.frame_skip_cmp);

  row++;

  return(frame);
}  /* end  p_create_expert_algortihms_frame */


/* --------------------------------
 * p_create_expert_flags_frame
 * --------------------------------
 */
GtkWidget*
p_create_expert_flags_frame (GapGveFFMpegGlobalParams *gpp)
{
  GtkWidget *frame;
  GtkWidget *flags_frame;
  GtkWidget *table2;
  GtkWidget *label;
  GtkWidget *checkbutton;

  gint       row;

  frame = gimp_frame_new (_("FFMpeg Expert Flags"));

  table2 = gtk_table_new (7, 3, FALSE);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (frame), table2);
  gtk_container_set_border_width (GTK_CONTAINER (table2), 2);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 4);

  row = 0;

  /* the (invisible) frame Flags container for the flag checkbuttons */
  flags_frame = gimp_frame_new (NULL);
  gtk_widget_show (flags_frame);
  gtk_table_attach (GTK_TABLE (table2), flags_frame, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  /* the flags table */
  {
    int flags_row;
    GtkWidget *flags_table;

    flags_table = gtk_table_new (8, 2, FALSE);
    gtk_widget_show (flags_table);
    gtk_container_add (GTK_CONTAINER (flags_frame), flags_table);
    gtk_container_set_border_width (GTK_CONTAINER (flags_table), 2);
    gtk_table_set_row_spacings (GTK_TABLE (flags_table), 4);
    gtk_table_set_col_spacings (GTK_TABLE (flags_table), 4);

    flags_row = 0;

    /* LABELS */
    label = gtk_label_new (_("General flags:"));
    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
    gtk_widget_show (label);
    gtk_table_attach (GTK_TABLE (flags_table), label, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);

    label = gtk_label_new (_("H263:"));
    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
    gtk_widget_show (label);
    gtk_table_attach (GTK_TABLE (flags_table), label, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);


    label = gtk_label_new (_("MPEG2/4:"));
    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
    gtk_widget_show (label);
    gtk_table_attach (GTK_TABLE (flags_table), label, 2, 3, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);


    flags_row++;

    /* CHECKBUTTONS */
    /* the Bitexact checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Bitexact"));
    gpp->ff_bitexact_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Only use bit exact algorithms (for codec testing)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.bitexact);


    /* the Advanced intra coding checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Advanced intra coding"));
    gpp->ff_aic_checkbutton                 = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Activate intra frame coding (only h263+ CODEC)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.aic);


    /* the 4 Motion Vectors checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("4 Motion Vectors"));
    gpp->ff_mv4_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 2, 3, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Use four motion vectors by macroblock (only MPEG-4 CODEC)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.mv4);


    flags_row++;

    /* the Closed GOP checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Closed GOP"));
    gpp->ff_closed_gop_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Closed group of pictures"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.closed_gop);

    /* the Unlimited motion vector checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Unlimited motion vector"));
    gpp->ff_umv_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Enable unlimited motion vector (only h263+ CODEC)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.umv);


    /* the Partitioning checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Partitioning"));
    gpp->ff_partitioning_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 2, 3, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Use data partitioning (only MPEG-4 CODEC)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.partitioning);



    flags_row++;

    /* the Strict GOP checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Strict GOP"));
    gpp->ff_strict_gop_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Strictly enforce GOP size"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.strict_gop);




    /* the Use slice struct checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Use slice struct"));
    gpp->ff_use_ss_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Enable slice structured mode (only h263+ CODEC)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.use_ss);


    /* the Use Alt scantable checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Use alt scantable"));
    gpp->ff_use_alt_scan_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 2, 3, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Enable alternate scantable (only MPEG-2 MPEG-4 CODECs)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.use_alt_scan);



    flags_row++;

    /* the Use interlaced me checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Use interlaced me"));
    gpp->ff_do_interlace_me_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Enable interlaced motion estimation"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.do_interlace_me);


    /* the Use AIV checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Use AIV"));
    gpp->ff_use_aiv_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Enable Alternative inter vlc (only h263+ CODEC)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.use_aiv);


    flags_row++;

    /* the interlace dct checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Interlace DCT"));
    gpp->ff_do_interlace_dct_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Use interlaced dct"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.do_interlace_dct);


    /* the Use OBMC checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Overlapped block"));
    gpp->ff_use_obmc_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Enable use overlapped block motion compensation (only h263+ CODEC)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.use_obmc);


    flags_row++;

    /* the quarter pel checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("quarter pel"));
    gpp->ff_use_qpel_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Enable 1/4-pel"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.use_qpel);

    /* the Use Loop checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Loop Filter"));
    gpp->ff_use_loop_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Use loop filter (only h263+ CODEC)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.use_loop);

    flags_row++;

    /* the Use qprd checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Use qprd"));
    gpp->ff_use_qprd_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Use rate distortion optimization for qp selection"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.use_qprd);

    flags_row++;

    /* the Use cbprd checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Use cbprd"));
    gpp->ff_use_cbprd_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Use rate distortion optimization for cbp"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.use_cbprd);

    flags_row++;

    /* the Use MV0 checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Use MV0"));
    gpp->ff_use_mv0_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Try to encode each MB with MV=<0,0> and choose the better one (has no effect if mbd=0)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.use_mv0);

    flags_row++;

    /* the Use Normalize checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Normalize"));
    gpp->ff_do_normalize_aqp_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Normalize adaptive quantization"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.do_normalize_aqp);



    flags_row++;

    /* the SVCD scan offset checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("SVCD scan offset"));
    gpp->ff_use_scan_offset_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Enable SVCD scan offset placeholder"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.use_scan_offset);



    flags_row++;


  }  /* end flags_table */


  row++;

  /* the dont_recode checkbutton */
  checkbutton = gtk_check_button_new_with_label (_("Dont Recode"));
  gpp->ff_dont_recode_checkbutton = checkbutton;
  gtk_widget_show (checkbutton);
  gtk_table_attach (GTK_TABLE (table2), checkbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (checkbutton
                        , _("Bypass the FFMPEG Vidoencoder where inputframes can "
                            "be copied 1:1 from an input MPEG videofile."
                            "This experimental feature provides lossless MPEG "
                            "video cut, but works only for the MPEG Fileformats.")
                        , NULL);
  g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (checkbutton), "toggled",
                    G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                    &gpp->evl.dont_recode_flag);


  return(frame);
}  /* end  p_create_expert_flags_frame */



/* --------------------------------
 * p_create_expert_flags2_frame
 * --------------------------------
 */
GtkWidget*
p_create_expert_flags2_frame (GapGveFFMpegGlobalParams *gpp)
{
  GtkWidget *frame;
  GtkWidget *flags_frame;
  GtkWidget *table2;
  GtkWidget *label;
  GtkWidget *checkbutton;

  gint       row;

  frame = gimp_frame_new (_("FFMpeg Expert Flags2"));

  table2 = gtk_table_new (7, 3, FALSE);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (frame), table2);
  gtk_container_set_border_width (GTK_CONTAINER (table2), 2);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 4);

  row = 0;

  /* the (invisible) frame Flags container for the flag checkbuttons */
  flags_frame = gimp_frame_new (NULL);
  gtk_widget_show (flags_frame);
  gtk_table_attach (GTK_TABLE (table2), flags_frame, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  /* the flags table */
  {
    int flags_row;
    GtkWidget *flags_table;

    flags_table = gtk_table_new (8, 2, FALSE);
    gtk_widget_show (flags_table);
    gtk_container_add (GTK_CONTAINER (flags_frame), flags_table);
    gtk_container_set_border_width (GTK_CONTAINER (flags_table), 2);
    gtk_table_set_row_spacings (GTK_TABLE (flags_table), 4);
    gtk_table_set_col_spacings (GTK_TABLE (flags_table), 4);

    flags_row = 0;

    /* LABELS */
    label = gtk_label_new (_("General flags2:"));
    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
    gtk_widget_show (label);
    gtk_table_attach (GTK_TABLE (flags_table), label, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);

    label = gtk_label_new (_("H264:"));
    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
    gtk_widget_show (label);
    gtk_table_attach (GTK_TABLE (flags_table), label, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);




    flags_row++;

    /* CHECKBUTTONS */
    /* the Fast checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Fast Non-Compliant"));
    gpp->ff_codec_FLAG2_FAST_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Allow non spec compliant speedup tricks"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_FAST);


    /* the use_bpyramid checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Bpyramid"));
    gpp->ff_codec_FLAG2_BPYRAMID_checkbutton  = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("allow B-frames to be used as references for predicting.(for H264 codec)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_BPYRAMID);



    flags_row++;

    /* the use_local_header checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Local Header"));
    gpp->ff_codec_FLAG2_LOCAL_HEADER_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Place global headers at every keyframe instead of in extradata"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_LOCAL_HEADER);

    /* the use_wpred checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Weighted Biprediction"));
    gpp->ff_codec_FLAG2_WPRED_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("weighted biprediction for B-frames (for H264 codec)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_WPRED);




    flags_row++;

    /* the use_brdo checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("B Rate Distortion"));
    gpp->ff_codec_FLAG2_BRDO_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("B-frame rate-distortion optimization"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_BRDO);




    /* the use_mixed_refs checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Mixed Refs"));
    gpp->ff_codec_FLAG2_MIXED_REFS_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("one reference per partition, as opposed to one reference per macroblock (for H264 codec)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_MIXED_REFS);



    flags_row++;

    /* the use_ivlc checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Intra VLC"));
    gpp->ff_codec_FLAG2_INTRA_VLC_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Use MPEG-2 intra VLC table."), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_INTRA_VLC);


    /* the use_dct8x8 checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Use AIV"));
    gpp->ff_codec_FLAG2_8X8DCT_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("high profile 8x8 transform (for H264 codec)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_8X8DCT);


    flags_row++;

    /* the use_memc_only checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Only ME/MC"));
    gpp->ff_codec_FLAG2_MEMC_ONLY_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Only do ME/MC (I frames -> ref, P frame -> ME+MC)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_MEMC_ONLY);


    /* the use_fastpskip checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Fast Pskip"));
    gpp->ff_codec_FLAG2_FASTPSKIP_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("fast pskip (for H264 codec)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_FASTPSKIP);



    flags_row++;

    /* the use_drop_frame_timecode checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("DropFrame Timecode"));
    gpp->ff_codec_FLAG2_DROP_FRAME_TIMECODE_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("timecode is in drop frame format"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_DROP_FRAME_TIMECODE);

    /* the use_aud checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("AccessUnit"));
    gpp->ff_codec_FLAG2_AUD_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 1, 2, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("use access unit delimiters (for H264 codec)"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_AUD);


    flags_row++;

    /* the use_skip_rd checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Use qprd"));
    gpp->ff_codec_FLAG2_SKIP_RD_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("RD optimal MB level residual skipping"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_SKIP_RD);

    flags_row++;

    /* the use_chunks checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Use chunks"));
    gpp->ff_codec_FLAG2_CHUNKS_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Input bitstream might be truncated at a packet boundaries instead of only at frame boundaries"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_CHUNKS);


    flags_row++;

    /* the use_non_linear_quant checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Nonlinear Quant"));
    gpp->ff_codec_FLAG2_NON_LINEAR_QUANT_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Use MPEG-2 nonlinear quantizer"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_NON_LINEAR_QUANT);

    flags_row++;

    /* the use_bit_reservoir checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Bit Reservoir"));
    gpp->ff_codec_FLAG2_BIT_RESERVOIR_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Use a bit reservoir when encoding if possible"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG2_BIT_RESERVOIR);



    flags_row++;

    /* the use_gmc checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Use GMC"));
    gpp->ff_codec_FLAG_GMC_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Use GMC"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG_GMC);

    flags_row++;

    /* the input_preserved checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Input Preserved"));
    gpp->ff_codec_FLAG_INPUT_PRESERVED_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Input Preserved"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG_INPUT_PRESERVED);

    flags_row++;

    /* the use_gray checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Use Gray"));
    gpp->ff_codec_FLAG_GRAY_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Only encode grayscale"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG_GRAY);


    flags_row++;

    /* the use_emu_edge checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Emu Edges"));
    gpp->ff_codec_FLAG_EMU_EDGE_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Dont draw edges"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG_EMU_EDGE);

    flags_row++;

    /* the use_truncated checkbutton */
    checkbutton = gtk_check_button_new_with_label (_("Truncated"));
    gpp->ff_codec_FLAG_TRUNCATED_checkbutton = checkbutton;
    gtk_widget_show (checkbutton);
    gtk_table_attach (GTK_TABLE (flags_table), checkbutton, 0, 1, flags_row, flags_row+1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gimp_help_set_help_data (checkbutton, _("Input bitstream might be truncated at a random location instead of only at frame boundaries"), NULL);
    g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
    g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.codec_FLAG_TRUNCATED);

    flags_row++;

  }  /* end flags_table */


  return(frame);
}  /* end  p_create_expert_flags2_frame */



/* --------------------------------
 * p_create_expert_options_frame
 * --------------------------------
 */
GtkWidget*
p_create_expert_options_frame (GapGveFFMpegGlobalParams *gpp)
{
  GtkWidget *frame;
  GtkWidget *table4;
  GtkWidget *label;
  GtkObject *adj;
  GtkWidget *spinbutton;

  gint       row;

  frame = gimp_frame_new (_("FFMpeg Expert Encoder Options"));


  table4 = gtk_table_new (14, 3, FALSE);
  gtk_widget_show (table4);
  gtk_container_add (GTK_CONTAINER (frame), table4);
  gtk_container_set_border_width (GTK_CONTAINER (table4), 4);
  gtk_table_set_row_spacings (GTK_TABLE (table4), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table4), 4);

  row = 0;

  /* the qblur label */
  label = gtk_label_new (_("qblur:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the qblur spinbutton */
  adj = gtk_adjustment_new (0.5, 0, 1.0, 0.01, 0.1, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 2);
  gpp->ff_qblur_spinbutton_adj            = adj;
  gpp->ff_qblur_spinbutton                = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Video quantiser scale blur (VBR) "
                                         "amount of qscale smoothing over time (0.0-1.0)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gdouble_spinbutton_changed),
                      &gpp->evl.qblur);



  row++;


  /* the qcomp label */
  label = gtk_label_new (_("qcomp:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the qcomp spinbutton */
  adj = gtk_adjustment_new (0.5, 0, 1.0, 0.01, 0.1, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 2);
  gpp->ff_qcomp_spinbutton_adj            = adj;
  gpp->ff_qcomp_spinbutton                = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Video quantiser scale compression (VBR) "
                                         "amount of qscale change between easy & hard scenes (0.0-1.0)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gdouble_spinbutton_changed),
                      &gpp->evl.qcomp);

  row++;

  /* the rc-init-cplx label */
  label = gtk_label_new (_("rc-init-cplx:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the rc-init-cplx spinbutton */
  adj = gtk_adjustment_new (1.25, 0, 100, 0.25, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 2);
  gpp->ff_rc_init_cplx_spinbutton_adj     = adj;
  gpp->ff_rc_init_cplx_spinbutton         = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Initial complexity for 1-pass encoding"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gdouble_spinbutton_changed),
                      &gpp->evl.rc_init_cplx);

  row++;

  /* the b-qfactor label */

  label = gtk_label_new (_("b-qfactor:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the b-qfactor spinbutton */
  adj = gtk_adjustment_new (1.25, -100, 100, 0.2, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 2);
  gpp->ff_b_qfactor_spinbutton_adj        = adj;
  gpp->ff_b_qfactor_spinbutton            = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("qp factor between p and b frames"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gdouble_spinbutton_changed),
                      &gpp->evl.b_qfactor);

  row++;

  /* the i-qfactor label */
  label = gtk_label_new (_("i-qfactor:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the i-qfactor spinbutton */
  adj = gtk_adjustment_new (-0.8, -100, 100, 0.2, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 2);
  gpp->ff_i_qfactor_spinbutton_adj        = adj;
  gpp->ff_i_qfactor_spinbutton            = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("qp factor between p and i frames"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gdouble_spinbutton_changed),
                      &gpp->evl.i_qfactor);


  row++;

  /* the b-qoffset label */
  label = gtk_label_new (_("b-qoffset:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the b-qoffset spinbutton */
  adj = gtk_adjustment_new (1.25, 0, 100, 0.25, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 2);
  gpp->ff_b_qoffset_spinbutton_adj        = adj;
  gpp->ff_b_qoffset_spinbutton            = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("qp offset between p and b frames"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gdouble_spinbutton_changed),
                      &gpp->evl.b_qoffset);

  row++;

  /* the i-qoffset label */
  label = gtk_label_new (_("i-qoffset:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the i-qoffset spinbutton */
  adj = gtk_adjustment_new (0, 0, 100, 0.25, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 2);
  gpp->ff_i_qoffset_spinbutton_adj        = adj;
  gpp->ff_i_qoffset_spinbutton            = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("qp offset between p and i frames"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gdouble_spinbutton_changed),
                      &gpp->evl.i_qoffset);


  row++;

  /* the Bitrate Tolerance label */
  label = gtk_label_new (_("Bitrate Tol:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the Bitrate Tolerance spinbutton */
  adj = gtk_adjustment_new (4200, 0, 10000, 100, 1000, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_bitrate_tol_spinbutton_adj      = adj;
  gpp->ff_bitrate_tol_spinbutton          = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Set video bitrate tolerance (in kbit/s)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.bitrate_tol);

  row++;

  /* the Maxrate Tolerance label */
  label = gtk_label_new (_("Maxrate Tol:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  /* the Maxrate Tolerance spinbutton */
  adj = gtk_adjustment_new (0, 0, 10000, 100, 1000, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_maxrate_tol_spinbutton_adj      = adj;
  gpp->ff_maxrate_tol_spinbutton          = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Set max video bitrate tolerance (in kbit/s)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.maxrate_tol);


  row++;


  /* the Minrate Tolerance label */
  label = gtk_label_new (_("Minrate Tol:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the Minrate Tolerance spinbutton */
  adj = gtk_adjustment_new (0, 0, 10000, 100, 1000, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_minrate_tol_spinbutton_adj      = adj;
  gpp->ff_minrate_tol_spinbutton          = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Set min video bitrate tolerance (in kbit/s)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.minrate_tol);

  row++;


  /* the Bufsize label */
  label = gtk_label_new (_("Bufsize:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the Bufsize spinbutton */
  adj = gtk_adjustment_new (0, 0, 10000, 100, 1000, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_bufsize_spinbutton_adj          = adj;
  gpp->ff_bufsize_spinbutton              = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Set ratecontrol buffer size (in kbyte)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.bufsize);

  row++;


  /* the strictness label */
  label = gtk_label_new (_("strictness:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the strictness spinbutton */
  adj = gtk_adjustment_new (1, -2, 2, 1, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_strict_spinbutton_adj           = adj;
  gpp->ff_strict_spinbutton               = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("How strictly to follow the standards"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.strict);


  row++;


  /* the mb-qmin label */
  label = gtk_label_new (_("mb-qmin:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the mb-qmin spinbutton */
  adj = gtk_adjustment_new (0, 0, 31, 1, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_mb_qmin_spinbutton_adj          = adj;
  gpp->ff_mb_qmin_spinbutton              = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Min macroblock quantiser scale (VBR)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.mb_qmin);

  row++;


  /* the mb-qmax label */
  label = gtk_label_new (_("mb-qmax:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table4), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the mb-qmax spinbutton */
  adj = gtk_adjustment_new (31, 0, 31, 1, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_mb_qmax_spinbutton_adj          = adj;
  gpp->ff_mb_qmax_spinbutton              = spinbutton;
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table4), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Max macroblock quantiser scale (VBR)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.mb_qmax);

  return(frame);
}  /* end  p_create_expert_options_frame */


/* --------------------------------
 * p_create_2pass_options_frame
 * --------------------------------
 */
GtkWidget*
p_create_2pass_options_frame (GapGveFFMpegGlobalParams *gpp)
{
  GtkWidget *frame;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *entry;
  GtkWidget *button;
  GtkWidget *checkbutton;
  GtkObject *adj;
  GtkWidget *spinbutton;

  gint       row;

  frame = gimp_frame_new (_("FFMpeg 2 pass and multiplexer expert settings"));

  table = gtk_table_new (8, 3, FALSE);
  gtk_widget_show (table);
  gtk_container_add (GTK_CONTAINER (frame), table);
  gtk_container_set_border_width (GTK_CONTAINER (table), 4);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 4);

  row = 0;

  /* the pass_logfile checkbutton */
  checkbutton = gtk_check_button_new_with_label (_("2 Pass Encoding"));
  gpp->ff_pass_checkbutton                = checkbutton;
  gtk_widget_show (checkbutton);
  gtk_table_attach (GTK_TABLE (table), checkbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (checkbutton, _("Activate 2 pass encoding when set"), NULL);
  g_object_set_data (G_OBJECT (checkbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (checkbutton), "toggled",
                      G_CALLBACK (on_ff_gint32_checkbutton_toggled),
                      &gpp->evl.twoPassFlag);

  row++;

  /* the pass_logfile label */
  label = gtk_label_new (_("Pass Logfile:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);



  /* the pass_logfile entry */
  entry = gtk_entry_new ();
  gpp->ff_passlogfile_entry               = entry;
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (entry, _("The pass logfile is only used as workfile for 2-pass encoding"), NULL);
  g_signal_connect (G_OBJECT (entry), "changed",
                      G_CALLBACK (on_ff_passlogfile_entry_changed),
                      gpp);

  /* the pass_logfile fileselector button */
  button = gtk_button_new_with_label (_("..."));
  gtk_widget_show (button);
  gtk_table_attach (GTK_TABLE (table), button, 2, 3, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (button, _("Select pass logfile via file browser"), NULL);
  g_signal_connect (G_OBJECT (button), "clicked",
                      G_CALLBACK (on_ff_passlogfile_filesel_button_clicked),
                      gpp);

  row++;

  /* the empty label */
  label = gtk_label_new (" ");
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);




  row++;

  /* the video bitrate label */
  label = gtk_label_new (_("Mux Rate:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the video bitrate spinbutton */
  adj = gtk_adjustment_new (0, 0, 1000000, 100, 1000, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_mux_rate_adj = adj;
  gpp->ff_mux_rate_spinbutton     = spinbutton;

  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Multiplexer rate Bit/sec"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.mux_rate);


  row++;

  /* the video bitrate label */
  label = gtk_label_new (_("Mux Packetsize:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the video bitrate spinbutton */
  adj = gtk_adjustment_new (0, 0, 32000, 100, 1000, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gpp->ff_mux_packet_size_adj = adj;
  gpp->ff_mux_packet_size_spinbutton     = spinbutton;

  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Multiplexer packet size"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gint32_spinbutton_changed),
                      &gpp->evl.mux_packet_size);




  row++;

  /* the video bitrate label */
  label = gtk_label_new (_("Mux Preload:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the video bitrate spinbutton */
  adj = gtk_adjustment_new (0.0, 0.0, 100.0, 0.01, 0.1, 0.0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 3);
  gpp->ff_mux_preload_adj = adj;
  gpp->ff_mux_preload_spinbutton     = spinbutton;

  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Set the initial demux-decode delay (seconds)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gdouble_spinbutton_changed),
                      &gpp->evl.mux_preload);



  row++;

  /* the video bitrate label */
  label = gtk_label_new (_("Mux Max Delay:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the video bitrate spinbutton */
  adj = gtk_adjustment_new (0.0, 0.0, 100.0, 0.01, 0.1, 0.0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 3);
  gpp->ff_mux_max_delay_adj = adj;
  gpp->ff_mux_max_delay_spinbutton     = spinbutton;

  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table), spinbutton, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (spinbutton, _("Set the maximum demux-decode delay (seconds)"), NULL);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_ADJ, (gpointer)adj);
  g_object_set_data (G_OBJECT (spinbutton), GAP_ENC_FFGUI_GPP, (gpointer)gpp);
  g_signal_connect (G_OBJECT (spinbutton), "value_changed",
                      G_CALLBACK (on_ff_gdouble_spinbutton_changed),
                      &gpp->evl.mux_max_delay);


  return(frame);
}  /* end  p_create_2pass_options_frame */


/* --------------------------------
 * p_create_file_comment_frame
 * --------------------------------
 */
GtkWidget*
p_create_file_comment_frame (GapGveFFMpegGlobalParams *gpp)
{
  GtkWidget *frame;
  GtkWidget *table6;
  GtkWidget *label;
  GtkWidget *entry;

  gint       row;

  frame = gimp_frame_new (_("FFMpeg File Comment settings"));


  table6 = gtk_table_new (5, 2, FALSE);
  gtk_widget_show (table6);
  gtk_container_add (GTK_CONTAINER (frame), table6);
  gtk_container_set_border_width (GTK_CONTAINER (table6), 4);
  gtk_table_set_row_spacings (GTK_TABLE (table6), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table6), 4);

  row = 0;

  /* the title lable */
  label = gtk_label_new (_("Title:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table6), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the title entry */
  entry = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY (entry), 40);
  gpp->ff_title_entry = entry;
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table6), entry, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  g_signal_connect (G_OBJECT (entry), "changed",
                      G_CALLBACK (on_ff_title_entry_changed),
                      gpp);


  row++;

  /* the Author lable */
  label = gtk_label_new (_("Author:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table6), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the Author entry */
  entry = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY (entry), 40);
  gpp->ff_author_entry = entry;
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table6), entry, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  g_signal_connect (G_OBJECT (entry), "changed",
                      G_CALLBACK (on_ff_author_entry_changed),
                      gpp);

  row++;

  /* the Copyright lable */
  label = gtk_label_new (_("Copyright:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table6), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the Copyright entry */
  entry = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY (entry), 40);
  gpp->ff_copyright_entry                 = entry;
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table6), entry, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  g_signal_connect (G_OBJECT (entry), "changed",
                      G_CALLBACK (on_ff_copyright_entry_changed),
                      gpp);


  row++;

  /* the Comment lable */
  label = gtk_label_new (_("Comment:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table6), label, 0, 1, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  /* the Comment entry */
  entry = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY (entry), 80);
  gpp->ff_comment_entry = entry;
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table6), entry, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  g_signal_connect (G_OBJECT (entry), "changed",
                      G_CALLBACK (on_ff_comment_entry_changed),
                      gpp);

  row++;

  /* the filecomment_label lable */
  label = gtk_label_new (_("\nText tags will be inserted in the\n"
                           "resulting video for all non blank entry fields."));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table6), label, 1, 2, row, row+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  return(frame);
}  /* end  p_create_file_comment_frame */




/* --------------------------------
 * p_create_ffmpeg_dialog_shell
 * --------------------------------
 */
GtkWidget*
p_create_ffmpeg_dialog_shell (GapGveFFMpegGlobalParams *gpp)
{
  GtkWidget *shell_window;
  GtkWidget *dialog_vbox2;
  GtkWidget *notebook1;
  GtkWidget *frame_preset;
  GtkWidget *frame;

  GtkWidget *table_preset;

  GtkWidget *nb1_label;
  gint       nb_page_nr;



  GtkWidget *combo;
  GtkWidget *ff_basic_info_label;
  GtkWidget *spc_hbox;

  /* set the widgets to defined NULL before we create them
   * (some callbacks may refer to those widgets before
   *  all of them are created. those callbacks check for NULL
   *  but would crash if the widgets are undefined yet)
   */
  gpp->ff_aspect_combo = NULL;
  gpp->ff_aud_bitrate_combo = NULL;
  gpp->ff_aud_bitrate_spinbutton = NULL;
  gpp->ff_aud_codec_combo = NULL;
  gpp->ff_author_entry = NULL;
  gpp->ff_b_frames_spinbutton = NULL;
  gpp->ff_b_qfactor_spinbutton = NULL;
  gpp->ff_b_qoffset_spinbutton = NULL;
  gpp->ff_basic_info_label = NULL;
  gpp->ff_bitrate_tol_spinbutton = NULL;
  gpp->ff_bufsize_spinbutton = NULL;
  gpp->ff_comment_entry = NULL;
  gpp->ff_copyright_entry = NULL;
  gpp->ff_dct_algo_combo = NULL;
  gpp->ff_dont_recode_checkbutton = NULL;
  gpp->ff_fileformat_combo = NULL;
  gpp->ff_gop_size_spinbutton = NULL;
  gpp->ff_bitexact_checkbutton = NULL;
  gpp->ff_aspect_checkbutton = NULL;
  gpp->ff_aic_checkbutton = NULL;
  gpp->ff_umv_checkbutton = NULL;
  gpp->ff_i_qfactor_spinbutton = NULL;
  gpp->ff_i_qoffset_spinbutton = NULL;
  gpp->ff_idct_algo_combo = NULL;
  gpp->ff_intra_checkbutton = NULL;
  gpp->ff_maxrate_tol_spinbutton = NULL;
  gpp->ff_mb_qmax_spinbutton = NULL;
  gpp->ff_mb_qmin_spinbutton = NULL;
  gpp->ff_mb_decision_combo = NULL;
  gpp->ff_minrate_tol_spinbutton = NULL;
  gpp->ff_motion_estimation_combo = NULL;
  gpp->ff_mv4_checkbutton = NULL;
  gpp->ff_partitioning_checkbutton = NULL;
  gpp->ff_pass_checkbutton = NULL;
  gpp->ff_passlogfile_entry = NULL;
  gpp->ff_presets_combo = NULL;
  gpp->ff_qblur_spinbutton = NULL;
  gpp->ff_qcomp_spinbutton = NULL;
  gpp->ff_qdiff_spinbutton = NULL;
  gpp->ff_qmax_spinbutton = NULL;
  gpp->ff_qmin_spinbutton = NULL;
  gpp->ff_qscale_spinbutton = NULL;
  gpp->ff_rc_init_cplx_spinbutton = NULL;
  gpp->ff_strict_spinbutton = NULL;
  gpp->ff_title_entry = NULL;
  gpp->ff_vid_bitrate_spinbutton = NULL;
  gpp->ff_vid_codec_combo = NULL;

  gpp->ff_mb_cmp_combo = NULL;
  gpp->ff_ildct_cmp_combo = NULL;
  gpp->ff_sub_cmp_combo = NULL;
  gpp->ff_cmp_combo = NULL;
  gpp->ff_pre_cmp_combo = NULL;
  gpp->ff_frame_skip_cmp_combo = NULL;
  gpp->ff_coder_combo = NULL;
  gpp->ff_predictor_combo = NULL;

  gpp->ff_mux_rate_spinbutton = NULL;
  gpp->ff_mux_packet_size_spinbutton = NULL;
  gpp->ff_mux_preload_spinbutton = NULL;
  gpp->ff_mux_max_delay_spinbutton = NULL;

  gpp->ff_use_ss_checkbutton = NULL;
  gpp->ff_use_aiv_checkbutton = NULL;
  gpp->ff_use_obmc_checkbutton = NULL;
  gpp->ff_use_loop_checkbutton = NULL;
  gpp->ff_use_alt_scan_checkbutton = NULL;
  gpp->ff_use_mv0_checkbutton = NULL;
  gpp->ff_do_normalize_aqp_checkbutton = NULL;
  gpp->ff_use_scan_offset_checkbutton = NULL;
  gpp->ff_closed_gop_checkbutton = NULL;
  gpp->ff_use_qpel_checkbutton = NULL;
  gpp->ff_use_qprd_checkbutton = NULL;
  gpp->ff_use_cbprd_checkbutton = NULL;
  gpp->ff_do_interlace_dct_checkbutton = NULL;
  gpp->ff_do_interlace_me_checkbutton = NULL;
  gpp->ff_strict_gop_checkbutton = NULL;
  gpp->ff_no_output_checkbutton = NULL;

  gpp->ff_codec_FLAG_GMC_checkbutton = NULL;
  gpp->ff_codec_FLAG_INPUT_PRESERVED_checkbutton = NULL;
  gpp->ff_codec_FLAG_GRAY_checkbutton = NULL;
  gpp->ff_codec_FLAG_EMU_EDGE_checkbutton = NULL;
  gpp->ff_codec_FLAG_TRUNCATED_checkbutton = NULL;
  
  gpp->ff_codec_FLAG2_FAST_checkbutton = NULL;
  gpp->ff_codec_FLAG2_LOCAL_HEADER_checkbutton = NULL;
  gpp->ff_codec_FLAG2_BPYRAMID_checkbutton = NULL;
  gpp->ff_codec_FLAG2_WPRED_checkbutton = NULL;
  gpp->ff_codec_FLAG2_MIXED_REFS_checkbutton = NULL;
  gpp->ff_codec_FLAG2_8X8DCT_checkbutton = NULL;
  gpp->ff_codec_FLAG2_FASTPSKIP_checkbutton = NULL;
  gpp->ff_codec_FLAG2_AUD_checkbutton = NULL;
  gpp->ff_codec_FLAG2_BRDO_checkbutton = NULL;
  gpp->ff_codec_FLAG2_INTRA_VLC_checkbutton = NULL;
  gpp->ff_codec_FLAG2_MEMC_ONLY_checkbutton = NULL;
  gpp->ff_codec_FLAG2_DROP_FRAME_TIMECODE_checkbutton = NULL;
  gpp->ff_codec_FLAG2_SKIP_RD_checkbutton = NULL;
  gpp->ff_codec_FLAG2_CHUNKS_checkbutton = NULL;
  gpp->ff_codec_FLAG2_NON_LINEAR_QUANT_checkbutton = NULL;
  gpp->ff_codec_FLAG2_BIT_RESERVOIR_checkbutton = NULL;


  shell_window = gimp_dialog_new (_("FFMPEG Video Encode Parameters"),
                         GAP_PLUGIN_NAME_FFMPEG_PARAMS,
                         NULL, 0,
                         gimp_standard_help_func, GAP_HELP_ID_FFMPEG_PARAMS,

                         GTK_STOCK_OPEN, GAP_ENC_FFMPEG_RESPONSE_OPEN,
                         GTK_STOCK_SAVE, GAP_ENC_FFMPEG_RESPONSE_SAVE,
                         GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                         GTK_STOCK_OK,     GTK_RESPONSE_OK,
                         NULL);
  gtk_window_set_type_hint (shell_window, GDK_WINDOW_TYPE_HINT_NORMAL);

  g_signal_connect (G_OBJECT (shell_window), "response",
                    G_CALLBACK (on_ff_response),
                    gpp);


  dialog_vbox2 = GTK_DIALOG (shell_window)->vbox;
  gtk_widget_show (dialog_vbox2);


  /* ================== */
  /* the preset frame   */
  /* ================== */
  spc_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (spc_hbox);
  frame_preset = gimp_frame_new (_("Parameter Presets"));
  gtk_widget_show (frame_preset);

  gtk_box_pack_start (GTK_BOX (spc_hbox), frame_preset, TRUE, TRUE, 10);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), spc_hbox, TRUE, TRUE, 4);

  /* the preset table */
  table_preset = gtk_table_new (2, 1, FALSE);
  gtk_widget_show (table_preset);
  gtk_container_add (GTK_CONTAINER (frame_preset), table_preset);
  gtk_container_set_border_width (GTK_CONTAINER (table_preset), 2);
  gtk_table_set_row_spacings (GTK_TABLE (table_preset), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table_preset), 4);


  /* the presets combo */
  combo = gimp_int_combo_box_new (
     _("** OOPS do not change any parameter **"),   GAP_GVE_FFMPEG_PRESET_00_NONE,
     _("use DivX default presets"),                 GAP_GVE_FFMPEG_PRESET_01_DIVX_DEFAULT,
     _("use DivX high quality presets"),            GAP_GVE_FFMPEG_PRESET_02_DIVX_BEST,
     _("use DivX low quality presets"),             GAP_GVE_FFMPEG_PRESET_03_DIVX_LOW,
     _("use DivX WINDOWS presets"),                 GAP_GVE_FFMPEG_PRESET_04_DIVX_MS,
     _("use MPEG1 (VCD) presets"),                  GAP_GVE_FFMPEG_PRESET_05_MPEG1_VCD,
     _("use MPEG1 high quality presets"),           GAP_GVE_FFMPEG_PRESET_06_MPEG1_BEST,
     _("use MPEG2 (SVCD) presets"),                 GAP_GVE_FFMPEG_PRESET_07_MPEG2_SVCD,
     _("use MPEG2 (DVD) presets"),                  GAP_GVE_FFMPEG_PRESET_08_MPEG2_DVD,
     _("use REAL video presets"),                   GAP_GVE_FFMPEG_PRESET_09_REAL,
     NULL);
  gpp->ff_presets_combo                   = combo;

  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo),
                              0,                /* initial int value */
                              G_CALLBACK (on_ff_presets_combo),
                              gpp);

  /* todo:
   * the on_ff_presets_combo callback should run when the same
   * item is selected again (to restore the presets for all the other widgets
   * that could have been changed since the same preset item was selected
   * the last time)
   * but the combo box widgets seems to support only the "changed" signal
   *
   * therefore the on_ff_presets_combo callback does always swicth back
   * to index 0 (OOPS, dont change preset params)
   */

  gtk_widget_show (combo);
  gtk_table_attach (GTK_TABLE (table_preset), combo, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  gimp_help_set_help_data (combo, _("Predefined encoder parameter settings"), NULL);




  /* the info label */
  ff_basic_info_label = gtk_label_new ("this text is replaced by the current"
                                       " preset/parameter description at runtime");
  gpp->ff_basic_info_label                = ff_basic_info_label;
  gtk_widget_show (ff_basic_info_label);
  gtk_table_attach (GTK_TABLE (table_preset), ff_basic_info_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  gtk_label_set_justify (GTK_LABEL (ff_basic_info_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (ff_basic_info_label), 0, 0.5);


  /* ================== */
  /* the parmeter frame */
  /* ================== */
  spc_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (spc_hbox);
  frame = gimp_frame_new (_("Parameter Values"));
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (spc_hbox), frame, TRUE, TRUE, 10);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), spc_hbox, TRUE, TRUE, 4);

  /* the notebook for detailed parameter settings */
  /* -------------------------------------------- */
  notebook1 = gtk_notebook_new ();
  gtk_widget_show (notebook1);
  gtk_container_add (GTK_CONTAINER (frame), notebook1);
  gtk_container_set_border_width (GTK_CONTAINER (notebook1), 4);

  nb_page_nr = 0;

  /* the frame with basic options */
  frame = p_create_basic_options_frame(gpp);
  gtk_widget_show (frame);

  gtk_container_add (GTK_CONTAINER (notebook1), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 4);

  /* the notebook page label for basic options */
  nb1_label = gtk_label_new (_("Basic Options"));
  gtk_widget_show (nb1_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), nb_page_nr), nb1_label);


  nb_page_nr++;

  /* the frame with expert_algortihms */
  frame = p_create_expert_algortihms_frame(gpp);
  gtk_widget_show (frame);

  gtk_container_add (GTK_CONTAINER (notebook1), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 4);


  /* the notebook page label for expert algorithms */
  nb1_label = gtk_label_new (_("Algorithms"));
  gtk_widget_show (nb1_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), nb_page_nr), nb1_label);

  nb_page_nr++;

  /* the frame with expert_flags */
  frame = p_create_expert_flags_frame(gpp);
  gtk_widget_show (frame);

  gtk_container_add (GTK_CONTAINER (notebook1), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 4);

  /* the notebook page label for expert flags */
  nb1_label = gtk_label_new (_("Expert Flags"));
  gtk_widget_show (nb1_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), nb_page_nr), nb1_label);


  nb_page_nr++;

  /* the frame with expert_flags2 */
  frame = p_create_expert_flags2_frame(gpp);
  gtk_widget_show (frame);

  gtk_container_add (GTK_CONTAINER (notebook1), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 4);

  /* the notebook page label for expert flags */
  nb1_label = gtk_label_new (_("Expert Flags2"));
  gtk_widget_show (nb1_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), nb_page_nr), nb1_label);


  nb_page_nr++;

  /* the frame with expert_options */
  frame = p_create_expert_options_frame(gpp);
  gtk_widget_show (frame);

  gtk_container_add (GTK_CONTAINER (notebook1), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 4);

  /* the notebook page label for expert encoder options */
  nb1_label = gtk_label_new (_("Expert Options"));
  gtk_widget_show (nb1_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), nb_page_nr), nb1_label);


  nb_page_nr++;

  /* the frame with the 2-pass settings */
  frame = p_create_2pass_options_frame(gpp);
  gtk_widget_show (frame);

  gtk_container_add (GTK_CONTAINER (notebook1), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 4);

  /* the notebook page label for 2 Pass Expert settings */
  nb1_label = gtk_label_new (_("2Pass/Mux"));
  gtk_widget_show (nb1_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), nb_page_nr), nb1_label);


  nb_page_nr++;

  /* the frame with the 2-pass settings */
  frame = p_create_file_comment_frame(gpp);
  gtk_widget_show (frame);

  gtk_container_add (GTK_CONTAINER (notebook1), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 4);


  /* the notebook page label for file comment settings */
  nb1_label = gtk_label_new (_("File Comment"));
  gtk_widget_show (nb1_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), nb_page_nr), nb1_label);

  return shell_window;
}  /* end p_create_ffmpeg_dialog_shell */

/* ----------------------------------
 * gap_enc_ffgui_ffmpeg_encode_dialog
 * ----------------------------------
 *   return  0 .. OK
 *          -1 .. in case of Error or cancel
 */
gint
gap_enc_ffgui_ffmpeg_encode_dialog(GapGveFFMpegGlobalParams *gpp)
{
  if(gap_debug) printf("gap_enc_ffgui_ffmpeg_encode_dialog: Start\n");

  gimp_ui_init ("gap_enc_ffmpeg_params", FALSE);
  gap_stock_init();

  /* ---------- sub dialog windows ----------*/
  gpp->startup = TRUE;
  gpp->ffpar_filename[0] = '\0';
  gpp->ffpar_fileselection = NULL;  /* used for video encoder parameter fileselection */
  gpp->fsb__fileselection = NULL;   /* used for pass log fileselection */
  gpp->ecp = NULL;

  if(gap_debug) printf("gap_enc_ffgui_ffmpeg_encode_dialog: Before p_create_ffmpeg_dialog_shell\n");

  /* ---------- dialog ----------*/
  gpp->shell_window = p_create_ffmpeg_dialog_shell (gpp);
  gpp->startup = FALSE;

  if(gap_debug) printf("p_ffmpeg_encode_dialog: After p_create_ffmpeg_dialog_shell\n");

  p_set_combo_box_callbacks(gpp);
  gap_enc_ffgui_init_main_dialog_widgets(gpp);
  gtk_widget_show (gpp->shell_window);
  gtk_window_present(GTK_WINDOW(gpp->shell_window));

  gpp->val.run = 0;
  gtk_main ();

  if(gap_debug) printf("p_ffmpeg_encode_dialog: A F T E R gtk_main run:%d\n", (int)gpp->val.run);

  if(gpp->val.run)
  {
    return 0;
  }
  return -1;
}    /* end gap_enc_ffgui_ffmpeg_encode_dialog (productive version) */
