/*
 * $Id: tx_layer.c,v 1.3 2003/09/17 19:13:59 hipnod Exp $
 *
 * Copyright (C) 2003 giFT project (gift.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#include "gt_gnutella.h"

#include "tx_stack.h"
#include "tx_layer.h"

/*****************************************************************************/

struct tx_layer *tx_layer_new (GtTxStack *stack, const char *name,
                               struct tx_layer_ops *ops)
{
	struct tx_layer *tx;

	if (!(tx = NEW (struct tx_layer)))
		return NULL;

	tx->ops   = ops;
	tx->name  = name;
	tx->stack = stack;

	if (!ops->init (tx))
	{
		free (tx);
		return NULL;
	}

	return tx;
}

void tx_layer_free (struct tx_layer *layer)
{
	if (!layer)
		return;

	layer->ops->destroy (layer);

	FREE (layer);
}

void tx_layer_enable (struct tx_layer *layer)
{
	layer->ops->enable (layer);
}

void tx_layer_disable (struct tx_layer *layer)
{
	layer->ops->disable (layer);
}

void tx_layer_send (struct tx_layer *tx, struct io_buf *io_buf)
{
	struct tx_layer *lower;

	lower = tx->lower;
	lower->ops->send (lower, io_buf);
}
