/* GtkEditor - a source editor widget for GTK
 * Copyright (C) 1998 Thomas Mailund.
 *
 * The editor widget was written by Thomas Mailund, so bugs should be
 * reported to <mailund@daimi.au.dk>, not the gtk ppl.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GTKEDITOR_REGEX_H
#define GTKEDITOR_REGEX_H

#include <sys/types.h>
#include <regex.h>
#include <string.h>

#include <gtk/gtk.h>
#include "gtkeditor.h"

typedef struct _Match {
  gint from;
  gint to;
} Match;

typedef struct _Regex {
  struct re_pattern_buffer buf;
  struct re_registers reg;
} Regex;

typedef struct _PEntry {
  /* name of the pattern -- should be a unique key.  Used for later
   * update/remove */
  char *name;

  /* the original char * pattern */
  char *pattern;
  
  /* the compiled pattern */
  Regex regex;

  /* the text properties associated with the pattern */
  GtkSCTextProperties *prop;

  /* The number of textproperties. This is used to set different
   * properties for sub-patterns */
  guint no_prop;

  /* reference count...it is possible to share pentries between
   * tables.  Changes in one will reflect in reflect in the others, so
   * be careful.*/
  int refcount;  
} PEntry;

struct _GtkEditorHilitePatterns {
  /* The different highlight pattern categories are kept in a list */
  GList *patterns;

  /* while all patterns are combined in one pattern to speedup
   * searching.  We search with this pattern, and if we match anything
   * we test with the patterns, which one matched. */
  Regex all;
};

/* --<prototypes>---------------------------------------------------------- */
gint            _gtk_editor_select_regex       (GtkEditor        *editor,
						gchar            *regex,
						gboolean          forward);

GtkEditorHilitePatterns *_gtk_editor_new_patterns (GList         *entries);
void            _gtk_editor_destroy_patterns   (GtkEditorHilitePatterns *patterns);

void            _gtk_editor_philite_interval   (GtkEditor        *editor,
						guint             from,
						guint             to);

gboolean        _gtk_editor_compile_regex      (const gchar *pattern,
						Regex *regex);
void            _gtk_editor_regex_free         (Regex            *regex);
gint            _gtk_editor_regex_search       (GtkSCText          *text,
						guint             pos,
						Regex            *regex,
						gboolean          forward,
						Match            *m);
gint            _gtk_editor_regex_match        (GtkSCText          *text,
						guint             pos,
						Regex            *regex);



#endif /* GTKEDITOR_REGEX_H */
