// MM2MDL.H : data storage for reduced protein models (molecular mechanics).

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM2MDL_H
#define MM2MDL_H

struct mm2_eng_param;	// temporary...

class mm2_mdl;
class mm2_superimpose;

/*################################################################################################*/

#include "model.h"
#include "mm2util.h"
#include "mm2alg.h"

#include "mm1mdl.h"
#include "mm1util.h"

#include "interface.h"

#include <vector>
using namespace std;

/*################################################################################################*/

struct mm2_eng_param
{
	f64 wtmp1;
	f64 wtmp2;
	f64 wtmp3;
	
	f64 wtor1;
	f64 wtor2;
	f64 lenjon;
	f64 vdwrad;
	f64 screen1;
	f64 screen2;
	f64 screen3;
	f64 screen4;
	f64 screen5;
	f64 dipole1;
	f64 dipole2;
	f64 pbility1;
	f64 pbility2;
	f64 sasa1;
	f64 sasa2;
	f64 solvrad;
	
	f64 rms;
	
	bool operator<(const mm2_eng_param & p1) const
	{
		return (rms < p1.rms);
	}
};

class mm2_mdl : public model_extended, public trajectory_interface
{
//	protected:
	public:		// ???
	
	vector<mm2_chn> chn_vector;
	vector<mm2_dsb> dsb_vector;
	
// debug!!! debug!!! debug!!! debug!!! debug!!!
// debug!!! debug!!! debug!!! debug!!! debug!!!
//vector<mm2_debug> debug_vector;
// debug!!! debug!!! debug!!! debug!!! debug!!!
// debug!!! debug!!! debug!!! debug!!! debug!!!

	mm2_eng_param prm;
	
	friend class mm2_eng;
	friend class mm2_superimpose;
	friend class mm2_ribbon;
	
	friend void CopyCRD(mm2_mdl *, mm2_eng *, i32u);
	friend void CopyCRD(mm2_eng *, mm2_mdl *, i32u);
	
	friend fGL mm2_GetESPValue(fGL *, mm2_mdl *, fGL *);
	friend fGL mm2_GetVDWSValue(fGL *, mm2_mdl *, fGL *);
	
	public:
	
	mm2_mdl(ostream *, class_factory &, mm2_eng_param *);
	~mm2_mdl(void);
	
	const char * GetProjectFileNameExtension(void);		// virtual
	
	void PushCRDSets(i32u);			// virtual
	void PopCRDSets(i32u);			// virtual
	
	void CopyCRDSet(i32u, i32u);		// virtual
	void SwapCRDSets(i32u, i32u);		// virtual
	
	void CenterCRDSet(i32u);		// virtual
	void ReserveCRDSets(i32u);		// virtual
	
	i32s GetVirtAtomCount(void);
	
	void Reduce(mm1_mdl *, mm1_readpdb_mdata *);
	void Reduce_sub1(iter_mm1al, vector<i32s> &, fGL *, i32u);
	
	void UpdateConstraints(void);
	
	// methods for file I/O...
	// ^^^^^^^^^^^^^^^^^^^^^^^
	
	bool ReadStream(istream &, bool = false);	// virtual
	void WriteStream(ostream &);			// virtual
	
/// someday we might move ImportFile() to all_atoms_interface, but at the moment we just have a dummy function here...
	bool ImportFile(const char*, int) { return false; }	// virtual
	void ImportPDB(const char *, i32s);
	
	// here we have a set of Do???()-functions. the idea is that there is a set
	// of features that we wish to behave EXACTLY same way in each target/platform.
	// we then create a Do???()-function for the feature, and hide the details of
	// the user interface in a set of virtual functions.
	
/// This will perform an energy calculation, and report the result.
	void DoEnergy(void);
	
/// This will perform geometry optimization.
	void DoGeomOpt(mm2_geomopt_param &);
	
/// This is used to ask user the GO options; this default function will just silently accept the defaults.
	virtual void GeomOptGetParam(mm2_geomopt_param &);
	
/// This will perform molecular dynamics.
	void DoMolDyn(mm2_moldyn_param &);
	
/// This is used to ask user the MD options; this default function will just silently accept the defaults.
	virtual void MolDynGetParam(mm2_moldyn_param &);
	
	// these come from trajectory_interface...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	void OpenTrajectory(const char *);	// virtual
	void CloseTrajectory(void);		// virtual
	void ReadFrame(void);			// virtual
};

/*################################################################################################*/

fGL mm2_GetESPValue(fGL *, mm2_mdl *, fGL *);
fGL mm2_GetSASValue(fGL *, mm2_mdl *, fGL *);

/*################################################################################################*/

class mm2_superimpose : public superimpose
{
	private:
	
	mm2_mdl * mdl;
	
	public:
	
	mm2_superimpose(mm2_mdl *, i32s, i32s);
	~mm2_superimpose(void);
	
	f64 GetValue(void);		// virtual
	f64 GetGradient(void);		// virtual
	
	void Transform(void);		// virtual
};

/*################################################################################################*/

#endif	// MM2MDL_H

// eof
