-- #hide
-----------------------------------------------------------------------------
-- |
-- Module      :  OS.PictCCall_12
-- Copyright   :  (c) Krasimir Andreev 2002
-- License     :  BSD-style
-- 
-- Maintainer  :  ka2_mail@yahoo.com
-- Stability   :  provisional
-- Portability :  portable
--
-- OS.PictCCall_12 contains all C calls related to drawing.
--
-----------------------------------------------------------------------------

module Graphics.UI.ObjectIO.OS.PictCCall_12
		( HDC, HDC, HBITMAP, Pt, RGBcolor, Fnt
		, iWhitePattern, iLtGreyPattern, iGreyPattern, iDkGreyPattern, iBlackPattern
		, iModeNotBic, iModeNotXor, iModeNotOr, iModeNotCopy, iModeBic, iModeXor, iModeOr, iModeCopy
		, iStrikeOut, iUnderline, iItalic, iBold
		, alternate, winding
		, winCreateScreenHDC, winDestroyScreenHDC
		, winGetStringWidth, winGetPicStringWidth, winGetCharWidth, winGetPicCharWidth
		, winGetPicFontInfo, winGetFontInfo, winSetFont
		, winDrawBitmap, winDrawResizedBitmap, winCreateBitmap
		, winInvertPolygon, winErasePolygon, winFillPolygon, winDrawPolygon, winUndrawPolygon, winAddPolygonPoint
		, winStartPolygon, winEndPolygon, winAllocPolyShape, winSetPolyPoint, winFreePolyShape
		, winInvertWedge, winEraseWedge, winFillWedge		
		, winInvertOval, winEraseOval, winFillOval, winDrawOval, winUndrawOval
		, winScrollRectangle, winCopyRectangle, winCopyRectangleTo, winMoveRectangle, winMoveRectangleTo
		, winInvertRectangle, winEraseRectangle, winFillRectangle, winDrawRectangle, winUndrawRectangle
		, winUndrawChar, winDrawChar, winUndrawString, winDrawString
		, winUndrawCurve, winDrawCurve, winUndrawLine, winDrawLine, winDrawPoint
		, winSetPenSize, winSetPattern, winSetMode, winSetBackColor, winSetPenColor
		, winClipRgnPicture, winSetClipRgnPicture, winGetClipRgnPicture
		, winDeleteObject
		, winDonePicture, winInitPicture
		, getPictureScalingFactors, getResolutionC
		, winDefaultFontDef, winDialogFontDef
		) where



import Graphics.UI.ObjectIO.OS.Types(Rect(..))
import Graphics.UI.ObjectIO.OS.RgnCCall_12
import Graphics.UI.ObjectIO.OS.Cutil_12

type	HDC
	= Ptr ()
type	Pt
	= ( Int
	  , Int
	  )
type	RGBcolor
	= ( Int
	  , Int
	  , Int
	  )
type	Fnt
	= ( String
	  , Int
	  , Int
	  )
type  HBITMAP = Ptr ()

iWhitePattern, iLtGreyPattern, iGreyPattern, iDkGreyPattern, iBlackPattern :: Int
iWhitePattern	= 4
iLtGreyPattern	= 3
iGreyPattern	= 2
iDkGreyPattern	= 1
iBlackPattern	= 0

iModeNotBic, iModeNotXor, iModeNotOr, iModeNotCopy, iModeBic, iModeXor, iModeOr, iModeCopy :: Int
iModeNotBic	= 7
iModeNotXor	= 6
iModeNotOr	= 5
iModeNotCopy	= 4
iModeBic	= 3
iModeXor	= 2
iModeOr		= 1
iModeCopy	= 0

iStrikeOut, iUnderline, iItalic, iBold :: Int
iStrikeOut	= 8
iUnderline	= 4
iItalic		= 2
iBold		= 1

--	Constants for drawing polygons.
alternate, winding :: Int
alternate	= 1
winding		= 2


return_fst (a,_) = return a

--	Win(Create/Destroy)ScreenHDC added to temporarily create a HDC of a screen.
--		Never use these values for a window or control.

foreign import ccall "cpicture_121.h WinCreateScreenHDC"  winCreateScreenHDC  :: IO HDC
foreign import ccall "cpicture_121.h WinDestroyScreenHDC" winDestroyScreenHDC :: HDC -> IO ()

winGetStringWidth :: String -> Fnt -> HDC -> IO Int
winGetStringWidth a1 (a2,a3,a4) a5
	= do {
		-- Marshal arguments:
		s1 <- newCString a1;
		s2 <- newCString a2;
		-- Call C:
		width <- cWinGetStringWidth s1 s2 a3 a4 a5;
		-- Read/free:
		free s1;
		free s2;		
		return width
	  }
foreign import ccall "cpicture_121.h WinGetStringWidth" cWinGetStringWidth :: CString -> CString -> Int -> Int -> HDC -> IO Int

winGetCharWidth :: Char -> Fnt -> HDC -> IO Int
winGetCharWidth a1 (a2,a3,a4) a5 = withCString a2 (\s -> cWinGetCharWidth a1 s a3 a4 a5)
foreign import ccall "cpicture_121.h WinGetCharWidth" cWinGetCharWidth :: Char -> CString -> Int -> Int -> HDC -> IO Int

winGetPicStringWidth :: String -> HDC -> IO Int
winGetPicStringWidth a1 a2 = withCString a1 (\s -> cWinGetPicStringWidth s a2)
foreign import ccall "cpicture_121.h WinGetPicStringWidth" cWinGetPicStringWidth :: CString -> HDC -> IO Int

foreign import ccall "cpicture_121.h WinGetPicCharWidth" winGetPicCharWidth :: Char -> HDC -> IO Int	


winGetPicFontInfo :: HDC -> IO (Int,Int,Int,Int)
winGetPicFontInfo a1
	= do {
		-- Marshal arguments:
		o1 <- malloc;
		o2 <- malloc;
		o3 <- malloc;
		o4 <- malloc;		
		-- Call C:
		cWinGetPicFontInfo a1 o1 o2 o3 o4;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		r3 <- fpeek o3;
		r4 <- fpeek o4;
		return (r1,r2,r3,r4)
	  }
foreign import ccall "cpicture_121.h WinGetPicFontInfo" cWinGetPicFontInfo :: HDC -> Ptr Int -> Ptr Int -> Ptr Int -> Ptr Int -> IO ()

winGetFontInfo :: Fnt -> HDC -> IO (Int,Int,Int,Int)
winGetFontInfo (a1,a2,a3) a4
	= do {
		-- Marshal arguments:
		s1 <- newCString a1;
		o1 <- malloc;
		o2 <- malloc;
		o3 <- malloc;
		o4 <- malloc;
		-- Call C:
		cWinGetFontInfo s1 a2 a3 a4 o1 o2 o3 o4;
		-- Read/free:
		free s1;
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		r3 <- fpeek o3;
		r4 <- fpeek o4;
		return (r1,r2,r3,r4)
	  }
foreign import ccall "cpicture_121.h WinGetFontInfo" cWinGetFontInfo :: CString -> Int -> Int -> HDC -> Ptr Int -> Ptr Int -> Ptr Int -> Ptr Int -> IO ()

winSetFont :: Fnt -> HDC -> IO ()
winSetFont (a1,a2,a3) a4 = withCString a1 (\s -> cWinSetFont s a2 a3 a4)
foreign import ccall "cpicture_121.h WinSetFont" cWinSetFont :: CString -> Int -> Int -> HDC -> IO ()

--	Routines to DRAW bitmaps.
winDrawBitmap :: (Int,Int) -> (Int,Int) -> HBITMAP -> HDC -> IO ()
winDrawBitmap (a1,a2) (a3,a4) a5 a6 = cWinDrawBitmap a1 a2 a3 a4 a5 a6

foreign import ccall "cpicture_121.h WinDrawBitmap" cWinDrawBitmap :: Int -> Int -> Int -> Int -> HBITMAP -> HDC -> IO ()

winDrawResizedBitmap :: (Int,Int) -> (Int,Int) -> (Int,Int) -> HBITMAP -> HDC -> IO ()
winDrawResizedBitmap (a1,a2) (a3,a4) (a5,a6) a7 a8 = cWinDrawResizedBitmap a1 a2 a3 a4 a5 a6 a7 a8

foreign import ccall "cpicture_121.h WinDrawResizedBitmap" cWinDrawResizedBitmap :: Int -> Int -> Int -> Int -> Int -> Int -> HBITMAP -> HDC -> IO ()
foreign import ccall "cpicture_121.h WinCreateBitmap" winCreateBitmap :: CString -> Ptr Int -> Ptr Int -> IO HBITMAP
foreign import ccall "cpicture_121.h WinInvertPolygon" winInvertPolygon :: HDC -> IO ()
foreign import ccall "cpicture_121.h WinErasePolygon"  winErasePolygon  :: HDC -> IO ()
foreign import ccall "cpicture_121.h WinFillPolygon"   winFillPolygon   :: HDC -> IO ()
foreign import ccall "cpicture_121.h WinDrawPolygon"   winDrawPolygon   :: HDC -> IO ()
foreign import ccall "cpicture_121.h WinUndrawPolygon" winUndrawPolygon :: HDC -> IO ()

winAddPolygonPoint :: Pt -> IO ()
winAddPolygonPoint (a1,a2) = cWinAddPolygonPoint a1 a2
foreign import ccall "cpicture_121.h WinAddPolygonPoint" cWinAddPolygonPoint :: Int -> Int -> IO ()
foreign import ccall "cpicture_121.h WinStartPolygon"    winStartPolygon :: Int -> IO ()
foreign import ccall "cpicture_121.h WinEndPolygon"      winEndPolygon :: IO ()


{-	Operations to create, modify, and destroy polygon shapes.
-}

foreign import ccall "cpicture_121.h WinAllocPolyShape" winAllocPolyShape :: Int -> IO (Ptr Int)
foreign import ccall "cpicture_121.h WinSetPolyPoint"   winSetPolyPoint   :: Int -> Int -> Int -> Ptr Int -> IO ()
foreign import ccall "cpicture_121.h WinFreePolyShape"  winFreePolyShape  :: Ptr Int -> IO ()


winInvertWedge :: Pt -> Pt ->  Float -> Float -> Bool -> HDC -> IO ()
winInvertWedge (x,y) (rx,ry) from to clockwise hdc = cWinInvertWedge x y rx ry from to clockwise hdc
foreign import ccall "cpicture_121.h WinInvertWedge" cWinInvertWedge :: Int -> Int -> Int -> Int -> Float -> Float -> Bool -> HDC -> IO ()

winEraseWedge :: Pt -> Pt ->  Float -> Float -> Bool -> HDC -> IO ()
winEraseWedge (x,y) (rx,ry) from to clockwise hdc = cWinEraseWedge x y rx ry from to clockwise hdc
foreign import ccall "cpicture_121.h WinEraseWedge" cWinEraseWedge :: Int -> Int -> Int -> Int -> Float -> Float -> Bool -> HDC -> IO ()

winFillWedge :: Pt -> Pt ->  Float -> Float -> Bool -> HDC -> IO ()
winFillWedge (x,y) (rx,ry) from to clockwise hdc = cWinFillWedge x y rx ry from to clockwise hdc
foreign import ccall "cpicture_121.h WinFillWedge" cWinFillWedge :: Int -> Int -> Int -> Int -> Float -> Float -> Bool -> HDC -> IO ()

winInvertOval :: Rect -> HDC -> IO ()
winInvertOval (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= cWinInvertOval a1 a2 a3 a4 a5
foreign import ccall "cpicture_121.h WinInvertOval" cWinInvertOval :: Int -> Int -> Int -> Int -> HDC -> IO ()

winEraseOval :: Rect -> HDC -> IO ()
winEraseOval (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= cWinEraseOval a1 a2 a3 a4 a5

foreign import ccall "cpicture_121.h WinEraseOval" cWinEraseOval :: Int -> Int -> Int -> Int -> HDC -> IO ()

winFillOval :: Rect -> HDC -> IO ()
winFillOval (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= cWinFillOval a1 a2 a3 a4 a5
foreign import ccall "cpicture_121.h WinFillOval" cWinFillOval :: Int -> Int -> Int -> Int -> HDC -> IO ()

winDrawOval :: Rect -> HDC -> IO ()
winDrawOval (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= cWinDrawOval a1 a2 a3 a4 a5
foreign import ccall "cpicture_121.h WinDrawOval" cWinDrawOval :: Int -> Int -> Int -> Int -> HDC -> IO ()

winUndrawOval :: Rect -> HDC -> IO ()
winUndrawOval (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= cWinUndrawOval a1 a2 a3 a4 a5
foreign import ccall "cpicture_121.h WinUndrawOval" cWinUndrawOval :: Int -> Int -> Int -> Int -> HDC -> IO ()

winScrollRectangle :: Rect -> Pt -> HDC -> IO Rect
winScrollRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) a7
	= do {
		-- Marshal arguments:
		o1 <- malloc;
		o2 <- malloc;
		o3 <- malloc;
		o4 <- malloc;
		-- Call C:
		cWinScrollRectangle a1 a2 a3 a4 a5 a6 a7 o1 o2 o3 o4;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		r3 <- fpeek o3;
		r4 <- fpeek o4;
		return (Rect {rleft=r1,rtop=r2,rright=r3,rbottom=r4})
	  }
foreign import ccall "cpicture_121.h WinScrollRectangle" cWinScrollRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> HDC -> Ptr Int -> Ptr Int -> Ptr Int -> Ptr Int -> IO ()

winCopyRectangle :: Rect -> Pt -> HDC -> IO ()
winCopyRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) a7
	= cWinCopyRectangle a1 a2 a3 a4 a5 a6 a7
foreign import ccall "cpicture_121.h WinCopyRectangle" cWinCopyRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> HDC -> IO ()

winCopyRectangleTo :: Rect -> Pt -> HDC -> IO ()
winCopyRectangleTo (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) a7
	= cWinCopyRectangleTo a1 a2 a3 a4 a5 a6 a7
foreign import ccall "cpicture_121.h WinCopyRectangleTo" cWinCopyRectangleTo :: Int -> Int -> Int -> Int -> Int -> Int -> HDC -> IO ()

winMoveRectangle :: Rect -> Pt -> HDC -> IO ()
winMoveRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) a7
	= cWinMoveRectangle a1 a2 a3 a4 a5 a6 a7
foreign import ccall "cpicture_121.h WinMoveRectangle" cWinMoveRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> HDC -> IO ()

winMoveRectangleTo :: Rect -> Pt -> HDC -> IO ()
winMoveRectangleTo (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) a7
	= cWinMoveRectangleTo a1 a2 a3 a4 a5 a6 a7
foreign import ccall "cpicture_121.h WinMoveRectangleTo" cWinMoveRectangleTo :: Int -> Int -> Int -> Int -> Int -> Int -> HDC -> IO ()

winInvertRectangle :: Rect -> HDC -> IO ()
winInvertRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= cWinInvertRectangle a1 a2 a3 a4 a5
foreign import ccall "cpicture_121.h WinInvertRectangle" cWinInvertRectangle :: Int -> Int -> Int -> Int -> HDC -> IO ()

winEraseRectangle :: Rect -> HDC -> IO ()
winEraseRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= cWinEraseRectangle a1 a2 a3 a4 a5
foreign import ccall "cpicture_121.h WinEraseRectangle" cWinEraseRectangle :: Int -> Int -> Int -> Int -> HDC -> IO ()

winFillRectangle :: Rect -> HDC -> IO ()
winFillRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= cWinFillRectangle a1 a2 a3 a4 a5
foreign import ccall "cpicture_121.h WinFillRectangle" cWinFillRectangle :: Int -> Int -> Int -> Int -> HDC -> IO ()

winDrawRectangle :: Rect -> HDC -> IO ()
winDrawRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= cWinDrawRectangle a1 a2 a3 a4 a5
foreign import ccall "cpicture_121.h WinDrawRectangle" cWinDrawRectangle :: Int -> Int -> Int -> Int -> HDC -> IO ()

winUndrawRectangle :: Rect -> HDC -> IO ()
winUndrawRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5 = cWinUndrawRectangle a1 a2 a3 a4 a5
foreign import ccall "cpicture_121.h WinUndrawRectangle" cWinUndrawRectangle :: Int -> Int -> Int -> Int -> HDC -> IO ()

winDrawChar :: Pt -> Char -> HDC -> IO ()
winDrawChar (a1,a2) a3 a4 = cWinDrawChar a1 a2 a3 a4
foreign import ccall "cpicture_121.h WinDrawChar" cWinDrawChar :: Int -> Int -> Char -> HDC -> IO ()

winUndrawChar :: Pt -> Char -> HDC -> IO ()
winUndrawChar (a1,a2) a3 a4 = cWinUndrawChar a1 a2 a3 a4
foreign import ccall "cpicture_121.h WinUndrawChar" cWinUndrawChar :: Int -> Int -> Char -> HDC -> IO ()

winDrawString :: Pt -> String -> HDC -> IO ()
winDrawString (a1,a2) a3 a4 = withCString a3 (\s -> cWinDrawString a1 a2 s a4)
foreign import ccall "cpicture_121.h WinDrawString" cWinDrawString :: Int -> Int -> CString -> HDC -> IO ()

winUndrawString :: Pt -> String -> HDC -> IO ()
winUndrawString (a1,a2) a3 a4 = withCString a3 (\s -> cWinUndrawString a1 a2 s a4)
foreign import ccall "cpicture_121.h WinUndrawString" cWinUndrawString :: Int -> Int -> CString -> HDC -> IO ()

winDrawCurve :: Pt -> Pt ->  Float -> Float -> Bool -> HDC -> IO ()
winDrawCurve (x,y) (rx,ry) from to clockwise hdc = cWinDrawCurve x y rx ry from to clockwise hdc
foreign import ccall "cpicture_121.h WinDrawCurve" cWinDrawCurve :: Int -> Int -> Int -> Int -> Float -> Float -> Bool -> HDC -> IO ()

winUndrawCurve :: Pt -> Pt ->  Float -> Float -> Bool -> HDC -> IO ()
winUndrawCurve (x,y) (rx,ry) from to clockwise hdc = cWinUndrawCurve x y rx ry from to clockwise hdc
foreign import ccall "cpicture_121.h WinUndrawCurve" cWinUndrawCurve :: Int -> Int -> Int -> Int -> Float -> Float -> Bool -> HDC -> IO ()

winDrawLine :: Pt -> Pt -> HDC -> IO ()
winDrawLine (a1,a2) (a3,a4) a5 = cWinDrawLine a1 a2 a3 a4 a5
foreign import ccall "cpicture_121.h WinDrawLine" cWinDrawLine :: Int -> Int -> Int -> Int -> HDC -> IO ()

winUndrawLine :: Pt -> Pt -> HDC -> IO ()
winUndrawLine (a1,a2) (a3,a4) a5 = cWinUndrawLine a1 a2 a3 a4 a5
foreign import ccall "cpicture_121.h WinUndrawLine" cWinUndrawLine :: Int -> Int -> Int -> Int -> HDC -> IO ()

winDrawPoint :: Pt -> HDC -> IO ()
winDrawPoint (a1,a2) a3
	= cWinDrawPoint a1 a2 a3
foreign import ccall "cpicture_121.h WinDrawPoint" cWinDrawPoint :: Int -> Int -> HDC -> IO ()

foreign import ccall "cpicture_121.h WinSetPenSize" winSetPenSize :: Int -> HDC -> IO ()

foreign import ccall "cpicture_121.h WinSetPattern" winSetPattern :: Int -> HDC -> IO ()

foreign import ccall "cpicture_121.h WinSetMode" winSetMode :: Int -> HDC -> IO ()

winSetBackColor :: RGBcolor -> HDC -> IO ()
winSetBackColor (a1,a2,a3) a4
	= cWinSetBackColor a1 a2 a3 a4
foreign import ccall "cpicture_121.h WinSetBackColor" cWinSetBackColor :: Int -> Int -> Int -> HDC -> IO ()

winSetPenColor :: RGBcolor -> HDC -> IO ()
winSetPenColor (a1,a2,a3) a4
	= cWinSetPenColor a1 a2 a3 a4
foreign import ccall "cpicture_121.h WinSetPenColor" cWinSetPenColor :: Int -> Int -> Int -> HDC -> IO ()

--	Operation to set the clipping region.
foreign import ccall "cpicture_121.h WinClipRgnPicture" winClipRgnPicture :: HRGN -> HDC -> IO ()

--	Operation to set the complete clipping region.
foreign import ccall "cpicture_121.h WinSetClipRgnPicture" winSetClipRgnPicture :: HRGN -> HDC -> IO ()

--	Operation to retrieve the current clipping region.
foreign import ccall "cpicture_121.h WinGetClipRgnPicture" winGetClipRgnPicture :: HDC -> IO HRGN

foreign import ccall "cpicture_121.h WinDeleteObject" winDeleteObject :: Ptr () -> IO ()

winDonePicture :: HDC -> IO (Int,Int,RGBcolor,RGBcolor,Fnt)
winDonePicture a1
	= do {
		o1 <- malloc;
		o2 <- malloc;
		o3 <- malloc;
		o4 <- malloc;
		o5 <- malloc;
		o6 <- malloc;
		o7 <- malloc;
		o8 <- malloc;		
		o11 <- malloc;
		o12 <- malloc;
		o13 <- malloc;
		cWinDonePicture a1 o1 o2 o3 o4 o5 o6 o7 o8 o11 o12 o13;
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		r3 <- fpeek o3;
		r4 <- fpeek o4;
		r5 <- fpeek o5;
		r6 <- fpeek o6;
		r7 <- fpeek o7;
		r8 <- fpeek o8;		
		clstr11 <- fpeek o11;
		s11 <- peekCString clstr11;
		free clstr11;
		r12 <- fpeek o12;
		r13 <- fpeek o13;
		return (r1,r2,(r3,r4,r5),(r6,r7,r8),(s11,r12,r13))
	  }
foreign import ccall "cpicture_121.h WinDonePicture" cWinDonePicture :: HDC -> Ptr Int -> Ptr Int -> Ptr Int -> Ptr Int -> Ptr Int -> Ptr Int -> Ptr Int -> Ptr Int -> Ptr CString -> Ptr Int -> Ptr Int -> IO ()

winInitPicture :: Int -> Int -> RGBcolor -> RGBcolor -> Fnt -> HRGN -> HDC -> IO ()
winInitPicture a1 a2 (a3,a4,a5) (a6,a7,a8) (a9,a10,a11) a12 a13 = withCString a9 (\s -> cWinInitPicture a1 a2 a3 a4 a5 a6 a7 a8 s a10 a11 a12 a13)
foreign import ccall "cpicture_121.h WinInitPicture" cWinInitPicture :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> CString -> Int -> Int -> HRGN -> HDC -> IO ()


-- MW...

getResolutionC :: HDC -> IO (Int, Int)
getResolutionC a1 = do
	o1 <- malloc
	o2 <- malloc
	cgetResolutionC a1 o1 o2
	r1 <- fpeek o1
	r2 <- fpeek o2
	return (r1, r2)

foreign import ccall "cpicture_121.h getResolutionC" cgetResolutionC :: HDC -> Ptr Int -> Ptr Int -> IO ()


getPictureScalingFactors :: HDC -> IO ((Int, Int), (Int, Int))
getPictureScalingFactors a1 = do
	o1 <- malloc
	o2 <- malloc
	o3 <- malloc
	o4 <- malloc
	cWinGetPictureScaleFactor a1 o1 o2 o3 o4
	r1 <- fpeek o1
	r2 <- fpeek o2
	r3 <- fpeek o3
	r4 <- fpeek o4
	return ((r1, r2), (r3, r4))
	
foreign import ccall "cpicture_121.h WinGetPictureScaleFactor" cWinGetPictureScaleFactor :: HDC -> Ptr Int -> Ptr Int -> Ptr Int -> Ptr Int -> IO ()
-- .. MW

winDefaultFontDef :: IO Fnt
winDefaultFontDef = do
	o1 <- malloc
	o2 <- malloc
	o3 <- malloc
	cWinDefaultFontDef o1 o2 o3
	r1 <- fpeek o1
	r2 <- fpeek o2
	r3 <- fpeek o3
	s <- peekCString r1;
	return (s, r2, r3)

foreign import ccall "cpicture_121.h WinDefaultFontDef" cWinDefaultFontDef :: Ptr CString -> Ptr Int -> Ptr Int -> IO ()

winDialogFontDef :: IO Fnt
winDialogFontDef = do
	o1 <- malloc
	o2 <- malloc
	o3 <- malloc
	cWinDialogFontDef o1 o2 o3
	r1 <- fpeek o1
	r2 <- fpeek o2
	r3 <- fpeek o3
	s <- peekCString r1;
	return (s, r2, r3)

foreign import ccall "cpicture_121.h WinDialogFontDef" cWinDialogFontDef :: Ptr CString -> Ptr Int -> Ptr Int -> IO ()