module Win32Pen where

import StdDIS
import Win32Types
import GDITypes


----------------------------------------------------------------
-- Stock Objects
----------------------------------------------------------------

type StockPen   = WORD

wHITE_PEN :: StockPen
wHITE_PEN =
  unsafePerformIO(
    prim_wHITE_PEN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_wHITE_PEN" prim_wHITE_PEN :: IO (Word16)
bLACK_PEN :: StockPen
bLACK_PEN =
  unsafePerformIO(
    prim_bLACK_PEN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_bLACK_PEN" prim_bLACK_PEN :: IO (Word16)
nULL_PEN :: StockPen
nULL_PEN =
  unsafePerformIO(
    prim_nULL_PEN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_nULL_PEN" prim_nULL_PEN :: IO (Word16)

getStockPen :: StockPen -> IO HPEN
getStockPen arg1 =
  prim_getStockPen arg1
  >>= \ gc_result ->
  access_prim_getStockPen_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getStockPen_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getStockPen_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_getStockPen" prim_getStockPen :: Word16 -> IO (Addr)
foreign import ccall unsafe "access_prim_getStockPen_res1" access_prim_getStockPen_res1 :: Addr -> IO (Addr)
foreign import ccall unsafe "access_prim_getStockPen_gc_failed" access_prim_getStockPen_gc_failed :: Addr -> IO (Int)
foreign import ccall unsafe "access_prim_getStockPen_gc_failstring" access_prim_getStockPen_gc_failstring :: Addr -> IO (Addr)

deletePen :: HPEN -> IO ()
deletePen arg1 =
  prim_deletePen arg1
  >>= \ gc_result ->
  access_prim_deletePen_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_deletePen_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_deletePen" prim_deletePen :: Addr -> IO (Addr)
foreign import ccall unsafe "access_prim_deletePen_gc_failed" access_prim_deletePen_gc_failed :: Addr -> IO (Int)
foreign import ccall unsafe "access_prim_deletePen_gc_failstring" access_prim_deletePen_gc_failstring :: Addr -> IO (Addr)

----------------------------------------------------------------
-- Creating pens
----------------------------------------------------------------

type PenStyle   = Int32

pS_SOLID :: PenStyle
pS_SOLID =
  unsafePerformIO(
    prim_pS_SOLID
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_SOLID" prim_pS_SOLID :: IO (Int32)
pS_DASH :: PenStyle
pS_DASH =
  unsafePerformIO(
    prim_pS_DASH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_DASH" prim_pS_DASH :: IO (Int32)
pS_DOT :: PenStyle
pS_DOT =
  unsafePerformIO(
    prim_pS_DOT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_DOT" prim_pS_DOT :: IO (Int32)
pS_DASHDOT :: PenStyle
pS_DASHDOT =
  unsafePerformIO(
    prim_pS_DASHDOT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_DASHDOT" prim_pS_DASHDOT :: IO (Int32)
pS_DASHDOTDOT :: PenStyle
pS_DASHDOTDOT =
  unsafePerformIO(
    prim_pS_DASHDOTDOT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_DASHDOTDOT" prim_pS_DASHDOTDOT :: IO (Int32)
pS_NULL :: PenStyle
pS_NULL =
  unsafePerformIO(
    prim_pS_NULL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_NULL" prim_pS_NULL :: IO (Int32)
pS_INSIDEFRAME :: PenStyle
pS_INSIDEFRAME =
  unsafePerformIO(
    prim_pS_INSIDEFRAME
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_INSIDEFRAME" prim_pS_INSIDEFRAME :: IO (Int32)
pS_USERSTYLE :: PenStyle
pS_USERSTYLE =
  unsafePerformIO(
    prim_pS_USERSTYLE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_USERSTYLE" prim_pS_USERSTYLE :: IO (Int32)
pS_ALTERNATE :: PenStyle
pS_ALTERNATE =
  unsafePerformIO(
    prim_pS_ALTERNATE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_ALTERNATE" prim_pS_ALTERNATE :: IO (Int32)
pS_STYLE_MASK :: PenStyle
pS_STYLE_MASK =
  unsafePerformIO(
    prim_pS_STYLE_MASK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_STYLE_MASK" prim_pS_STYLE_MASK :: IO (Int32)

pS_ENDCAP_ROUND :: PenStyle
pS_ENDCAP_ROUND =
  unsafePerformIO(
    prim_pS_ENDCAP_ROUND
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_ENDCAP_ROUND" prim_pS_ENDCAP_ROUND :: IO (Int32)
pS_ENDCAP_SQUARE :: PenStyle
pS_ENDCAP_SQUARE =
  unsafePerformIO(
    prim_pS_ENDCAP_SQUARE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_ENDCAP_SQUARE" prim_pS_ENDCAP_SQUARE :: IO (Int32)
pS_ENDCAP_FLAT :: PenStyle
pS_ENDCAP_FLAT =
  unsafePerformIO(
    prim_pS_ENDCAP_FLAT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_ENDCAP_FLAT" prim_pS_ENDCAP_FLAT :: IO (Int32)
pS_ENDCAP_MASK :: PenStyle
pS_ENDCAP_MASK =
  unsafePerformIO(
    prim_pS_ENDCAP_MASK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_ENDCAP_MASK" prim_pS_ENDCAP_MASK :: IO (Int32)

{-
If PS_JOIN_MASK is not defined with your GNU Windows32 header files,
you'll have to define it.
-}
pS_JOIN_ROUND :: PenStyle
pS_JOIN_ROUND =
  unsafePerformIO(
    prim_pS_JOIN_ROUND
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_JOIN_ROUND" prim_pS_JOIN_ROUND :: IO (Int32)
pS_JOIN_BEVEL :: PenStyle
pS_JOIN_BEVEL =
  unsafePerformIO(
    prim_pS_JOIN_BEVEL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_JOIN_BEVEL" prim_pS_JOIN_BEVEL :: IO (Int32)
pS_JOIN_MITER :: PenStyle
pS_JOIN_MITER =
  unsafePerformIO(
    prim_pS_JOIN_MITER
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_JOIN_MITER" prim_pS_JOIN_MITER :: IO (Int32)

pS_COSMETIC :: PenStyle
pS_COSMETIC =
  unsafePerformIO(
    prim_pS_COSMETIC
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_COSMETIC" prim_pS_COSMETIC :: IO (Int32)
pS_GEOMETRIC :: PenStyle
pS_GEOMETRIC =
  unsafePerformIO(
    prim_pS_GEOMETRIC
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_GEOMETRIC" prim_pS_GEOMETRIC :: IO (Int32)
pS_TYPE_MASK :: PenStyle
pS_TYPE_MASK =
  unsafePerformIO(
    prim_pS_TYPE_MASK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_pS_TYPE_MASK" prim_pS_TYPE_MASK :: IO (Int32)

createPen :: PenStyle -> INT -> COLORREF -> IO HPEN
createPen arg1 arg2 arg3 =
  prim_createPen arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_createPen_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_createPen_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createPen_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall unsafe "Win32Pen_stub_ffi.h prim_createPen" prim_createPen :: Int32 -> Int32 -> Word32 -> IO (Addr)
foreign import ccall unsafe "access_prim_createPen_res1" access_prim_createPen_res1 :: Addr -> IO (Addr)
foreign import ccall unsafe "access_prim_createPen_gc_failed" access_prim_createPen_gc_failed :: Addr -> IO (Int)
foreign import ccall unsafe "access_prim_createPen_gc_failstring" access_prim_createPen_gc_failstring :: Addr -> IO (Addr)

-- Not very well supported on Win'95
-- %fun NullHANDLE ExtCreatePen :: PenStyle -> INT -> LOGBRUSH -> [StyleBit] -> IO HPEN

-- ToDo: CreatePenIndirect

----------------------------------------------------------------
-- End
----------------------------------------------------------------
