{-# OPTIONS -#include <windows.h> #-}
{-# OPTIONS -#include "errors.h" #-}
{-# OPTIONS -#include "win32debug.h" #-}
{-# OPTIONS -#include "finalizers.h" #-}
{-# OPTIONS -#include "Win32File_stub_ffi.h" #-}
module Win32File
{-
	( AccessMode, ShareMode, CreateMode, FileAttributeOrFlag
	, CreateFile, CloseHandle, DeleteFile, CopyFile
	, MoveFileFlag, MoveFile, MoveFileEx, 
	)
-}
where

import Win32Types
import StdDIS


----------------------------------------------------------------
-- Enumeration types
----------------------------------------------------------------

type AccessMode   = UINT

gENERIC_NONE :: AccessMode
gENERIC_NONE =
  unsafePerformIO(
    prim_gENERIC_NONE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gENERIC_NONE" unsafe prim_gENERIC_NONE :: IO (Word32)
gENERIC_READ :: AccessMode
gENERIC_READ =
  unsafePerformIO(
    prim_gENERIC_READ
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gENERIC_READ" unsafe prim_gENERIC_READ :: IO (Word32)
gENERIC_WRITE :: AccessMode
gENERIC_WRITE =
  unsafePerformIO(
    prim_gENERIC_WRITE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gENERIC_WRITE" unsafe prim_gENERIC_WRITE :: IO (Word32)
gENERIC_EXECUTE :: AccessMode
gENERIC_EXECUTE =
  unsafePerformIO(
    prim_gENERIC_EXECUTE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gENERIC_EXECUTE" unsafe prim_gENERIC_EXECUTE :: IO (Word32)
gENERIC_ALL :: AccessMode
gENERIC_ALL =
  unsafePerformIO(
    prim_gENERIC_ALL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gENERIC_ALL" unsafe prim_gENERIC_ALL :: IO (Word32)
dELETE :: AccessMode
dELETE =
  unsafePerformIO(
    prim_dELETE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dELETE" unsafe prim_dELETE :: IO (Word32)
rEAD_CONTROL :: AccessMode
rEAD_CONTROL =
  unsafePerformIO(
    prim_rEAD_CONTROL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rEAD_CONTROL" unsafe prim_rEAD_CONTROL :: IO (Word32)
wRITE_DAC :: AccessMode
wRITE_DAC =
  unsafePerformIO(
    prim_wRITE_DAC
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_wRITE_DAC" unsafe prim_wRITE_DAC :: IO (Word32)
wRITE_OWNER :: AccessMode
wRITE_OWNER =
  unsafePerformIO(
    prim_wRITE_OWNER
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_wRITE_OWNER" unsafe prim_wRITE_OWNER :: IO (Word32)
sYNCHRONIZE :: AccessMode
sYNCHRONIZE =
  unsafePerformIO(
    prim_sYNCHRONIZE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sYNCHRONIZE" unsafe prim_sYNCHRONIZE :: IO (Word32)
sTANDARD_RIGHTS_REQUIRED :: AccessMode
sTANDARD_RIGHTS_REQUIRED =
  unsafePerformIO(
    prim_sTANDARD_RIGHTS_REQUIRED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sTANDARD_RIGHTS_REQUIRED" unsafe prim_sTANDARD_RIGHTS_REQUIRED :: IO (Word32)
sTANDARD_RIGHTS_READ :: AccessMode
sTANDARD_RIGHTS_READ =
  unsafePerformIO(
    prim_sTANDARD_RIGHTS_READ
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sTANDARD_RIGHTS_READ" unsafe prim_sTANDARD_RIGHTS_READ :: IO (Word32)
sTANDARD_RIGHTS_WRITE :: AccessMode
sTANDARD_RIGHTS_WRITE =
  unsafePerformIO(
    prim_sTANDARD_RIGHTS_WRITE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sTANDARD_RIGHTS_WRITE" unsafe prim_sTANDARD_RIGHTS_WRITE :: IO (Word32)
sTANDARD_RIGHTS_EXECUTE :: AccessMode
sTANDARD_RIGHTS_EXECUTE =
  unsafePerformIO(
    prim_sTANDARD_RIGHTS_EXECUTE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sTANDARD_RIGHTS_EXECUTE" unsafe prim_sTANDARD_RIGHTS_EXECUTE :: IO (Word32)
sTANDARD_RIGHTS_ALL :: AccessMode
sTANDARD_RIGHTS_ALL =
  unsafePerformIO(
    prim_sTANDARD_RIGHTS_ALL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sTANDARD_RIGHTS_ALL" unsafe prim_sTANDARD_RIGHTS_ALL :: IO (Word32)
sPECIFIC_RIGHTS_ALL :: AccessMode
sPECIFIC_RIGHTS_ALL =
  unsafePerformIO(
    prim_sPECIFIC_RIGHTS_ALL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sPECIFIC_RIGHTS_ALL" unsafe prim_sPECIFIC_RIGHTS_ALL :: IO (Word32)
aCCESS_SYSTEM_SECURITY :: AccessMode
aCCESS_SYSTEM_SECURITY =
  unsafePerformIO(
    prim_aCCESS_SYSTEM_SECURITY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_aCCESS_SYSTEM_SECURITY" unsafe prim_aCCESS_SYSTEM_SECURITY :: IO (Word32)
mAXIMUM_ALLOWED :: AccessMode
mAXIMUM_ALLOWED =
  unsafePerformIO(
    prim_mAXIMUM_ALLOWED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mAXIMUM_ALLOWED" unsafe prim_mAXIMUM_ALLOWED :: IO (Word32)

----------------------------------------------------------------

type ShareMode   = UINT

fILE_SHARE_NONE :: ShareMode
fILE_SHARE_NONE =
  unsafePerformIO(
    prim_fILE_SHARE_NONE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_SHARE_NONE" unsafe prim_fILE_SHARE_NONE :: IO (Word32)
fILE_SHARE_READ :: ShareMode
fILE_SHARE_READ =
  unsafePerformIO(
    prim_fILE_SHARE_READ
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_SHARE_READ" unsafe prim_fILE_SHARE_READ :: IO (Word32)
fILE_SHARE_WRITE :: ShareMode
fILE_SHARE_WRITE =
  unsafePerformIO(
    prim_fILE_SHARE_WRITE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_SHARE_WRITE" unsafe prim_fILE_SHARE_WRITE :: IO (Word32)

----------------------------------------------------------------

type CreateMode   = UINT

cREATE_NEW :: CreateMode
cREATE_NEW =
  unsafePerformIO(
    prim_cREATE_NEW
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cREATE_NEW" unsafe prim_cREATE_NEW :: IO (Word32)
cREATE_ALWAYS :: CreateMode
cREATE_ALWAYS =
  unsafePerformIO(
    prim_cREATE_ALWAYS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cREATE_ALWAYS" unsafe prim_cREATE_ALWAYS :: IO (Word32)
oPEN_EXISTING :: CreateMode
oPEN_EXISTING =
  unsafePerformIO(
    prim_oPEN_EXISTING
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_oPEN_EXISTING" unsafe prim_oPEN_EXISTING :: IO (Word32)
oPEN_ALWAYS :: CreateMode
oPEN_ALWAYS =
  unsafePerformIO(
    prim_oPEN_ALWAYS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_oPEN_ALWAYS" unsafe prim_oPEN_ALWAYS :: IO (Word32)
tRUNCATE_EXISTING :: CreateMode
tRUNCATE_EXISTING =
  unsafePerformIO(
    prim_tRUNCATE_EXISTING
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_tRUNCATE_EXISTING" unsafe prim_tRUNCATE_EXISTING :: IO (Word32)

----------------------------------------------------------------

type FileAttributeOrFlag   = UINT

fILE_ATTRIBUTE_READONLY :: FileAttributeOrFlag
fILE_ATTRIBUTE_READONLY =
  unsafePerformIO(
    prim_fILE_ATTRIBUTE_READONLY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_ATTRIBUTE_READONLY" unsafe prim_fILE_ATTRIBUTE_READONLY :: IO (Word32)
fILE_ATTRIBUTE_HIDDEN :: FileAttributeOrFlag
fILE_ATTRIBUTE_HIDDEN =
  unsafePerformIO(
    prim_fILE_ATTRIBUTE_HIDDEN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_ATTRIBUTE_HIDDEN" unsafe prim_fILE_ATTRIBUTE_HIDDEN :: IO (Word32)
fILE_ATTRIBUTE_SYSTEM :: FileAttributeOrFlag
fILE_ATTRIBUTE_SYSTEM =
  unsafePerformIO(
    prim_fILE_ATTRIBUTE_SYSTEM
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_ATTRIBUTE_SYSTEM" unsafe prim_fILE_ATTRIBUTE_SYSTEM :: IO (Word32)
fILE_ATTRIBUTE_DIRECTORY :: FileAttributeOrFlag
fILE_ATTRIBUTE_DIRECTORY =
  unsafePerformIO(
    prim_fILE_ATTRIBUTE_DIRECTORY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_ATTRIBUTE_DIRECTORY" unsafe prim_fILE_ATTRIBUTE_DIRECTORY :: IO (Word32)
fILE_ATTRIBUTE_ARCHIVE :: FileAttributeOrFlag
fILE_ATTRIBUTE_ARCHIVE =
  unsafePerformIO(
    prim_fILE_ATTRIBUTE_ARCHIVE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_ATTRIBUTE_ARCHIVE" unsafe prim_fILE_ATTRIBUTE_ARCHIVE :: IO (Word32)
fILE_ATTRIBUTE_NORMAL :: FileAttributeOrFlag
fILE_ATTRIBUTE_NORMAL =
  unsafePerformIO(
    prim_fILE_ATTRIBUTE_NORMAL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_ATTRIBUTE_NORMAL" unsafe prim_fILE_ATTRIBUTE_NORMAL :: IO (Word32)
fILE_ATTRIBUTE_TEMPORARY :: FileAttributeOrFlag
fILE_ATTRIBUTE_TEMPORARY =
  unsafePerformIO(
    prim_fILE_ATTRIBUTE_TEMPORARY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_ATTRIBUTE_TEMPORARY" unsafe prim_fILE_ATTRIBUTE_TEMPORARY :: IO (Word32)
fILE_ATTRIBUTE_COMPRESSED :: FileAttributeOrFlag
fILE_ATTRIBUTE_COMPRESSED =
  unsafePerformIO(
    prim_fILE_ATTRIBUTE_COMPRESSED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_ATTRIBUTE_COMPRESSED" unsafe prim_fILE_ATTRIBUTE_COMPRESSED :: IO (Word32)
fILE_FLAG_WRITE_THROUGH :: FileAttributeOrFlag
fILE_FLAG_WRITE_THROUGH =
  unsafePerformIO(
    prim_fILE_FLAG_WRITE_THROUGH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_FLAG_WRITE_THROUGH" unsafe prim_fILE_FLAG_WRITE_THROUGH :: IO (Word32)
fILE_FLAG_OVERLAPPED :: FileAttributeOrFlag
fILE_FLAG_OVERLAPPED =
  unsafePerformIO(
    prim_fILE_FLAG_OVERLAPPED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_FLAG_OVERLAPPED" unsafe prim_fILE_FLAG_OVERLAPPED :: IO (Word32)
fILE_FLAG_NO_BUFFERING :: FileAttributeOrFlag
fILE_FLAG_NO_BUFFERING =
  unsafePerformIO(
    prim_fILE_FLAG_NO_BUFFERING
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_FLAG_NO_BUFFERING" unsafe prim_fILE_FLAG_NO_BUFFERING :: IO (Word32)
fILE_FLAG_RANDOM_ACCESS :: FileAttributeOrFlag
fILE_FLAG_RANDOM_ACCESS =
  unsafePerformIO(
    prim_fILE_FLAG_RANDOM_ACCESS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_FLAG_RANDOM_ACCESS" unsafe prim_fILE_FLAG_RANDOM_ACCESS :: IO (Word32)
fILE_FLAG_SEQUENTIAL_SCAN :: FileAttributeOrFlag
fILE_FLAG_SEQUENTIAL_SCAN =
  unsafePerformIO(
    prim_fILE_FLAG_SEQUENTIAL_SCAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_FLAG_SEQUENTIAL_SCAN" unsafe prim_fILE_FLAG_SEQUENTIAL_SCAN :: IO (Word32)
fILE_FLAG_DELETE_ON_CLOSE :: FileAttributeOrFlag
fILE_FLAG_DELETE_ON_CLOSE =
  unsafePerformIO(
    prim_fILE_FLAG_DELETE_ON_CLOSE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_FLAG_DELETE_ON_CLOSE" unsafe prim_fILE_FLAG_DELETE_ON_CLOSE :: IO (Word32)
fILE_FLAG_BACKUP_SEMANTICS :: FileAttributeOrFlag
fILE_FLAG_BACKUP_SEMANTICS =
  unsafePerformIO(
    prim_fILE_FLAG_BACKUP_SEMANTICS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_FLAG_BACKUP_SEMANTICS" unsafe prim_fILE_FLAG_BACKUP_SEMANTICS :: IO (Word32)
fILE_FLAG_POSIX_SEMANTICS :: FileAttributeOrFlag
fILE_FLAG_POSIX_SEMANTICS =
  unsafePerformIO(
    prim_fILE_FLAG_POSIX_SEMANTICS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_FLAG_POSIX_SEMANTICS" unsafe prim_fILE_FLAG_POSIX_SEMANTICS :: IO (Word32)
sECURITY_ANONYMOUS :: FileAttributeOrFlag
sECURITY_ANONYMOUS =
  unsafePerformIO(
    prim_sECURITY_ANONYMOUS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sECURITY_ANONYMOUS" unsafe prim_sECURITY_ANONYMOUS :: IO (Word32)
sECURITY_IDENTIFICATION :: FileAttributeOrFlag
sECURITY_IDENTIFICATION =
  unsafePerformIO(
    prim_sECURITY_IDENTIFICATION
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sECURITY_IDENTIFICATION" unsafe prim_sECURITY_IDENTIFICATION :: IO (Word32)
sECURITY_IMPERSONATION :: FileAttributeOrFlag
sECURITY_IMPERSONATION =
  unsafePerformIO(
    prim_sECURITY_IMPERSONATION
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sECURITY_IMPERSONATION" unsafe prim_sECURITY_IMPERSONATION :: IO (Word32)
sECURITY_DELEGATION :: FileAttributeOrFlag
sECURITY_DELEGATION =
  unsafePerformIO(
    prim_sECURITY_DELEGATION
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sECURITY_DELEGATION" unsafe prim_sECURITY_DELEGATION :: IO (Word32)
sECURITY_CONTEXT_TRACKING :: FileAttributeOrFlag
sECURITY_CONTEXT_TRACKING =
  unsafePerformIO(
    prim_sECURITY_CONTEXT_TRACKING
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sECURITY_CONTEXT_TRACKING" unsafe prim_sECURITY_CONTEXT_TRACKING :: IO (Word32)
sECURITY_EFFECTIVE_ONLY :: FileAttributeOrFlag
sECURITY_EFFECTIVE_ONLY =
  unsafePerformIO(
    prim_sECURITY_EFFECTIVE_ONLY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sECURITY_EFFECTIVE_ONLY" unsafe prim_sECURITY_EFFECTIVE_ONLY :: IO (Word32)
sECURITY_SQOS_PRESENT :: FileAttributeOrFlag
sECURITY_SQOS_PRESENT =
  unsafePerformIO(
    prim_sECURITY_SQOS_PRESENT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sECURITY_SQOS_PRESENT" unsafe prim_sECURITY_SQOS_PRESENT :: IO (Word32)
sECURITY_VALID_SQOS_FLAGS :: FileAttributeOrFlag
sECURITY_VALID_SQOS_FLAGS =
  unsafePerformIO(
    prim_sECURITY_VALID_SQOS_FLAGS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sECURITY_VALID_SQOS_FLAGS" unsafe prim_sECURITY_VALID_SQOS_FLAGS :: IO (Word32)

----------------------------------------------------------------

type MoveFileFlag   = DWORD

mOVEFILE_REPLACE_EXISTING :: MoveFileFlag
mOVEFILE_REPLACE_EXISTING =
  unsafePerformIO(
    prim_mOVEFILE_REPLACE_EXISTING
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mOVEFILE_REPLACE_EXISTING" unsafe prim_mOVEFILE_REPLACE_EXISTING :: IO (Word32)
mOVEFILE_COPY_ALLOWED :: MoveFileFlag
mOVEFILE_COPY_ALLOWED =
  unsafePerformIO(
    prim_mOVEFILE_COPY_ALLOWED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mOVEFILE_COPY_ALLOWED" unsafe prim_mOVEFILE_COPY_ALLOWED :: IO (Word32)
mOVEFILE_DELAY_UNTIL_REBOOT :: MoveFileFlag
mOVEFILE_DELAY_UNTIL_REBOOT =
  unsafePerformIO(
    prim_mOVEFILE_DELAY_UNTIL_REBOOT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mOVEFILE_DELAY_UNTIL_REBOOT" unsafe prim_mOVEFILE_DELAY_UNTIL_REBOOT :: IO (Word32)

----------------------------------------------------------------

type FilePtrDirection   = DWORD

fILE_BEGIN :: FilePtrDirection
fILE_BEGIN =
  unsafePerformIO(
    prim_fILE_BEGIN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_BEGIN" unsafe prim_fILE_BEGIN :: IO (Word32)
fILE_CURRENT :: FilePtrDirection
fILE_CURRENT =
  unsafePerformIO(
    prim_fILE_CURRENT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_CURRENT" unsafe prim_fILE_CURRENT :: IO (Word32)
fILE_END :: FilePtrDirection
fILE_END =
  unsafePerformIO(
    prim_fILE_END
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_END" unsafe prim_fILE_END :: IO (Word32)

----------------------------------------------------------------

type DriveType = UINT

dRIVE_UNKNOWN :: DriveType
dRIVE_UNKNOWN =
  unsafePerformIO(
    prim_dRIVE_UNKNOWN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dRIVE_UNKNOWN" unsafe prim_dRIVE_UNKNOWN :: IO (Word32)
dRIVE_NO_ROOT_DIR :: DriveType
dRIVE_NO_ROOT_DIR =
  unsafePerformIO(
    prim_dRIVE_NO_ROOT_DIR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dRIVE_NO_ROOT_DIR" unsafe prim_dRIVE_NO_ROOT_DIR :: IO (Word32)
dRIVE_REMOVABLE :: DriveType
dRIVE_REMOVABLE =
  unsafePerformIO(
    prim_dRIVE_REMOVABLE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dRIVE_REMOVABLE" unsafe prim_dRIVE_REMOVABLE :: IO (Word32)
dRIVE_FIXED :: DriveType
dRIVE_FIXED =
  unsafePerformIO(
    prim_dRIVE_FIXED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dRIVE_FIXED" unsafe prim_dRIVE_FIXED :: IO (Word32)
dRIVE_REMOTE :: DriveType
dRIVE_REMOTE =
  unsafePerformIO(
    prim_dRIVE_REMOTE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dRIVE_REMOTE" unsafe prim_dRIVE_REMOTE :: IO (Word32)
dRIVE_CDROM :: DriveType
dRIVE_CDROM =
  unsafePerformIO(
    prim_dRIVE_CDROM
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dRIVE_CDROM" unsafe prim_dRIVE_CDROM :: IO (Word32)
dRIVE_RAMDISK :: DriveType
dRIVE_RAMDISK =
  unsafePerformIO(
    prim_dRIVE_RAMDISK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dRIVE_RAMDISK" unsafe prim_dRIVE_RAMDISK :: IO (Word32)

----------------------------------------------------------------

type DefineDosDeviceFlags = DWORD

dDD_RAW_TARGET_PATH :: DefineDosDeviceFlags
dDD_RAW_TARGET_PATH =
  unsafePerformIO(
    prim_dDD_RAW_TARGET_PATH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dDD_RAW_TARGET_PATH" unsafe prim_dDD_RAW_TARGET_PATH :: IO (Word32)
dDD_REMOVE_DEFINITION :: DefineDosDeviceFlags
dDD_REMOVE_DEFINITION =
  unsafePerformIO(
    prim_dDD_REMOVE_DEFINITION
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dDD_REMOVE_DEFINITION" unsafe prim_dDD_REMOVE_DEFINITION :: IO (Word32)
dDD_EXACT_MATCH_ON_REMOVE :: DefineDosDeviceFlags
dDD_EXACT_MATCH_ON_REMOVE =
  unsafePerformIO(
    prim_dDD_EXACT_MATCH_ON_REMOVE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dDD_EXACT_MATCH_ON_REMOVE" unsafe prim_dDD_EXACT_MATCH_ON_REMOVE :: IO (Word32)

----------------------------------------------------------------

type BinaryType = DWORD

sCS_32BIT_BINARY :: BinaryType
sCS_32BIT_BINARY =
  unsafePerformIO(
    prim_sCS_32BIT_BINARY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sCS_32BIT_BINARY" unsafe prim_sCS_32BIT_BINARY :: IO (Word32)
sCS_DOS_BINARY :: BinaryType
sCS_DOS_BINARY =
  unsafePerformIO(
    prim_sCS_DOS_BINARY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sCS_DOS_BINARY" unsafe prim_sCS_DOS_BINARY :: IO (Word32)
sCS_WOW_BINARY :: BinaryType
sCS_WOW_BINARY =
  unsafePerformIO(
    prim_sCS_WOW_BINARY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sCS_WOW_BINARY" unsafe prim_sCS_WOW_BINARY :: IO (Word32)
sCS_PIF_BINARY :: BinaryType
sCS_PIF_BINARY =
  unsafePerformIO(
    prim_sCS_PIF_BINARY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sCS_PIF_BINARY" unsafe prim_sCS_PIF_BINARY :: IO (Word32)
sCS_POSIX_BINARY :: BinaryType
sCS_POSIX_BINARY =
  unsafePerformIO(
    prim_sCS_POSIX_BINARY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sCS_POSIX_BINARY" unsafe prim_sCS_POSIX_BINARY :: IO (Word32)
sCS_OS216_BINARY :: BinaryType
sCS_OS216_BINARY =
  unsafePerformIO(
    prim_sCS_OS216_BINARY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sCS_OS216_BINARY" unsafe prim_sCS_OS216_BINARY :: IO (Word32)

----------------------------------------------------------------

type FileNotificationFlag = DWORD

fILE_NOTIFY_CHANGE_FILE_NAME :: FileNotificationFlag
fILE_NOTIFY_CHANGE_FILE_NAME =
  unsafePerformIO(
    prim_fILE_NOTIFY_CHANGE_FILE_NAME
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_NOTIFY_CHANGE_FILE_NAME" unsafe prim_fILE_NOTIFY_CHANGE_FILE_NAME :: IO (Word32)
fILE_NOTIFY_CHANGE_DIR_NAME :: FileNotificationFlag
fILE_NOTIFY_CHANGE_DIR_NAME =
  unsafePerformIO(
    prim_fILE_NOTIFY_CHANGE_DIR_NAME
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_NOTIFY_CHANGE_DIR_NAME" unsafe prim_fILE_NOTIFY_CHANGE_DIR_NAME :: IO (Word32)
fILE_NOTIFY_CHANGE_ATTRIBUTES :: FileNotificationFlag
fILE_NOTIFY_CHANGE_ATTRIBUTES =
  unsafePerformIO(
    prim_fILE_NOTIFY_CHANGE_ATTRIBUTES
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_NOTIFY_CHANGE_ATTRIBUTES" unsafe prim_fILE_NOTIFY_CHANGE_ATTRIBUTES :: IO (Word32)
fILE_NOTIFY_CHANGE_SIZE :: FileNotificationFlag
fILE_NOTIFY_CHANGE_SIZE =
  unsafePerformIO(
    prim_fILE_NOTIFY_CHANGE_SIZE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_NOTIFY_CHANGE_SIZE" unsafe prim_fILE_NOTIFY_CHANGE_SIZE :: IO (Word32)
fILE_NOTIFY_CHANGE_LAST_WRITE :: FileNotificationFlag
fILE_NOTIFY_CHANGE_LAST_WRITE =
  unsafePerformIO(
    prim_fILE_NOTIFY_CHANGE_LAST_WRITE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_NOTIFY_CHANGE_LAST_WRITE" unsafe prim_fILE_NOTIFY_CHANGE_LAST_WRITE :: IO (Word32)
fILE_NOTIFY_CHANGE_SECURITY :: FileNotificationFlag
fILE_NOTIFY_CHANGE_SECURITY =
  unsafePerformIO(
    prim_fILE_NOTIFY_CHANGE_SECURITY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_NOTIFY_CHANGE_SECURITY" unsafe prim_fILE_NOTIFY_CHANGE_SECURITY :: IO (Word32)

----------------------------------------------------------------

type FileType = DWORD

fILE_TYPE_UNKNOWN :: FileType
fILE_TYPE_UNKNOWN =
  unsafePerformIO(
    prim_fILE_TYPE_UNKNOWN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_TYPE_UNKNOWN" unsafe prim_fILE_TYPE_UNKNOWN :: IO (Word32)
fILE_TYPE_DISK :: FileType
fILE_TYPE_DISK =
  unsafePerformIO(
    prim_fILE_TYPE_DISK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_TYPE_DISK" unsafe prim_fILE_TYPE_DISK :: IO (Word32)
fILE_TYPE_CHAR :: FileType
fILE_TYPE_CHAR =
  unsafePerformIO(
    prim_fILE_TYPE_CHAR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_TYPE_CHAR" unsafe prim_fILE_TYPE_CHAR :: IO (Word32)
fILE_TYPE_PIPE :: FileType
fILE_TYPE_PIPE =
  unsafePerformIO(
    prim_fILE_TYPE_PIPE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_TYPE_PIPE" unsafe prim_fILE_TYPE_PIPE :: IO (Word32)
fILE_TYPE_REMOTE :: FileType
fILE_TYPE_REMOTE =
  unsafePerformIO(
    prim_fILE_TYPE_REMOTE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_fILE_TYPE_REMOTE" unsafe prim_fILE_TYPE_REMOTE :: IO (Word32)

----------------------------------------------------------------

type LPSECURITY_ATTRIBUTES = Addr
type MbLPSECURITY_ATTRIBUTES = Maybe LPSECURITY_ATTRIBUTES

----------------------------------------------------------------
-- File operations
----------------------------------------------------------------

deleteFile :: String -> IO ()
deleteFile gc_arg1 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  prim_deleteFile arg1
  >>= \ gc_result ->
  access_prim_deleteFile_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_deleteFile_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_deleteFile" unsafe prim_deleteFile :: Addr -> IO (Addr)
foreign import ccall "access_prim_deleteFile_gc_failed" unsafe access_prim_deleteFile_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_deleteFile_gc_failstring" unsafe access_prim_deleteFile_gc_failstring :: Addr -> IO (Addr)

copyFile :: String -> String -> Bool -> IO ()
copyFile gc_arg1 gc_arg2 gc_arg3 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg2) ->
  (marshall_bool_ gc_arg3) >>= \ (arg3) ->
  prim_copyFile arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_copyFile_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_copyFile_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_copyFile" unsafe prim_copyFile :: Addr -> Addr -> Int -> IO (Addr)
foreign import ccall "access_prim_copyFile_gc_failed" unsafe access_prim_copyFile_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_copyFile_gc_failstring" unsafe access_prim_copyFile_gc_failstring :: Addr -> IO (Addr)

moveFile :: String -> String -> IO ()
moveFile gc_arg1 gc_arg2 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg2) ->
  prim_moveFile arg1 arg2
  >>= \ gc_result ->
  access_prim_moveFile_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_moveFile_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_moveFile" unsafe prim_moveFile :: Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_moveFile_gc_failed" unsafe access_prim_moveFile_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_moveFile_gc_failstring" unsafe access_prim_moveFile_gc_failstring :: Addr -> IO (Addr)

moveFileEx :: String -> String -> MoveFileFlag -> IO ()
moveFileEx gc_arg1 gc_arg2 arg3 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg2) ->
  prim_moveFileEx arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_moveFileEx_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_moveFileEx_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_moveFileEx" unsafe prim_moveFileEx :: Addr -> Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_moveFileEx_gc_failed" unsafe access_prim_moveFileEx_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_moveFileEx_gc_failstring" unsafe access_prim_moveFileEx_gc_failstring :: Addr -> IO (Addr)

setCurrentDirectory :: String -> IO ()
setCurrentDirectory gc_arg1 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  prim_setCurrentDirectory arg1
  >>= \ gc_result ->
  access_prim_setCurrentDirectory_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_setCurrentDirectory_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_setCurrentDirectory" unsafe prim_setCurrentDirectory :: Addr -> IO (Addr)
foreign import ccall "access_prim_setCurrentDirectory_gc_failed" unsafe access_prim_setCurrentDirectory_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_setCurrentDirectory_gc_failstring" unsafe access_prim_setCurrentDirectory_gc_failstring :: Addr -> IO (Addr)

createDirectory :: String -> MbLPSECURITY_ATTRIBUTES -> IO ()
createDirectory gc_arg1 arg2 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  (case arg2 of {
      Nothing -> (return (nullAddr));
      (Just arg2) -> (return ((arg2)))
   }) >>= \ (arg2) ->
  prim_createDirectory arg1 arg2
  >>= \ gc_result ->
  access_prim_createDirectory_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createDirectory_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_createDirectory" unsafe prim_createDirectory :: Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_createDirectory_gc_failed" unsafe access_prim_createDirectory_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createDirectory_gc_failstring" unsafe access_prim_createDirectory_gc_failstring :: Addr -> IO (Addr)

createDirectoryEx :: String -> String -> MbLPSECURITY_ATTRIBUTES -> IO ()
createDirectoryEx gc_arg1 gc_arg2 arg3 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg2) ->
  (case arg3 of {
      Nothing -> (return (nullAddr));
      (Just arg3) -> (return ((arg3)))
   }) >>= \ (arg3) ->
  prim_createDirectoryEx arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_createDirectoryEx_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createDirectoryEx_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_createDirectoryEx" unsafe prim_createDirectoryEx :: Addr -> Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_createDirectoryEx_gc_failed" unsafe access_prim_createDirectoryEx_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createDirectoryEx_gc_failstring" unsafe access_prim_createDirectoryEx_gc_failstring :: Addr -> IO (Addr)

removeDirectory :: String -> IO ()
removeDirectory gc_arg1 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  prim_removeDirectory arg1
  >>= \ gc_result ->
  access_prim_removeDirectory_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_removeDirectory_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_removeDirectory" unsafe prim_removeDirectory :: Addr -> IO (Addr)
foreign import ccall "access_prim_removeDirectory_gc_failed" unsafe access_prim_removeDirectory_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_removeDirectory_gc_failstring" unsafe access_prim_removeDirectory_gc_failstring :: Addr -> IO (Addr)

getBinaryType :: String -> IO BinaryType
getBinaryType gc_arg1 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  prim_getBinaryType arg1
  >>= \ gc_result ->
  access_prim_getBinaryType_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getBinaryType_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getBinaryType_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_getBinaryType" unsafe prim_getBinaryType :: Addr -> IO (Addr)
foreign import ccall "access_prim_getBinaryType_res1" unsafe access_prim_getBinaryType_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getBinaryType_gc_failed" unsafe access_prim_getBinaryType_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getBinaryType_gc_failstring" unsafe access_prim_getBinaryType_gc_failstring :: Addr -> IO (Addr)

----------------------------------------------------------------
-- HANDLE operations
----------------------------------------------------------------

createFile :: String -> AccessMode -> ShareMode -> MbLPSECURITY_ATTRIBUTES -> CreateMode -> FileAttributeOrFlag -> MbHANDLE -> IO HANDLE
createFile gc_arg1 arg2 arg3 arg4 arg5 arg6 arg7 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  (case arg4 of {
      Nothing -> (return (nullAddr));
      (Just arg4) -> (return ((arg4)))
   }) >>= \ (arg4) ->
  (case arg7 of {
      Nothing -> (return (nullHANDLE));
      (Just arg7) -> (return ((arg7)))
   }) >>= \ (arg7) ->
  prim_createFile arg1 arg2 arg3 arg4 arg5 arg6 arg7
  >>= \ gc_result ->
  access_prim_createFile_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_createFile_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createFile_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_createFile" unsafe prim_createFile :: Addr -> Word32 -> Word32 -> Addr -> Word32 -> Word32 -> Addr -> IO (Addr)
foreign import ccall "access_prim_createFile_res1" unsafe access_prim_createFile_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createFile_gc_failed" unsafe access_prim_createFile_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createFile_gc_failstring" unsafe access_prim_createFile_gc_failstring :: Addr -> IO (Addr)

closeHandle :: HANDLE -> IO ()
closeHandle arg1 =
  prim_closeHandle arg1
  >>= \ gc_result ->
  access_prim_closeHandle_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_closeHandle_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_closeHandle" unsafe prim_closeHandle :: Addr -> IO (Addr)
foreign import ccall "access_prim_closeHandle_gc_failed" unsafe access_prim_closeHandle_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_closeHandle_gc_failstring" unsafe access_prim_closeHandle_gc_failstring :: Addr -> IO (Addr)

getFileType :: HANDLE -> IO FileType
getFileType arg1 =
  prim_getFileType arg1
  >>= \  res1  ->
  (return (res1))
foreign import  ccall "prim_getFileType" unsafe prim_getFileType :: Addr -> IO (Word32)
--Apparently no error code

flushFileBuffers :: HANDLE -> IO ()
flushFileBuffers arg1 =
  prim_flushFileBuffers arg1
  >>= \ gc_result ->
  access_prim_flushFileBuffers_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_flushFileBuffers_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_flushFileBuffers" unsafe prim_flushFileBuffers :: Addr -> IO (Addr)
foreign import ccall "access_prim_flushFileBuffers_gc_failed" unsafe access_prim_flushFileBuffers_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_flushFileBuffers_gc_failstring" unsafe access_prim_flushFileBuffers_gc_failstring :: Addr -> IO (Addr)

setEndOfFile :: HANDLE -> IO ()
setEndOfFile arg1 =
  prim_setEndOfFile arg1
  >>= \ gc_result ->
  access_prim_setEndOfFile_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_setEndOfFile_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_setEndOfFile" unsafe prim_setEndOfFile :: Addr -> IO (Addr)
foreign import ccall "access_prim_setEndOfFile_gc_failed" unsafe access_prim_setEndOfFile_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_setEndOfFile_gc_failstring" unsafe access_prim_setEndOfFile_gc_failstring :: Addr -> IO (Addr)

setFileAttributes :: String -> FileAttributeOrFlag -> IO ()
setFileAttributes gc_arg1 arg2 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  prim_setFileAttributes arg1 arg2
  >>= \ gc_result ->
  access_prim_setFileAttributes_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_setFileAttributes_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_setFileAttributes" unsafe prim_setFileAttributes :: Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_setFileAttributes_gc_failed" unsafe access_prim_setFileAttributes_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_setFileAttributes_gc_failstring" unsafe access_prim_setFileAttributes_gc_failstring :: Addr -> IO (Addr)

getFileAttributes :: String -> IO FileAttributeOrFlag
getFileAttributes gc_arg1 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  prim_getFileAttributes arg1
  >>= \ gc_result ->
  access_prim_getFileAttributes_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getFileAttributes_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getFileAttributes_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_getFileAttributes" unsafe prim_getFileAttributes :: Addr -> IO (Addr)
foreign import ccall "access_prim_getFileAttributes_res1" unsafe access_prim_getFileAttributes_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getFileAttributes_gc_failed" unsafe access_prim_getFileAttributes_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getFileAttributes_gc_failstring" unsafe access_prim_getFileAttributes_gc_failstring :: Addr -> IO (Addr)

----------------------------------------------------------------
-- Read/write files
----------------------------------------------------------------

-- No support for this yet
--type OVERLAPPED =
-- (DWORD,  -- Offset
--  DWORD,  -- OffsetHigh
--  HANDLE) -- hEvent

type LPOVERLAPPED = Addr

type MbLPOVERLAPPED = Maybe LPOVERLAPPED

--Sigh - I give up & prefix win32_ to the next two to avoid
-- senseless Prelude name clashes. --sof.

win32_ReadFile :: HANDLE -> Addr -> DWORD -> MbLPOVERLAPPED -> IO DWORD
win32_ReadFile arg1 arg2 arg3 arg4 =
  (case arg4 of {
      Nothing -> (return (nullAddr));
      (Just arg4) -> (return ((arg4)))
   }) >>= \ (arg4) ->
  prim_win32_ReadFile arg1 arg2 arg3 arg4
  >>= \ gc_result ->
  access_prim_win32_ReadFile_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_win32_ReadFile_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_win32_ReadFile_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_win32_ReadFile" unsafe prim_win32_ReadFile :: Addr -> Addr -> Word32 -> Addr -> IO (Addr)
foreign import ccall "access_prim_win32_ReadFile_res1" unsafe access_prim_win32_ReadFile_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_win32_ReadFile_gc_failed" unsafe access_prim_win32_ReadFile_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_win32_ReadFile_gc_failstring" unsafe access_prim_win32_ReadFile_gc_failstring :: Addr -> IO (Addr)

win32_WriteFile :: HANDLE -> Addr -> DWORD -> MbLPOVERLAPPED -> IO DWORD
win32_WriteFile arg1 arg2 arg3 arg4 =
  (case arg4 of {
      Nothing -> (return (nullAddr));
      (Just arg4) -> (return ((arg4)))
   }) >>= \ (arg4) ->
  prim_win32_WriteFile arg1 arg2 arg3 arg4
  >>= \ gc_result ->
  access_prim_win32_WriteFile_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_win32_WriteFile_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_win32_WriteFile_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_win32_WriteFile" unsafe prim_win32_WriteFile :: Addr -> Addr -> Word32 -> Addr -> IO (Addr)
foreign import ccall "access_prim_win32_WriteFile_res1" unsafe access_prim_win32_WriteFile_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_win32_WriteFile_gc_failed" unsafe access_prim_win32_WriteFile_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_win32_WriteFile_gc_failstring" unsafe access_prim_win32_WriteFile_gc_failstring :: Addr -> IO (Addr)

-- missing Seek functioinality; GSL ???
-- Dont have Word64; ADR
-- %fun SetFilePointer :: HANDLE -> Word64 -> FilePtrDirection -> IO Word64

----------------------------------------------------------------
-- File Notifications
--
-- Use these to initialise, "increment" and close a HANDLE you can wait
-- on.
----------------------------------------------------------------

findFirstChangeNotification :: String -> Bool -> FileNotificationFlag -> IO HANDLE
findFirstChangeNotification gc_arg1 gc_arg2 arg3 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  (marshall_bool_ gc_arg2) >>= \ (arg2) ->
  prim_findFirstChangeNotification arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_findFirstChangeNotification_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_findFirstChangeNotification_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_findFirstChangeNotification_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_findFirstChangeNotification" unsafe prim_findFirstChangeNotification :: Addr -> Int -> Word32 -> IO (Addr)
foreign import ccall "access_prim_findFirstChangeNotification_res1" unsafe access_prim_findFirstChangeNotification_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_findFirstChangeNotification_gc_failed" unsafe access_prim_findFirstChangeNotification_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_findFirstChangeNotification_gc_failstring" unsafe access_prim_findFirstChangeNotification_gc_failstring :: Addr -> IO (Addr)

findNextChangeNotification :: HANDLE -> IO ()
findNextChangeNotification arg1 =
  prim_findNextChangeNotification arg1
  >>= \ gc_result ->
  access_prim_findNextChangeNotification_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_findNextChangeNotification_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_findNextChangeNotification" unsafe prim_findNextChangeNotification :: Addr -> IO (Addr)
foreign import ccall "access_prim_findNextChangeNotification_gc_failed" unsafe access_prim_findNextChangeNotification_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_findNextChangeNotification_gc_failstring" unsafe access_prim_findNextChangeNotification_gc_failstring :: Addr -> IO (Addr)

findCloseChangeNotification :: HANDLE -> IO ()
findCloseChangeNotification arg1 =
  prim_findCloseChangeNotification arg1
  >>= \ gc_result ->
  access_prim_findCloseChangeNotification_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_findCloseChangeNotification_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_findCloseChangeNotification" unsafe prim_findCloseChangeNotification :: Addr -> IO (Addr)
foreign import ccall "access_prim_findCloseChangeNotification_gc_failed" unsafe access_prim_findCloseChangeNotification_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_findCloseChangeNotification_gc_failstring" unsafe access_prim_findCloseChangeNotification_gc_failstring :: Addr -> IO (Addr)

----------------------------------------------------------------
-- DOS Device flags
----------------------------------------------------------------

defineDosDevice :: DefineDosDeviceFlags -> String -> String -> IO ()
defineDosDevice arg1 gc_arg1 gc_arg2 =
  (marshall_string_ gc_arg1) >>= \ (arg2) ->
  (marshall_string_ gc_arg2) >>= \ (arg3) ->
  prim_defineDosDevice arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_defineDosDevice_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_defineDosDevice_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_defineDosDevice" unsafe prim_defineDosDevice :: Word32 -> Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_defineDosDevice_gc_failed" unsafe access_prim_defineDosDevice_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_defineDosDevice_gc_failstring" unsafe access_prim_defineDosDevice_gc_failstring :: Addr -> IO (Addr)

----------------------------------------------------------------

-- These functions are very unusual in the Win32 API:
-- They dont return error codes

areFileApisANSI :: IO Bool
areFileApisANSI =
  prim_areFileApisANSI
  >>= \  res1  ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))
foreign import  ccall "prim_areFileApisANSI" unsafe prim_areFileApisANSI :: IO (Int)
setFileApisToOEM :: IO ()
setFileApisToOEM =
  prim_setFileApisToOEM
foreign import  ccall "prim_setFileApisToOEM" unsafe prim_setFileApisToOEM :: IO ()
setFileApisToANSI :: IO ()
setFileApisToANSI =
  prim_setFileApisToANSI
foreign import  ccall "prim_setFileApisToANSI" unsafe prim_setFileApisToANSI :: IO ()
setHandleCount :: UINT -> IO UINT
setHandleCount arg1 =
  prim_setHandleCount arg1
  >>= \  res1  ->
  (return (res1))
foreign import  ccall "prim_setHandleCount" unsafe prim_setHandleCount :: Word32 -> IO (Word32)

----------------------------------------------------------------

getLogicalDrives :: IO DWORD
getLogicalDrives =
  prim_getLogicalDrives
  >>= \ gc_result ->
  access_prim_getLogicalDrives_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getLogicalDrives_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getLogicalDrives_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_getLogicalDrives" unsafe prim_getLogicalDrives :: IO (Addr)
foreign import ccall "access_prim_getLogicalDrives_res1" unsafe access_prim_getLogicalDrives_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getLogicalDrives_gc_failed" unsafe access_prim_getLogicalDrives_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getLogicalDrives_gc_failstring" unsafe access_prim_getLogicalDrives_gc_failstring :: Addr -> IO (Addr)

-- %fun GetDriveType :: MbString -> IO DriveType

getDiskFreeSpace :: MbString -> IO (DWORD,DWORD,DWORD,DWORD)
getDiskFreeSpace gc_arg1 =
  (case gc_arg1 of {
      Nothing -> (return (nullAddr));
      (Just gc_arg1) -> (marshall_string_ gc_arg1) >>= \ (s) ->
			(return ((s)))
   }) >>= \ (s) ->
  prim_getDiskFreeSpace s
  >>= \ gc_result ->
  access_prim_getDiskFreeSpace_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getDiskFreeSpace_res2 (gc_result :: Addr) >>= \ res2 ->
  access_prim_getDiskFreeSpace_res3 (gc_result :: Addr) >>= \ res3 ->
  access_prim_getDiskFreeSpace_res4 (gc_result :: Addr) >>= \ res4 ->
  access_prim_getDiskFreeSpace_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getDiskFreeSpace_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return ((res1,res2,res3,res4)))
foreign import  ccall "prim_getDiskFreeSpace" unsafe prim_getDiskFreeSpace :: Addr -> IO (Addr)
foreign import ccall "access_prim_getDiskFreeSpace_res1" unsafe access_prim_getDiskFreeSpace_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getDiskFreeSpace_res2" unsafe access_prim_getDiskFreeSpace_res2 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getDiskFreeSpace_res3" unsafe access_prim_getDiskFreeSpace_res3 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getDiskFreeSpace_res4" unsafe access_prim_getDiskFreeSpace_res4 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getDiskFreeSpace_gc_failed" unsafe access_prim_getDiskFreeSpace_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getDiskFreeSpace_gc_failstring" unsafe access_prim_getDiskFreeSpace_gc_failstring :: Addr -> IO (Addr)

setVolumeLabel :: String -> String -> IO ()
setVolumeLabel gc_arg1 gc_arg2 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg2) ->
  prim_setVolumeLabel arg1 arg2
  >>= \ gc_result ->
  access_prim_setVolumeLabel_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_setVolumeLabel_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_setVolumeLabel" unsafe prim_setVolumeLabel :: Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_setVolumeLabel_gc_failed" unsafe access_prim_setVolumeLabel_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_setVolumeLabel_gc_failstring" unsafe access_prim_setVolumeLabel_gc_failstring :: Addr -> IO (Addr)

----------------------------------------------------------------
-- End
----------------------------------------------------------------
