\section[IORef]{Mutable Variables}

\begin{code}
module IORef
	( IORef		      -- abstract, instance of: Eq
        , newIORef	      -- :: a -> IO (IORef a)
        , readIORef	      -- :: IORef a -> IO a
        , writeIORef	      -- :: IORef a -> a -> IO ()
	, modifyIORef	      -- :: IORef a -> (a -> a) -> IO ()
	, updateIORef	      -- deprecated, use modifyIORef

#if !defined(__PARALLEL_HASKELL__) && defined(__GLASGOW_HASKELL__)
	, mkWeakIORef           -- :: IORef a -> IO () -> IO (Weak (IORef a))
#endif
	) where

#ifdef __GLASGOW_HASKELL__
import PrelGHC		( mkWeak# )
import PrelArr		( STRef(..) )
import PrelIOBase
#if !defined(__PARALLEL_HASKELL__)
import PrelWeak
#endif
#elif defined __HUGS__
import IOExts		( IORef, newIORef, writeIORef, readIORef )
import ST		( stToIO, newSTRef, readSTRef, writeSTRef )
#endif
\end{code}

\begin{code}
#ifndef __PARALLEL_HASKELL__
mkWeakIORef :: IORef a -> IO () -> IO (Weak (IORef a))
mkWeakIORef r@(IORef (STRef r#)) f = IO $ \s ->
  case mkWeak# r# r f s of (# s1, w #) -> (# s1, Weak w #)
#endif

#if defined __HUGS__
modifyIORef :: IORef a -> (a -> a) -> IO ()
modifyIORef ref f = writeIORef ref . f =<< readIORef ref

-- deprecated, use modifyIORef
updateIORef :: IORef a -> (a -> a) -> IO ()
updateIORef = modifyIORef
#endif
\end{code}
