{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2001  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to section 4.3 (Drawing, Reading, and Copying Pixels)
of the OpenGL 1.2.1 specs.
-}

module GL_MovePixels (
   readPixels, readBuffer,
   PixelType(..), copyPixels
) where

import Foreign          (Ptr)

import GL_BasicTypes    (GLint, GLsizei, GLenum)
import GL_Constants     (gl_COLOR, gl_DEPTH, gl_STENCIL)
import GL_VertexArray   (marshalType)
import GL_PixelRect     (PixelDescriptor(..), marshalPixelFormat)
import GL_Framebuffer   (DrawBuffer, marshalDrawBuffer)

---------------------------------------------------------------------------
-- Section 4.3.2 (Reading Pixels)

readPixels :: GLint -> GLint -> GLsizei -> GLsizei -> PixelDescriptor -> IO ()
readPixels x y w h (PixelDescriptor f t p) =
   glReadPixels x y w h (marshalPixelFormat f) (marshalType t) p

foreign import "glReadPixels" unsafe glReadPixels ::
   GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ()

readBuffer :: DrawBuffer -> IO ()
readBuffer = glReadBuffer . marshalDrawBuffer

foreign import "glReadBuffer" unsafe glReadBuffer :: GLenum -> IO ()

---------------------------------------------------------------------------
-- Section 4.3. (Copying Pixels)

-- GL_Color: Collision with GL_CoordTrans.MatrixMode (resolved there)
data PixelType =
     Color
   | Depth
   | Stencil
   deriving (Eq,Ord)

marshalPixelType :: PixelType -> GLenum
marshalPixelType Color   = gl_COLOR
marshalPixelType Depth   = gl_DEPTH
marshalPixelType Stencil = gl_STENCIL

copyPixels :: GLint -> GLint -> GLsizei -> GLsizei -> PixelType -> IO ()
copyPixels x y w h = glCopyPixels x y w h . marshalPixelType

foreign import "glCopyPixels" unsafe glCopyPixels ::
   GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> IO ()
