
/* -*- mode:C++ -*- */


#ifndef _GFONT_H
#define _GFONT_H



#include <t1lib.h>
#include <freetype.h>
#include <ftxerr18.h>
#include <ftxkern.h>
#include <ftxpost.h>



typedef void (Callback) (GtkWidget*, gpointer);


enum FontType {T1FONT, TTFONT};

struct T1Data {
  int fontID;
  char **encoding;
};


struct TTData {
  TT_Face face; 
  TT_Face_Properties properties;
  TT_Kerning kerndir;
  guint kernpairs, kerntable;
  bool PSloaded;
};


/* 
   Each row of the font selection list has a FontData structure associated to it
   A window which needs access to the structure after being created 
   (like the fonttables) has to increase the refcount when
   created and decrease it when destroyed. If the FontData is not visible, 
   the structure shall be destroyed when destroying the window (calling destroyfont)
*/
struct FontData {
  FontType fontType;
  union {
    struct T1Data t1data;
    struct TTData ttdata;
  };
  int num_glyphs;
  char *fontName;
  char *fontFile;
  int refcount;    // How oft the font is used by windows that will access it
  bool visible;    // Whether the font is being displayed in the actual font list
};



class InputDialog {
public:
  InputDialog(const char* labeltext, const char* entrytext);
  GtkWidget* getWidget(void) {return hbox;}
  void setText(const char* text) {gtk_entry_set_text(GTK_ENTRY(entry), text);}
  const char *getText(void) {return gtk_entry_get_text(GTK_ENTRY(entry));}
  void setEntryWidth(int width) {gtk_widget_set_usize(entry, width, -1);};
protected:
  GtkWidget *hbox, *label, *entry;
};



// ********************* Prototypes

// T1 functions
const char* GetT1error(int err);
bool is_t1font(gchar *pathname, FontData *fd);
void t1_showchar(FontData* fd, guint character, double size);
void t1_showstring(FontData* fd, const char* string, double size);
void t1_fonttable(FontData* fd, double size);
void t1_drawsample(FontData* fd, const char* msg, double size);
bool t1_downloadfont(FILE* fp, FontData *fd);
void t1_showproperties(FontData *fd, GtkWidget *window);


// TT funtions
void fill_ttfontdata(FontData* fd);
const char* getfontname(FontData* fd, int idx);
bool is_ttfont(gchar *pathname, FontData *fd);
bool is_ttfontcollection(gchar *pathname, FontData *fd);
void tt_showchar(FontData* fd, guint character, double size);
void tt_showstring(FontData* fd, const char* string, double size);
void tt_fonttable(FontData* fd, double size);
void tt_drawsample(FontData* fd, const char* msg, double size);
bool tt_downloadfont(FILE* fp, FontData *fd);
void tt_showproperties(FontData *fd, GtkWidget *window);


// Others
gint expose_event(GtkWidget *widget, GdkEventExpose *event, gpointer data);
gint image_clicked(GtkWidget *widget, GdkEventButton *event, gpointer data);

Callback delete_pixmap, delete_image;
Callback show_message_window, makeabout, printfont, 
  show_properties, save_names;

void make_message_window(void);
void add_error(FontData* fd, const char* msg, ...);
void errormsg(const char* msg, ...);
GtkWidget* makeicon(GtkWidget* toplevel, char** pixmap);
void destroyfont(FontData *fd);
bool ask_yes_no(GtkWidget *parent, const char* msg, ...);
void save_asgif(GtkWidget *window);
GtkWidget *make_imagepopupmenu(GtkWidget *window);
void set_window_busy(GtkWidget *window, bool state);


#endif _GFONT_H
