/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  glyph.inl - Pango::GlyphString inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*  Pango::GlyphGeometry
 */

inline PangoGlyphGeometry*
GFC::Pango::GlyphGeometry::pango_glyph_geometry() const
{
	return const_cast<PangoGlyphGeometry*>(&geometry_);
}

inline GFC::Pango::GlyphUnit
GFC::Pango::GlyphGeometry::width() const
{
	return geometry_.width;
}

inline GFC::Pango::GlyphUnit
GFC::Pango::GlyphGeometry::x_offset() const
{
	return geometry_.x_offset;
}

inline GFC::Pango::GlyphUnit
GFC::Pango::GlyphGeometry::y_offset() const
{
	return geometry_.y_offset;
}

/*  Pango::GlyphVisAttr
 */

inline PangoGlyphVisAttr*
GFC::Pango::GlyphVisAttr::pango_glyph_vis_attr() const
{
	return const_cast<PangoGlyphVisAttr*>(&attr_);
}

inline bool
GFC::Pango::GlyphVisAttr::is_cluster_start() const
{
	return attr_.is_cluster_start;
}

/*  Pango::GlyphInfo
 */

inline GFC::Pango::Glyph
GFC::Pango::GlyphInfo::glpyh() const
{
	return info_.glyph;
}

/*  Pango::GlyphString
 */

inline PangoGlyphString*
GFC::Pango::GlyphString::pango_glyph_string() const
{
	return reinterpret_cast<PangoGlyphString*>(boxed_);
}

inline GFC::Pango::GlyphString::operator PangoGlyphString* () const
{
	return this ? pango_glyph_string() : 0;
}

inline int
GFC::Pango::GlyphString::size() const
{
	return pango_glyph_string()->num_glyphs;
}

inline int*
GFC::Pango::GlyphString::log_clusters() const
{
	return pango_glyph_string()->log_clusters;
}

inline void
GFC::Pango::GlyphString::set_size(int length)
{
	pango_glyph_string_set_size(pango_glyph_string(), length);
}



