/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  menuitemsignals.cc - Gtk::MenuItem virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "menuitem.hh"
#include "menuitemsignals.hh"
#include "menu.hh"
#include "private/menuitemclass.hh"

using namespace GFC;

/*  Gtk::MenuItemSignals
 */

Gtk::MenuItemSignals::MenuItemSignals(MenuItem *menu_item)
: ItemSignals(menu_item)
{
	Gtk::MenuItemClass::init(GTK_MENU_ITEM_GET_CLASS(menu_item->gtk_menu_item()));
}

Gtk::MenuItemSignals::~MenuItemSignals()
{
}

void
Gtk::MenuItemSignals::on_activate()
{
	GtkMenuItemClass *g_class = MenuItemClass::get_parent_class(instance_);
	if (g_class->activate)
		g_class->activate((GtkMenuItem*)instance_);
}

void
Gtk::MenuItemSignals::on_activate_item()
{
	GtkMenuItemClass *g_class = MenuItemClass::get_parent_class(instance_);
	if (g_class->activate_item)
		g_class->activate_item((GtkMenuItem*)instance_);
}

void
Gtk::MenuItemSignals::on_toggle_size_request(int *requisition)
{
	GtkMenuItemClass *g_class = MenuItemClass::get_parent_class(instance_);
	if (g_class->toggle_size_request)
		g_class->toggle_size_request((GtkMenuItem*)instance_, requisition);
}

void
Gtk::MenuItemSignals::on_toggle_size_allocate(int allocate)
{
	GtkMenuItemClass *g_class = MenuItemClass::get_parent_class(instance_);
	if (g_class->toggle_size_allocate)
		g_class->toggle_size_allocate((GtkMenuItem*)instance_, allocate);
}

/*  Gtk::MenuItemClass
 */

void
Gtk::MenuItemClass::init(GtkMenuItemClass *g_class)
{
 	g_class->activate = &activate_proxy;
	g_class->activate_item = &activate_item_proxy;
	g_class->toggle_size_request = &toggle_size_request_proxy;
	g_class->toggle_size_allocate = &toggle_size_allocate_proxy;
}

GtkMenuItemClass*
Gtk::MenuItemClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_MENU_ITEM_GET_CLASS(instance));
	return static_cast<GtkMenuItemClass*>(ptr);
}

GType
Gtk::MenuItemClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_MENU_ITEM);
	}
	return type;
}

void*
Gtk::MenuItemClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::MenuItemClass::activate_proxy(GtkMenuItem *menu_item)
{
	void *ptr = g_object_get_qdata((GObject*)menu_item, G::ObjectSignals::quark());
	if (ptr)
		static_cast<MenuItemSignals*>(ptr)->on_activate();
	else
	{
		GtkMenuItemClass *g_class = MenuItemClass::get_parent_class(menu_item);
		if (g_class->activate)
			g_class->activate(menu_item);
	}
}

void
Gtk::MenuItemClass::activate_item_proxy(GtkMenuItem *menu_item)
{
	void *ptr = g_object_get_qdata((GObject*)menu_item, G::ObjectSignals::quark());
	if (ptr)
		static_cast<MenuItemSignals*>(ptr)->on_activate_item();
	else
	{
		GtkMenuItemClass *g_class = MenuItemClass::get_parent_class(menu_item);
		if (g_class->activate_item)
			g_class->activate_item(menu_item);
	}
}

void
Gtk::MenuItemClass::toggle_size_request_proxy(GtkMenuItem *menu_item, gint *requisition)
{
	void *ptr = g_object_get_qdata((GObject*)menu_item, G::ObjectSignals::quark());
	if (ptr)
		static_cast<MenuItemSignals*>(ptr)->on_toggle_size_request(requisition);
	else
	{
		GtkMenuItemClass *g_class = MenuItemClass::get_parent_class(menu_item);
		if (g_class->toggle_size_request)
			g_class->toggle_size_request(menu_item, requisition);
	}
}

void
Gtk::MenuItemClass::toggle_size_allocate_proxy(GtkMenuItem *menu_item, gint allocation)
{
	void *ptr = g_object_get_qdata((GObject*)menu_item, G::ObjectSignals::quark());
	if (ptr)
		static_cast<MenuItemSignals*>(ptr)->on_toggle_size_allocate(allocation);
	else
	{
		GtkMenuItemClass *g_class = MenuItemClass::get_parent_class(menu_item);
		if (g_class->toggle_size_allocate)
			g_class->toggle_size_allocate(menu_item, allocation);
	}
}

