/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  entrycompletionsignals.cc - Gtk::EntryCompletion virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "entrycompletion.hh"
#include "entrycompletionsignals.hh"
#include "private/entrycompletionclass.hh"
#include "treemodel.hh"

using namespace GFC;

/*  Gtk::EntryCompletionSignals
 */

Gtk::EntryCompletionSignals::EntryCompletionSignals(EntryCompletion *completion)
: G::ObjectSignals(completion)
{
	Gtk::EntryCompletionClass::init(GTK_ENTRY_COMPLETION_GET_CLASS(completion->gtk_entry_completion()));
}

Gtk::EntryCompletionSignals::~EntryCompletionSignals()
{
}

bool
Gtk::EntryCompletionSignals::on_match_selected(const TreeModel& model, const TreeIter& iter)
{
	bool result = false;	
	GtkEntryCompletionClass *g_class = EntryCompletionClass::get_parent_class(instance_);
	if (g_class->match_selected)
		result = g_class->match_selected((GtkEntryCompletion*)instance_, model.gtk_tree_model(), iter.gtk_tree_iter());
	return result;
}

void
Gtk::EntryCompletionSignals::on_action_activated(int index)
{
	GtkEntryCompletionClass *g_class = EntryCompletionClass::get_parent_class(instance_);
	if (g_class->action_activated)
		g_class->action_activated((GtkEntryCompletion*)instance_, index);
}

/*  Gtk::EntryCompletionClass
 */

void
Gtk::EntryCompletionClass::init(GtkEntryCompletionClass *g_class)
{
	g_class->match_selected = &match_selected_proxy;
	g_class->action_activated = &action_activated_proxy;
}

GtkEntryCompletionClass*
Gtk::EntryCompletionClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_ENTRY_COMPLETION_GET_CLASS(instance));
	return static_cast<GtkEntryCompletionClass*>(ptr);
}

GType
Gtk::EntryCompletionClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ENTRY_COMPLETION);
	}
	return type;
}

void*
Gtk::EntryCompletionClass::create()
{
	return g_object_new(get_type(), 0);
}

gboolean
Gtk::EntryCompletionClass::match_selected_proxy(GtkEntryCompletion *completion, GtkTreeModel *model, GtkTreeIter *iter)
{
	gboolean result = FALSE;		
	void *ptr = g_object_get_qdata((GObject*)completion, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = G::Object::pointer((GObject*)model);
		Gtk::TreeModel *tmp_model = dynamic_cast<Gtk::TreeModel*>(object);
		Gtk::TreeIter tmp_iter(iter);
		result = static_cast<EntryCompletionSignals*>(ptr)->on_match_selected(*tmp_model, tmp_iter);
	}
	else
	{
		GtkEntryCompletionClass *g_class = EntryCompletionClass::get_parent_class(completion);
		if (g_class->match_selected)
			result = g_class->match_selected(completion, model, iter);
	}
	return result;
}

void
Gtk::EntryCompletionClass::action_activated_proxy(GtkEntryCompletion *completion, int index)
{
	void *ptr = g_object_get_qdata((GObject*)completion, G::ObjectSignals::quark());
	if (ptr)
		static_cast<EntryCompletionSignals*>(ptr)->on_action_activated(index);
	else
	{
		GtkEntryCompletionClass *g_class = EntryCompletionClass::get_parent_class(completion);
		if (g_class->action_activated)
			g_class->action_activated(completion, index);
	}
}

