/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  curve.cc - GtkCurve C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "curve.hh"
#include "private/curveclass.hh"
#include "private/marshal.hh"

using namespace GFC;

/*  Gtk::Curve
 */

Gtk::Curve::Curve(GtkCurve *curve, bool owns_reference)
: DrawingArea((GtkDrawingArea*)curve, owns_reference)
{
}
	
Gtk::Curve::Curve()
: DrawingArea((GtkDrawingArea*)CurveClass::create())
{
}

Gtk::Curve::~Curve() 
{
}
	
/*  Gtk::Curve signals
 */

const Gtk::Curve::CurveTypeChangedSignalType Gtk::Curve::curve_type_changed_signal("curve_type_changed", (GCallback)&G::Marshal::void_callback);

