/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  containersignals.cc - Gtk::Container virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "container.hh"
#include "containersignals.hh"
#include "private/containerclass.hh"

using namespace GFC;

/*  Gtk::ContainerSignals
 */

Gtk::ContainerSignals::ContainerSignals(Container *container)
: WidgetSignals(container)
{
	Gtk::ContainerClass::init(GTK_CONTAINER_GET_CLASS(container->gtk_container()));
}

Gtk::ContainerSignals::~ContainerSignals()
{
}

void
Gtk::ContainerSignals::on_add(Widget& widget)
{
	GtkContainerClass *g_class = ContainerClass::get_parent_class(instance_);
	if (g_class->add)
		g_class->add((GtkContainer*)instance_, widget.gtk_widget());
}

void
Gtk::ContainerSignals::on_remove(Widget& widget)
{
	GtkContainerClass *g_class = ContainerClass::get_parent_class(instance_);
	if (g_class->remove)
		g_class->remove((GtkContainer*)instance_, widget.gtk_widget());
}

void
Gtk::ContainerSignals::on_check_resize()
{
	GtkContainerClass *g_class = ContainerClass::get_parent_class(instance_);
	if (g_class->check_resize)
		g_class->check_resize((GtkContainer*)instance_);
}

void
Gtk::ContainerSignals::on_set_focus_child(Widget *widget)
{
	GtkContainerClass *g_class = ContainerClass::get_parent_class(instance_);
	if (g_class->set_focus_child)
		g_class->set_focus_child((GtkContainer*)instance_, *widget);
}

/*  Gtk::ContainerClass
 */

void
Gtk::ContainerClass::init(GtkContainerClass *g_class)
{
	g_class->add = &add_proxy;
	g_class->remove = &remove_proxy;
	g_class->check_resize = &check_resize_proxy;
	g_class->set_focus_child = &set_focus_child_proxy;
}

GtkContainerClass*
Gtk::ContainerClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_CONTAINER_GET_CLASS(instance));
	return static_cast<GtkContainerClass*>(ptr);
}

GType
Gtk::ContainerClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CONTAINER);
	}
	return type;
}

void*
Gtk::ContainerClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ContainerClass::add_proxy(GtkContainer *container, GtkWidget *widget)
{
	void *ptr = g_object_get_qdata((GObject*)container, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ContainerSignals*>(ptr)->on_add(*G::Object::wrap<Widget>(widget));
	else
	{
		GtkContainerClass *g_class = ContainerClass::get_parent_class(container);
		if (g_class->add)
			g_class->add(container, widget);
	}
}

void
Gtk::ContainerClass::remove_proxy(GtkContainer *container, GtkWidget *widget)
{
	void *ptr = g_object_get_qdata((GObject*)container, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ContainerSignals*>(ptr)->on_remove(*G::Object::wrap<Widget>(widget));
	else
	{
		GtkContainerClass *g_class = ContainerClass::get_parent_class(container);
		if (g_class->remove)
			g_class->remove(container, widget);
	}
}

void
Gtk::ContainerClass::check_resize_proxy(GtkContainer *container)
{
	void *ptr = g_object_get_qdata((GObject*)container, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ContainerSignals*>(ptr)->on_check_resize();
	else
	{
		GtkContainerClass *g_class = ContainerClass::get_parent_class(container);
		if (g_class->check_resize)
			g_class->check_resize(container);
	}
}

void
Gtk::ContainerClass::set_focus_child_proxy(GtkContainer *container, GtkWidget *widget)
{
	void *ptr = g_object_get_qdata((GObject*)container, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ContainerSignals*>(ptr)->on_set_focus_child(G::Object::wrap<Widget>(widget));
	else
	{
		GtkContainerClass *g_class = ContainerClass::get_parent_class(container);
		if (g_class->set_focus_child)
			g_class->set_focus_child(container, widget);
	}
}

