/*  GFC-Core: GTK+ Foundation Classes (Core Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  main.inl - G::MainContext, G::MainLoop and G::Source inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*  G::MainContext
 */

inline GMainContext*
GFC::G::MainContext::g_main_context() const
{
	return context_;
}

inline GFC::G::MainContext::operator GMainContext* () const
{
	return this ? context_ : 0;
}

inline bool
GFC::G::MainContext::pending() const
{
	return g_main_context_pending(context_);
}

inline bool
GFC::G::MainContext::iteration(bool may_block)
{
	return g_main_context_iteration(context_, may_block);
}

/*  G::MainLoop
 */

inline GMainLoop*
GFC::G::MainLoop::g_main_loop() const
{
	return loop_;
}

inline GFC::G::MainLoop::operator GMainLoop* () const
{
	return this ? loop_ : 0;
}

inline bool
GFC::G::MainLoop::is_running() const
{
	return g_main_loop_is_running(loop_);
}

inline int 
GFC::G::MainLoop::depth()
{
	return g_main_depth();
	
}

inline void
GFC::G::MainLoop::run()
{
	g_main_loop_run(loop_);
}

inline void
GFC::G::MainLoop::quit()
{
	g_main_loop_quit(loop_);
}

/*  G::Source
 */

inline GSource*
GFC::G::Source::g_source() const
{
	return source_;
}

inline GFC::G::Source::operator GSource* () const
{
	return this ? source_ : 0;
}

inline int
GFC::G::Source::get_priority() const
{
	return g_source_get_priority(source_);
}

inline bool
GFC::G::Source::get_can_recurse() const
{
	return g_source_get_can_recurse(source_);
}

inline unsigned int
GFC::G::Source::get_id() const
{
	return g_source_get_id(source_);
}

inline void
GFC::G::Source::destroy()
{
	g_source_destroy (source_);
}

inline void
GFC::G::Source::set_priority(int priority)
{
	g_source_set_priority(source_, priority);
}

inline void
GFC::G::Source::set_can_recurse(bool can_recurse)
{
	g_source_set_can_recurse(source_, can_recurse);
}

