/*  GFC-Core: GTK+ Foundation Classes (Core Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/// @file gfc/glib/g.hh
/// @brief Main G header file
///
/// This header file includes all the G header files. You can safely include
/// this header file only, with minimal extra overhead, because each header file
/// uses include guards to prevent multiple inclusions.

#ifndef GFC_G_HH
#define GFC_G_HH

#include <gfc/glib/asyncqueue.hh>
#include <gfc/glib/completion.hh>
#include <gfc/glib/date.hh>
#include <gfc/glib/error.hh>
#include <gfc/glib/fileutils.hh>
#include <gfc/glib/main.hh>
#include <gfc/glib/markup.hh>
#include <gfc/glib/module.hh>
#include <gfc/glib/pattern.hh>
#include <gfc/glib/object.hh>
#include <gfc/glib/rand.hh>
#include <gfc/glib/scanner.hh>
#include <gfc/glib/shell.hh>
#include <gfc/glib/spawn.hh>
#include <gfc/glib/timer.hh>
#include <gfc/glib/thread.hh>
#include <gfc/glib/threadpool.hh>

#endif // GFC_G_HH

