#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "gfcc.h"

extern GtkWidget *window;
extern GtkWidget *notebook;

struct _menu *service_tcp = NULL;
struct _menu *service_udp = NULL;
struct _menu *proto_name = NULL;

struct _fwchain fwchain[MAXCHAINS];
GtkWidget *cliplist = NULL;
gint maxchains=0;
gint modified=0;

static gint openpurpose;
static gchar *content[NUMCOLS];
static gchar fbuf[256];
static GtkWidget *popup_menu = NULL;
static GtkWidget *filew = NULL;

static gint rulelist_event_handler(GtkWidget *, GdkEvent *, gpointer);
static GtkWidget *create_rule_popup_menu(void);
static void set_fwpolicy_data(GtkWidget *, gpointer);
static void get_fwnames(gchar *);
static void draw_default_chain();
static void draw_policy(gint);
static void get_fwrules(gchar *);
static void put_to_rulelist(struct _fwrule);
static void put_unvisible_data(struct _fwrule);
static void clearChain();
static void file_select(void);
static void file_ok_sel(GtkWidget *, gpointer);
static void file_destroy(GtkWidget *, gpointer);
static void write_to_file(FILE *, struct ip_fwuser, ip_chainlabel);
static void force_load_file(GtkWidget *, gpointer);
static void force_load_system(GtkWidget *, gpointer);

static gchar *current_filename = NULL;
static gint set_and_quit;

void get_fw_data(gchar *filename, gint flag)
{
	gchar buf[128];

	maxchains=0;
	set_and_quit = flag;

	if(set_and_quit) {
		if(!clear_system()) {
			printf("%s\n", ipfwc_strerror(errno));
			return;
		}
	}

	if(current_filename) {
		g_free(current_filename);
		current_filename = NULL;
	}
	if(filename)
		current_filename = g_strdup(filename);

	get_fwnames(filename);
	get_fwrules(filename);
	
	if(set_and_quit) {
		return;
	}

	if(filename)
		sprintf(buf, "%s: %s", PACKAGE_VERSION,filename);
	else
		sprintf(buf, "%s: %s", PACKAGE_VERSION,"Current System rules");

	gtk_window_set_title(GTK_WINDOW (window), buf);

	if(cliplist) {
		gtk_clist_clear(GTK_CLIST(cliplist));
	} else
		cliplist = gtk_clist_new(NUMCOLS);

	modified = 0;
}

static void get_fwnames(gchar *filename)
{
	FILE *fp;
	gint ret=1, nread;
	
	if(filename) {
		if(!(fp = fopen(filename, "r"))) {
			perror(filename);
			exit(1);
		}
	} else if(!(fp = fopen("/proc/net/"IP_FW_PROC_CHAIN_NAMES, "r"))) {
		fprintf(stderr, "Your kernel doesn't support ipchains\n");
		exit(2);
	}

	if(filename) {
		fgets(fbuf, sizeof(fbuf), fp);
		if(memcmp(fbuf, "#!ip-firewall", 13)) {
			fclose(fp);
			dialog_window("Maybe It's not a data file", NULL);
			return;
		}
	}
	clearChain();
	while(fgets(fbuf, sizeof(fbuf), fp)) {
		if(fbuf[0] == '#' || fbuf[0] == '\n')
			continue;
		if(fbuf[0] == '*')
			break;
		nread = sscanf(fbuf, "%s %s %u %u %u %u %u",
			 fwchain[maxchains].label,   fwchain[maxchains].policy,
			&fwchain[maxchains].refcnt, &fwchain[maxchains].pkthi,
			&fwchain[maxchains].pktlo,  &fwchain[maxchains].bytehi,
			&fwchain[maxchains].bytelo);
		if(nread != 7)
			continue;
		
		if(!set_and_quit) {
			draw_chain(notebook, maxchains);
		} else {
			if(strcmp(fwchain[maxchains].label,
						IP_FW_LABEL_INPUT)&&
			   strcmp(fwchain[maxchains].label,
						IP_FW_LABEL_FORWARD) &&
			   strcmp(fwchain[maxchains].label,
						IP_FW_LABEL_OUTPUT)) {
				ret = ipfwc_create_chain(
						fwchain[maxchains].label);
			} else {
				ret = ipfwc_set_policy(
						fwchain[maxchains].label,
						fwchain[maxchains].policy);
			}
		}
		if(!ret) {
			fprintf(stderr, "%s\n", ipfwc_strerror(errno));
			fclose(fp);
			return;
		}
		maxchains++;
	}
	fclose(fp);
	
	if(!maxchains && !set_and_quit)
		draw_default_chain();
}

static void draw_default_chain()
{
	strcpy(fwchain[0].label, IP_FW_LABEL_INPUT);
	strcpy(fwchain[0].policy, IP_FW_LABEL_ACCEPT);
	draw_chain(notebook, 0);

	strcpy(fwchain[1].label, IP_FW_LABEL_FORWARD);
	strcpy(fwchain[1].policy, IP_FW_LABEL_ACCEPT);
	draw_chain(notebook, 1);

	strcpy(fwchain[2].label, IP_FW_LABEL_OUTPUT);
	strcpy(fwchain[2].policy, IP_FW_LABEL_ACCEPT);
	draw_chain(notebook, 2);
		
	maxchains = 3;
}

void draw_chain(GtkWidget *notebook, gint idx)
{
	GtkWidget *vbox, *button;
	GtkWidget *scrolled_window;
	gchar *titles[NUMCOLS] = {
		" Source",	" port",	" Destination",	" port",
		" Proto",	"Interface",	"Target",	" A ",
		" X ",		"portsmin",	"portsmax",	"portdmin",
		"portdmax",	"fw_flg",	"fw_invflg",	"redirect",
		"fw_mark",	"outputsize",	"deleted",
	};

	gint i;

	if(!popup_menu)
		popup_menu = create_rule_popup_menu();
	vbox = gtk_vbox_new(FALSE, 1);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
	gtk_widget_show(vbox);
		
	fwchain[idx].hbox = gtk_hbox_new(FALSE, 1);
	gtk_widget_show(fwchain[idx].hbox);
	gtk_box_pack_start(GTK_BOX(vbox),
			fwchain[idx].hbox, FALSE, FALSE, 2);

	button = gtk_button_new_with_label(" Zero counter ");
	gtk_box_pack_end(GTK_BOX(fwchain[idx].hbox), button, FALSE, FALSE, 2);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(set_zero_entries), NULL);
	gtk_widget_show(button);

	if(fwchain[idx].policy[0] != '-') {
		draw_policy(idx);
	} else {
		button = gtk_button_new_with_label(" Edit Chain ");
		gtk_box_pack_end(GTK_BOX(fwchain[idx].hbox),
					button, FALSE, FALSE, 2);
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(edit_chain_window),(RuleAction *)EDIT);
		gtk_widget_show(button);
		button = gtk_check_button_new_with_label(" Delete Chain ");
		gtk_box_pack_end(GTK_BOX(fwchain[idx].hbox),
					button, FALSE, FALSE, 2);
		gtk_signal_connect(GTK_OBJECT(button), "toggled",
			GTK_SIGNAL_FUNC(delete_chain), NULL);
		gtk_widget_show(button);
	}

	scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
			GTK_SCROLLED_WINDOW(scrolled_window),
			GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(vbox), scrolled_window);
	gtk_widget_show(scrolled_window);
	
	fwchain[idx].rulelist = gtk_clist_new_with_titles(NUMCOLS, titles);
	gtk_clist_set_selection_mode(
		GTK_CLIST(fwchain[idx].rulelist), GTK_SELECTION_EXTENDED);
	gtk_signal_connect(GTK_OBJECT(fwchain[idx].rulelist), "event",
				GTK_SIGNAL_FUNC(rulelist_event_handler), NULL);
	for(i=9; i<NUMCOLS; i++) {
		gtk_clist_set_column_visibility(
				GTK_CLIST(fwchain[idx].rulelist),i,FALSE);
	}
	gtk_clist_set_column_width(GTK_CLIST(fwchain[idx].rulelist), 0, 110);
	gtk_clist_set_column_width(GTK_CLIST(fwchain[idx].rulelist), 1, 85);
	gtk_clist_set_column_width(GTK_CLIST(fwchain[idx].rulelist), 2, 110);
	gtk_clist_set_column_width(GTK_CLIST(fwchain[idx].rulelist), 3, 85);
	gtk_clist_set_column_width(GTK_CLIST(fwchain[idx].rulelist), 4, 60);
	gtk_clist_set_column_width(GTK_CLIST(fwchain[idx].rulelist), 6, 65);

	gtk_container_add(
		GTK_CONTAINER(scrolled_window), fwchain[idx].rulelist);
	gtk_widget_show(fwchain[idx].rulelist);
	
	fwchain[idx].tablabel = gtk_label_new(fwchain[idx].label);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
				vbox, fwchain[idx].tablabel);
}

void set_zero_entries(GtkWidget *widget, gpointer data)
{
	gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
	gchar buf[64];
	
	if(page < 0)
		return;

	if(!ipfwc_zero_entries(fwchain[page].label))
		sprintf(buf, "%s.\n\nDid you have apply this data?",
				(gchar *)ipfwc_strerror(errno));
	else
		strcpy(buf, "Successfully zeroed the counters\nin this chain");
	
	dialog_window(buf, NULL);
}

static void draw_policy(gint idx)
{
	GtkWidget *button, *button2, *button3, *button4;

	button = gtk_radio_button_new_with_label(NULL, IP_FW_LABEL_ACCEPT);
	gtk_box_pack_start(GTK_BOX(fwchain[idx].hbox), button, FALSE, FALSE, 2);
	gtk_widget_show(button);

	button2 = gtk_radio_button_new_with_label(
			gtk_radio_button_group(GTK_RADIO_BUTTON(button)),
			IP_FW_LABEL_BLOCK);
	gtk_box_pack_start(GTK_BOX(fwchain[idx].hbox), button2,FALSE,FALSE, 2);
	gtk_widget_show(button2);

	button3 = gtk_radio_button_new_with_label(
			gtk_radio_button_group(GTK_RADIO_BUTTON(button2)),
			IP_FW_LABEL_REJECT);
	gtk_box_pack_start(GTK_BOX(fwchain[idx].hbox), button3,FALSE,FALSE, 2);
	gtk_widget_show(button3);

	if(!strcmp(fwchain[idx].label, IP_FW_LABEL_FORWARD)) {
		button4 = gtk_radio_button_new_with_label(
			gtk_radio_button_group(GTK_RADIO_BUTTON(button3)),
			IP_FW_LABEL_MASQUERADE);
		gtk_box_pack_start(GTK_BOX(fwchain[idx].hbox),
						button4,FALSE,FALSE, 2);
		gtk_widget_show(button4);
	}
	
	if(!strcmp(fwchain[idx].policy, IP_FW_LABEL_ACCEPT))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
	else if(!strcmp(fwchain[idx].policy, IP_FW_LABEL_BLOCK))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button2), TRUE);
	else if(!strcmp(fwchain[idx].policy, IP_FW_LABEL_REJECT))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button3), TRUE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button4), TRUE);

	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(set_fwpolicy_data), IP_FW_LABEL_ACCEPT);
	gtk_signal_connect(GTK_OBJECT(button2), "clicked",
			GTK_SIGNAL_FUNC(set_fwpolicy_data), IP_FW_LABEL_BLOCK);
	gtk_signal_connect(GTK_OBJECT(button3), "clicked",
			GTK_SIGNAL_FUNC(set_fwpolicy_data), IP_FW_LABEL_REJECT);
	if(!strcmp(fwchain[idx].label, IP_FW_LABEL_FORWARD)) {
		gtk_signal_connect(GTK_OBJECT(button4), "clicked",
				   GTK_SIGNAL_FUNC(set_fwpolicy_data),
				   IP_FW_LABEL_MASQUERADE);
	}
}

#define _IPFWC_FMT2(i) "%" #i "s "
#define _IPFWC_FMT(i) _IPFWC_FMT2(i)
#define IPFWC_CHAIN_FMT _IPFWC_FMT(IP_FW_MAX_LABEL_LENGTH)

static void get_fwrules(gchar *filename)
{
	FILE *fp = NULL;
	struct _fwrule tfw;
	struct ip_fwuser sfw;
	__u32 pkthi, pktlo, bytehi, bytelo;
	unsigned short tosand, tosxor;
	gint nread;

	if(filename)
		fp = fopen(filename, "r");
	else
		fp = fopen("/proc/net/"IP_FW_PROC_CHAINS, "r");
	if(!fp)
		return;

	if(filename) {
		while(fgets(fbuf, sizeof(fbuf), fp)) {
			if(fbuf[0] == '*')
				break;
		}
	}
	while(fgets(fbuf, sizeof(fbuf), fp)) {
		if(fbuf[0] == '#' || fbuf[0] == '\n')
			continue;
		if(fbuf[0] == '*')
			break;
		nread = sscanf(fbuf, IPFWC_CHAIN_FMT
			             "%X/%X->%X/%X "
			             "%s %hX %hX %hu "
			             "%u %u %u %u %hu-%hu %hu-%hu "
			             "A%hX X%hX %hX %u %hu %s"
			,tfw.label
			,&tfw.ipfw.fw_src.s_addr,&tfw.ipfw.fw_smsk.s_addr
			,&tfw.ipfw.fw_dst.s_addr,&tfw.ipfw.fw_dmsk.s_addr
			,tfw.ipfw.fw_vianame
			,&tfw.ipfw.fw_flg,	&tfw.ipfw.fw_invflg
			,&tfw.ipfw.fw_proto
			,&pkthi, &pktlo, &bytehi, &bytelo
			,&tfw.ipfw.fw_spts[0],	&tfw.ipfw.fw_spts[1]
			,&tfw.ipfw.fw_dpts[0],	&tfw.ipfw.fw_dpts[1]
			,&tosand,		&tosxor
			,&tfw.ipfw.fw_redirpt,	&tfw.ipfw.fw_mark
			,&tfw.ipfw.fw_outputsize,	tfw.target);
		if(nread != 23)
			continue;
		
		tfw.ipfw.fw_tosand = (unsigned char)tosand;
		tfw.ipfw.fw_tosxor = (unsigned char)tosxor;

		if(set_and_quit) {
			sfw.ipfw = tfw.ipfw;
			if(!append_entry(tfw.label, tfw.target, sfw)) {
				fclose(fp);
				return;
			}
		} else
			put_to_rulelist(tfw);

	}
	if(filename)
		get_masq_timeout(fp);
	else
		get_masq_timeout(NULL);

	fclose(fp);
}

static void put_to_rulelist(struct _fwrule tfw)
{
	GtkCList *tlist = NULL;
	gint i, idx=0, row;
	gchar protocol[64];

	get_ipaddr(fbuf, tfw.ipfw.fw_src.s_addr, tfw.ipfw.fw_smsk.s_addr);
	content[idx++] = content_new(fbuf);

	proto_itos(protocol, tfw.ipfw.fw_proto);
	get_port(fbuf, tfw.ipfw.fw_spts[0], tfw.ipfw.fw_spts[1], protocol);
	content[idx++] = content_new(fbuf);

	get_ipaddr(fbuf, tfw.ipfw.fw_dst.s_addr, tfw.ipfw.fw_dmsk.s_addr);
	content[idx++] = content_new(fbuf);
		
	get_port(fbuf, tfw.ipfw.fw_dpts[0], tfw.ipfw.fw_dpts[1], protocol);
	content[idx++] = content_new(fbuf);

	content[idx++] = content_new(protocol);
		
	if(tfw.ipfw.fw_vianame[0] == '-')
		tfw.ipfw.fw_vianame[0] = '\0';
	content[idx++] = content_new(tfw.ipfw.fw_vianame);

	if(tfw.target[0] == '-')
		strcpy(tfw.target, IP_FW_LABEL_NONE);
	content[idx++] = content_new(tfw.target);

	sprintf(fbuf,"%02X",tfw.ipfw.fw_tosand);
	content[idx++] = content_new(fbuf);

	sprintf(fbuf,"%02X",tfw.ipfw.fw_tosxor);
	content[idx++] = content_new(fbuf);

	put_unvisible_data(tfw);

	for(i=0; fwchain[i].label[0]; i++) {
		if(!strcmp(fwchain[i].label, tfw.label))
				break;
	}
	if(!fwchain[i].label[0]) {
		strcpy(fwchain[i].label, tfw.target);
		strcpy(fwchain[i].policy, "-");
		draw_chain(notebook, maxchains);
	}
	tlist = GTK_CLIST(fwchain[i].rulelist);
	row = gtk_clist_append(tlist, content);
	if(tlist == GTK_CLIST(fwchain[i].rulelist))
		inverse_mark(tlist, row, tfw.ipfw.fw_invflg);
		
	for(i=0; i<NUMCOLS; i++)
		g_free(content[i]);
}

#include "Pics/inverse.xpm"
#include "Pics/normal.xpm"
void inverse_mark(GtkCList *tlist, gint row, __u16 fw_invflg)
{
	__u16 invflag[] = {
		IP_FW_INV_SRCIP,
		IP_FW_INV_SRCPT,
		IP_FW_INV_DSTIP,
		IP_FW_INV_DSTPT,
		IP_FW_INV_PROTO,
		IP_FW_INV_VIA,
		0
	};
	gint i;
	GdkPixmap *pixmap, *invpixmap, *nrmpixmap;
	GdkBitmap *mask, *invmask, *nrmmask;
	gchar *text;
	
	invpixmap = gdk_pixmap_create_from_xpm_d(window->window, &invmask,
			&notebook->style->bg[GTK_STATE_NORMAL], inverse);
	nrmpixmap = gdk_pixmap_create_from_xpm_d(window->window, &nrmmask,
			&notebook->style->bg[GTK_STATE_NORMAL], normal);

	for(i=0; invflag[i]; i++) {
		pixmap = (fw_invflg & invflag[i]) ? invpixmap : nrmpixmap;
		mask = (fw_invflg & invflag[i]) ? invmask : nrmmask;
		gtk_clist_get_text(tlist, row, i, &text);
		gtk_clist_set_pixtext(tlist, row, i,
				g_strdup(text), 0, pixmap, mask);
	}
	
	gdk_pixmap_unref(invpixmap);
	gdk_pixmap_unref(invmask);
	gdk_pixmap_unref(nrmpixmap);
	gdk_pixmap_unref(nrmmask);
}

static void put_unvisible_data(struct _fwrule tfw)
{
	gint i=9;
	gchar protocol[64];

	proto_itos(protocol, tfw.ipfw.fw_proto);

	port_itos(fbuf, tfw.ipfw.fw_spts[0], protocol);
	content[i++] = content_new(fbuf);

	port_itos(fbuf, tfw.ipfw.fw_spts[1], protocol);
	content[i++] = content_new(fbuf);

	port_itos(fbuf, tfw.ipfw.fw_dpts[0], protocol);
	content[i++] = content_new(fbuf);

	port_itos(fbuf, tfw.ipfw.fw_dpts[1], protocol);
	content[i++] = content_new(fbuf);

	sprintf(fbuf, "%hu", tfw.ipfw.fw_flg);
	content[i++] = content_new(fbuf);

	sprintf(fbuf, "%hu", tfw.ipfw.fw_invflg);
	content[i++] = content_new(fbuf);

	sprintf(fbuf, "%hu", tfw.ipfw.fw_redirpt);
	content[i++] = content_new(fbuf);

	sprintf(fbuf, "%u", tfw.ipfw.fw_mark);
	content[i++] = content_new(fbuf);

	sprintf(fbuf, "%hu", tfw.ipfw.fw_outputsize);
	content[i++] = content_new(fbuf);

	content[i++] = content_new(g_strdup("0"));
}

static void clearChain()
{
	gint i;

	maxchains = 0;
	for(i=0; fwchain[i].label[0]; i++) {
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook), 0);
	}
	memset(fwchain, 0x00, sizeof(fwchain));
}

static void force_load_file(GtkWidget *widget, gpointer data)
{
	modified = 0;
	load_from_file(widget, data);
}

void load_from_file(GtkWidget *widget, gpointer data)
{
	if(modified) {
		dialog_window("Data has changed. continue ?",
				GTK_SIGNAL_FUNC(force_load_file));
		return;
	}

	openpurpose = FILE_OPEN;
	
	file_select();
}

static void force_load_system(GtkWidget *widget, gpointer data)
{
	modified = 0;

	load_from_system(widget, data);
}

void load_from_system(GtkWidget *widget, gpointer data)
{
	if(modified) {
		dialog_window("Data has changed. continue ?",
				GTK_SIGNAL_FUNC(force_load_system));
		return;
	}

	get_fw_data(NULL, 0);
}

void save_to_file(void)
{
	openpurpose = FILE_SAVE;

	if(current_filename) {
		save_fw_data(NULL, g_strdup(current_filename));
		modified = 0;
		return;
	}

	file_select();
}

void save_as_to_file(void)
{
	openpurpose = FILE_SAVE;

	modified = 0;
	file_select();
}

void export_to_file(void)
{
	openpurpose = FILE_EXPORT;

	file_select();
}

static void file_select(void)
{
	if(filew)
		gtk_widget_destroy(filew);

	filew = gtk_file_selection_new("File selection");
	gtk_window_set_position(GTK_WINDOW(filew), GTK_WIN_POS_CENTER);
	gtk_signal_connect(GTK_OBJECT(filew), "destroy",
			GTK_SIGNAL_FUNC(file_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(filew), "delete_event",
			GTK_SIGNAL_FUNC(file_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filew)->ok_button),
			"clicked", GTK_SIGNAL_FUNC(file_ok_sel), NULL);
	gtk_signal_connect(
			GTK_OBJECT(GTK_FILE_SELECTION(filew)->cancel_button),
			"clicked", GTK_SIGNAL_FUNC(file_destroy), NULL);

	gtk_widget_show(filew);
}

static void file_ok_sel(GtkWidget *w, gpointer data)
{
	gchar *fname;
	GtkFileSelection *filesel;
	
	filesel = GTK_FILE_SELECTION(filew);
	
	fname = gtk_file_selection_get_filename(filesel);
	if(!fname)
		return;
	fname = g_strdup(fname);

	gtk_widget_destroy(filew);
	filew = NULL;

	if(fname[strlen((const char *)fname)-1] == '/')
		return;

	switch(openpurpose) {
	case FILE_OPEN : get_fw_data(fname, 0); break;
	case FILE_SAVE : save_fw_data(NULL, fname); break;
	case FILE_EXPORT : export_fw_data(NULL, fname); break;
	default : break;
	}
}

static void file_destroy(GtkWidget *w, gpointer data)
{
	gtk_widget_destroy(filew);
	filew = NULL;
}

GtkWidget *menu_new;
GtkWidget *menu_edit;
GtkWidget *menu_insert;
GtkWidget *menu_copy;
GtkWidget *menu_cut;
GtkWidget *menu_paste;
GtkWidget *menu_delete;
GtkWidget *menu_duplicate;

static GtkWidget *create_rule_popup_menu(void)
{
	GtkWidget *popmenu;
	GtkWidget *menu = gtk_menu_new();
	
	menu_new = create_menu_item(menu, " New  ", TRUE,
		GTK_SIGNAL_FUNC(popup_rule_edit),(RuleAction *)NEW);
	menu_edit = create_menu_item(menu, " Edit  ", FALSE,
		GTK_SIGNAL_FUNC(popup_rule_edit),(RuleAction *)EDIT);
	menu_insert = create_menu_item(menu, " Insert  ", FALSE,
		GTK_SIGNAL_FUNC(popup_rule_edit),(RuleAction *)INSERT);
	menu_copy = create_menu_item(menu, " Copy  ", FALSE,
			GTK_SIGNAL_FUNC(popup_rule_copy), NULL);
	menu_cut = create_menu_item(menu, " Cut  ", FALSE,
			GTK_SIGNAL_FUNC(popup_rule_cut), NULL);
	menu_paste = create_menu_item(menu, " Paste  ", FALSE,
			GTK_SIGNAL_FUNC(popup_rule_paste), NULL);
	menu_delete = create_menu_item(menu, " Delete  ", FALSE,
			GTK_SIGNAL_FUNC(popup_rule_delete), NULL);
	menu_duplicate = create_menu_item(menu, " Duplicate  ", FALSE,
			GTK_SIGNAL_FUNC(popup_rule_duplicate), NULL);
	menu_separator(menu);
	popmenu = create_menu_item(menu, " Quit ", TRUE,
			GTK_SIGNAL_FUNC(program_quit), NULL);
	
	return menu;
}

static gint rulelist_event_handler(
		GtkWidget *w, GdkEvent *event, gpointer data)
{
	GdkEventButton *bevent;
	GList *selection;
	gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
	gint active, multi, paste;

	if(page < 0)
		return FALSE;
	selection = GTK_CLIST(fwchain[page].rulelist)->selection;
	active = selection ? TRUE : FALSE;

	switch(event->type) {
	case GDK_BUTTON_PRESS:
		switch(event->button.button) {
		case 3:
			multi = (selection && selection->next) ? TRUE : FALSE;
			paste = GTK_CLIST(cliplist)->rows ? TRUE : FALSE;

			gtk_widget_set_sensitive(menu_edit, (active&&!multi));
			gtk_widget_set_sensitive(menu_insert, (active&&!multi));
			gtk_widget_set_sensitive(menu_copy, active);
			gtk_widget_set_sensitive(menu_cut, active);
			gtk_widget_set_sensitive(menu_paste, paste);
			gtk_widget_set_sensitive(menu_delete, active);
			gtk_widget_set_sensitive(
					menu_duplicate, (active&&!multi));

			bevent = (GdkEventButton *)event;
			gtk_menu_popup(GTK_MENU(popup_menu), NULL, NULL,
				NULL, NULL, bevent->button, bevent->time);
			return TRUE;
		default: break;
		}
		break;
	case GDK_2BUTTON_PRESS:
		switch(event->button.button) {
		case 1:
			if(GTK_CLIST(fwchain[page].rulelist)->rows)
				popup_rule_edit(w, EDIT);
			return TRUE;
		default: break;
		}
		break;
	default: break;
	}
	return FALSE;
}

static void set_fwpolicy_data(GtkWidget *widget, gpointer data)
{
	gint page = gtk_notebook_current_page(GTK_NOTEBOOK(notebook));

	if(page < 0)
		return;
	if(!strcmp(fwchain[page].policy, data))
		return;
	
	modified = 1;
	strcpy(fwchain[page].policy, data);
}

void export_fw_data(GtkWidget *widget, gchar *filename)
{
	FILE *fp = NULL;
	guint i, row=0;
	guint8 tspace;
	struct ip_fwuser sfw;
	ip_chainlabel target;
	GdkPixmap *tpixmap;
	GdkBitmap *tmask;
	gchar buf[64], fname[256], *text;
	
	if(filename) {
		strcpy(fname, filename);
		if(strlen(fname) > 3) {
			if(strcmp(&fname[strlen(fname)-3], ".sh"))
				strcat(fname, ".sh");
		} else
			strcat(fname, ".sh");
		fp = fopen(fname, "w+");
		if(!fp) {
			sprintf(fbuf, "File %s open error", fname);
			dialog_window(fbuf, NULL);
			return;
		}
		fprintf(fp, "#!/bin/sh\n");
		fprintf(fp, "# Generated by Gtk+ firewall control center\n\n");
	} else
		return;

	fprintf(fp, "IPCHAINS=/sbin/ipchains\n\n");
	write_host_data(fp);

	for(i=0; i<3; i++) {
		fprintf(fp, "$IPCHAINS -P %s %s\n",
				fwchain[i].label, fwchain[i].policy);
	}
	fprintf(fp, "\n$IPCHAINS -F\n");
	fprintf(fp, "$IPCHAINS -X\n");
	for(; i<maxchains; i++)
		fprintf(fp, "$IPCHAINS -N %s\n", fwchain[i].label);
	
	for(i=0; i<maxchains; i++) {
		if(fwchain[i].deleted)
			continue;
		strcpy(sfw.label, fwchain[i].label);
		fprintf(fp, "\n# %s rules\n", sfw.label);
		for(row=0; row<GTK_CLIST(fwchain[i].rulelist)->rows; row++) {
			/*
			gtk_clist_get_text(GTK_CLIST(fwchain[i].rulelist),
					row, 18, &text);
			if(*text == '1')
				continue;
			*/

			conv_fw_data(&sfw, target,
				GTK_CLIST(fwchain[i].rulelist), row);
			fprintf(fp, "$IPCHAINS -A %s ", sfw.label);
			
			gtk_clist_get_pixtext(GTK_CLIST(fwchain[i].rulelist),
					row, 4, &text,&tspace,&tpixmap,&tmask);
			if(strcmp(text, "all")) {
				fprintf(fp, "-p ");
				if(sfw.ipfw.fw_invflg & IP_FW_INV_PROTO)
					fprintf(fp, "! ");
				fprintf(fp, "%s ", text);
			}

			fprintf(fp, "-s ");
			if(sfw.ipfw.fw_invflg & IP_FW_INV_SRCIP)
				fprintf(fp, "! ");
			if(!get_ipaddr(buf, sfw.ipfw.fw_src.s_addr,
						 sfw.ipfw.fw_smsk.s_addr)) {
				fprintf(fp, "$");
				dot_to_underbar(buf, fbuf);
			} else
				strcpy(fbuf, buf);
			fprintf(fp, "%s ", fbuf);

			gtk_clist_get_pixtext(GTK_CLIST(fwchain[i].rulelist),
					row, 1, &text,&tspace,&tpixmap,&tmask);
			if(strcmp(text, "n/a")) {
				if(sfw.ipfw.fw_invflg & IP_FW_INV_SRCPT)
					fprintf(fp, "! ");
				fprintf(fp, "%s ", text);
			}

			fprintf(fp, "-d ");
			if(sfw.ipfw.fw_invflg & IP_FW_INV_DSTIP)
				fprintf(fp, "! ");
			if(!get_ipaddr(buf, sfw.ipfw.fw_dst.s_addr,
						 sfw.ipfw.fw_dmsk.s_addr)) {
				fprintf(fp, "$");
				dot_to_underbar(buf, fbuf);
			} else
				strcpy(fbuf, buf);
			fprintf(fp, "%s ", fbuf);
			
			gtk_clist_get_pixtext(GTK_CLIST(fwchain[i].rulelist),
					row, 3, &text,&tspace,&tpixmap,&tmask);
			if(strcmp(text, "n/a")) {
				if(sfw.ipfw.fw_invflg & IP_FW_INV_DSTPT)
					fprintf(fp, "! ");
				fprintf(fp, "%s ", text);
			}

			gtk_clist_get_pixtext(GTK_CLIST(fwchain[i].rulelist),
					row, 5, &text,&tspace,&tpixmap,&tmask);
			if(*text) {
				fprintf(fp, "-i ");
				if(sfw.ipfw.fw_invflg & IP_FW_INV_VIA)
					fprintf(fp, "! ");
				fprintf(fp, "%s ", text);
			}
			
			if(target[0] != '-') {
				fprintf(fp, "-j %s ", target);
				if(!strcmp(target, IP_FW_LABEL_REDIRECT))
					fprintf(fp,"%u ",sfw.ipfw.fw_redirpt);
			}

			if(sfw.ipfw.fw_flg & IP_FW_F_TCPSYN) {
				if(sfw.ipfw.fw_invflg & IP_FW_INV_SYN)
					fprintf(fp, "! ");
				fprintf(fp, "-y ");
			}
			if(sfw.ipfw.fw_flg & IP_FW_F_FRAG) {
				if(sfw.ipfw.fw_invflg & IP_FW_INV_FRAG)
					fprintf(fp, "! ");
				fprintf(fp, "-f ");
			}
			if(sfw.ipfw.fw_flg & IP_FW_F_MARKABS)
				fprintf(fp, "-m %u ", sfw.ipfw.fw_mark);
			if(sfw.ipfw.fw_flg & IP_FW_F_NETLINK)
				fprintf(fp, "-o %u ", sfw.ipfw.fw_outputsize);
			if(sfw.ipfw.fw_flg & IP_FW_F_PRN)
				fprintf(fp, "-l ");
			
			if(sfw.ipfw.fw_tosand != 0xff &&
			   sfw.ipfw.fw_tosxor != 0x00) {
				fprintf(fp, "-t 0x%02x 0x%02x ",
				     sfw.ipfw.fw_tosand, sfw.ipfw.fw_tosxor);
			}
			

			fprintf(fp, "\n");
		}
	}
	fclose(fp);
	chmod(fname, 0700);

	sprintf(buf, "Successfully Exported to\n%s", fname);
	dialog_window(buf, NULL);
	
	return;
}

void save_fw_data(GtkWidget *widget, gchar *filename)
{
	FILE *fp = NULL;
	guint i, row=0;
	struct ip_fwuser sfw;
	ip_chainlabel target;
	gchar buf[64];
	
	if(filename) {
		fp = fopen(filename, "w+");
		if(!fp) {
			sprintf(fbuf, "File %s open error", filename);
			dialog_window(fbuf, NULL);
			return;
		}
		fputs("#!ip-firewall rule  *DO NOT EDIT*\n", fp);
	} else {
		flush_entries(NULL);
		delete_user_chain(NULL);
	}

	for(i=0; i<maxchains; i++) {
		if(fwchain[i].deleted)
			continue;
		if(filename) {
			fprintf(fp, "%s %s %u %u %u %u %u\n",
				fwchain[i].label, fwchain[i].policy,
				fwchain[i].refcnt, 0,0,0,0);
		} else if(strcmp(fwchain[i].label, IP_FW_LABEL_INPUT) &&
			  strcmp(fwchain[i].label, IP_FW_LABEL_FORWARD) &&
			  strcmp(fwchain[i].label, IP_FW_LABEL_OUTPUT)) {
			ipfwc_create_chain(fwchain[i].label);
		} else {
			ipfwc_set_policy(fwchain[i].label, fwchain[i].policy);
		}
	}
	if(filename)
		fputs("*\n", fp);
	
	for(i=0; i<maxchains; i++) {
		if(fwchain[i].deleted)
			continue;
		strcpy(sfw.label, fwchain[i].label);
		for(row=0; row<GTK_CLIST(fwchain[i].rulelist)->rows; row++) {
			/*
			gtk_clist_get_text(GTK_CLIST(fwchain[i].rulelist),
					row, 18, &text);
			if(*text == '1')
				continue;
			*/

			conv_fw_data(&sfw, target,
				GTK_CLIST(fwchain[i].rulelist), row);
			if(filename)
				write_to_file(fp, sfw, target);
			else if(!dialog_append_entry(
					fwchain[i].label, target, sfw)) {
				gtk_notebook_set_page(GTK_NOTEBOOK(notebook),i);
				gtk_clist_unselect_all(
					GTK_CLIST(fwchain[i].rulelist));
				gtk_clist_select_row(
					GTK_CLIST(fwchain[i].rulelist),row,0);
				return;
			}
		}
	}
	
	if(filename) {
		if(strcmp(filename, GFCC_HOME"/system.rule")) {
			sprintf(buf, "Successfully Saved to\n%s", filename);
			dialog_window(buf, NULL);
		}
		fclose(fp);
	} else {
		dialog_window("Successfully Applied to system", NULL);
		save_fw_data(NULL, g_strdup(GFCC_HOME"/system.rule"));
		return;
	}
	get_fw_data(filename, 0);
	
	return;
}

static void write_to_file(FILE *fp, struct ip_fwuser sfw, gchar *rule)
{
	fprintf(fp, "%9s "
		    "%08lX/%08lX->%08lX/%08lX "
		    "%s "
		    "%hX %hX "
		    "%hu "
		    "%-9lu %-9lu %-9lu %-9lu "
		    "%hu-%hu %hu-%hu "
		    "A%02X X%02X "
		    "%08X "
		    "%hu %hu"
		    "%10s\n",
		    sfw.label,
		    (unsigned long)sfw.ipfw.fw_src.s_addr,
		    (unsigned long)sfw.ipfw.fw_smsk.s_addr,
		    (unsigned long)sfw.ipfw.fw_dst.s_addr,
		    (unsigned long)sfw.ipfw.fw_dmsk.s_addr,
		    sfw.ipfw.fw_vianame,
		    sfw.ipfw.fw_flg, sfw.ipfw.fw_invflg,
		    sfw.ipfw.fw_proto,
		    (unsigned long)0, (unsigned long)0,
		    (unsigned long)0, (unsigned long)0,
		    sfw.ipfw.fw_spts[0], sfw.ipfw.fw_spts[1],
		    sfw.ipfw.fw_dpts[0], sfw.ipfw.fw_dpts[1],
		    sfw.ipfw.fw_tosand, sfw.ipfw.fw_tosxor,
		    sfw.ipfw.fw_redirpt, sfw.ipfw.fw_mark,
		    sfw.ipfw.fw_outputsize, rule);
}

void get_service_name()
{
	FILE *fp;
	gint nread;
	guint portval;
	gchar portlabel[32], proto[8];
	struct _menu *tmptcp = NULL, *tmpudp = NULL;
	
	fp = fopen("/etc/services", "r");
	if(!fp)
		return;
	
	while(fgets(fbuf, sizeof(fbuf), fp)) {
		if(fbuf[0] == '#' || fbuf[0] == '\n')
			continue;
		nread = sscanf(fbuf, "%s %u/%s", portlabel, &portval, proto);
		if(nread != 3)
			continue;
		
		if(!strcmp(proto, "tcp")) {
			if(tmptcp) {
				tmptcp->next = g_malloc(sizeof(struct _menu));
				tmptcp = tmptcp->next;
			} else {
				tmptcp = g_malloc(sizeof(struct _menu));
				service_tcp = tmptcp;
			}
			tmptcp->label = g_malloc(strlen(portlabel)+1);
			strcpy(tmptcp->label, portlabel);
			tmptcp->value = portval;
			tmptcp->next = NULL;
		} else if(!strcmp(proto, "udp")) {
			if(tmpudp) {
				tmpudp->next = g_malloc(sizeof(struct _menu));
				tmpudp = tmpudp->next;
			} else {
				tmpudp = g_malloc(sizeof(struct _menu));
				service_udp = tmpudp;
			}
			tmpudp->label = g_malloc(strlen(portlabel)+1);
			strcpy(tmpudp->label, portlabel);
			tmpudp->value = portval;
			tmpudp->next = NULL;
		}
	}

	fclose(fp);
}

void get_proto_name()
{
	FILE *fp;
	gint nread;
	guint protoval;
	gchar protolabel[32];
	struct _menu *tmp = NULL;
	
	fp = fopen("/etc/protocols", "r");
	if(!fp) {
		perror("/etc/protocols");
		return;
	}
	
	while(fgets(fbuf, sizeof(fbuf), fp)) {
		if(fbuf[0] == '#' || fbuf[0] == '\n')
			continue;
		nread = sscanf(fbuf, "%s %u", protolabel, &protoval);
		if(nread != 2)
			continue;
		if(!protoval)
			strcpy(protolabel, "all");

		if(tmp) {
			tmp->next = g_malloc(sizeof(struct _menu));
			tmp = tmp->next;
		} else {
			tmp = g_malloc(sizeof(struct _menu));
			proto_name = tmp;
		}

		tmp->label = g_malloc(strlen(protolabel)+1);
		strcpy(tmp->label, protolabel);
		tmp->value = protoval;
		tmp->next = NULL;
	}

	fclose(fp);
}
