/*  GFAX - Gnome fax application
 *  Copyright (C) 1999 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* Mgetty+Sendfax sendfax.config file help messages */
static gchar *mgHeader = N_(
"#Sendfax.config\n#\n\
#This file has beed created by GFax.  It will be over written\n\
#every time Gfax's mgetty setup is changed.\n#\n#If you want to edit this file by hand, disable \
this option in Gfax.\n\n"
);

static gchar *mgModemInitHelp = N_(
"\n#Specifies an `AT...' command that is to be sent to the modem right\n\
#at the *beginning* of all modem talk (even before setting the modem\n\
#into fax mode, so this could be an `ATZ' if you want to reset the\n\
#modem).\n\n"
);

static gchar *mgModemPortHelp = N_("\n#Sets the fax modem to use, e.g. tty1a.\n\n");

static gchar *mgModemTypeHelp = N_(
"\n#Force the modem command set to use. Default is `auto' (auto-detect,\n\
#which may not work on very cheap modems), possible other values are\n\
#`cls2', for \"class 2 only\" modems, and `c2.0' for \"class 2.0\"\n\
#faxmodems.\n\n"
);

static gchar *mgMaxTriesHelp = N_(
"\n#Specify the maximum number of tries per page if the receiving end\n\
#reports reception errors. If NNN tries do not suffice to\n\
#successfully transmit a page, `sendfax' will give up or simply go\n\
#on. If this is set to `0', `sendfax' will ignore retransmission\n\
#requests and simply go on.\n\n"
);

static gchar *mgIgnoreCarrierHelp = N_(
"\n#Some misbehaving modems lower the DCD (carrier detect) line briefly\n\
#between sending multiple pages.  Depending on the operating system\n\
#used, this may cause all subsequent port accesses on this serial\n\
#port to fail.  You'll recognize it if you get a \"weird-looking\"\n\
#sendfax log file that works fine up to the end of the first page,\n\
#and then aborts with `I/O error' or so.\n\n"
);

static gchar *mgPortSpeedHelp = N_(
"\n#Set the port speed to use for fax send operations. Usually,\n\
#`38400' is a good choice, but a few dumb modems (for example, some\n\
#based on rockwell chipsets) need `19200' or even `9600'. A few\n\
#modems can go higher, but `sendfax' may not support it, and it may\n\
#not always work.\n\n"
);

static gchar *mgDialCommandHelp = N_(
"\n#This is the command used for dialing out. Usually this will be\n\
#something simple, as `ATD' or `ATDP', but if you have an unusual\n\
#setup, it could also be something like `ATX0DP0;X4DT' (meaning:\n\
#switch off dial-tone detection, pulse-dial `0', back to command\n\
#mode, switch on dial-tone detection, and go ahead dialing with\n\
#touch tones). The phone number will be sent right after the\n\
#`dial-prefix'.\n\n"
);

static gchar *mgModemHandshakeHelp = N_(
"\n#Specifies an `AT...' command that will be sent to the modem at the\n\
#*end* of the modem initialization, right before dialing. *Do not\n\
#use ATZ or such here*, since resetting the modem will switch off\n\
#fax mode.\n\n"
);

static gchar *mgModemQuirksHelp = N_(
"\n#Same as in `mgetty', this can be used to adapt `sendfax' to some\n\
#peculiarities in certain modems.\n\n"
);

static gchar *mgMaxTriesContHelp = N_(
"\n#After the maximum number of tries for one page are reached,\n\
#`sendfax' can report an error and abort (`max-tries-continue NO'),\n\
#or go on with the next page (YES)\n\n"
);

static gchar *mgSwitchBdHelp = N_(
"\n#On some (very few) modems it is necessary to start with baudrate\n\
#\"A\" and switch to baudrate \"B\" after sending the `AT+FCLASS=2'\n\
#command. If you specify this, `sendfax' will switch from `speed' to\n\
#`switchbd' right after setting the modem to class 2/2.0. Default is\n\
#`FAX_SEND_SWITCHBD', I'd recommend *not* using it unless you're\n\
#sure that you need it.\n\n"
);

static gchar *mgOpenDelayHelp = N_(
"\n#A few modems respond to raising the DTR line (when opening the\n\
#device) with `OK'.  This can confuse `sendfax', because it will see\n\
#this OK as response to the next command.\n\n\
#The only modem that needs this so far is an ELSA 33.6, and\n\
#delaying for about 1500 ms cured the problem.\n\n"
);

static gchar *mgDebugLevelHelp = N_(
"\n#Controls the amount of information written into the fax log file\n\
#(`FAX_LOG' in `policy.h'). `0' means \"totally silent\" (not even\n\
#errors are written), `9' is really noisy. I usually use `3' or `4'\n\
#in normal use, and `6' for debugging.\n\n"
);

/* static gchar *mgFaxidHelp = N_(
"\n#Specifies the \"fax station id\" used to identify your fax machine\n\
to the receiving end. Usually this is the telephone number of your\n\
own fax machine, but if you want to (and if your modem supports\n\
it), you can put up to 20 alphanumeric characters here, e.g.\n\
`+1-11-222 Fred'.\n\n"
);
 */
