/*  GFAX - Gnome fax application
 *  Copyright (C) 1999 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include <config.h>
#include <gnome.h>
#include <glade/glade.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include "gfax.h"
#include "setup.h"


extern Setup *prop;
extern HylafaxConfigData *hylafax;

/*=========================================================================
 * void hylafax_get_config(prop)
 *	
 *	If calledFromMain is true then we only load the main settings and
 *  do not store any of the hylafax fax agent settings into the widgets.
 *
 *-----------------------------------------------------------------------*/
void hylafax_get_config(gboolean calledFromMain, Setup *prop, HylafaxConfigData *hylafax)
{
	GString *tmpstr;
	gboolean is_default;	/* Indicates if default item returned from config file */

	/* OK lets go get the config data -----------------------------------*/
	tmpstr = g_string_new(NULL);
 	gnome_config_push_prefix("/Gfax/Hylafax/");
		
	if ( hylafaxServerName ) 
		free(hylafaxServerName);
        
        hylafaxServerName = g_strdup(gnome_config_get_string_with_default(
				"ServerHost=localhost", &is_default));
        hylafaxServerPort = gnome_config_get_int_with_default("ServerPort=4559", &is_default);
	hylafaxInternalSendfax = gnome_config_get_bool_with_default("InternalSendfax=Yes", &is_default);

        gnome_config_pop_prefix();

        if ( !calledFromMain ) {
                hylafax->serverHost      = g_strdup(hylafaxServerName);
                hylafax->serverPort      = hylafaxServerPort;
		hylafax->internalSendfax = hylafaxInternalSendfax;

                /* set the widgets with the retrieved values - never set a NULL value */
                if (hylafax->serverHost != NULL)
                        gtk_entry_set_text(GTK_ENTRY(prop->hylafaxServerNameEntry), hylafax->serverHost);
                g_string_sprintf(tmpstr, "%d", hylafax->serverPort);
                gtk_entry_set_text(GTK_ENTRY(prop->hylafaxServerPortEntry), tmpstr->str);
                
                gtk_widget_draw(GTK_WIDGET(prop->setup), NULL);
        }

	g_string_free(tmpstr, TRUE);

	return;
}



/*=========================================================================
 * hylafax_set_config()
 *	write the hylafax config data out.
 *
 *-----------------------------------------------------------------------*/
 
void hylafax_set_config(Setup *prop, HylafaxConfigData *hylafax)
{
	hylafax->serverHost = g_strdup(gtk_entry_get_text((GtkEntry *)prop->hylafaxServerNameEntry));
	hylafax->serverPort = atoi(gtk_entry_get_text((GtkEntry *)prop->hylafaxServerPortEntry));
	
	if ( hylafaxServerName ) 
		free(hylafaxServerName);
	
	hylafaxServerName   = g_strdup(hylafax->serverHost);
	hylafaxServerPort   = hylafax->serverPort;

	/* if everything is ok we get to here and save the settings */
	gnome_config_push_prefix("/Gfax/Hylafax/");
    
	gnome_config_set_string("ServerHost", hylafax->serverHost);
	gnome_config_set_int("ServerPort", hylafax->serverPort);

	gnome_config_pop_prefix();
	
	return;
}

/* These are Emacs variables to use a common "Gfax" coding style:
 * ;;; Local Variables: ***
 * ;;; mode:C ***
 * ;;; c-basic-offset:8 ***
 * ;;; indent-tabs-mode:t ***
 * ;;; End: ***
 */

