#include "parser.h"
#include "printer.h"
#include "polynomial.h"
#include "division.h"
#include "buchberger.h"
#include "wallideal.h"
#include "lp.h"
#include "reversesearch.h"
#include "polyhedralfan.h"
#include "breadthfirstsearch.h"
#include "termorder.h"
#include "ep_standard.h"
#include "ep_xfig.h"
#include "gfanapplication.h"
#include "timer.h"
#include "dimension.h"
#include "tropical.h"
#include "tropical2.h"

class FVectorApplication : public GFanApplication
{
  IntegerOption debugOption;
  SimpleOption listInitialIdealsOption;
  SimpleOption checkBgOption;
public:
  bool includeInDefaultInstallation()
  {
    return false;
  }
  const char *helpText()
  {
    return "This program takes the complete list of reduced Groebner bases for a homogeneous ideal and outputs the f-vector for the Groebner fan.\n";
  }
  FVectorApplication():
    checkBgOption("--bg","Check BG theorem.\n"),
    listInitialIdealsOption("-l","List all initial ideals.\n"),
    debugOption("-d","Tell the program to print out the partial f-vector for every nth Groebner basis. Besides printing the partial f-vector on the stderr the program also tries to write it to the file gfan_fvector_temporary.",0)
  {
    registerOptions();
  }    

  char *name()
  {
    return "_fvector";
  }

  int main()
  {
    //    Field::printList(Stderr);

    LpSolver::printList(Stderr);
    lpSetSolver("cddgmp");
     
    FileParser p(Stdin);

    PolynomialRing r=p.parsePolynomialRing();
    int c=p.nextNonBlank();
    
    IntegerVector f(0);
    IntegerVector fTrop(0);
    int homog=-1;
    int n=-1;

    bool first=true;
    int counter=0;
    assert(p.isLeftBracket(c));
    if(listInitialIdealsOption.getValue())fprintf(Stdout,"{");
    do
      {
	PolynomialSet g=p.parsePolynomialSet(r);
	if(f.size()==0)
	  {
	    n=g.numberOfVariablesInRing();
	    homog=dimensionOfHomogeneitySpace(g);
	    f=IntegerVector(n-homog+1);
	    fTrop=IntegerVector(n-homog+1);
	    //	    fprintf(Stderr,"Dimensions computed.\n");
	  }
	PolyhedralCone c=groebnerCone(g,true);
	PolyhedralFan F(n);
	F.insert(c);
	for(int i=0;i<n-homog+1;i++)
	  {
	    F.removeAllLowerDimensional();
	    //	    IntegerVectorList l=F.getRelativeInteriorPoints();
	    //	    if(i==n-homog)
	    //  {
	    //	assert(l.size()==1);
	    //  }
	    PolyhedralFan F2(n);
	    while(!F.isEmpty())
	      {
		//		fprintf(Stderr,"checking cone\n");
		PolyhedralCone K=F.highestDimensionalCone();
		F.remove(K);

		IntegerVector w=K.getRelativeInteriorPoint();
		WeightTermOrder myOrder(w);
		if(g.checkMarkings(myOrder))
		  {
		    f[n-homog-i]++;
		    F2.insert(K);
		    if(checkBgOption.getValue())
		      {
			if(!containsMonomial(initialFormsAssumeMarked(g,w)))
			  {
			    fTrop[n-homog-i]++;
			    PolynomialSet g2=saturatedIdeal(initialFormsAssumeMarked(g,w));
			    fprintf(Stderr,"Checking BG theorem\n");
			    AsciiPrinter(Stderr).printPolynomialSet(g2);
			    assert(krullDimension(g2)==krullDimension(g));
			  }
		      }
		    if(listInitialIdealsOption.getValue())
		      {
			if(!first)fprintf(Stdout,",\n");
			first=false;
			AsciiPrinter(Stdout).printPolynomialSet(initialFormsAssumeMarked(g,w));
		      }
		  }
	      }
	    F=F2.facetComplex();
	    //	    fprintf(Stderr,"facetComplex computed\n");
	  }
	counter++;
	if(debugOption.getValue())
	  {
	    if((counter%debugOption.getValue())==0)
	      {
		AsciiPrinter(Stderr).printVector(f);
		AsciiPrinter(Stderr).printNewLine();

		FILE *p=fopen("gfan_fvector_temporary","w");
		if(p)
		  {
		    AsciiPrinter(p).printVector(f);
		    AsciiPrinter(p).printNewLine();
		    fclose(p);
		  }
	      }
	  }
      }
    while((c=p.nextNonBlank())==',');
    assert(p.isRightBracket(c));
    if(listInitialIdealsOption.getValue())fprintf(Stdout,"}\n");

    AsciiPrinter(Stdout).printVector(f);
    if(checkBgOption.getValue())
      {
	fprintf(Stdout,"F-vector of tropical variety:\n");
	AsciiPrinter(Stdout).printVector(fTrop);
      }
    return 0;
  }
};

static FVectorApplication theApplication;

