/*
 * Geotrans.java
 * Created on 22 juin 2000, 16:56
 *
 * @author  finnc
 * @version
 */
package geotrans.gui;


import geotrans.enumerations.ConversionState;
import geotrans.enumerations.CoordinateTypes;
import geotrans.enumerations.ListType;
import geotrans.enumerations.SourceOrTarget;
import geotrans.gui.*;
import geotrans.jni.*;
import geotrans.utility.Center;
import geotrans.utility.DATFileFilter;
import geotrans.utility.Directory;
import geotrans.utility.Platform;
import geotrans.utility.ReadEnv;
import geotrans.utility.StartBrowser;
import geotrans.utility.color.*;


public class Geotrans extends javax.swing.JFrame 
{
  private Directory currentDir = new Directory(".");
  private JNIEngine jniEngine = new JNIEngine();
  private JNIStrtoval jniStrtoval = new JNIStrtoval();
  private java.awt.Color defaultSelectedColor = new java.awt.Color(0, 0, 0);
  private java.awt.Color currentColor = Green.VALUE;
  private java.awt.Component prevFocus;
  private MasterPanel upperMasterPanel;
  private MasterPanel lowerMasterPanel;
  private jOptions options;
  private java.lang.String currLookAndFeel = "Java";
  private String dataDirPathName = "";
  private java.io.File defaultFile;

  
 /** Creates new form Geotrans */
  public Geotrans() 
  {
    defaultSelectedColor = (java.awt.Color)javax.swing.UIManager.get("Button.select");

    initComponents ();
    initialize();

    javax.swing.ButtonGroup lookAndFeelGroup = new javax.swing.ButtonGroup();
    lookAndFeelGroup.add(metalRadioButtonMenuItem);
    lookAndFeelGroup.add(unixRadioButtonMenuItem);
    lookAndFeelGroup.add(windowsRadioButtonMenuItem);

    // Change title bar icon
    java.net.URL url = getClass().getResource("/geotrans/gui/icons/Icon.gif");
    try
    {
        java.awt.Image img = createImage((java.awt.image.ImageProducer)url.getContent());
        setIconImage(img);
    }
    catch (Exception e)
    {
        e.printStackTrace();
    }
    pack();
    if (Platform.isUnix)
        setSize(new java.awt.Dimension(484, 679));
    new Center(null, this);
    
    try 
    {
      java.util.Properties p = ReadEnv.getEnvVars();
      dataDirPathName = p.getProperty("GEOTRANS_DATA");
    }
    catch (Throwable e) 
    {
      e.printStackTrace();
    }
    
    if (dataDirPathName != null && dataDirPathName.length() > 0)
      dataDirPathName += "/";
    else
      dataDirPathName = "../data/";
    dataDirPathName += "default.xml";
    
    defaultFile = new java.io.File(dataDirPathName);
    
    if(defaultFile.exists())
      new RestoreDefault(this, defaultFile, upperMasterPanel, lowerMasterPanel, options);   
  }

  static {
    System.loadLibrary("jnigeotrans");
    // Load JNI Native library.  .dll or .so
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    geotransToolBar = new javax.swing.JToolBar();
    cutButton = new javax.swing.JButton();
    copyButton = new javax.swing.JButton();
    pasteButton = new javax.swing.JButton();
    formatButton = new javax.swing.JButton();
    geotransToolBarSeparator = new javax.swing.JSeparator();
    upperPanel = new javax.swing.JPanel();
    convertPanel = new javax.swing.JPanel();
    convertDownButton = new javax.swing.JButton();
    convertUpButton = new javax.swing.JButton();
    lowerPanel = new javax.swing.JPanel();
    geotransMenuBar = new javax.swing.JMenuBar();
    fileMenu = new javax.swing.JMenu();
    openMenuItem = new javax.swing.JMenuItem();
    createFileHeaderMenuItem = new javax.swing.JMenuItem();
    restoreDefaultMenuItem = new javax.swing.JMenuItem();
    saveAsDefaultMenuItem = new javax.swing.JMenuItem();
    fileMenuSeparator = new javax.swing.JSeparator();
    exitMenuItem = new javax.swing.JMenuItem();
    editMenu = new javax.swing.JMenu();
    cutMenuItem = new javax.swing.JMenuItem();
    copyMenuItem = new javax.swing.JMenuItem();
    pasteMenuItem = new javax.swing.JMenuItem();
    optionsMenu = new javax.swing.JMenu();
    formatMenuItem = new javax.swing.JMenuItem();
    lookAndFeelMenu = new javax.swing.JMenu();
    metalRadioButtonMenuItem = new javax.swing.JRadioButtonMenuItem();
    unixRadioButtonMenuItem = new javax.swing.JRadioButtonMenuItem();
    windowsRadioButtonMenuItem = new javax.swing.JRadioButtonMenuItem();
    datumMenu = new javax.swing.JMenu();
    createDatumMenuItem = new javax.swing.JMenuItem();
    deleteDatumMenuItem = new javax.swing.JMenuItem();
    ellipsoidMenu = new javax.swing.JMenu();
    createEllipsoidMenuItem = new javax.swing.JMenuItem();
    deleteEllipsoidMenuItem = new javax.swing.JMenuItem();
    convertMenu = new javax.swing.JMenu();
    convertDownMenuItem = new javax.swing.JMenuItem();
    convertMenuSeparator = new javax.swing.JSeparator();
    convertUpMenuItem = new javax.swing.JMenuItem();
    helpMenu = new javax.swing.JMenu();
    contentsMenuItem = new javax.swing.JMenuItem();
    helpMenuSeparator = new javax.swing.JSeparator();
    aboutMenuItem = new javax.swing.JMenuItem();

    getContentPane().setLayout(new java.awt.GridBagLayout());

    setTitle("GEOTRANS V2.4.2 - Geographic Translator V2.4.2");
    setResizable(false);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        exitForm(evt);
      }
    });

    geotransToolBar.setFloatable(false);
    geotransToolBar.setAlignmentX(0.0F);
    geotransToolBar.setMinimumSize(new java.awt.Dimension(25, 25));
    geotransToolBar.setPreferredSize(new java.awt.Dimension(25, 25));
    cutButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Cut16.gif")));
    cutButton.setToolTipText("Cut");
    cutButton.setMaximumSize(new java.awt.Dimension(25, 30));
    cutButton.setMinimumSize(new java.awt.Dimension(17, 21));
    cutButton.setPreferredSize(new java.awt.Dimension(27, 27));
    cutButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cutActionPerformed(evt);
      }
    });
    cutButton.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseEntered(java.awt.event.MouseEvent evt) {
        editButtonMouseEntered(evt);
      }
    });

    geotransToolBar.add(cutButton);

    copyButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Copy16.gif")));
    copyButton.setToolTipText("Copy");
    copyButton.setMaximumSize(new java.awt.Dimension(25, 30));
    copyButton.setMinimumSize(new java.awt.Dimension(17, 21));
    copyButton.setPreferredSize(new java.awt.Dimension(27, 27));
    copyButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        copyActionPerformed(evt);
      }
    });
    copyButton.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseEntered(java.awt.event.MouseEvent evt) {
        editButtonMouseEntered(evt);
      }
    });

    geotransToolBar.add(copyButton);

    pasteButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Paste16.gif")));
    pasteButton.setToolTipText("Paste");
    pasteButton.setMaximumSize(new java.awt.Dimension(25, 30));
    pasteButton.setMinimumSize(new java.awt.Dimension(17, 21));
    pasteButton.setPreferredSize(new java.awt.Dimension(27, 27));
    pasteButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        pasteActionPerformed(evt);
      }
    });
    pasteButton.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseEntered(java.awt.event.MouseEvent evt) {
        editButtonMouseEntered(evt);
      }
    });

    geotransToolBar.add(pasteButton);

    formatButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Preferences16.gif")));
    formatButton.setToolTipText("Format Options");
    formatButton.setMaximumSize(new java.awt.Dimension(25, 30));
    formatButton.setMinimumSize(new java.awt.Dimension(17, 21));
    formatButton.setPreferredSize(new java.awt.Dimension(27, 27));
    formatButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        formatActionPerformed(evt);
      }
    });

    geotransToolBar.add(formatButton);

    geotransToolBarSeparator.setOrientation(javax.swing.SwingConstants.VERTICAL);
    geotransToolBar.add(geotransToolBarSeparator);

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
    getContentPane().add(geotransToolBar, gridBagConstraints);

    upperPanel.setLayout(new java.awt.GridBagLayout());

    upperPanel.setBackground(java.awt.Color.lightGray);
    upperPanel.setBorder(javax.swing.BorderFactory.createCompoundBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED), javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0))));
    upperPanel.setMinimumSize(new java.awt.Dimension(469, 284));
    upperPanel.setPreferredSize(new java.awt.Dimension(469, 284));
    upperPanel.setOpaque(false);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
    gridBagConstraints.weightx = 0.5;
    gridBagConstraints.weighty = 0.5;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    getContentPane().add(upperPanel, gridBagConstraints);

    convertPanel.setLayout(new java.awt.GridBagLayout());

    convertPanel.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));
    convertDownButton.setFont(new java.awt.Font("Dialog", 0, 11));
    convertDownButton.setText("Convert Upper -> Lower");
    convertDownButton.setToolTipText("Convert Upper to Lower");
    convertDownButton.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
    convertDownButton.setMaximumSize(new java.awt.Dimension(197, 24));
    convertDownButton.setMinimumSize(new java.awt.Dimension(197, 24));
    convertDownButton.setPreferredSize(new java.awt.Dimension(197, 24));
    convertDownButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        convertDownActionPerformed(evt);
      }
    });
    convertDownButton.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mousePressed(java.awt.event.MouseEvent evt) {
        convertButtonMousePressed(evt);
        convertDownButtonMousePressed(evt);
      }
      public void mouseReleased(java.awt.event.MouseEvent evt) {
        convertButtonMouseReleased(evt);
        convertDownButtonMouseReleased(evt);
      }
    });

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 12);
    convertPanel.add(convertDownButton, gridBagConstraints);

    convertUpButton.setFont(new java.awt.Font("Dialog", 0, 11));
    convertUpButton.setText("Convert Lower -> Upper");
    convertUpButton.setToolTipText("Convert Lower to Upper");
    convertUpButton.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
    convertUpButton.setMaximumSize(new java.awt.Dimension(197, 24));
    convertUpButton.setMinimumSize(new java.awt.Dimension(197, 24));
    convertUpButton.setPreferredSize(new java.awt.Dimension(197, 24));
    convertUpButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        convertUpActionPerformed(evt);
      }
    });
    convertUpButton.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mousePressed(java.awt.event.MouseEvent evt) {
        convertButtonMousePressed(evt);
        convertUpButtonMousePressed(evt);
      }
      public void mouseReleased(java.awt.event.MouseEvent evt) {
        convertButtonMouseReleased(evt);
        convertUpButtonMouseReleased(evt);
      }
    });

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.insets = new java.awt.Insets(3, 12, 3, 0);
    convertPanel.add(convertUpButton, gridBagConstraints);

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 2;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
    getContentPane().add(convertPanel, gridBagConstraints);

    lowerPanel.setLayout(new java.awt.GridBagLayout());

    lowerPanel.setBackground(java.awt.Color.lightGray);
    lowerPanel.setBorder(javax.swing.BorderFactory.createCompoundBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED), javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0))));
    lowerPanel.setMinimumSize(new java.awt.Dimension(469, 284));
    lowerPanel.setPreferredSize(new java.awt.Dimension(469, 284));
    lowerPanel.setOpaque(false);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 3;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
    gridBagConstraints.weightx = 0.5;
    gridBagConstraints.weighty = 0.5;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    getContentPane().add(lowerPanel, gridBagConstraints);

    geotransMenuBar.setMinimumSize(new java.awt.Dimension(285, 23));
    fileMenu.setMnemonic(java.awt.event.KeyEvent.VK_F);
    fileMenu.setText("File");
    openMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_O, java.awt.event.InputEvent.CTRL_MASK));
    openMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Open16.gif")));
    openMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_O);
    openMenuItem.setText("Open");
    openMenuItem.setToolTipText("Open");
    openMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        openActionPerformed(evt);
      }
    });

    fileMenu.add(openMenuItem);

    createFileHeaderMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F2, 0));
    createFileHeaderMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Create16.gif")));
    createFileHeaderMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_C);
    createFileHeaderMenuItem.setText("Create File Header");
    createFileHeaderMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        createFileHeaderActionPerformed(evt);
      }
    });

    fileMenu.add(createFileHeaderMenuItem);

    restoreDefaultMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_R, java.awt.event.InputEvent.CTRL_MASK));
    restoreDefaultMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Open16.gif")));
    restoreDefaultMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_R);
    restoreDefaultMenuItem.setText("Restore Default");
    restoreDefaultMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        restoreDefaultActionPerformed(evt);
      }
    });

    fileMenu.add(restoreDefaultMenuItem);

    saveAsDefaultMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.CTRL_MASK));
    saveAsDefaultMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Save16.gif")));
    saveAsDefaultMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_S);
    saveAsDefaultMenuItem.setText("Save As Default");
    saveAsDefaultMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        saveAsDefaultActionPerformed(evt);
      }
    });

    fileMenu.add(saveAsDefaultMenuItem);

    fileMenu.add(fileMenuSeparator);

    exitMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Stop16.gif")));
    exitMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_X);
    exitMenuItem.setText("Exit");
    exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        exitActionPerformed(evt);
      }
    });

    fileMenu.add(exitMenuItem);

    geotransMenuBar.add(fileMenu);

    editMenu.setMnemonic(java.awt.event.KeyEvent.VK_E);
    editMenu.setText("Edit");
    cutMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_X, java.awt.event.InputEvent.CTRL_MASK));
    cutMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Cut16.gif")));
    cutMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_T);
    cutMenuItem.setText("Cut");
    cutMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cutActionPerformed(evt);
      }
    });

    editMenu.add(cutMenuItem);

    copyMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, java.awt.event.InputEvent.CTRL_MASK));
    copyMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Copy16.gif")));
    copyMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_C);
    copyMenuItem.setText("Copy");
    copyMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        copyActionPerformed(evt);
      }
    });

    editMenu.add(copyMenuItem);

    pasteMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_V, java.awt.event.InputEvent.CTRL_MASK));
    pasteMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Paste16.gif")));
    pasteMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_P);
    pasteMenuItem.setText("Paste");
    pasteMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        pasteActionPerformed(evt);
      }
    });

    editMenu.add(pasteMenuItem);

    geotransMenuBar.add(editMenu);

    optionsMenu.setMnemonic(java.awt.event.KeyEvent.VK_O);
    optionsMenu.setText("Options");
    formatMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F, java.awt.event.InputEvent.CTRL_MASK));
    formatMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Preferences16.gif")));
    formatMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_F);
    formatMenuItem.setText("Format . . .");
    formatMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        formatActionPerformed(evt);
      }
    });

    optionsMenu.add(formatMenuItem);

    lookAndFeelMenu.setMnemonic(java.awt.event.KeyEvent.VK_L);
    lookAndFeelMenu.setText("Look and Feel");
    metalRadioButtonMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_J, java.awt.event.InputEvent.CTRL_MASK));
    metalRadioButtonMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_J);
    metalRadioButtonMenuItem.setSelected(true);
    metalRadioButtonMenuItem.setText("Java");
    metalRadioButtonMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        lookAndFeelActionPerformed(evt);
      }
    });

    lookAndFeelMenu.add(metalRadioButtonMenuItem);

    unixRadioButtonMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_U, java.awt.event.InputEvent.CTRL_MASK));
    unixRadioButtonMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_U);
    unixRadioButtonMenuItem.setText("Unix");
    unixRadioButtonMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        lookAndFeelActionPerformed(evt);
      }
    });

    lookAndFeelMenu.add(unixRadioButtonMenuItem);

    windowsRadioButtonMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_W, java.awt.event.InputEvent.CTRL_MASK));
    windowsRadioButtonMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_W);
    windowsRadioButtonMenuItem.setText("Windows");
    windowsRadioButtonMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        lookAndFeelActionPerformed(evt);
      }
    });

    lookAndFeelMenu.add(windowsRadioButtonMenuItem);

    optionsMenu.add(lookAndFeelMenu);

    geotransMenuBar.add(optionsMenu);

    datumMenu.setMnemonic(java.awt.event.KeyEvent.VK_D);
    datumMenu.setText("Datum");
    createDatumMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F3, 0));
    createDatumMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/New16.gif")));
    createDatumMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_C);
    createDatumMenuItem.setText("Create . . .");
    createDatumMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        createDatumActionPerformed(evt);
      }
    });

    datumMenu.add(createDatumMenuItem);

    deleteDatumMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F4, 0));
    deleteDatumMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Delete16.gif")));
    deleteDatumMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_D);
    deleteDatumMenuItem.setText("Delete . . .");
    deleteDatumMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        deleteDatumActionPerformed(evt);
      }
    });

    datumMenu.add(deleteDatumMenuItem);

    geotransMenuBar.add(datumMenu);

    ellipsoidMenu.setMnemonic(java.awt.event.KeyEvent.VK_L);
    ellipsoidMenu.setText("Ellipsoid");
    createEllipsoidMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F5, 0));
    createEllipsoidMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/New16.gif")));
    createEllipsoidMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_C);
    createEllipsoidMenuItem.setText("Create . . .");
    createEllipsoidMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        createEllipsoidActionPerformed(evt);
      }
    });

    ellipsoidMenu.add(createEllipsoidMenuItem);

    deleteEllipsoidMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F6, 0));
    deleteEllipsoidMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Delete16.gif")));
    deleteEllipsoidMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_D);
    deleteEllipsoidMenuItem.setText("Delete . . .");
    deleteEllipsoidMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        deleteEllipsoidActionPerformed(evt);
      }
    });

    ellipsoidMenu.add(deleteEllipsoidMenuItem);

    geotransMenuBar.add(ellipsoidMenu);

    convertMenu.setMnemonic(java.awt.event.KeyEvent.VK_C);
    convertMenu.setText("Convert");
    convertDownMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F7, 0));
    convertDownMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Down16.gif")));
    convertDownMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_U);
    convertDownMenuItem.setLabel(" Upper to Lower");
    convertDownMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        convertDownActionPerformed(evt);
      }
    });

    convertMenu.add(convertDownMenuItem);

    convertMenu.add(convertMenuSeparator);

    convertUpMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F8, 0));
    convertUpMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/geotrans/gui/icons/Up16.gif")));
    convertUpMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_L);
    convertUpMenuItem.setLabel("Lower to Upper");
    convertUpMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        convertUpActionPerformed(evt);
      }
    });

    convertMenu.add(convertUpMenuItem);

    geotransMenuBar.add(convertMenu);

    helpMenu.setMnemonic(java.awt.event.KeyEvent.VK_H);
    helpMenu.setText("Help");
    contentsMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F1, 0));
    contentsMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_C);
    contentsMenuItem.setText("Contents");
    contentsMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        helpContentsActionPerformed(evt);
      }
    });

    helpMenu.add(contentsMenuItem);

    helpMenu.add(helpMenuSeparator);

    aboutMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_A, java.awt.event.InputEvent.CTRL_MASK));
    aboutMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_A);
    aboutMenuItem.setText("About GEOTRANS...");
    aboutMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        aboutMenuItemActionPerformed(evt);
      }
    });

    helpMenu.add(aboutMenuItem);

    geotransMenuBar.add(helpMenu);

    setJMenuBar(geotransMenuBar);

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void restoreDefaultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_restoreDefaultActionPerformed
    if(defaultFile.exists())
      new RestoreDefault(this, defaultFile, upperMasterPanel, lowerMasterPanel, options);
    else
      javax.swing.JOptionPane.showMessageDialog(this, "File does not exist: " + defaultFile, "Error", javax.swing.JOptionPane.ERROR_MESSAGE);
  }//GEN-LAST:event_restoreDefaultActionPerformed

  private void saveAsDefaultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveAsDefaultActionPerformed
    new SaveAsDefault(this, defaultFile, upperMasterPanel, lowerMasterPanel, options);
  }//GEN-LAST:event_saveAsDefaultActionPerformed

    private void convertUpButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_convertUpButtonMouseReleased
    convertUpButton.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
    }//GEN-LAST:event_convertUpButtonMouseReleased

    private void convertUpButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_convertUpButtonMousePressed
    convertUpButton.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
    }//GEN-LAST:event_convertUpButtonMousePressed

    private void convertDownButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_convertDownButtonMouseReleased
    convertDownButton.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
    }//GEN-LAST:event_convertDownButtonMouseReleased

    private void convertDownButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_convertDownButtonMousePressed
    convertDownButton.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
    }//GEN-LAST:event_convertDownButtonMousePressed

    private void convertButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_convertButtonMouseReleased
    javax.swing.UIManager.put("Button.select", defaultSelectedColor);
    }//GEN-LAST:event_convertButtonMouseReleased

    private void convertButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_convertButtonMousePressed
    javax.swing.UIManager.put("Button.select", currentColor);
    }//GEN-LAST:event_convertButtonMousePressed

  private void createFileHeaderActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_createFileHeaderActionPerformed
    new CreateFileHeaderDlg (this, true, currentDir, options).show ();
  }//GEN-LAST:event_createFileHeaderActionPerformed

  private void aboutMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_aboutMenuItemActionPerformed
    new AboutDlg(this, true).show();
  }//GEN-LAST:event_aboutMenuItemActionPerformed

  private void helpContentsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpContentsActionPerformed
   java.io.File helpFile = new java.io.File ("..");
   try
   {
       if (StartBrowser.isWindowsPlatform())
           StartBrowser.displayURL(this, "file:" + helpFile.getCanonicalPath() + "\\help\\contents.htm");
       else
           StartBrowser.displayURL(this, "file:" + helpFile.getCanonicalPath() + "/help/contents.htm");
   }
   catch(Exception e)
   {
        jniStrtoval.displayErrorMsg(this, "Could not invoke browser");
   }
  }//GEN-LAST:event_helpContentsActionPerformed

  private void lookAndFeelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lookAndFeelActionPerformed
    try
    {
        if (metalRadioButtonMenuItem.isSelected())
        {
            currLookAndFeel = "Java";
            javax.swing.UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        else if (unixRadioButtonMenuItem.isSelected())
        {
            currLookAndFeel = "Unix";
            javax.swing.UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        else if (windowsRadioButtonMenuItem.isSelected())
        {
            String osName = System.getProperty("os.name");
            if ((osName != null) && (osName.indexOf("Windows") != -1))
            {
                currLookAndFeel = "Windows";
                javax.swing.UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            else
            {
                resetLookAndFeel();
                jniStrtoval.displayErrorMsg(this, "This option is only available on a Windows platform");
            }
        }
        javax.swing.SwingUtilities.updateComponentTreeUI(this);
        upperMasterPanel.setLookAndFeel(currLookAndFeel);
        lowerMasterPanel.setLookAndFeel(currLookAndFeel);
    }
    catch (Exception e)
    {
        jniStrtoval.displayErrorMsg(this, e.getMessage());
    }

  }//GEN-LAST:event_lookAndFeelActionPerformed

  private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
    System.exit(0);
  }//GEN-LAST:event_exitForm

  /** Exit the Application in response to File menu - "exit" event.*/
  private void exitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitActionPerformed
    System.exit(0);
  }//GEN-LAST:event_exitActionPerformed

  /** Open a File for multi-point conversions. */
  private void openActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openActionPerformed
    JNIFiomeths jniFiomeths = new JNIFiomeths();

    javax.swing.JFileChooser jChooser1 = new javax.swing.JFileChooser(currentDir.getDirectory());
    jChooser1.addChoosableFileFilter(new DATFileFilter());
    jChooser1.setSelectedFile(new java.io.File("*.dat"));
    int state = jChooser1.showOpenDialog(this);
    if( state == javax.swing.JFileChooser.APPROVE_OPTION )
    {
        java.io.File file = jChooser1.getSelectedFile();
        currentDir.setDirectory(file.getAbsolutePath());
        if( file != null )
        {
            try
            {
                jniFiomeths.JNISetInputFilename(file.getPath());

                new FileDlg (this, true, currentDir, options, jniFiomeths).show ();
            }
            catch(GeotransError e)
            {
                jniStrtoval.displayErrorMsg(this, e.getMessage());
                jniFiomeths.JNICloseInputFile();
            }
            catch(JNIException e)
            {
                jniStrtoval.displayErrorMsg(this, e.getMessage());
                jniFiomeths.JNICloseInputFile();
            }
        }
    }

  }//GEN-LAST:event_openActionPerformed

  /** Open "Format Options" dialog in response to Options menu - "Format" event.
  *   Specifies output precision and angle measure (Latitude/Longitude/Orientation)
  *   format in terms of units, range, sign and separator.*/
  private void formatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_formatActionPerformed
    FormatOptionsDlg formatOptionsDlg = new FormatOptionsDlg(this, true, options);
    formatOptionsDlg.show();
  }//GEN-LAST:event_formatActionPerformed

  /** Converts Lower Projection Coordinates to Upper Projection Coordinates. */
  private void convertUpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_convertUpActionPerformed
    boolean errorCode = false;

    try
    {
        lowerMasterPanel.setProjectionDir(SourceOrTarget.SOURCE);
        lowerMasterPanel.setEngine();
        if(!lowerMasterPanel.JNIError() && !lowerMasterPanel.engineError())
        {
            upperMasterPanel.setProjectionDir(SourceOrTarget.TARGET);
            upperMasterPanel.setEngine();
            if(!upperMasterPanel.JNIError() && !upperMasterPanel.engineError())
                jniEngine.JNIConvert(ConversionState.INTERACTIVE);
            else
            {
                errorCode = true;
                upperMasterPanel.showErrors(this);
            }
        }
        else
        {
            errorCode = true;
            lowerMasterPanel.showErrors(this);
        }
    }
    catch(GeotransError e)
    {
        errorCode = true;
        jniStrtoval.displayErrorMsg(this, e.getMessage());
    }
    catch(GeotransWarning e)
    {
        errorCode = false;
        jniStrtoval.displayWarningMsg(this, e.getMessage());
    }
    catch(JNIException e)
    {
        errorCode = true;
        jniStrtoval.displayErrorMsg(this, e.getMessage());
    }

    if (!errorCode)
    {
        upperMasterPanel.getCoords(SourceOrTarget.TARGET);
        if(!upperMasterPanel.JNIError() && !upperMasterPanel.engineError())
        {
            upperMasterPanel.reportAccuracy();
///            lowerMasterPanel.resetAccuracy();
        }
        else
            upperMasterPanel.showErrors(this);
    }
  }//GEN-LAST:event_convertUpActionPerformed

  /** Converts Upper Projection Coordinates to Lower Projection Coordinates. */
  private void convertDownActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_convertDownActionPerformed
    boolean errorCode = false;

    try
    {
        upperMasterPanel.setProjectionDir(SourceOrTarget.SOURCE);
        upperMasterPanel.setEngine();
        if(!upperMasterPanel.JNIError() && !upperMasterPanel.engineError())
        {
            lowerMasterPanel.setProjectionDir(SourceOrTarget.TARGET);
            lowerMasterPanel.setEngine();
            if(!lowerMasterPanel.JNIError() && !lowerMasterPanel.engineError())
                jniEngine.JNIConvert(ConversionState.INTERACTIVE);
            else
            {
                errorCode = true;
                lowerMasterPanel.showErrors(this);
            }
        }
        else
        {
            errorCode = true;
            upperMasterPanel.showErrors(this);
        }
    }
    catch(GeotransError e)
    {
        errorCode = true;
        jniStrtoval.displayErrorMsg(this, e.getMessage());
    }
    catch(GeotransWarning e)
    {
        errorCode = false;
        jniStrtoval.displayWarningMsg(this, e.getMessage());
    }
    catch(JNIException e)
    {
        errorCode = true;
        jniStrtoval.displayErrorMsg(this, e.getMessage());
    }

    if(!errorCode)
    {   // no errors
        lowerMasterPanel.getCoords(SourceOrTarget.TARGET);
        if(!lowerMasterPanel.JNIError() && !lowerMasterPanel.engineError())
        {
///            upperMasterPanel.resetAccuracy();
            lowerMasterPanel.reportAccuracy();
        }
        else
            lowerMasterPanel.showErrors(this);
    }
  }//GEN-LAST:event_convertDownActionPerformed

  private void deleteEllipsoidActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteEllipsoidActionPerformed
    // The DeleteDlg class is used for both Delete Ellipsoid and Delete Datum commands.
    new DeleteDlg(this, true, ListType.ELLIPSOID).show();
  }//GEN-LAST:event_deleteEllipsoidActionPerformed

  private void createEllipsoidActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_createEllipsoidActionPerformed
    new CreateEllipsoidDlg(this, true).show();
  }//GEN-LAST:event_createEllipsoidActionPerformed

  private void deleteDatumActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteDatumActionPerformed
    // The DeleteDlg class is used for both Delete Ellipsoid and Delete Datum commands.
    DeleteDlg deleteDatum = new DeleteDlg(this, true, ListType.DATUM);
    deleteDatum.show();
    upperMasterPanel.deleteDatumFromList(deleteDatum.getIndex());
    lowerMasterPanel.deleteDatumFromList(deleteDatum.getIndex());
  }//GEN-LAST:event_deleteDatumActionPerformed

  private void createDatumActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_createDatumActionPerformed
    new CreateDatumDlg(this, true).show();
    upperMasterPanel.addDatumToList();
    lowerMasterPanel.addDatumToList();
  }//GEN-LAST:event_createDatumActionPerformed

  private void editButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_editButtonMouseEntered
    prevFocus = getFocusOwner();
  }//GEN-LAST:event_editButtonMouseEntered

  private void pasteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pasteActionPerformed
    java.awt.Component focus = getFocusOwner();
    if (focus instanceof javax.swing.text.JTextComponent)
        ((javax.swing.text.JTextComponent)focus).paste();
    else
    {
        if (prevFocus instanceof javax.swing.text.JTextComponent)
            ((javax.swing.text.JTextComponent)prevFocus).paste();
    }
  }//GEN-LAST:event_pasteActionPerformed

  private void cutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cutActionPerformed
    java.awt.Component focus = getFocusOwner();
    if (focus instanceof javax.swing.text.JTextComponent)
        ((javax.swing.text.JTextComponent)focus).cut();
    else
    {
        if (prevFocus instanceof javax.swing.text.JTextComponent)
            ((javax.swing.text.JTextComponent)prevFocus).cut();
    }
  }//GEN-LAST:event_cutActionPerformed

  private void copyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_copyActionPerformed
    java.awt.Component focus = getFocusOwner();
    if (focus instanceof javax.swing.text.JTextComponent)
        ((javax.swing.text.JTextComponent)focus).copy();
    else
    {
        if (prevFocus instanceof javax.swing.text.JTextComponent)
            ((javax.swing.text.JTextComponent)prevFocus).copy();
    }
  }//GEN-LAST:event_copyActionPerformed


  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
    new Geotrans().show ();
    return;
  }

  // Test if a 3D conversion is possible
  // If it is, enable the geodetic height fields
  // If it is not, set the geodetic height fields to read only
  public void check3DConversion()
  {
      boolean _3dConversion = false;
      if (upperMasterPanel.getProjectionType() == CoordinateTypes.GEODETIC)
      {
        if ((lowerMasterPanel.getProjectionType() == CoordinateTypes.GEODETIC) || (lowerMasterPanel.getProjectionType() == CoordinateTypes.GEOCENTRIC) || (lowerMasterPanel.getProjectionType() == CoordinateTypes.LOCCART))
        {
            upperMasterPanel.enableHeightComboBox(true);
            upperMasterPanel.selectEllipsoidHeightButton();
           _3dConversion = true;
            upperMasterPanel.setHeightFieldEditable(true);

            if (lowerMasterPanel.getProjectionType() == CoordinateTypes.GEODETIC)
            {
                lowerMasterPanel.enableHeightComboBox(true);
                lowerMasterPanel.selectEllipsoidHeightButton();
                lowerMasterPanel.setHeightFieldEditable(true);
            }
        }
        else
        {
            upperMasterPanel.selectNoHeightButton();
            upperMasterPanel.setHeightText("0");
            upperMasterPanel.setHeightFieldEditable(false);
            upperMasterPanel.enableHeightComboBox(false);
        }
      }
      else if (lowerMasterPanel.getProjectionType() == CoordinateTypes.GEODETIC)
      {
        if ((upperMasterPanel.getProjectionType() == CoordinateTypes.GEOCENTRIC) || (upperMasterPanel.getProjectionType() == CoordinateTypes.LOCCART))
        {
            lowerMasterPanel.enableHeightComboBox(true);
            lowerMasterPanel.selectEllipsoidHeightButton();
            _3dConversion = true;
            lowerMasterPanel.setHeightFieldEditable(true);
        }
        else
        {
            lowerMasterPanel.selectNoHeightButton();
            lowerMasterPanel.setHeightText("0");
            lowerMasterPanel.setHeightFieldEditable(false);
            lowerMasterPanel.enableHeightComboBox(false);
        }
      }
      else if (((upperMasterPanel.getProjectionType() == CoordinateTypes.GEOCENTRIC) || (upperMasterPanel.getProjectionType() == CoordinateTypes.LOCCART)) &&
               ((lowerMasterPanel.getProjectionType() == CoordinateTypes.GEOCENTRIC) || (lowerMasterPanel.getProjectionType() == CoordinateTypes.LOCCART)))
        _3dConversion = true;

      upperMasterPanel.updateSrcErrors(_3dConversion);
      lowerMasterPanel.updateSrcErrors(_3dConversion);
  }

  // Color code the convert buttons based on the current input/output datum & coordinate system combination
  public void checkValidConversion()
  {
      int validColor = jniEngine.JNICheckValidConversion(upperMasterPanel.getProjectionType(), lowerMasterPanel.getProjectionType(),
                                                         upperMasterPanel.getDatumIndex(), lowerMasterPanel.getDatumIndex());
      if(validColor == Red.ID)  // Errors
        currentColor = Red.VALUE;
      else if(validColor == Yellow.ID)  // Warnings
        currentColor = Yellow.VALUE;
      else if(validColor == Green.ID)  // No errors or warnings
        currentColor = Green.VALUE;

      convertUpButton.setBackground(currentColor);
      convertDownButton.setBackground(currentColor);
  }

// Creates projection panels, coordinate & parameter objects,
// and initializes engine via JNI functions.
  private void initialize(){
    boolean error = false;
    options = new jOptions();

    try
    {
        jniEngine.JNIInitializeEngine(); // JNI; calls Initialize_Engine.

        upperMasterPanel = new MasterPanel(ConversionState.INTERACTIVE, SourceOrTarget.SOURCE, options);
        if (upperMasterPanel == null)
        {
            jniStrtoval.displayErrorMsg(this, "Unable to initialize GEOTRANS");
            System.exit (0);
        }

        lowerMasterPanel = new MasterPanel(ConversionState.INTERACTIVE, SourceOrTarget.TARGET, options);
        if (lowerMasterPanel == null)
        {
            jniStrtoval.displayErrorMsg(this, "Unable to initialize GEOTRANS");
            System.exit (0);
        }

        upperMasterPanel.setParent(this);
        lowerMasterPanel.setParent(this);

        check3DConversion();
        checkValidConversion();

        upperPanel.setLayout(new java.awt.GridBagLayout());

       // upperPanel.setMinimumSize(new java.awt.Dimension(160, 265));
     //   upperPanel.setPreferredSize(new java.awt.Dimension(160, 265));
     //   upperPanel.setMaximumSize(new java.awt.Dimension(160, 265));
       /* datumLabel.setMinimumSize(new java.awt.Dimension(270, 16));
        datumLabel.setPreferredSize(new java.awt.Dimension(270, 16));*/
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
      //  gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        //gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 9);
        upperPanel.add(upperMasterPanel, gridBagConstraints);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        lowerPanel.add( lowerMasterPanel, gridBagConstraints );

        //upperPanel.add( upperMasterPanel, java.awt.GridBagLayout);
//        upperPanel.add( upperMasterPanel, java.awt.BorderLayout.CENTER);
      //  lowerPanel.add( lowerMasterPanel, java.awt.BorderLayout.CENTER );
    }
    catch(GeotransError e)
    {
        jniStrtoval.displayErrorMsg(this, e.getMessage());
        error = true;
    }
    catch (java.lang.UnsatisfiedLinkError e)
    {
        jniStrtoval.displayErrorMsg(this, "Unsatisfied Link Error: " + e.getMessage());
        error = true;
    }

    if (error)
        System.exit (0);
  }

  private void resetLookAndFeel()
  {
      if (currLookAndFeel.equals("Java"))
        metalRadioButtonMenuItem.setSelected(true);
      else if (currLookAndFeel.equals("Unix"))
        unixRadioButtonMenuItem.setSelected(true);
      else if (currLookAndFeel.equals("Windows"))
        windowsRadioButtonMenuItem.setSelected(true);
  }


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JMenuItem aboutMenuItem;
  private javax.swing.JMenuItem contentsMenuItem;
  private javax.swing.JButton convertDownButton;
  private javax.swing.JMenuItem convertDownMenuItem;
  private javax.swing.JMenu convertMenu;
  private javax.swing.JSeparator convertMenuSeparator;
  private javax.swing.JPanel convertPanel;
  private javax.swing.JButton convertUpButton;
  private javax.swing.JMenuItem convertUpMenuItem;
  private javax.swing.JButton copyButton;
  private javax.swing.JMenuItem copyMenuItem;
  private javax.swing.JMenuItem createDatumMenuItem;
  private javax.swing.JMenuItem createEllipsoidMenuItem;
  private javax.swing.JMenuItem createFileHeaderMenuItem;
  private javax.swing.JButton cutButton;
  private javax.swing.JMenuItem cutMenuItem;
  private javax.swing.JMenu datumMenu;
  private javax.swing.JMenuItem deleteDatumMenuItem;
  private javax.swing.JMenuItem deleteEllipsoidMenuItem;
  private javax.swing.JMenu editMenu;
  private javax.swing.JMenu ellipsoidMenu;
  private javax.swing.JMenuItem exitMenuItem;
  private javax.swing.JMenu fileMenu;
  private javax.swing.JSeparator fileMenuSeparator;
  private javax.swing.JButton formatButton;
  private javax.swing.JMenuItem formatMenuItem;
  private javax.swing.JMenuBar geotransMenuBar;
  private javax.swing.JToolBar geotransToolBar;
  private javax.swing.JSeparator geotransToolBarSeparator;
  private javax.swing.JMenu helpMenu;
  private javax.swing.JSeparator helpMenuSeparator;
  private javax.swing.JMenu lookAndFeelMenu;
  private javax.swing.JPanel lowerPanel;
  private javax.swing.JRadioButtonMenuItem metalRadioButtonMenuItem;
  private javax.swing.JMenuItem openMenuItem;
  private javax.swing.JMenu optionsMenu;
  private javax.swing.JButton pasteButton;
  private javax.swing.JMenuItem pasteMenuItem;
  private javax.swing.JMenuItem restoreDefaultMenuItem;
  private javax.swing.JMenuItem saveAsDefaultMenuItem;
  private javax.swing.JRadioButtonMenuItem unixRadioButtonMenuItem;
  private javax.swing.JPanel upperPanel;
  private javax.swing.JRadioButtonMenuItem windowsRadioButtonMenuItem;
  // End of variables declaration//GEN-END:variables

} //end of Geotrans class.

