/*
** 1998-05-19 -	Header file for the text viewing module. Real complex.
** 1999-03-02 -	Completely redesigned interface. Now uses a (rather) opaque
**		GTK+ widget. Makes life easier for the cmdgrab module.
*/

#if !defined TEXTVIEW_H
#define TEXTVIEW_H

/* Open and return a pointer to a text viewing window. The only thing the caller
** is allowed to assume about it is that it is a GTK+ window widget. Its GTK+
** user data slot is used internally by the txv module, so keep out! Also, it's
** not a good idea to destroy it by any other means than calling txv_close() on it.
*/
GtkWidget *	txv_open(MainInfo *min, const gchar *label);

void		txv_show(GtkWidget *textviewer);

/* Use this to connect a "key_press_event" handler on the window. Call with
** <func>==NULL to reset internal handler.
*/
guint		txv_connect_keypress(GtkWidget *wid, GtkSignalFunc func, gpointer user);

void		txv_set_label(GtkWidget *wid, const gchar *text);

void		txv_freeze(GtkWidget *wid);
void		txv_thaw(GtkWidget *wid);

void		txv_put_text(GtkWidget *wid, const gchar *text, gint length);
int		txv_load_text(GtkWidget *wid, const gchar *name, gboolean use_mmap, gsize buf_size);
int		txv_load_text_hex(GtkWidget *wid, const gchar *name);

void		txv_enable(GtkWidget *wid);

void		txv_close(GtkWidget *wid);

#endif		/* TEXTVIEW_H */
