/*
** 1998-05-25 -	Header file for the dirpane module. Deals with all aspects of
**		directory panes. Since those are very central to this program,
**		there's quite a lot to deal with.
*/

DirPane *	dp_mirror(MainInfo *min, DirPane *dp);
const gchar *	dp_full_name(DirPane *dp, gint row);
const gchar *	dp_name_quoted(DirPane *dp, gint row, guint path);

void		dp_show_stats(DirPane *dp);
void		dp_update_stats(DirPane *dp);
gboolean	dp_activate(DirPane *dp);

void		dp_resort(DirPane *dp);
void		dp_redisplay(DirPane *dp);
void		dp_redisplay_preserve(DirPane *dp);

void		dp_unfocus(DirPane *dp);
void		dp_focus(DirPane *dp, gint row);

gint		dp_has_selection(DirPane *dp);
gint		dp_is_selected(DirPane *dp, DirRow *row);

GSList *	dp_get_selection(DirPane *dp);
GSList *	dp_get_selection_full(DirPane *dp);
#if 0
void		dp_print_selection(DirPane *dp, const gchar *tag);
#endif
void		dp_free_selection(GSList *sel);

void		dp_enter_dir(DirPane *dp, const gchar *path);
void		dp_rescan(DirPane *dp);

void		dp_freeze(DirPane *dp);
void		dp_thaw(DirPane *dp);

void		dp_dbclk(DirPane *dp);
void		dp_dbclk_row(DirPane *dp, gint row);

void		dp_select(DirPane *dp, gint row);
void		dp_select_all(DirPane *dp);
void		dp_unselect(DirPane *dp, gint row);
void		dp_unselect_all(DirPane *dp);
void		dp_toggle(DirPane *dp, gint row);

GtkWidget *	dp_build(MainInfo *min, DPFormat *fmt, DirPane *dp);
