/*
** 2001-08-18 -	Configuration handling for the error reporting stuff. Small.
*/

#include "gentoo.h"

#include "cfg_module.h"

#include "cfg_errors.h"

#define	NODE	"Errors"

/* ----------------------------------------------------------------------------------------- */

typedef struct {
	GtkWidget	*vbox;
	GtkWidget	*dialog;

	MainInfo	*min;
	ErrInfo		edit;
	gboolean	modified;
} P_Errors;

static P_Errors	the_page;

/* ----------------------------------------------------------------------------------------- */

static void evt_dialog_toggled(GtkWidget *wid, gpointer user)
{
	((P_Errors *) user)->modified = TRUE;
}

static GtkWidget * cer_init(MainInfo *min, gchar **name)
{
	P_Errors	*page = &the_page;

	if(name == NULL)
		return NULL;

	*name = _("Errors");

	page->min = min;
	page->modified = FALSE;

	page->vbox = gtk_vbox_new(FALSE, 0);

	page->dialog = gtk_check_button_new_with_label(_("Use Dialog to Report Errors?"));
	gtk_signal_connect(GTK_OBJECT(page->dialog), "toggled", GTK_SIGNAL_FUNC(evt_dialog_toggled), page);
	gtk_box_pack_start(GTK_BOX(page->vbox), page->dialog, FALSE, FALSE, 0);

	gtk_widget_show_all(page->vbox);
	return page->vbox;
}

/* ----------------------------------------------------------------------------------------- */

static void cer_update(MainInfo *min)
{
	P_Errors	*page = &the_page;

	page->edit = min->cfg.errors;
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(page->dialog), page->edit.dialog);
	page->modified = FALSE;
}

/* ----------------------------------------------------------------------------------------- */

static void cer_accept(MainInfo *min)
{
	P_Errors	*page = &the_page;

	if(!page->modified)
		return;
	/* We have very little widget state, so just grab it right here. */
	page->edit.dialog = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(page->dialog));
	min->cfg.errors = page->edit;
	page->modified = FALSE;
}

/* ----------------------------------------------------------------------------------------- */

static gint cer_save(MainInfo *min, FILE *out)
{
	xml_put_node_open(out, NODE);
	xml_put_boolean(out, "dialog", min->cfg.errors.dialog);
	xml_put_node_close(out, NODE);

	return TRUE;
}

static void cer_load(MainInfo *min, const XmlNode *node)
{
	const XmlNode	*root;

	if((root = xml_tree_search(node, NODE)) != NULL)
	{
		gboolean	tmp;

		if(xml_get_boolean(root, "dialog", &tmp))
			min->cfg.errors.dialog = tmp;
	}
}

/* ----------------------------------------------------------------------------------------- */

CfgPage * cer_describe(MainInfo *min)
{
	static CfgPage	desc = { NODE, cer_init, cer_update, cer_accept, cer_save, cer_load, NULL };

	return &desc;
}
