static char rcsid[] = "$Id: h_init.c,v 1.9 1997/08/08 19:21:32 dhb Exp $";

/* Version EDS21e 97/05/05, Erik De Schutter, Caltech & BBF-UIA 4/94-5/97 */
/* Original version by Upi Bhalla, Caltech 1991 */

/*
** $Log: h_init.c,v $
** Revision 1.9  1997/08/08 19:21:32  dhb
** Removed extraneous backslash in printf string.  Causes some compilers
** to warn of unknown escape in string.
**
** Revision 1.8  1997/07/31 23:27:10  dhb
** Change working element to hsolve during search of hsolve path.
** This allows hsolve SETUP to be called when hsolve is not the
** workig element.
**
** Revision 1.7  1997/05/28 22:40:02  dhb
** Replaced with version from Antwerp GENESIS
**
 * Revision 1.6  1995/08/01  19:29:03  dhb
 * Changes from Erik DeSchutter described below.
 *
 * Revision 1.5  1995/05/11  23:02:21  dhb
 * Fixed call to ElementPath() which should have been Pathname().
 *
 * Revision 1.4  1995/05/11  20:29:47  dhb
 * h_init() now check that the hsolve path matches one or more elements
 * and issues an appropriate error message if no elements are matched.
 *
 * Revision 1.3.1.1  1995/08/01  18:45:03  dhb
 * Changes from Erik DeSchuter described below.
 *
** Revision 1.4  1994/03/22 eds
 * Included special code for INJECT/EREST msg in chanmode 0/1
 *
 * Revision 1.3  1993/06/29  19:13:28  dhb
 * Modified for extended objects.  Uses base object rather than extended
 * object as basis for inclusion in hines processing.
 *
 * Revision 1.2  1992/10/29  16:45:43  dhb
 * Changed explicit looping over msgins to use MSGLOOP macro.  Reindented
 * affected area.
*/

#include "hines_ext.h"

int h_init(hsolve)
	Hsolve	*hsolve;
{
	GenesisObject *baseobject;
	ElementList *list;
	int 	ncompts;
	Element	**compts;
	Element	*compt,*kid;
	int 	i,j,k;
	MsgIn	*msgin;
	int		hnumcount;
	int		*parents,**kids,*nkids,*elmnum,*hnum;
	int		temp,parentno,valueno,nvalues;
	int		*diag,*cip,*ri;
	int		chanmode,symflag;
	Element *elm;
	Element *saveelm;

	chanmode=hsolve->chanmode;
	if (hsolve->readflag < HREAD_T) { /* standard initialization */
	    if (!(hsolve->path)) {
		Error();
		printf(" during SETUP of %s: no path defined.\n",Pathname(hsolve));
		return(ERR);
	    }
	    saveelm = WorkingElement();
	    SetWorkingElement(hsolve);
		list = WildcardGetElement(hsolve->path,0);
	    SetWorkingElement(saveelm);

	    hsolve->ncompts = ncompts = list->nelements;
	    hsolve->compts = compts =  list->element;
	    if (list->nelements <= 0) {
		Error();
		printf(" during SETUP of %s: no elements match path.\n",Pathname(hsolve));
		return(ERR);
	    }
	} else {
	    ncompts=hsolve->ncompts;
	}
	if (ncompts==0) {
	    elm=WorkingElement();
	    Error();
	    printf(" during SETUP of %s: empty path.\n",Pathname(hsolve));
	    return(ERR);
	}
	hsolve->parents = parents = (int *)calloc(ncompts, sizeof(int));
	hsolve->nkids = nkids = (int *)calloc(ncompts, sizeof(int));
	hsolve->kids = kids = (int **)calloc(ncompts, sizeof(int *));
	hsolve->hnum = hnum = (int *)calloc(ncompts,sizeof(int));
	hsolve->elmnum = elmnum = (int *)calloc(ncompts,sizeof(int));
	if (chanmode<2) hsolve->msgcompts = (short *)calloc(ncompts,sizeof(short));
	hsolve->outinfo = NULL;

	symflag = hsolve->symcomparts;
	baseobject = (GenesisObject *) BaseObject(compts[0]);
	if (hsolve->readflag==HREAD_T) { /* called by readsolve */
	    /*
	    if (init_hparents(hsolve))
		    return(ERR);
	    */
	} else { 			/* called by SETUP */
	    if ((!symflag && (strcmp(baseobject->name,"compartment") != 0)) ||
		(symflag && (strcmp(baseobject->name,"symcompartment") != 0))) {
		Error();
		printf(" during SETUP of %s: type '%s' not supported as path.\n",Pathname(hsolve),baseobject->name);
		return(ERR);
	    }
	}

	/* AXIALs go from parent to kid compts */
	for (i=0;i<ncompts;i++){
	    compt = compts[i];
	    /* disable element to prevent it from doing anything. */
	    HsolveBlock(compt);
	    parents[i] = -1;
	    if (chanmode<2) hsolve->msgcompts[i]=0; /* default */
	    MSGLOOP(compt, msgin) {
		/* look for parent compts */
		default:
		    if (strcmp(BaseObject(msgin->src)->type,"compartment_type")==0
			&& msgin->type == AXIAL) {
			for (j=0;j<ncompts;j++) {
			    if (msgin->src == compts[j]) {
			    /* the jth elment is a parent of the ith element */
				if (parents[i] != -1) {
				    Error();
				    printf(" during SETUP of %s: multiple parents for compartment '%s[%d]'.\n",Pathname(hsolve),compt->name,compt->index);
				    return(ERR);
				}
				parents[i] = j;
				nkids[j] += 1;
				break;
			    }
			}
		    } else if ((chanmode<2) && (msgin->type > AXIAL)) {
			/* we need to update internal fields in compartment */
			(hsolve->msgcompts[i])++;
		    }
		break;
	    }
	}
	/* Fill in indices for kids */
	for (i=0;i<ncompts;i++){
	    k=0;
	    if (nkids[i] == 0) {
		kids[i] = NULL; /* a terminal branch */
	    } else {
		kids[i]=(int *)calloc(nkids[i],sizeof(int));
		for (j=0;j<ncompts;j++) {
		    if (parents[j] == i) {
			kids[i][k] = j;
			k++;
		    }
		}
	    }
	}

	/* find the soma */
	for (i=0;i<ncompts;i++){
	    if (parents[i] == -1) {
	    /* This is the trunk element. Usually it will be the soma */
		hnumcount = ncompts-1;
		/* Do Hines numbering */
		do_hnum(hsolve,i,&hnumcount,elmnum);
		break;
	    }
	}
	/* count the coeffs */
	nvalues=1; /* since we start at the root elm */
	for (i=0;i<ncompts;i++){
	    /* Count all the kids */
	    nvalues += nkids[i];
	    /* Checking if this is the soma */
	    if (parents[i] != -1) {
		if (symflag)
		    /* Count all the siblings, including self */
		    nvalues += nkids[parents[i]];
		else
		    /* only count self */
		    nvalues++;
		/* count the parent */
		nvalues++;
	    }
	}
	/* allocate the matrices handling the coeffs */
	hsolve->nvalues=nvalues;
	hsolve->ri = ri = (int *)calloc(nvalues+1,sizeof(int));
	hsolve->cip = cip = (int *)calloc(ncompts + 1,sizeof(int));
	hsolve->diag = diag = (int *)calloc(ncompts+1,sizeof(int));
	if (hsolve->numnodes==0) {	/* uniprocessor mode */ 
	    hsolve->values=(double *)calloc(nvalues,sizeof(double));
	}
	/* figure out the indices for the coeffs */
	valueno = 0;
	/* Set up matrices indexing the values matrix */
	for (i=0;i<ncompts;i++){
	    cip[i] = valueno;
	    j = elmnum[i]; /* j is the index, i is the hnum of the elm */
	    /* scanning thru kids. Remember, the Hines numbering was
	    ** in decreasing order */
	    for (k=nkids[j]-1;k>=0;k--) {
		ri[valueno++]=hnum[kids[j][k]];
	    }
	    if ((parentno = parents[j]) != -1) {
		/* scanning thru siblings */
		for (k=nkids[parentno]-1;k>=0;k--) {
		    temp=hnum[kids[parentno][k]];
		    if (temp == i) { /* diagonal element */
			diag[i] = valueno;
			ri[valueno++]=temp;
		    } else if (symflag) {
			/* include siblings if it is a symmetric compt */
			ri[valueno++]=temp;
		    }
		}
		/* a coeff for the parent */
		ri[valueno++]=hnum[parentno];
	    } else {
		    /* a coeff for the root element */
		    ri[valueno++]=i;
	    }
	    /* A little sort routine, which will be needed only for a few
	    ** rows, to ensure that the order of the coeffs is correct */
	    bubble_sort(&ri[cip[i]],valueno - cip[i]);
	}
	if (valueno != nvalues) {
		Error();
		printf(" during SETUP of %s: bug in assigning coeffs.\n",Pathname(hsolve));
		return(ERR);
	}
	diag[ncompts-1]=nvalues-1;
	diag[ncompts]=nvalues;
	cip[ncompts] = nvalues;
	ri[nvalues] = ncompts;
	return(0);
}

int h2_init(hsolve)
	Hsolve	*hsolve;
{
	int ncompts;

	ncompts=hsolve->ncompts;
	hsolve->vm = (double *) calloc(ncompts,sizeof(double));
	if (hsolve->numnodes==0) {	/* uniprocessor mode */ 
	    if (hsolve->chanmode>=2) {	/* diag also stored in results */
		hsolve->results=(double *)calloc(2*ncompts,sizeof(double));
	    } else {
		hsolve->results=(double *)calloc(ncompts,sizeof(double));
	    }
	}
	return(0);
}


chip_hcalc_init(hsolve)
/* initializes values array */
	Hsolve	*hsolve;
{
	int	nvalues = hsolve->nvalues;
	int	ncompts = hsolve->ncompts;
	double *values,*chip,*origchip;
	int	 *cip,*ri,*elmnum,*parents,*compchips;
	struct channelA_type *ch; /* basic channel */
	int i,j,k,nchip,duplicate_flag;
	int comptindex,linkindex;
	double	dt,diagterm,tbyc;
	struct compartment_type *compt,*link,**compts;

	duplicate_flag=hsolve->readflag==HDUPLICATE_T;
	if (duplicate_flag) {
	    origchip=hsolve->origsolve->chip;
	} else {
	    cip = hsolve->cip;
	    ri = hsolve->ri;
	    elmnum = hsolve->elmnum;
	    parents = hsolve->parents;
	    compts = (struct compartment_type **)hsolve->compts;

	    if (BaseObject(hsolve)->method == CRANK_INT)
		dt = hsolve->dt/2.0;
	    else /* BEULER by default */
		dt = hsolve->dt;
	    
	    values = hsolve->values;
	    for(i=0;i<nvalues;i++) *values++=0.0;
	    values = hsolve->values;
	}
	chip = hsolve->chip;
	compchips = hsolve->compchips;

	for(i=0;i<ncompts;i++) {
	    if (!duplicate_flag) {
		comptindex=elmnum[i];
		compt = compts[comptindex];
		tbyc=dt/compt->Cm;

		diagterm = 0.0;

		for(j=cip[i];j<cip[i+1];j++){
		    /* finding the column number */
		    k=ri[j];
		    /* Diagonal element */
		    linkindex=elmnum[k];
		    link=compts[linkindex];
		    if (i==k) {
			diagterm += 1.0 + tbyc/compt->Rm;
		    } else {
			if (parents[linkindex]==comptindex) {
			    /* Child elements */
			    diagterm -= (values[j]= -tbyc/link->Ra);
			} else {
			    /* parent element */
				diagterm -= (values[j]= -tbyc/compt->Ra);
			}
		    }
		}
	    }
	    /* values[diag[i]]=diagterm; */
	    if (i==ncompts-1) {
		nchip=hsolve->nchips-1;
	    } else {
		nchip=compchips[i+1]-1;
	    }
	    if (duplicate_flag) {
		chip[nchip]=origchip[nchip];
	    } else {
		chip[nchip]=diagterm;
	    }
	}
}

bubble_sort(array,nterms)
	int	*array;
	int nterms;
{
	int temp;
	int i;
	int	flag=1;

	while(flag) {
	    flag=0;
	    for(i=1;i<nterms;i++) {
		if (array[i-1]>array[i]) {
		    temp = array[i-1];
		    array[i-1] = array[i];
		    array[i] = temp;
		    flag=1;
		}
	    }
	}
}

/* Doing hines numbering */
do_hnum(hsolve,comptno,hnum,elmnum)
	Hsolve	*hsolve;
	int		comptno;
	int		*hnum;
	int		*elmnum;
{
	int i;
	int kidno;

	hsolve->hnum[comptno]= *hnum;
	elmnum[*hnum]=comptno;
	*hnum -= 1;
	for(i=0;i<hsolve->nkids[comptno];i++) {
	    /* Numbering kids of this elm which have no kids of their own */
	    kidno = hsolve->kids[comptno][i];
	    if (hsolve->nkids[kidno]==0) {
		hsolve->hnum[kidno] = *hnum;
		elmnum[*hnum]=kidno;
		*hnum -= 1;
	    }
	}
	for(i=0;i<hsolve->nkids[comptno];i++) {
	    /* Numbering kids of this elm which do have kids of their own */
	    kidno = hsolve->kids[comptno][i];
	    if (hsolve->nkids[kidno]>0) {
		do_hnum(hsolve,kidno,hnum,elmnum);
	    }
	}
}


/* This routine sets up the func array for fast solution of the 
** sparse matrix. It does this in two passes : first, it finds
** the number of functions, second it fills them up.  */
/* chanmode 0/1 version: diag elements in values array */
int do_fast_hsetup(hsolve)
	Hsolve	*hsolve;
{
	int i,j,k;
	int	row;
	int	ind1,ind2,ind3;
	int	ncompts;
	int	*ri,*cip,*diag;
	double resultvalue,diavalue,temp;
	int get_index();
	int	nextcip,di,cipnextrow;
	int	cipi,drow;
	int	justcount;
	int	nfuncs=0;
	int	*funcs;

	ncompts=hsolve->ncompts;
	ri=hsolve->ri;
	cip=hsolve->cip;
	diag=hsolve->diag;

	if (hsolve->nfuncs > 0) {
	    justcount = 0;
	    if (hsolve->funcs) {
		funcs=hsolve->funcs;
	    } else {
		hsolve->funcs=funcs=(int *)calloc(hsolve->nfuncs,sizeof(int));
	    }
	} else {
	    justcount = 1;
	}


	/* looping over all rows, doing forward substitution */
	for(i=0;i<ncompts;i++) {
	    di=diag[i];
/*		diavalue = values[di];		*/
/*		resultvalue=results[i];		*/
	    if(justcount){
		if (i==0) {
		    nfuncs+=1;
		} else {
		    nfuncs+=2;
		}
	    } else {
		if (i>0) funcs[nfuncs++]=SET_DIAG;
		funcs[nfuncs++]=di;		/* always a diag term */
	    }
	    di++;
	    nextcip=cip[i+1];
	    /* Looping over all coupled rows */
	    for (j=di;j<nextcip;j++) {
		row=ri[j]; /* since the matrix is symmetrical, the ri also
			  ** gives the correct row index */
		cipnextrow=cip[row+1];
		for (ind1=cip[row];ind1<cipnextrow;ind1++)
		  if (ri[ind1]==i) {
			/* calculate scaling factor */
/*				temp = values[ind1]/diavalue;		*/
/*				results[row] -= resultvalue*temp;	*/
		    if(justcount){
			nfuncs+=3;
		    } else {
			funcs[nfuncs++]=SCALE;
			funcs[nfuncs++]=ind1;
			funcs[nfuncs++]=row;	/* results array */
		    }
		    /* looping over all nonzero columns for _ith_ row */
		    for (ind2=di,ind3=ind1+1;ind2<nextcip;ind2++){
			for (;ri[ind3]!=ri[ind2];ind3++) {
			    if(ind3>=cipnextrow) {
				/* a major screw-up */
				Error();
				printf(" during SETUP of %s: bug in forward elim.\n",Pathname(hsolve));
				return(ERR);
			    }
			}
			/* Otherwise, proceed with elimination */
/*					values[ind3] -= values[ind2]*temp */
			if (justcount){
			    nfuncs+=3;
			} else {
			    funcs[nfuncs++]=FORWARD_ELIM;
			    funcs[nfuncs++]=ind3;	/* always a diag term */
			    funcs[nfuncs++]=ind2;
			}
		    }
		}
	    }
	}
	/* looping over all rows, doing backwards elimination */
	for (i=ncompts-1;i>=0;i--) {
	    di=diag[i];
	    cipi=cip[i];
/*		results[i] = temp = results[i]/values[di];		*/
	    if(justcount){
		nfuncs+=2;
	    } else {
		funcs[nfuncs++]=CALC_RESULTS;
		funcs[nfuncs++]=diag[i];	/* always a diag term */
	    }
	    for(j=di-1;j>=cipi;j--) {
		/* since the matrix is symmetrical, the ri also
	        ** gives the correct row index */
		drow=diag[row=ri[j]];
		for (ind1=cip[row+1]-1;ind1>drow;ind1--) {
		    if (ri[ind1]==i) {
/*					results[row] -= values[ind1]*temp; */
			if (justcount){
				nfuncs+=3;
			} else {
			    funcs[nfuncs++]=BACKWARD_ELIM;
			    funcs[nfuncs++]=row;	/* results array */
			    funcs[nfuncs++]=ind1;
			}
		    }
		}
	    }
	}
	if(justcount){
	    nfuncs++;
	    hsolve->nfuncs=nfuncs;
	} else {
	    funcs[nfuncs++]=FINISH;
	}
	return(0);
}
