/* $Id: Gif.c,v 1.3 1995/04/27 21:40:03 venkat Exp $ */
/* $Log: Gif.c,v $
 * Revision 1.3  1995/04/27 21:40:03  venkat
 * Commented call to free the filename resource in the Destroy
 * method. XtDestroyWidget() takes care of freeing the resources
 * that are allocated by calls to XtSetValues() etc.,
 *
 * Revision 1.2  1995/03/17  20:39:57  venkat
 * Merged
 *
 * Revision 1.1  1994/02/02  18:49:54  bhalla
 * Initial revision
 * */
/* This was a start on the GIF pix.  I stopped working on it to
 * work on the standalone image widget.
 */





#include <math.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "Xo/XoDefs.h"
#include "CoreDrawP.h"
#include "GifP.h"
/* #define PURIFY_RUN */

#define offset(field) XtOffset(GifObject, gif.field)
static XtResource resources[] = {

    {XtNfilename, XtCFilename, XtRString, sizeof(char *),
		offset(filename), XtRString, "image.gif"
    },
    {XtNfileformat, XtCFileformat, XtRString, sizeof(char *),
        offset(fileformat), XtRString, "gif"
    },
    {XtNstoremode, XtCStoremode, XtRString, sizeof(char *),
        offset(storemode), XtRString, "mem"
    },
    {XtNrescaleable, XtCRescaleable, XtRBoolean, sizeof(int),
        offset(rescaleable), XtRString, "FALSE"
    },
    {XtNvalue, XtCValue, XtRString, sizeof(char *),
        offset(value), XtRString, "none"
    },
    {XtNsrcx, XtCSrcx, XtRInt, sizeof(int),
        offset(srcx), XtRString, "0"
    },
    {XtNsrcy, XtCSrcy, XtRInt, sizeof(int),
        offset(srcy), XtRString, "0"
    },
    {XtNdstx, XtCDstx, XtRInt, sizeof(int),
        offset(dstx), XtRString, "0"
    },
    {XtNdsty, XtCDsty, XtRInt, sizeof(int),
        offset(dsty), XtRString, "0"
    },
    {XtNwx, XtCWx, XtRInt, sizeof(int),
        offset(wx), XtRString, "100"
    },
    {XtNwy, XtCWy, XtRInt, sizeof(int),
        offset(wy), XtRString, "100"
    },
};

#undef offset


/* methods */

/* I have no idea where Expose is getting defined
*/
#ifdef Expose
#undef Expose
#endif
static void ClassInitialize();
static void ResetGC();
static void Expose();
static void Initialize();
static Boolean SetValues();
static void Destroy();
static void Project();
static XtGeometryResult QueryGeometry();

/* class record definition */


GifClassRec gifClassRec = {
	{			/* RectObj (Core) Fields */

		 /* superclass         */ (WidgetClass) & pixClassRec,
		 /* class_name         */ "Gif",
		 /* size               */ sizeof(GifRec),
		 /* class_initialize   */ ClassInitialize,
		 /* class_part_initialize */ NULL,
		 /* Class init'ed      */ FALSE,
		 /* initialize         */ Initialize,
		 /* initialize_hook    */ NULL,
		 /* realize            */ NULL,
		 /* actions            */ NULL,
		 /* num_actions        */ 0,
		 /* resources          */ resources,
		 /* resource_count     */ XtNumber(resources),
		 /* xrm_class          */ NULLQUARK,
		 /* compress_motion    */ FALSE,
		 /* compress_exposure  */ FALSE,
		 /* compress_enterleave */ FALSE,
		 /* visible_interest   */ FALSE,
		 /* destroy            */ Destroy,
		 /* resize             */ NULL,
		 /* expose             */ Expose,
		 /* set_values         */ SetValues,
		 /* set_values_hook    */ NULL,
		 /* set_values_almost  */ XtInheritSetValuesAlmost,
		 /* get_values_hook    */ NULL,
		 /* accept_focus       */ NULL,
		 /* intrinsics version */ XtVersion,
		 /* callback offsets   */ NULL,
		 /* tm_table           */ NULL,
		 /* query_geometry     */ QueryGeometry,
		 /* display_accelerator */ NULL,
		 /* extension          */ NULL
	},
	{
		/* pix Fields */
		 /* project */ 		Project,
		 /* undraw */		XoInheritUndraw,
		 /* select_distance */ XoInheritSelectDistance,
		 /* select */ 		XoInheritSelect,
		 /* unselect */		XoInheritUnSelect,
		 /* motion */		XoInheritMotion,
		 /* highlight */	XoInheritHighlight,
		 /* extension */ NULL
	},
	{
		/* gif fields */
		 /* make_compiler_happy */ 0
	}
};

WidgetClass gifObjectClass = (WidgetClass) & gifClassRec;

static void 
ResetGC(gif)
GifObject gif;
{
	/* Set the values in the GC */
	XGCValues values;
	XtGCMask mask = GCForeground | GCLineStyle | GCLineWidth;

	if (gif->pix.gc != NULL)
		XtReleaseGC(XtParent((Widget) gif), gif->pix.gc);

	values.foreground = gif->pix.fg;
	gif->pix.gc = XtGetGC(XtParent((Widget) gif), mask, &values);
}

static void 
ClassInitialize()
{

}


static void 
Initialize(req, new)
Widget req, new;
{
	GifObject gif = (GifObject) new;
	CoreDrawWidget dw;
	XGCValues values;
	int i;

	/* Check that the initial values are reasonable */
/*
	gif->pix.gc = NULL;
	gif->gif.filename = NULL;
*/
	gif->gif.image = NULL;
#ifdef PURIFY_RUN
	purify_watch(&(gif->gif.filename));
#endif

	
}



static Boolean 
SetValues(curw, reqw, neww)
Widget curw, reqw, neww;
{
	GifObject curg = (GifObject) curw;
	GifObject newg = (GifObject) neww;
	Boolean ret = False;

	if (strcmp(newg->gif.filename, curg->gif.filename)) {
/*		printf("Load up file: %s\n", newg->gif.filename); */
		LoadImage(newg);
		ret = True;
	}
	/* Any of these changes requires a reprojection of the pix
        ** and a redrawing of the entire draw */
        if (
                newg->pix.tx != curg->pix.tx ||
                newg->pix.ty != curg->pix.ty ||
                newg->pix.tz != curg->pix.tz
                ) {
                Project(newg);
                ret = True;
        }

	return (ret);
}



static void 
Expose(w)
Widget w;
{
	GifObject gw = (GifObject) w;

	GC gc;

	gc = XDefaultGCOfScreen(XtScreen(XtParent(w)));

	if (XtIsRealized(w) && gw->gif.image) {
		XPutImage(XtDisplay(XtParent(w)),XtWindow(XtParent(w)),gc,gw->gif.image,
/* src coords */
			gw->gif.srcx,gw->gif.srcy,
/* dest coords */
			gw->pix.cx - gw->gif.wx/2,gw->pix.cy - gw->gif.wy/2,
/* width and height */
			gw->gif.wx,gw->gif.wy);
	}
}

static void 
Destroy(w)
Widget w;
{
	int i;

	GifObject gw = (GifObject) w;

	XtReleaseGC(XtParent(w), gw->pix.gc);
/*
	if (gw->gif.filename)
	XtFree(gw->gif.filename);
*/

	if (gw->gif.image)
	XtFree(gw->gif.image);
}

/* We dont really need this since the parent widget has complete
** control over the gadget layout */
static XtGeometryResult 
QueryGeometry(w, intended, preferred)
Widget w;
XtWidgetGeometry *intended, *preferred;
{
	GifObject gw = (GifObject) w;

	preferred->x = gw->pix.x;
	preferred->y = gw->pix.y;
	preferred->width = gw->pix.w;
	preferred->height = gw->pix.h;
	if (intended->request_mode & (CWX | CWY | CWWidth | CWHeight)) {
		if (preferred->x == intended->x &&
		    preferred->y == intended->y &&
		    preferred->width == intended->width &&
		    preferred->height == intended->height)
			return (XtGeometryYes);
	}
	else {
		if (preferred->x == gw->pix.x &&
		    preferred->y == gw->pix.y &&
		    preferred->width == gw->pix.w &&
		    preferred->height == gw->pix.h)
			return (XtGeometryYes);
	}
	return (XtGeometryAlmost);
}


static void 
Project(w)
Widget w;
{
  GifObject	pw = (GifObject)w;
  CoreDrawWidgetClass class = (CoreDrawWidgetClass)XtClass(XtParent(w));
  void  (*tpt)();
  int x,y,z;

  if (pw->pix.pixflags & XO_VISIBLE_NOT) return;
  if (pw->pix.pixflags & XO_RESIZABLE_NOT){ /*Freeze size and position*/
        return;
  }
  if (pw->pix.pixflags & XO_PIXELOFFSET) { /* transform using pixels*/
        tpt = PixelTransformPoint;
  } else { /* use standard transformations */
        tpt = class->coredraw_class.transformpt;
  }
 
  /* Calculate offset on screen using parents TransformPoint routine */
  (tpt)(XtParent(w),
    pw->pix.tx,pw->pix.ty, pw->pix.tz,&x,&y,&z);
    pw->pix.cx = x; pw->pix.cy = y; pw->pix.cz=z;

	/* Figure out where the coords for clicks should be */
	pw->pix.w = pw->gif.wx;
	pw->pix.h = pw->gif.wy;
	pw->pix.y = y - pw->gif.wy/2;
	pw->pix.x = x - pw->gif.wx/2;
/* if we were to put x,y at one corner, it would be: */
	/* pw->pix.y = y + pw->gif.wy/2; */
	/*
	pw->pix.x = x;
	pw->pix.y = y;
	*/
}



static LoadImage(w)
GifObject w;
{
	extern XImage	*UpiLoadGIF();
	int	screen;
	extern int Width, Height;
	Widget widg = (Widget) w;
	
	screen = XDefaultScreen(XtDisplay(XtParent(widg)));

/*
	if (w->gif.image && w->gif.filename) {
		XDestroyImage(w->gif.image);
		w->gif.image = NULL;
	}
*/
	w->gif.image = UpiLoadGIF(w->gif.filename,XtDisplay(XtParent(widg)),
		screen);

	w->gif.wx = Width;
	w->gif.wy = Height;

	/* If the user has not specified an explicit hgeom then the following
	 * will take into affect to set the hgeom to the height of the widget.
	 */
/*
	((CoreDrawWidget) XtParent(widg))->core.width = Width;
	((CoreDrawWidget) XtParent(widg))->core.height = Height;
*/


}
