// genesis

// Commands to specify the inputs to the simulation.

/*
 * A more modern GENESIS implentation would replace the script_out object with
 * an extended object based upon a neutral object.  An "addaction" command
 * would be used to define a new PROCESS action.  The function which defines
 * the action for the each_step element would be "do_autosweep".  The main
 * function which steps the simulation "autosweep" would no longer set the
 * command field of a script_out object.
 */

float bar_x,bar_y,bar_w,bar_h,bar_dx,bar_dy
float baserate = 10  // spikes/sec

/* 
 * Bar generates a bar-shaped pattern of activity in the 
 * retina rec cells.
 *
 * rate is in spikes/sec
 */

function bar(x,y,w,h,rate)
    float x,y,w,h,rate
    float x1,y1,x2,y2

    x1 = x - w/2
    y1 = y - h/2
    x2 = x + w/2
    y2 = y + h/2

    /* 
     * Here we are using advanced wildcarding features to create a list
     * of elements to be used (by the setfield command)  based on their
     * x and y positions. 
     */

    setfield /retina/recplane/rec[x>{x1}][y>{y1}][x<{x2}][y<{y2}]/input \
	     rate {rate}
end


// Sweeps a bar across the visual field; bar_x and bar_y are
// incremented every time this function is called.

function do_autosweep
    setfield /retina/recplane/rec[]/input rate {baserate}
    bar_x = bar_x + bar_dx;
    bar_y = bar_y + bar_dy;
    bar {bar_x} {bar_y} {bar_w} {bar_h} {getfield /control/bar_firing_rate value}
end


// a dummy function

function do_nothing
end


/* 
 * Autosweep calculates the parameters for the bar and sweep rate, then
 * causes the simulator to step the appropriate number of times, then
 * cleans up. 
 */

function autosweep(direction, widget)
    str direction // vertical or horizontal
    str widget
    float vel 
    int	nsteps
    vel = {getfield {widget} value}
    nsteps = {REC_NX / vel - 1}

    if ({strcmp {direction} "vertical"} == 0)
      bar_x = {-0.5 * REC_NX * REC_SEPX}
      bar_y = 0
      bar_w = {2 * REC_SEPX}  
      bar_h = {(REC_NY + REC_SEPX) * REC_SEPY}
      bar_dx = {REC_SEPX * vel}
      bar_dy = 0
    else // horizontal 
      bar_x  = 0
      bar_y  = {-0.5 * REC_NX * REC_SEPX}
      bar_w  = {(REC_NY + REC_SEPX) * REC_SEPY}
      bar_h  = {2 * REC_SEPX}  
      bar_dx = 0
      bar_dy = {REC_SEPX * vel}
      setfield /output/each_step command do_autosweep
    end

    setfield /output/each_step command do_autosweep
    reset
    echo sweeping {direction} bar across {REC_NX} cells in {nsteps} timesteps
    step {nsteps}
    echo finished {nsteps} steps
    setfield /output/each_step command do_nothing
    call /output/each_step RECALC 
    /*
     * Setting the command does not change the actual command stored,
     * so we force the change using the RECALC. To be fixed !! 
     */
end


// The script_out elements execute the script defined in their 'command'
// field every timestep. 

create   script_out /output/each_step 
setfield /output/each_step command do_nothing

/* 
 * If we change the clock used by a script_out element to one with another
 * period, we can get commands executed different rates. Here, 
 * clock 1 starts up at 1/10 the simulation clock rate so the script
 * is executed every 10 timesteps 
 */

create script_out /output/refresh_out
setfield /output/refresh_out command do_refresh
useclock /output/refresh_out 1
