//genesis
/**********************************************************************
** This program is part of kinetikit and is
**           copyright (C) 1995-1997 Upinder S. Bhalla.
** It is made available under the terms of the GNU General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/


/******************************************************************
      Stuff for connecting xtabs
	  For now we will restrict their action to pools and
	  other xtabs.
******************************************************************/

// Attaches the xtab to a pool
function xtab_to_pool_add(xtab,pool)
	str xtab,pool
	int is_running = {getfield {xtab} is_running}
	int slave_enable = {getfield {pool} slave_enable} & 4

	if (is_running == 3)
		slave_enable = slave_enable | 2
	end
	if (is_running == 1)
		slave_enable = slave_enable | 1
	end
		
	echo in xtab_to_pool_add with {xtab}, {pool}
	addmsg {xtab} {pool} SLAVE output
	setfield {pool} slave_enable {slave_enable}
	call /edit/draw/tree RESET
end

// Detaches the xtab from the pool
// This assumes that only 1 xtab at a time goes to a pool,
// since it disables slaving
function xtab_to_pool_drop(xtab,pool)
	str xtab,pool
	int slave_enable = {getfield {pool} slave_enable} & 4
	
	echo in xtab_to_pool_drop with {xtab}, {pool}
	deletemsg {pool} 0 -find {xtab} SLAVE
	setfield {pool} slave_enable {slave_enable}
	call /edit/draw/tree RESET
end

// Attaches the xtab to a xtab
function xtab_to_xtab_add(src,dest)
	str src,dest
	
	echo in xtab_to_xtab_add with {src}, {dest}
	addmsg {src} {dest} INPUT output
	call /edit/draw/tree RESET
end

// Detaches the xtab from the xtab
// since it disables slaving
function xtab_to_xtab_drop(src,dest)
	str src,dest
	
	echo in xtab_to_xtab_drop with {src}, {dest}
	deletemsg {dest} 0 -find {src} INPUT
	call /edit/draw/tree RESET
end

// Attaches a pool to a xtab for saving output for ascii dumps
function pool_to_xtab_add(src,dest)
	str src,dest

	fieldname = {getfield {src} plotfield}
	
	echo in pool_to_xtab_add with {src}, {dest}
	addmsg {src} {dest} INPUT {fieldname}
	setfield {dest} step_mode 3 // This does buffering
	call /edit/draw/tree RESET
end

// Detaches the pool from the xtab
function pool_to_xtab_drop(src,dest)
	str src,dest
	
	echo in pool_to_xtab_drop with {src}, {dest}
	deletemsg {dest} 0 -find {src} INPUT
	setfield {dest} step_mode 1 // This loops. It is the default.
	call /edit/draw/tree RESET
end

/******************************************************************
      Stuff for editing xtab
******************************************************************/

function make_xtab_sine
	echo NYI
end

function make_flatline
	str xtab = {getfield /parmedit/xtab elmpath}
	setfield {xtab} table ==={getfield {xtab} baselevel}
	setfield /parmedit/xtab2/tabform/shape \
			ypts {xtab}/table
	xupdate /parmedit/xtab2/tabform
end

/* assumes that the current directory is the same as the xtabinfo,
** and that the name is current */
function do_update_xtabinfo
	str xtab = {getfield /parmedit/xtab elmpath}

	if ({getfield {xtab} alloced} == 0)
		call {xtab} TABCREATE 100 0 100
	end

	setfield /parmedit/xtab/path value {getpath {xtab} -head}
	setfield /parmedit/xtab/name value {getpath {xtab} -tail}
	setfield /parmedit/xtab2/path value {getpath {xtab} -head}
	setfield /parmedit/xtab2/name value {getpath {xtab} -tail}
	setfield /parmedit/xtab2/tabform/shape ypts {xtab}/table
	/* need to have auto resizing of graph here */
	xupdate /parmedit/xtab2/tabform
	setfield /parmedit/xtab2/baselevel value {getfield {xtab} baselevel}
	setfield /parmedit/xtab/is_running state {({getfield {xtab} is_running} & 1) > 0}
	setfield /parmedit/xtab2/n_or_conc state {({getfield {xtab} is_running} & 2) > 0}

	float tabwidth = {getfield {xtab} table->xmax} - {getfield {xtab} table->xmin}
	if ({getfield {xtab} stepsize} > 0)
		setfield /parmedit/xtab/loop_duration value \
			{tabwidth * SIMDT / {getfield {xtab} stepsize}}
	else 
		setfield /parmedit/xtab/loop_duration value {tabwidth}
	end

	setfield /parmedit/xtab/notes initialtext {getfield {xtab} notes}
	setfield /parmedit/xtab/color value {getfield {xtab} xtree_fg_req}

end

function set_xtab_slave_enables
	str xtab = {getfield /parmedit/xtab elmpath}
	int do_stim = {getfield /parmedit/xtab/is_running state}
	int do_conc = {getfield /parmedit/xtab2/n_or_conc state}
	int slave_enable = do_stim + do_conc
	int pool_s_e
	if (!do_stim)
		slave_enable = 0
	end
	setfield {xtab} is_running {do_stim + 2 * do_conc}

	// setting the color of the xtab
	if (do_stim)
        setfield {xtab} xtree_textfg_req red
    else
        setfield {xtab} xtree_textfg_req green
    end

	/* going through the destination pools and setting their
	** slave_enable flags */
	int	i
	int nmsgs
	str src
	nmsgs = {getmsg {xtab} -outgoing -count}
	for (i = 0 ; i < nmsgs ; i = i + 1)
		src = {getmsg {xtab} -outgoing -destination {i}}
		if ({exists {src} slave_enable})
			pool_s_e = {getfield {src} slave_enable} & 4
			setfield {src} slave_enable {slave_enable | pool_s_e}
		end
	end
end

/* here we have to scale according to the graph limits */
function selectpt(x,y)
	float x, y

	str xtab = {getfield /parmedit/xtab elmpath}
	float xmin = {getfield /parmedit/xtab2/tabform xmin}
	float xmax = {getfield /parmedit/xtab2/tabform xmax}
	float ymin = {getfield /parmedit/xtab2/tabform ymin}
	float ymax = {getfield /parmedit/xtab2/tabform ymax}

	int rx = {round {xmin + (x - xmin) * (xmax - xmin)}}
	y = ymin + (y - ymin) * (ymax - ymin)

	if ((rx >= 0) && (rx <= 100))
		setfield {xtab} \
			table->table[{rx}] {y} \
			last_x {rx} \
			last_y {y}
		setfield /parmedit/xtab2/tabform/shape ypts->table[{rx}] {y}
		setfield /parmedit/xtab2/X2 value {getfield /parmedit/xtab2/X1 value}
		setfield /parmedit/xtab2/Y2 value {getfield /parmedit/xtab2/Y1 value}
		setfield /parmedit/xtab2/X1 value {rx}
		setfield /parmedit/xtab2/Y1 value {y}
		xupdate /parmedit/xtab2/tabform
	end
end

function stepline
	str xtab = {getfield /parmedit/xtab elmpath}
	float x1 = {round {getfield /parmedit/xtab2/X1 value}}
	float x2 = {round {getfield /parmedit/xtab2/X2 value}}
	float y = {getfield /parmedit/xtab2/Y1 value}
	int i

	if (x1 > x2)
		for (i = x2 + 1  ; i <= x1; i = i + 1)
			setfield {xtab} table->table[{i}] {y}
		end
		setfield /parmedit/xtab2/tabform/shape ypts {xtab}/table
		xupdate /parmedit/xtab2/tabform
	end
	if (x2 > x1)
		y = {getfield /parmedit/xtab2/Y2 value}
		for (i = x1 + 1  ; i <= x2; i = i + 1)
			setfield {xtab} table->table[{i}] {y}
		end
		setfield /parmedit/xtab2/tabform/shape ypts {xtab}/table
		xupdate /parmedit/xtab2/tabform
	end
end

function interpline
	str xtab = {getfield /parmedit/xtab elmpath}
	float x1 = {round {getfield /parmedit/xtab2/X1 value}}
	float x2 = {round {getfield /parmedit/xtab2/X2 value}}
	float y1 = {getfield /parmedit/xtab2/Y1 value}
	float y2 = {getfield /parmedit/xtab2/Y2 value}
	int i
	float dy = y1 - y2
	float lasty

	if (x1 > x2)
		dy = dy / (x1 - x2)
		lasty = y2
		for (i = x2  ; i < x1; i = i + 1)
			setfield {xtab} table->table[{i}] {lasty}
			lasty = lasty + dy
		end
		setfield /parmedit/xtab2/tabform/shape ypts {xtab}/table
		xupdate /parmedit/xtab2/tabform
	end
	if (x2 > x1)
		dy = dy / (x2 - x1)
		lasty = y2
		for (i = x1 ; i < x2; i = i + 1)
			setfield {xtab} table->table[{i}] {lasty}
			lasty = lasty + dy
		end
		setfield /parmedit/xtab2/tabform/shape ypts {xtab}/table
		xupdate /parmedit/xtab2/tabform
	end
end

function smoothline
	echo Smoothing not yet implemented
end

function update_loop_duration(ltime)
	float ltime
	str xtab = {getfield /parmedit/xtab elmpath}
	setfield {xtab} table->xmin 0 \
		table->xmax {ltime} \
		table->dx {{ltime}/{getfield {xtab} table->xdivs}} \
		table->invdx {{getfield {xtab} table->xdivs} / {ltime}}
end

function update_loop_start(stime)
	float stime
	str xtab = {getfield /parmedit/xtab elmpath}
	if ({getfield /parmedit/xtab/do_loop state} == 0)
		setfield {xtab} input {-stime}
	else
		setfield {xtab} input {stime}
	end
end

function xtab_increment(widget, incr)
	str widget
	int incr
	
	int orig = {getfield /parmedit/xtab2/{widget} value}
	setfield /parmedit/xtab2/{widget} value {orig + incr}
end

function set_step_mode(mode)
	int mode

	str xtab = {getfield /parmedit/xtab elmpath}
	if (mode == 0)
		setfield {xtab} step_mode 2 // TAB_ONCE
	else
		setfield {xtab} step_mode 1 // TAB_LOOP
	end
end

function xtab_do_scale(axis)
	str axis

	float x = {getfield /parmedit/xtab2/{axis}_scale_factor value}
	setfield /parmedit/xtab2/tabform/shape {axis}pts =*={x}
	xupdate /parmedit/xtab2/tabform
end

function xtab_do_offset(axis)
	str axis

	float x = {getfield /parmedit/xtab2/{axis}_offset value}
	setfield /parmedit/xtab2/tabform/shape {axis}pts =+={x}
	xupdate /parmedit/xtab2/tabform
end

function xtab_do_log
	setfield /parmedit/xtab2/tabform/shape ypts \
		=l=/parmedit/xtab2/tabform/shape/ypts
	xupdate /parmedit/xtab2/tabform
end

function xtab_do_log10
	setfield /parmedit/xtab2/tabform/shape ypts \
		=L=/parmedit/xtab2/tabform/shape/ypts
	xupdate /parmedit/xtab2/tabform
end

function xtab_do_exp
	setfield /parmedit/xtab2/tabform/shape ypts \
		=e=/parmedit/xtab2/tabform/shape/ypts
	xupdate /parmedit/xtab2/tabform
end

function xtab_do_exp10
	setfield /parmedit/xtab2/tabform/shape ypts \
		=E=/parmedit/xtab2/tabform/shape/ypts
	xupdate /parmedit/xtab2/tabform
end

function xtab_apply_scale
	str xtab = {getfield /parmedit/xtab elmpath}
	float xmin = {getfield /parmedit/xtab2/tabform/shape xpts->table[0]}
	int xdivs = {getfield /parmedit/xtab2/tabform/shape xpts->xdivs}
	float xmax = \
		{getfield /parmedit/xtab2/tabform/shape xpts->table[{xdivs}]}
	setfield {xtab} table /parmedit/xtab2/tabform/shape/ypts
	setfield {xtab} table->xmin {xmin}
	setfield {xtab} table->xmax {xmax}
end

function tab_autoscale_plot(xtab)
	str xtab
	int xdivs = {getfield {xtab} table->xdivs}
	float xmin, xmax
	float ymin, ymax

	xmin = {getfield {xtab} table->xmin}
	xmax = {getfield {xtab} table->xmax}
	call {xtab} TABOP m
	ymin = {getfield {xtab} output}
	call {xtab} TABOP M
	ymax = {getfield {xtab} output}
	setfield /parmedit/xtab2/tabform/shape allocated_pts {xdivs}
	setfield /parmedit/xtab2/tabform/shape npts {xdivs}
	setfield /parmedit/xtab2/tabform/shape xpts->table[0] {xmin}
	setfield /parmedit/xtab2/tabform/shape xpts =i={(xmax-xmin)/xdivs}
	setfield /parmedit/xtab2/tabform/shape ypts {xtab}/table

	setfield /parmedit/xtab2/tabform xmin {xmin} xmax {xmax} \
		ymin {ymin} ymax {ymax}
	xupdate /parmedit/xtab2/tabform
end

function xtab_undo_scale
	str xtab = {getfield /parmedit/xtab elmpath}
	tab_autoscale_plot {xtab}
end

function tab_load_xplot_file(filename)
	str filename

	str xtab = {getfield /parmedit/xtab elmpath}
	int skiplines = {getfield /parmedit/xtab/skip_lines value}
	int xdivs = {getfield /parmedit/xtab/xdivs value}
	float xmin, xmax

	file2tab {filename} {xtab} table -skiplines {skiplines} -xy {xdivs}
	// something here to update the graph
	do_inform "Loaded file "{filename}" into "{xtab}
	tab_autoscale_plot {xtab}
end

function xtab_set_baselevel(value)
	str xtab = {getfield /parmedit/xtab elmpath}
	setfield {xtab} baselevel {value}
end

function make_xedit_xtab
	int i,j,k

	create xform /parmedit/xtab [{EX},{EY},{EW},400]
	addfield /parmedit/xtab elmpath \
		-description "path of elm being edited"
	ce /parmedit/xtab

	create xlabel title -label "Stimulus run options" -bg cyan
	create xdialog path -wgeom 60% -title "Parent"
	create xdialog name -xgeom 60% -ygeom 0:title -wgeom 40% \
		-title "Name" \
		-script "set_item_name <w> <v>"
	create xbutton stimpanel -label "Open stimulus waveform options..." \
		-script "xhide /parmedit/xtab; xshow /parmedit/xtab2"
	create xtoggle do_loop [0,0:stimpanel,33%,30] \
		-onlabel "Looping enabled" \
		-offlabel "Looping disabled" \
		-script "set_step_mode <v>"
	create xdialog loop_duration [0:last,0:stimpanel,34%,30] \
		-value {MAXTIME} -script "update_loop_duration <v>"
	create xdialog loop_start [0:last,0:stimpanel,33%,30] \
		-value 0 -script "update_loop_start <v>"
	create xtoggle is_running -onlabel "Stimulus ON: click to stop" \
		-offlabel "Stimulus OFF: click to start" \
		-script "set_xtab_slave_enables" -wgeom 50% -hgeom 30
	 create xdialog color [0:last,0:loop_start,50%,30] \
		-script "set_item_color <w> <v>"
	create xlabel fileinfo -bg cyan -label "File loading info"
	create xdialog load_xplot_file [0,0:fileinfo,60%,30] \
		-script "tab_load_xplot_file <v>" -value "xplot.data"
	create xdialog skip_lines [0:last,0:fileinfo,40%,30] -value 0
	create xdialog xdivs -value 100 // later we'll put in a script
	create xbutton savenotes -label NOTES [0,0:last,10%,70] \
		-script "save_item_notes <w>" -offbg gray
	create xtext notes [10%,0:xdivs,90%,70] -editable 1
	create xbutton UPDATE [0%,0:notes,50%,30] \
		-script "do_update_xtabinfo"
	create xbutton HIDE [50%,0:notes,50%,30] \
		-script "xhide /parmedit/xtab"
	ce /

	create xform /parmedit/xtab2 [{EX},{EY},{EW},510]
	ce /parmedit/xtab2

	create xlabel title -label "Stimulus waveform options" -bg cyan
	create xdialog path -wgeom 60% -title "Parent"
	create xdialog name -xgeom 60% -ygeom 0:title -wgeom 40% \
		-title "Name" \
		-script "set_item_name <w> <v>"
	create xbutton general -title "Open stimulus run options..." \
		-script "xhide /parmedit/xtab2; xshow /parmedit/xtab"
	create xgraph tabform [0,0:last,100%,180] \
		-xmin 0 -xmax 100 -ymin 0 -ymax 1.0 \
		-script "selectpt.d1 <x> <y>" 
	create xplot tabform/shape -npts 100 -fg red -ysquish 0

	setfield tabform/shape xpts =i=1
	setfield tabform/x_axis pixflags c
	setfield tabform/y_axis pixflags c

	/*
	create xshape tabform/grid -fg white -drawmode DrawPoints
	setfield tabform/grid npts 250 pixflags c
	k = 0;
	for(j = 1; j < 6; j = j + 1)
		for(i = 0; i < 50; i = i + 2)
			setfield tabform/grid \
				xpts->table[{k}] {i} \
				ypts->table[{k}] {j/5.0}
			k = k + 1
		end
	end
	*/

	/*
	create xbutton sine -label "Sine Wave" [0,0:tabform,30%,30] \
		-script make_xtab_sine
	create xdialog period -label "Period" [0:last,0:tabform,35%,30] \
		-script make_xtab_sine -value 100
	create xdialog phase -label "Phase" [0:last,0:tabform,35%,30] \
		-script make_xtab_sine -value 0
	*/
	create xbutton flatline -label "Flat line" [0,0:tabform,25%,30] \
		-script make_flatline
	create xdialog baselevel -label "Baseline level" \
		[0:last,0:tabform,50%,30] -value 0 \
		-script "xtab_set_baselevel <v>"
	create xtoggle n_or_conc [0:last,0:tabform,25%,30] \
		-offlabel "Output is #" -onlabel "Output is conc" \
		-script set_xtab_slave_enables
	create xlabel interplab -label "Interpolation options" -bg cyan
	create xdialog X1 [0,0:interplab,20%,30] -value 0
	create xbutton x1up [0:last,0:interplab,5%,30] -title "+" \
		 -script "xtab_increment X1 1"
	create xbutton x1dn [0:last,0:interplab,5%,30] -title "-" \
		 -script "xtab_increment X1 -1"
	setfield ^ title "-" // this fools the parser on the create line
	create xdialog Y1 [0:last,0:interplab,20%,30] -value 0
	create xdialog X2 [0:last,0:interplab,20%,30] -value 0
	create xbutton x2up [0:last,0:interplab,5%,30] -title "+" \
		 -script "xtab_increment X2 1"
	create xbutton x2dn [0:last,0:interplab,5%,30] -title "-" \
		 -script "xtab_increment X2 -1"
	setfield ^ title "-" // this fools the parser on the create line
	create xdialog Y2 [0:last,0:interplab,20%,30] -value 0
	create xbutton Step [0,0:Y2,33%,25] -script stepline
	create xbutton Interpolate [0:last,0:Y2,34%,25] -script interpline
	create xbutton Smooth [0:last,0:Y2,33%,25] -script smoothline
	/*
	create xdialog load_xplot_file [0,0:Smooth,60%,30] \
		-script "tab_load_xplot_file <v>" -value "xplot.data"
	create xdialog skip_lines [0:last,0:Smooth,40%,30] -value 0
	create xdialog xdivs -value 100 // later we'll put in a script
	*/
	create xlabel scale_title -label "Scaling options" -bg cyan
	create xdialog y_scale_factor [0,0:scale_title,50%,30] -value 1 \
		-script "xtab_do_scale y"
	create xdialog y_offset [50%,0:scale_title,50%,30] -value 0 \
		-script "xtab_do_offset y"
	create xdialog x_scale_factor [0,0:y_offset,50%,30] -value 1 \
		-script "xtab_do_scale x"
	create xdialog x_offset [50%,0:y_offset,50%,30] -value 0 \
		-script "xtab_do_offset x"
	create xbutton Log [0,0:x_offset,25%,25] -script "xtab_do_log"
	create xbutton Exp [0:last,0:x_offset,25%,25] -script "xtab_do_exp"
	create xbutton Log10 [0:last,0:x_offset,25%,25] -script "xtab_do_log10"
	create xbutton Exp10 [0:last,0:x_offset,25%,25] -script "xtab_do_exp10"
	create xbutton Apply [0,0:Log,50%,25] -script "xtab_apply_scale"
	create xbutton Undo [0:last,0:Log,50%,25] -script "xtab_undo_scale"
	ce /
end

function edit_xtab(xtab)
	str xtab

	setfield /parmedit/xtab elmpath {xtab}
	do_update_xtabinfo
	xshowontop /parmedit/xtab
end

/******************************************************************
      Stuff for initializing xtabs
******************************************************************/

function ktabproto
	create table /xtab

	// need to extend the RESET action so that the input is zeroed too

    addfield /xtab notes -description "string for xtab notes and refs"
    addfield /xtab editfunc -description "func for xtab edit"
    addfield /xtab xtree_fg_req -description "color for xtab icon"
    addfield /xtab xtree_textfg_req -description "color for xtab icon"
    addfield /xtab plotfield -description "field to plot"
    addfield /xtab manageclass -description "Class that can manage it"
    addfield /xtab baselevel -description "base level for xtab"
    addfield /xtab last_x -description "last x point clicked on"
    addfield /xtab last_y -description "last y point clicked on"
    addfield /xtab is_running -description "flag for state of xtab"
 
    addobject xtab /xtab \
        -author "Upi Bhalla Mt Sinai Apr 1994" \
        -description "xtab plus a notes field"
	setdefault xtab step_mode 1
	setdefault xtab stepsize 0
    setdefault xtab editfunc "edit_xtab"
    setdefault xtab xtree_fg_req "white"
    setdefault xtab xtree_textfg_req "red"
    setdefault xtab plotfield "output"
    setdefault xtab manageclass "group"
    setdefault xtab is_running "0"
	setdefault xtab baselevel 0
	setdefault xtab last_x 0
	setdefault xtab last_y 0
end

function xtabproto
	ce /control/lib/tree
	create xshape shape -autoindex \
		-fg red \
		-drawmode DrawLines \
		-linewidth 2 \
		-coords [-.6,0.5,0][-.2,.9,0][.6,.9,0][.4,.7,0] \
			[.6,0.5,0][.4,.7,0][.2,.5,0][0,.5,0][.2,.1,0] \
			[0,.5,0][-.4,.5,0][-.6,.1,0][-.4,.5,0][-.6,.5,0] \
		-text "xtab" -textmode draw -textcolor black \
		-value "xtab" \
		-pixflags v \
		-pixflags c \
		-script \
		"edit_xtab.D"

	copy {el ^} /edit/draw/tree -autoindex
	setfield ^ script "edit_xtab.D"
	ce /
end


function init_xtab
    // set up the prototype
	ktabproto

	if (DO_X)
	    xtabproto
	
		// Set up the calls used to handle dragging xtab to pool
		call /edit/draw/tree ADDMSGARROW "/kinetics/##[TYPE=xtab]" \
			"/kinetics/##[TYPE=kpool]" SLAVE kpool orange -1 0 \
			"echo.p dragging <S> to <D> for xtab" \
			"xtab_to_pool_add.p <S> <D>" \
			"xtab_to_pool_drop.p <S> <D>"
	
		// Set up the calls used to handle dragging xtab to xtab
		call /edit/draw/tree ADDMSGARROW "/kinetics/##[TYPE=xtab]" \
			"/kinetics/##[TYPE=xtab]" INPUT xtab orange -1 0 \
			"echo.p dragging <S> to <D> for xtab" \
			"xtab_to_xtab_add.p <S> <D>" \
			"xtab_to_xtab_drop.p <S> <D>"
	
		// Set up the calls used to handle dragging pool to xtab
		call /edit/draw/tree ADDMSGARROW "/kinetics/##[TYPE=kpool]" \
			"/kinetics/##[TYPE=xtab]" INPUT xtab hotpink -1 0 \
			"echo.p dragging <S> to <D> for xtab" \
			"pool_to_xtab_add.p <S> <D>" \
			"pool_to_xtab_drop.p <S> <D>"
	
	
	    // make the editor for xtabs
	    make_xedit_xtab
	
	end
	// set up the dumping fields
	simobjdump xtab input output alloced step_mode stepsize notes \
    	editfunc xtree_fg_req xtree_textfg_req plotfield manageclass \
    	baselevel last_x last_y is_running
end
