/*****************************************************************************\
 *  $Id: genders_test_corner_case_tests.c,v 1.3 2005/01/03 17:31:21 achu Exp $
 *****************************************************************************
 *  Copyright (C) 2001-2003 The Regents of the University of California.
 *  Produced at Lawrence Livermore National Laboratory (cf, DISCLAIMER).
 *  Written by Jim Garlick <garlick@llnl.gov> and Albert Chu <chu11@llnl.gov>.
 *  UCRL-CODE-2003-004.
 *
 *  This file is part of Genders, a cluster configuration database.
 *  For details, see <http://www.llnl.gov/linux/genders/>.
 *
 *  Genders is free software; you can redistribute it and/or modify it under
 *  the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 2 of the License, or (at your option)
 *  any later version.
 *
 *  Genders is distributed in the hope that it will be useful, but WITHOUT ANY
 *  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 *  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with Genders; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
\*****************************************************************************/

#include "genders.h"
#include "genders_testlib.h"
#include "genders_test_corner_case.h"
#include "genders_test_database.h"

genders_handle_destroy_corner_case_t genders_handle_destroy_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,            0, GENDERS_ERR_MAGIC     },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1, GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,              0, GENDERS_ERR_MAGIC     },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_load_data_corner_case_t genders_load_data_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NULL,               -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_EXIST,     -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_NOT_EXIST, -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NULL,                0, GENDERS_ERR_SUCCESS   },
  {4,  GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_EXIST,      0, GENDERS_ERR_SUCCESS   },
  {5,  GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_NOT_EXIST, -1, GENDERS_ERR_OPEN      },
  {6,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NULL,               -1, GENDERS_ERR_MAGIC     },
  {7,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_EXIST,     -1, GENDERS_ERR_MAGIC     },
  {8,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_NOT_EXIST, -1, GENDERS_ERR_MAGIC     },
  {9,  GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NULL,               -1, GENDERS_ERR_ISLOADED  },
  {10, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_EXIST,     -1, GENDERS_ERR_ISLOADED  },
  {11, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_NOT_EXIST, -1, GENDERS_ERR_ISLOADED  },
  {12, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NULL,               -1, GENDERS_ERR_MAGIC     },
  {13, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_EXIST,     -1, GENDERS_ERR_MAGIC     },
  {14, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_NOT_EXIST, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_errnum_corner_case_t genders_errnum_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,            GENDERS_ERR_SUCCESS   },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,              GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_ERR_MAGIC     },
  {-1, -1, -1},
};

genders_strerror_corner_case_t genders_strerror_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,            GENDERS_ERR_SUCCESS   },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,              GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_ERR_MAGIC     },
  {-1, -1, -1},
};

genders_errormsg_corner_case_t genders_errormsg_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,            GENDERS_ERR_SUCCESS   },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,              GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_ERR_MAGIC     },
  {-1, -1, -1},
};

genders_perror_corner_case_t genders_perror_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                NULL,       GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                "not-null", GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            NULL,       GENDERS_ERR_SUCCESS   },
  {3, GENDERS_HANDLE_UNLOADED,            "not-null", GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  NULL,       GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  "not-null", GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              NULL,       GENDERS_ERR_SUCCESS   },
  {7, GENDERS_HANDLE_LOADED,              "not-null", GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    NULL,       GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    "not-null", GENDERS_ERR_MAGIC     },
  {-1, -1, NULL, -1},
};

genders_getnumnodes_corner_case_t genders_getnumnodes_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1,                                    GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,           -1,                                    GENDERS_ERR_NOTLOADED },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1,                                    GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,             GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1,                                    GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_getnumattrs_corner_case_t genders_getnumattrs_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1,                                    GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,           -1,                                    GENDERS_ERR_NOTLOADED },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1,                                    GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,             GENDERS_DATABASE_CORNER_CASE_NUMATTRS, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1,                                    GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_getmaxattrs_corner_case_t genders_getmaxattrs_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1,                                    GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,           -1,                                    GENDERS_ERR_NOTLOADED },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1,                                    GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,             GENDERS_DATABASE_CORNER_CASE_MAXATTRS, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1,                                    GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_getmaxnodelen_corner_case_t genders_getmaxnodelen_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1,                                      GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,           -1,                                      GENDERS_ERR_NOTLOADED },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1,                                      GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,             GENDERS_DATABASE_CORNER_CASE_MAXNODELEN, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1,                                      GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_getmaxattrlen_corner_case_t genders_getmaxattrlen_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1,                                      GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,           -1,                                      GENDERS_ERR_NOTLOADED },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1,                                      GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,             GENDERS_DATABASE_CORNER_CASE_MAXATTRLEN, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1,                                      GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_getmaxvallen_corner_case_t genders_getmaxvallen_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1,                                     GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,           -1,                                     GENDERS_ERR_NOTLOADED },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1,                                     GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,             GENDERS_DATABASE_CORNER_CASE_MAXVALLEN, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1,                                     GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_nodelist_create_corner_case_t genders_nodelist_create_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_nodelist_clear_corner_case_t genders_nodelist_clear_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_nodelist_destroy_corner_case_t genders_nodelist_destroy_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_attrlist_create_corner_case_t genders_attrlist_create_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  GENDERS_DATABASE_CORNER_CASE_NUMATTRS, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_attrlist_clear_corner_case_t genders_attrlist_clear_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_attrlist_destroy_corner_case_t genders_attrlist_destroy_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_vallist_create_corner_case_t genders_vallist_create_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  GENDERS_DATABASE_CORNER_CASE_NUMATTRS, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_vallist_clear_corner_case_t genders_vallist_clear_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_vallist_destroy_corner_case_t genders_vallist_destroy_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_getnodename_corner_case_t genders_getnodename_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {4,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {5,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {6,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {7,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {8,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {9,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {10, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {11, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {12, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {13, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {14, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {15, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {16, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {17, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {18, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {19, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {20, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {21, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {22, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {23, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {24, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {25, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {26, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {27, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {28, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {29, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_OVERFLOW  },
  {30, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_OVERFLOW  },
  {31, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE,  0, GENDERS_ERR_SUCCESS   },
  {32, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {33, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {34, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {35, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {36, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {37, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {38, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {39, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1},
};

genders_getnodes_corner_case_t genders_getnodes_corner_case_tests[] = {
  {0,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {1,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {2,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {3,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {4,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {5,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {6,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {7,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {8,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {9,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {10,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {11,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {12,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {13,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {14,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {15,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {16,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {17,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {18,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {19,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {20,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {21,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {22,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {23,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {24,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {25,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {26,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {27,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {28,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {29,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {30,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {31,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},

  {32,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {33,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {34,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {35,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {36,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {37,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {38,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {39,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {40,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {41,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {42,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {43,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {44,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {45,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {46,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {47,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {48,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {49,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {50,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {51,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {52,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {53,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {54,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {55,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {56,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {57,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {58,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {59,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {60,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {61,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {62,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {63,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },

  {64,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {65,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {66,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {67,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {68,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {69,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {70,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {71,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {72,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {73,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {74,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {75,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {76,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {77,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {78,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {79,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {80,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {81,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {82,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {83,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {84,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {85,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {86,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {87,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {88,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {89,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {90,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {91,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {92,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {93,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {94,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {95,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },

  {96,  GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {97,  GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {98,  GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {99,  GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {100, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_OVERFLOW  },
  {101, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_OVERFLOW  },
  {102, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {103, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW},
  {104, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {105, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {106, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {107, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {108, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {109, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {110, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {111, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {112, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {113, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {114, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {115, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {116, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_OVERFLOW  },
  {117, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_OVERFLOW  },
  {118, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {119, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {120, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_OVERFLOW  },
  {121, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_OVERFLOW  },
  {122, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {123, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {124, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {125, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {126, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {127, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },

  {128, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {129, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {130, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {131, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {132, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {133, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {134, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {135, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {136, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {137, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {138, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {139, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {140, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {141, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {142, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {143, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {144, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {145, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {146, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {147, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {148, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {149, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {150, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {151, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {152, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {153, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {154, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {155, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {156, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {157, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {158, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {159, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1, -1, -1},
};

genders_getattr_corner_case_t genders_getattr_corner_case_tests[] = {
  {0,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {1,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {2,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {3,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {4,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {5,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {6,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {7,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {8,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {9,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {10,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {11,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {12,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {13,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {14,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {15,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {16,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {17,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {18,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {19,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {20,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {21,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {22,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {23,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {24,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {25,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {26,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {27,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {28,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {29,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {30,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {31,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},

  {32,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {33,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {34,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {35,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {36,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {37,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {38,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {39,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {40,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {41,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {42,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {43,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {44,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {45,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {46,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {47,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {48,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {49,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {50,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {51,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {52,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {53,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {54,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {55,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {56,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {57,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {58,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {59,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {60,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {61,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {62,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {63,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },

  {64,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {65,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {66,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {67,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {68,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {69,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {70,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {71,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {72,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {73,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {74,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {75,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {76,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {77,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {78,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {79,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {80,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {81,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {82,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {83,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {84,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {85,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {86,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {87,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {88,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {89,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {90,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {91,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {92,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {93,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {94,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {95,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },

  {96,  GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {97,  GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {98,  GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTFOUND  },
  {99,  GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {100, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {101, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {102, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {103, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {104, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {105, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {106, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTFOUND  },
  {107, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {108, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {109, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {110, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {111, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {112, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {113, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {114, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTFOUND  },
  {115, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {116, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTFOUND  },
  {117, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {118, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTFOUND  },
  {119, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_DATABASE_CORNER_CASE_MAXATTRS, GENDERS_ERR_SUCCESS   },
  {120, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {121, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {122, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTFOUND  },
  {123, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {124, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTFOUND  },
  {125, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {126, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTFOUND  },
  {127, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_DATABASE_CORNER_CASE_MAXATTRS, GENDERS_ERR_SUCCESS   },

  {128, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {129, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {130, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {131, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {132, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {133, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {134, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {135, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {136, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {137, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {138, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {139, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {140, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {141, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {142, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {143, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {144, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {145, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {146, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {147, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {148, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {149, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {150, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {151, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {152, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {153, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {154, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {155, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {156, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {157, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {158, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {159, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1, -1, -1},
};

genders_getattr_all_corner_case_t genders_getattr_all_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_NULLHANDLE},
  {4,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_NULLHANDLE},
  {5,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {6,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {7,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_NULLHANDLE},
  {8,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_NOTLOADED },
  {9,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_NOTLOADED },
  {10, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_NOTLOADED },
  {11, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_NOTLOADED },
  {12, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_NOTLOADED },
  {13, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_NOTLOADED },
  {14, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_NOTLOADED },
  {15, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_NOTLOADED },
  {16, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_MAGIC     },
  {17, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_MAGIC     },
  {18, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_MAGIC     },
  {19, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_MAGIC     },
  {20, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_MAGIC     },
  {21, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_MAGIC     },
  {22, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_MAGIC     },
  {23, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_MAGIC     },
  {24, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_PARAMETERS},
  {25, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {26, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_PARAMETERS},
  {27, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_PARAMETERS},
  {28, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_PARAMETERS},
  {29, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {30, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {31, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_DATABASE_CORNER_CASE_NUMATTRS, GENDERS_ERR_SUCCESS   },
  {32, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_MAGIC     },
  {33, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_MAGIC     },
  {34, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_MAGIC     },
  {35, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_MAGIC     },
  {36, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_MAGIC     },
  {37, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_MAGIC     },
  {38, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_MAGIC     },
  {39, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1},
};

genders_testattr_corner_case_t genders_testattr_corner_case_tests[] = {
  {0,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {1,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {2,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {3,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {4,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {5,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {6,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {7,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {8,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {9,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {10,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {11,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {12,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {13,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {14,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {15,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {16,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {17,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {18,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {19,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {20,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {21,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {22,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {23,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {24,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {25,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {26,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {27,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {28,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {29,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {30,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {31,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},

  {32,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {33,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {34,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {35,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {36,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {37,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {38,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {39,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {40,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {41,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {42,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {43,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {44,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {45,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {46,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {47,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {48,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {49,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {50,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {51,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {52,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {53,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {54,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {55,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {56,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {57,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {58,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {59,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {60,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {61,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {62,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {63,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },

  {64,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {65,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {66,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {67,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {68,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {69,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {70,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {71,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {72,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {73,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {74,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {75,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {76,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {77,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {78,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {79,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {80,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {81,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {82,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {83,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {84,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {85,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {86,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {87,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {88,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {89,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {90,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {91,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {92,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {93,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {94,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {95,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },

  {96,  GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {97,  GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {98,  GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {99,  GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {100, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {101, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {102, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {103, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {104, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTFOUND  },
  {105, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTFOUND  },
  {106, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTFOUND  },
  {107, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTFOUND  },
  {108, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {109, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTFOUND  },
  {110, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTFOUND  },
  {111, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTFOUND  },
  {112, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {113, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {114, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {115, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {116, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {117, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {118, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {119, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {120, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,        1, GENDERS_ERR_SUCCESS   },
  {121, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,            1, GENDERS_ERR_SUCCESS   },
  {122, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL,  1, GENDERS_ERR_SUCCESS   },
  {123, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE,  1, GENDERS_ERR_SUCCESS   },
  {124, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {125, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_OVERFLOW  },
  {126, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_OVERFLOW  },
  {127, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE,  1, GENDERS_ERR_SUCCESS   },

  {128, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {129, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {130, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {131, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {132, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {133, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {134, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {135, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {136, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {137, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {138, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {139, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {140, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {141, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {142, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {143, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {144, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {145, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {146, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {147, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {148, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {149, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {150, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {151, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {152, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {153, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {154, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {155, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {156, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {157, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {158, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {159, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1, -1, -1},
};

genders_testattrval_corner_case_t genders_testattrval_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {4,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {5,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {6,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {7,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},

  {8,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {9,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {10, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {11, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {12, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {13, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {14, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {15, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },

  {16, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {17, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {18, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {19, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {20, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {21, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {22, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {23, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },

  {24, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {25, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_PARAMETERS},
  {26, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTFOUND  },
  {27, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTFOUND  },
  {28, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {29, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_PARAMETERS},
  {30, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,      1, GENDERS_ERR_SUCCESS   },
  {31, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL,  1, GENDERS_ERR_SUCCESS   },

  {32, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {33, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {34, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {35, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {36, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {37, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {38, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {39, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1, -1},
};

genders_isnode_corner_case_t genders_isnode_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,      0, GENDERS_ERR_SUCCESS   },
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  1, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_isattr_corner_case_t genders_isattr_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  1, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_isattrval_corner_case_t genders_isattrval_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {4,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {5,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {6,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {7,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {8,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {10, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {11, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {12, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {13, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_PARAMETERS},
  {14, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {15, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL,  1, GENDERS_ERR_SUCCESS   },
  {16, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {17, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {18, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {19, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1, -1},
};

genders_index_attrvals_corner_case_t genders_index_attrvals_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_query_corner_case_t genders_query_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {4,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {5,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {6,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {7,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {8,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {9,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {10, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {11, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {12, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {13, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {14, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NULLHANDLE},
  {15, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {16, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {17, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {18, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {19, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {20, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {21, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {22, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {23, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {24, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {25, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {26, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {27, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {28, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {29, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {30, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_NOTLOADED },
  {31, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_NOTLOADED },
  {32, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {33, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {34, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {35, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {36, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {37, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {38, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {39, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {40, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {41, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {42, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {43, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {44, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {45, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {46, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {47, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {48, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {49, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {50, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_OVERFLOW  },
  {51, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {52, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {53, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {54, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {55, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {56, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_PARAMETERS},
  {57, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_PARAMETERS},
  {58, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_OVERFLOW  },
  {59, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {60, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_OVERFLOW  },
  {61, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {62, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {63, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {64, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {65, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {66, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {67, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {68, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {69, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {70, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {71, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {72, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {73, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {74, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {75, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {76, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {77, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {78, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NULL,     -1,                                    GENDERS_ERR_MAGIC     },
  {79, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_POINTER_NON_NULL, -1,                                    GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1, -1, -1},
};

genders_parse_corner_case_t genders_parse_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NULL,               GENDERS_POINTER_NULL,      -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NULL,               GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NULL,      -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_NULLHANDLE},
  {4,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NULL,      -1, GENDERS_ERR_NULLHANDLE},
  {5,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_NULLHANDLE},
  {6,  GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NULL,               GENDERS_POINTER_NULL,       0, GENDERS_ERR_SUCCESS   },
  {7,  GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NULL,               GENDERS_POINTER_NON_NULL,   0, GENDERS_ERR_SUCCESS   },
  {8,  GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NULL,       0, GENDERS_ERR_SUCCESS   },
  {9,  GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NON_NULL,   0, GENDERS_ERR_SUCCESS   },
  {10, GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NULL,      -1, GENDERS_ERR_OPEN      },
  {11, GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_OPEN      },
  {12, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NULL,               GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {13, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NULL,               GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {14, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {15, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {16, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {17, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {18, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NULL,               GENDERS_POINTER_NULL,       0, GENDERS_ERR_SUCCESS   },
  {19, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NULL,               GENDERS_POINTER_NON_NULL,   0, GENDERS_ERR_SUCCESS   },
  {20, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NULL,       0, GENDERS_ERR_SUCCESS   },
  {21, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NON_NULL,   0, GENDERS_ERR_SUCCESS   },
  {22, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NULL,      -1, GENDERS_ERR_OPEN      },
  {23, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_OPEN      },
  {24, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NULL,               GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {25, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NULL,               GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {26, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {27, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {28, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {29, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_set_errnum_corner_case_t genders_set_errnum_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,                -1,                          GENDERS_ERR_NULLHANDLE     },
  {1,  GENDERS_HANDLE_NULL,                GENDERS_ERR_SUCCESS,         GENDERS_ERR_NULLHANDLE     },
  {2,  GENDERS_HANDLE_NULL,                GENDERS_ERR_ERRNUMRANGE + 1, GENDERS_ERR_NULLHANDLE     },
  {3,  GENDERS_HANDLE_UNLOADED,            -1,                          -1                         },
  {4,  GENDERS_HANDLE_UNLOADED,            GENDERS_ERR_SUCCESS,         GENDERS_ERR_SUCCESS        },
  {5,  GENDERS_HANDLE_UNLOADED,            GENDERS_ERR_ERRNUMRANGE + 1, GENDERS_ERR_ERRNUMRANGE + 1},
  {6,  GENDERS_HANDLE_UNLOADED_DESTROYED,  -1,                          GENDERS_ERR_MAGIC          },
  {7,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_ERR_SUCCESS,         GENDERS_ERR_MAGIC          },
  {8,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_ERR_ERRNUMRANGE + 1, GENDERS_ERR_MAGIC          },
  {9,  GENDERS_HANDLE_LOADED,              -1,                          -1                         },
  {10, GENDERS_HANDLE_LOADED,              GENDERS_ERR_SUCCESS,         GENDERS_ERR_SUCCESS        },
  {11, GENDERS_HANDLE_LOADED,              GENDERS_ERR_ERRNUMRANGE + 1, GENDERS_ERR_ERRNUMRANGE + 1},
  {12, GENDERS_HANDLE_LOADED_DESTROYED,    -1,                          GENDERS_ERR_MAGIC          },
  {13, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_ERR_SUCCESS,         GENDERS_ERR_MAGIC          },
  {14, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_ERR_ERRNUMRANGE + 1, GENDERS_ERR_MAGIC          },
  {-1, -1, -1, -1},
};
