#  signal.rb - 
#  Copyright (C) 2004-2006 Frdric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

require 'glib2'
require 'singleton'

module Geekast

  class Signal < GLib::Object
    include Singleton
    
    type_register
    
    signal_new("CrefreshNB",            # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Integer                  # parameter types
               )  
    signal_new("MrefreshNB",            # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array                    # parameter types
               )  
    
    signal_new("CnotifyBAR",            # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               String,
               String                   # parameter types
               )  
    signal_new("VnotifyBAR",            # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               String                   # parameter types
               )  
    signal_new("VrefreshBAR",           # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Integer,                  # parameter types
               Integer,                  # parameter types
               Integer                  # parameter types
               )  
    
    signal_new("MrefreshYP",            # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Integer                  # parameter types
               )  
    
    signal_new("CrefreshYP",            # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array, Integer, Integer  # parameter types
               )  
    signal_new("VrefreshYP",            # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array, Integer, Integer  # parameter types
               )  
    signal_new("VclearTreeview",        # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Integer                  # parameter types
               )  
    signal_new("CrefreshRelay",         # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array, Integer, Integer  # parameter types
               )  
    signal_new("VrefreshRelay",         # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array, Integer, Integer  # parameter types
               )  
    signal_new("CxmlParse",             # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Integer                  # parameter types
               )  
    signal_new("CrefreshBM",            # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array                    # parameter types
               )  
    signal_new("VrefreshBM",            # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array                    # parameter types
               )  
    signal_new("CbookmarkAdd",          # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array                    # parameter types
               )  
    signal_new("MbookmarkAdd",          # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array                    # parameter types
               )  
    signal_new("MbookmarkDel",          # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Integer                  # parameter types
               )  
    signal_new("CbookmarkDel",          # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Integer                  # parameter types
               )  

    signal_new("CrefreshConnection",    # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array                    # parameter types
               )  

    signal_new("VrefreshConnection",    # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array                    # parameter types
               )  

    signal_new("CrefreshInformation",    # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array, Array, 
               Array, Array             # parameter types
               )  

    signal_new("VrefreshInformation",    # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array, Array,
               Array, Array             # parameter types
               )  

    signal_new("VrefreshVIDEO",         # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Integer                  # parameter types
               )  

    signal_new("ChandlerError",         # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               String,
               String                   # parameter types
               )  

    signal_new("VblockSignal",          # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               String                   # parameter types
               )  

    signal_new("VunblockSignal",        # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               String                   # parameter types
               )  

    signal_new("CgetChannelinfo",          # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               String                   # parameter types
               )  


    signal_new("CreturnChannelinfo",    # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array                    # parameter types
               )  

    signal_new("VrefreshChannelInfo",          # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Array                    # parameter types
               )  

    signal_new("VstatusChannelinfo",    # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               Integer                  # parameter types
               )  

    signal_new("VrefreshWeb",           # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               String                   # parameter types
               )  

    signal_new("CrefreshWeb",           # name
               GLib::Signal::RUN_FIRST, # flags
               nil,                     # accumulator (XXX: not supported yet)
               nil,                     # return type (void == nil)
               String                   # parameter types
               )  

    
    def initialize
      super(nil)
      @signalStackConnect = Hash.new
    end

    def emit(signal_name, *data)
      begin
        signal_emit(signal_name, *data)
      rescue => e
        puts "Alert : signal_emit exception on the signal named " + signal_name + " !"
        puts "Exception : " + e.to_str
        puts "Backtrace :"
        puts e.backtrace
      end
    end
    

    def connect(signal_name)
      begin
        signal_connect(signal_name){|obj, *signal_param|
          yield *signal_param
        }
      rescue => e
        puts "Alert : signal_connect exception on the signal named " + signal_name + " !"
        puts "Exception : " + e.to_str
        puts "Backtrace :"
        puts e.backtrace
      end
    end
    
    def handler_block(handler_id)
      unless @signalStackConnect[handler_id]
        @signalStackConnect[handler_id] = 1
      else
        @signalStackConnect[handler_id] += 1
      end
      puts "SIGNAL block : " + @signalStackConnect[handler_id].to_s if $DEBUG
      signal_handler_block(handler_id)
    end
    
    def handler_unblock(handler_id)
      puts "SIGNAL unblock : " + @signalStackConnect[handler_id].to_s if $DEBUG
      @signalStackConnect[handler_id].times do
        signal_handler_unblock(handler_id)
      end
      @signalStackConnect[handler_id] = 0
    end

    def handler_is_connected(handler_id)
      signal_handler_is_connected?(handler_id)
    end


    
    #######
    private
    #######
    
    def signal_do_CrefreshNB(int)
    end
    def signal_do_MrefreshNB(int)
    end
    def signal_do_VrefreshBAR(int1, int2, int3)
    end
    def signal_do_MrefreshYP(int)
    end
    def signal_do_CrefreshYP(array,int1,int2)
    end
    def signal_do_VrefreshYP(array,int1,int2)
    end
    def signal_do_VclearTreeview(int)
    end
    def signal_do_CrefreshRelay(array,int1,int2)
    end
    def signal_do_VrefreshRelay(array,int1,int2)
    end
    def signal_do_CnotifyBAR(string1, string2)
    end
    def signal_do_VnotifyBAR(string)
    end
    def signal_do_CxmlParse(int)
    end
    def signal_do_CrefreshBM(array)
    end
    def signal_do_VrefreshBM(array)
    end
    def signal_do_CbookmarkAdd(array)
    end
    def signal_do_MbookmarkAdd(array)
    end
    def signal_do_CbookmarkDel(int)
    end
    def signal_do_MbookmarkDel(int)
    end
    def signal_do_CrefreshConnection(array)
    end
    def signal_do_VrefreshConnection(array)
    end
    def signal_do_CrefreshInformation(array1,array2,array3,array4)
    end
    def signal_do_VrefreshInformation(array1,array2,array3,array4)
    end
    def signal_do_VrefreshVIDEO(int)
    end
    def signal_do_ChandlerError(string1,string2)
    end
    def signal_do_VblockSignal(string)
    end
    def signal_do_VunblockSignal(string)
    end
    def signal_do_CgetChannelinfo(string)
    end
    def signal_do_CreturnChannelinfo(array)
    end
    def signal_do_VrefreshChannelInfo(array)
    end
    def signal_do_VstatusChannelinfo(int)
    end
    def signal_do_VrefreshWeb(string)
    end
    def signal_do_CrefreshWeb(string)
    end


  end
end
