#  controller.rb - 
#  Controller is a controller module
#  Copyright (C) 2004-2006 Frédéric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


require 'geekast/controllers/lib/callback'

require 'singleton'
require 'observer'


module Geekast
  module Controller

    def self.main
      Controller.instance
    end

    #######
    private
    #######

    class Controller
      include Singleton


      def initialize
        puts "Controller singleton launched" if $DEBUG

        trap_quit_signal = proc{ Gtk.main_quit }
        trap "SIGINT", trap_quit_signal


        @callback = CallbackMain.new
      end
    end


  end
end


