/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


/* DO NOT read or edit this file ! Use ../noweb/x_basic.nw instead */

#include <config.h>
#include <stdio.h>
#include <signal.h>
#include <math.h>

#include <libgeda/libgeda.h>

#include "../include/globals.h"
#include "../include/x_event.h"
#include "../include/prototype.h"



#if 0				/* once you are sure your new color system works... delete code */
GdkColor *x_get_color(int color)
{
  switch (color) {
  case (RED):
    return (&red);
    break;
  case (BLUE):
    return (&blue);
    break;
  case (GREEN):
    return (&green);
    break;
  case (YELLOW):
    return (&yellow);
    break;
  case (CYAN):
    return (&cyan);
    break;
  case (GREY):
    return (&grey);
    break;
  case (GREY90):
    return (&grey90);
    break;
  case (BLACK):
    return (&black);
    break;
  case (WHITE):
    return (&white);
    break;
  default:
    return (&white);
    break;
  }
}


GdkColor *x_get_darkcolor(int color)
{
  switch (color) {
  case (RED):
    return (&darkred);
    break;
  case (BLUE):
    return (&darkblue);
    break;
  case (GREEN):
    return (&darkgreen);
    break;
  case (YELLOW):
    return (&darkyellow);
    break;
  case (CYAN):
    return (&darkcyan);
    break;
  case (GREY):
    return (&darkgrey);
    break;
  case (BLACK):
    return (&black);
    break;
  case (WHITE):
    return (&grey);
    break;
  default:
    return (&white);
    break;
  }
}


#endif

void x_repaint_background(TOPLEVEL * w_current)
{
  if (!w_current->inside_redraw) {
    gdk_gc_set_foreground(w_current->gc,
			  x_get_color(w_current->background_color));

    gdk_draw_rectangle(w_current->window,
		       w_current->gc, TRUE, 0, 0,
		       w_current->win_width, w_current->win_height);

    gdk_draw_rectangle(w_current->backingstore,
		       w_current->gc, TRUE, 0, 0,
		       w_current->win_width, w_current->win_height);

    x_grid_draw(w_current);

  }

}


void x_hscrollbar_set_ranges(TOPLEVEL * w_current)
{
  GtkAdjustment *hadjustment;

  if (w_current->scrollbars_flag == FALSE) {
    return;
  }

  hadjustment =
      gtk_range_get_adjustment(GTK_RANGE(w_current->h_scrollbar));

  hadjustment->lower = w_current->init_left;
  hadjustment->upper = w_current->init_right;

}


void x_hscrollbar_update(TOPLEVEL * w_current)
{
  GtkAdjustment *hadjustment;

  if (w_current->scrollbars_flag == FALSE) {
    return;
  }

  if (w_current->h_scrollbar == NULL) {
    return;
  }

  hadjustment =
      gtk_range_get_adjustment(GTK_RANGE(w_current->h_scrollbar));

  hadjustment->value = w_current->page_current->left;

  hadjustment->page_size = fabs(w_current->page_current->right -
				w_current->page_current->left);

  hadjustment->page_increment = hadjustment->page_size - 100.0;

#if DEBUG
  printf("H %f %f\n", hadjustment->lower, hadjustment->upper);
  printf("Hp %f\n", hadjustment->page_size);
#endif

  gtk_signal_emit_by_name(GTK_OBJECT(hadjustment), "changed");
  gtk_signal_emit_by_name(GTK_OBJECT(hadjustment), "value_changed");
}


void x_vscrollbar_set_ranges(TOPLEVEL * w_current)
{
  GtkAdjustment *vadjustment;

  if (w_current->scrollbars_flag == FALSE) {
    return;
  }

  vadjustment =
      gtk_range_get_adjustment(GTK_RANGE(w_current->v_scrollbar));

  vadjustment->lower = w_current->init_top;
  vadjustment->upper = w_current->init_bottom;
}


void x_vscrollbar_update(TOPLEVEL * w_current)
{
  GtkAdjustment *vadjustment;

  if (w_current->scrollbars_flag == FALSE) {
    return;
  }

  if (w_current->v_scrollbar == NULL) {
    return;
  }

  vadjustment =
      gtk_range_get_adjustment(GTK_RANGE(w_current->v_scrollbar));

  vadjustment->page_size = fabs(w_current->page_current->bottom -
				w_current->page_current->top);

  vadjustment->page_increment = vadjustment->page_size - 100.0;

  vadjustment->value =
      w_current->init_bottom - w_current->page_current->bottom;

#if DEBUG
  printf("V %f %f\n", vadjustment->lower, vadjustment->upper);
  printf("Vp %f\n", vadjustment->page_size);
#endif

  gtk_signal_emit_by_name(GTK_OBJECT(vadjustment), "changed");
  gtk_signal_emit_by_name(GTK_OBJECT(vadjustment), "value_changed");
}


void x_scrollbars_update(TOPLEVEL * w_current)
{
  if (w_current->scrollbars_flag == FALSE) {
    return;
  }

  w_current->DONT_RECALC = 1;
  w_current->DONT_RESIZE = 1;
  w_current->DONT_REDRAW = 1;
  x_hscrollbar_update(w_current);
  x_vscrollbar_update(w_current);
  w_current->DONT_REDRAW = 0;
  w_current->DONT_RECALC = 0;
  w_current->DONT_RESIZE = 0;
}


GtkWidget *x_create_dialog_box(GtkWidget ** out_vbox,
			       GtkWidget ** out_action_area)
{
  GtkWidget *separator;
  GtkWidget *vbox;
  GtkWidget *action_area;
  GtkWidget *dialog;

  if (!out_vbox)
    return (NULL);

  if (!out_action_area)
    return (NULL);

  dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(dialog), vbox);
  gtk_widget_show(vbox);

  action_area = gtk_hbox_new(TRUE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(action_area), 10);
  gtk_box_pack_end(GTK_BOX(vbox), action_area, FALSE, TRUE, 0);
  gtk_widget_show(action_area);

  separator = gtk_hseparator_new();
  gtk_box_pack_end(GTK_BOX(vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show(separator);

  *out_vbox = vbox;
  *out_action_area = action_area;

  return (dialog);
}


/* not used */
GtkWidget *x_create_dialog_box_horiz(GtkWidget ** out_hbox,
				     GtkWidget ** out_action_area)
{
  GtkWidget *separator;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *action_area;
  GtkWidget *dialog;

  if (!out_hbox)
    return (NULL);

  if (!out_action_area)
    return (NULL);

  dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(dialog), vbox);
  gtk_widget_show(vbox);

  hbox = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show(hbox);

  separator = gtk_hseparator_new();
  gtk_box_pack_end(GTK_BOX(vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show(separator);

  action_area = gtk_hbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(action_area), 10);
  gtk_box_pack_end(GTK_BOX(vbox), action_area, FALSE, FALSE, 0);
  gtk_widget_show(action_area);

  *out_hbox = hbox;
  *out_action_area = action_area;

  return (dialog);
}
