/* 
   schema.h
   
   Part of GNU Enterprise Application Server (GEAS)

   Copyright (C) 2001 Free Software Foundation

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
   
   $id$

*/

#ifndef SCHEMA_H
#define SCHEMA_H

#include "geas-server.h"
#include "geas.h"

/** \brief Get a list of all classes known to GEAS
 *  \return A pointer to a sequence of strings, where each
 *   string is the name of a known class
 *  \param id The ID of the object this method was called from
 *  \param ev CORBA environment variable
 */

GEAS_classnames *schema_list_classes (GEAS_object_reference * id,
                                      CORBA_Environment * ev);

/** \brief Get the definition of a single class
 *  \return 
 *  \param id The ID of the object this method was called from
 *  \param name The class to retrieve
 *  \param includeinherited If FALSE, inherited attributes will not
 *   be included. Parents are always identified.
 *  \param ev CORBA environment variable
 */
GEAS_ClassDefinition *schema_get_class (GEAS_object_reference * id,
                                        const char *name,
                                        gboolean includeinherited,
                                        CORBA_Environment * ev);

GEAS_fieldlist *schema_get_fields (GEAS_object_reference * id,
                                   const char *name,
                                   gboolean includeinherited,
                                   CORBA_Environment * ev);

/** \brief Get full schema (Not yet implemented)
 */
GEAS_classlist *schema_get_all (GEAS_object_reference * id,
                                CORBA_Environment * ev);

#endif
