
/*
   objectcache_internal.h
   
   Part of GNU Enterprise Application Server (GEAS)
 
   Copyright (C) 2001 Free Software Foundation
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
   
   $Id: objectcache_internal.h,v 1.5 2001/06/13 03:33:03 treshna Exp $
 
*/

#ifndef OBJECTCACHE_INTERNAL_H
#define OBJECTCACHE_INTERNAL_H

/**
 * This structure stores the information on a single object in the cache
 */
typedef struct _ObjectData
{
  /* object identifier */
  char *classname, *key;        /* classname/objectid */
  char *hashkey;                /* key used in hash table */

  /* field data */
  GHashTable *fields;

  /* object flags */
  int deleted:1;
  int indatabase:1;

  /* nasty hack. what, another one? */
  void *userdata;

  /* what indexes know about this object */
  GList *indexes;
}
_ObjectData;

/**
 * This structure stores the value of a single field in an object
 */
typedef struct _FieldData
{
  char *name;
  char *value;
  gboolean readonly;
}
_FieldData;

/**
 * This is stored in the hash table of an index.
 * 
 * The hashkey is made up of the fields of the object (that are part
 * of the index)
 * 
 * The objects lists contains all objects with the indicated key.
 * If the index is a unique index, there will only be one object,
 * otherwise there will be at least one object, and probably more.
 */
typedef struct _CacheIndexLink
{
  char *hashkey;
  GList *objects;
}
_CacheIndexLink;

/**
 * This structure stores a hash table for a single index.
 */
typedef struct _CacheIndex
{
  /* identify the index */
  char *hashkey;

  /* what fields are in this index */
  _odl_index *index;

  /* record the objects in this index */
  GHashTable *hashtable;
}
_CacheIndex;

typedef struct oc_index_identifier
{
  char *classname;
  char *indexid;
  _odl_index *index;
}
oc_index_identifier;

#endif
