
/*
   factory.h
   
   Part of GNU Enterprise Application Server (GEAS)
 
   Copyright (C) 2000 Free Software Foundation
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 
   $Id: factory.h,v 1.4 2001/06/10 12:56:12 ntiffin Exp $
   
*/

#ifndef CONNECTIONFACTORY_H
#define CONNECTIONFACTORY_H

#include "geas.h"

GEAS_Connection ConnectionFactory_guestLogin (CORBA_Environment * ev);

GEAS_Connection ConnectionFactory_unsecureLogin (const CORBA_char * username,
                                                 const CORBA_char * password,
                                                 CORBA_Environment * ev);

CORBA_char *ConnectionFactory_getAuthenticationKey (CORBA_char * username,
                                                    CORBA_Environment * ev);
GEAS_Connection ConnectionFactory_getConnection (CORBA_char * username,
                                                 CORBA_char * passkey,
                                                 CORBA_Environment * ev);
GEAS_Connection ConnectionFactory_adminLogin (CORBA_char * username,
                                              CORBA_char * passkey,
                                              CORBA_Environment * ev);

#endif /* CONNECTIONFACTORY_H */
