#!/usr/bin/env python

# a test file: relies on GEAS being run from gnue/geas/src
# and this from gnue/geas/examples/python
# name server and other configuration details will be
# completed soon

# $Id: addrbook.py,v 1.16 2001/08/24 21:46:47 reinhard Exp $

import sys
from string import * 

# load CORBA modules
try:
    import CORBA
    # read IDL files for GEAS server
    CORBA._load_idl("../../idl/geas.idl")
    import GEAS
except ImportError,ex:
    print ""
    print "Failed to load CORBA module."
    print "Please see http://sourceforge.net/projects/orbit-python for the required python CORBA bindings"
    print ""
    print "important: the latest version of ORBit-python is required - 0.1.3"
    print "has a bug that prevents it from working with ORBit 0.5.4 or greater"
    print ""
    sys.exit(0)



class GEAS_database:
    def __init__(self):
	self.orb = CORBA.ORB_init( () , "orbit-local-orb" )
	self.ior = open("../../src/geas-server.ior").readline()
	self.factory = self.orb.string_to_object(self.ior)
	try:
	    self.database = self.factory.guestLogin()
	    # self.tr = self.database.new()
	except:
	    print ""
	    print "An error occoured while trying to connect to the server."
	    print ""
	    sys.exit(0)
#    def __del__(self):
#	if self.database:
#	    self.databsae.logout()
    
class AddressBook(GEAS_database):
    def __init__(self):
	GEAS_database.__init__(self)

    def show_countries(self):
	lst = self.database.loadAll("addressbook::country")
	for c in lst.objects:
	    self.database.clearCache()
	    print c.getField("id") , " : " , c.getField("name"), "  ",
            print c.getField("inhabitants"), " inhabitants; US$ ",
            print c.getField("year_budget")
	print ""
	lst.release();

    def add_country(self):
	name = raw_input("Please enter the name of the country          : ")
	id   = raw_input("Please enter the two letter country code      : ")
        inha = raw_input("Please enter the number of inhabitants (32bit): ")
        budg = raw_input("Please enter the yearly budget in US$ (64bit) : ")
	o = self.database.newObject("addressbook::country")
	o.setField( "id"         , id   )
	o.setField( "name"       , name )
        o.setField( "inhabitants", inha )
        o.setField( "year_budget", budg )

    def rename_country(self):
	id = raw_input("Enter the two letter code of the country to delete: ")
	o = self.database.loadSingleObject("addressbook::country","id",id)
	if o == None:
	    print "That country could not be found."
	    print ""
	else:
	    name = raw_input( "Enter a new name for country '" + o.getField("name") + "' " )
	    o.setField( "name" , name )
	    print "New name: Country code " , id , " is now named '" + o.getField("name") + "'"
	    print ""

    def delete_country(self):
	id = raw_input("Enter the two letter code of the country to delete: ")
	o = self.database.loadSingleObject("addressbook::country","id",id)
	if o == None:
	    print "That country could not be found."
	    print ""
	else:
	    yorn = lower( raw_input("Really delete country " + o.getField("name") + "? ('Y' or 'N') ") )
	    if yorn == 'y':
		o.delete()
		print "Deleted"
		print ""
	    else:
		print "Not deleted."
		print ""

    def setup(self):
	while 1:
	    # display (sub) menu
	    print "1 - Show all countries"
	    print "2 - Add country"
	    print "3 - Rename country"
	    print "4 - Delete country"
	    print ""
	    print "M - Return to main menu"
	    print ""

	    # handle selection
	    x = lower(raw_input("Please enter a choice: "))
	    if x == 'm':
		break
	    elif x == '1':
		self.show_countries()
	    elif x == '2':
		self.add_country()
	    elif x == '3':
		self.rename_country()
	    elif x == '4':
		self.delete_country()


    def search(self):
	name = raw_input( "Enter a name to search for: " )
	lst = self.database.loadObjects( "addressbook::person" , "name" , name )
	if lst != None:
	    people = lst.objects
	    length = len(people)
	    print `length` + " entries were found with the name " + name + ":"
	    i = 1;
	    for p in people:
		print ""
		print "Entry " + `i` + " of " + `length`
		print ""
		self.show_single_person( p )
		print ""
		if i != length:
		    raw_input( "Press enter to see the next entry" )
		else:
		    raw_input( "Press enter to return to the main menu" )
		i = i + 1
	    lst.release();
	else:
	    print "No entries were found."
	    print ""

    def show_single_person(self,p):
	try:
	    print "Name          " + p.getField("name")
	    print "Addr (line 1) " + p.getField("addr1")
	    print "Addr (line 2) " + p.getField("addr2")
	    print "Addr (line 3) " + p.getField("addr3")
	    print "Country       " + p.getField("country")
	    print "Birthday      " + p.getField("birthday")
            print "Birth time    " + p.getField("birthtime")
            print "Next appointm." + p.getField("appointment")
            print "# of children " + p.getField("children")
            print "female        " + p.getField("female")
            print "weight        " + p.getField("weight")
            print "comment       " + p.getField("comment")
            # print p.callMethod ("tell_children", [])
	    print ""
	except GEAS.NotDataField,ex:
	    print ex.detail
	    sys.exit(0)

    def show_all(self):
	# self.tr.begin()
	lst = None
	try:
	    lst = self.database.loadAll( "addressbook::person" )
	except GEAS.ServerError,ex: print ex.detail
	if lst != None:
	    people = lst.objects
	    length = len(people)
	    i = 1;
	    for p in people:
		print ""
		print "Entry " + `i` + " of " + `length`
		print ""
		self.show_single_person( p )
		print ""
		if i != length:
		    raw_input( "Press enter to see the next entry" )
		else:
		    raw_input( "Press enter to return to the main menu" )
		i = i + 1
	    lst.release();
	# self.tr.commit()

    def add(self):
	print "Add person to address book:"
	print "(Format: name, addr1, addr2, addr3, country, birthday)"
	print ""

	# enter basic info
	name  = raw_input( "Enter name              : " )
	addr1 = raw_input( "Enter address (line 1/3): " )
	addr2 = raw_input( "Enter address (line 2/3): " )
	addr3 = raw_input( "Enter address (line 3/3): " )
	bday  = raw_input( "Enter birthday          : " )
        btim  = raw_input( "Enter birth time        : " )
        appoi = raw_input( "Enter next appointment  : " )
        child = raw_input( "Enter # children (16bit): " )
        femal = raw_input( "0 = male, 1 = female    : " )
        weigh = raw_input( "Enter weight            : " )
        comm  = raw_input( "Enter comment           : " )

	# select a country
	try:
	    print ""
	    print "Select a country from the following list:"
	    opts = self.database.getLookupFieldOptions( "addressbook::person" , "country" )
	    i = 1
	    for c in opts:
		print `i` + " : " + c.value
		i = i + 1
	    print ""
	    x = 0
	    while x == 0:
		x = atoi( raw_input( "> " ) )
		if x < 1 or x > len(opts):
		    x = 0
		    print "Please enter anumber between 1 and " + `len(opts)`
		    print ""
	except GEAS.UnknownField, ex:
	    print ex.detail
	    sys.exit(0)

	# create the object, fill it with data
	obj = self.database.newObject( "addressbook::person" )
	obj.setField( "name"       , name  )
	obj.setField( "addr1"      , addr1 )
	obj.setField( "addr2"      , addr2 )
	obj.setField( "addr3"      , addr3 )
	obj.setField( "birthday"   , bday  )
        obj.setField( "birthtime"  , btim  )
        obj.setField( "appointment", appoi )
        obj.setField( "children"   , child )
        obj.setField( "female"     , femal )
        obj.setField( "weight"     , weigh )
        obj.setField( "comment"    , comm  )
	obj.setLookupField( opts[x-1] )

	# done
	print ""
	print "Data entered:"
	print ""
	self.show_single_person(obj)
	print ""
	yorn = lower( raw_input( "Is this correct? (y/n) " ) )
	if yorn == 'y':
	    print "Data added"
	    print ""
	else:
	    obj.delete() # remove it, after all
	    print "Data not added"
	    print ""

    def delete(self):
	name = raw_input( "Enter a name to delete: " )
	lst = self.database.loadObjects( "addressbook::person" , "name" , name )
	if lst != None:
	    people = lst.objects
	    length = len(people)
	    print `length` + " entries were found with the name " + name + ":"
	    i = 1;
	    for p in people:
		print ""
		print "Entry " + `i` + " of " + `length`
		print ""
		self.show_single_person( p )
		print ""
		yorn = lower( raw_input( "Delete this person? (Y/N) " ) )
		if yorn == 'y':
		    p.delete()
		    print "Deleted."
		    print ""
		i = i + 1
	else:
	    print "No entries were found."
	    print ""

    def main_loop(self):
	while 1:
	    # display menu
	    print "1 - Search for person"
	    print "2 - Show all people"
	    print "3 - Add new person"
	    print "4 - Delete person"
	    print ""
	    print "S - Setup"
	    print ""
	    print "Q - Quit"
	    print ""

	    # handle selection
	    try:
		x = lower(raw_input("Please enter a choice: "))
	    except GEAS.ServerError,ex:
		print ex.detail
	    if x == 'q':
		break
	    elif x == 's':
		self.setup()
	    elif x == '1':
		self.search()
	    elif x == '2':
		self.show_all()
	    elif x == '3':
		self.add()
	    elif x == '4':
		self.delete()
	    else:
		continue

if __name__ == '__main__':
    print ""
    print "Address Book : GEAS Demo"
    print "Copyright 2001, Free Software Foundation"
    print ""
    print "This is a simple demo of using GEAS from a Python program"
    print ""
    blah = AddressBook()
    blah.main_loop()
    print ""
    print "Thank you for playing."
    print ""
