/* cdd.c: Main program of the sofware cdd
   written by Komei Fukuda, fukuda@ifor.math.ethz.ch
   Version 0.61, December 1, 1997
   Standard ftp site: ftp.ifor.math.ethz.ch, Directory: pub/fukuda/cdd
*/

/* cdd : C-Implementation of the double description method for
   computing all vertices and extreme rays of the polyhedron 
   P= {x :  b - A x >= 0}.
   Please read COPYING (GNU General Public Licence) and
   the manual cddman.tex for detail.
*/

/*  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* The first version C0.21 was created on November 10,1993 
   with Dave Gillespie's p2c translator 
   from the Pascal program pdd.p written by Komei Fukuda. 
*/

#include "config.h"
#include "setoper.h" 
  /* set operation library header (March 16, 1995 version or later) */
#include "cdddef.h"
#include "cdd.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <string.h>

#include "gdis.h"

/* calls to give data back to GDIS struct */
void save_vertex(struct model_pak *);
void save_adj(struct model_pak *, Amatrix);
void save_facet(struct model_pak *);

/* removed a bunch of unused vars, Sean Fleming Feb. 2001 */
rowset EqualitySet=NULL, NonequalitySet=NULL, GroundSet=NULL; 
rowset Face=NULL, Face1=NULL;
rowindex EqualityIndex=NULL;  
rowset InitialHyperplanes=NULL;
rowset AddedHyperplanes=NULL, WeaklyAddedHyperplanes=NULL;
long RayCount=0, FeasibleRayCount=0, WeaklyFeasibleRayCount=0;
long TotalRayCount=0, VertexCount=0, ZeroRayCount=0;
long EdgeCount=0, TotalEdgeCount=0;
long count_int=0, count_int_good=0, count_int_bad=0;
RayRecord *ArtificialRay=NULL, *FirstRay=NULL, *LastRay=NULL;
RayRecord *PosHead=NULL, *ZeroHead=NULL, *NegHead=NULL;
RayRecord *PosLast=NULL, *ZeroLast=NULL, *NegLast=NULL;
boolean RecomputeRowOrder=FALSE, found=FALSE;

HyperplaneOrderType HyperplaneOrder;
AdjacencyTestType AdjacencyTest;
NumberType Number;
AdjacencyRecord *Edges[MMAX];  /* adjacency relation storage for iteration k */
CompStatusType CompStatus;  /* Computation Status */
ErrorType Error;

/* Nondegeneacy preknowledge flag */
boolean NondegAssumed=FALSE;
/* TRUE - initial Basis will be selected at bottom */
boolean InitBasisAtBottom=FALSE;  
/* TRUE - restricted intersection of EqualitySet hyperplanes */
boolean RestrictedEnumeration=FALSE; 
/* TRUE - NonequalitySet inequalities must be satisfied */
boolean RelaxedEnumeration=TRUE;
/* TRUE - rows are ordered & all necessary adjacencies stored */
boolean PreOrderedRun=FALSE; 

unsigned int rseed=1;  /* random seed for random row permutation */

void CheckAdjacency1(rowrange m_size, colrange n_size, Amatrix A, rowindex ordervec,
    RayRecord **RP1, RayRecord **RP2, boolean *adjacent)
{
  long rank;

  *adjacent = TRUE;
  set_int(Face1, (*RP1)->ZeroSet, (*RP2)->ZeroSet);
  set_int(Face, Face1, AddedHyperplanes);
  if (set_card(Face)< n_size - 2) {
    *adjacent = FALSE;
    return;
  }
  else if (NondegAssumed) {
  	*adjacent = TRUE;
  	return;
  }
  ComputeRank(m_size, n_size, A, Face, ordervec, &rank);
  if (rank < n_size - 2){
    *adjacent = FALSE;
  }
}

void CheckAdjacency2(rowrange m_size, colrange n_size, Amatrix A,
    RayRecord **RP1, RayRecord **RP2, boolean *adjacent)
{
  RayRecord *TempRay;

  *adjacent = TRUE;
  set_int(Face1, (*RP1)->ZeroSet, (*RP2)->ZeroSet);
  set_int(Face, Face1, AddedHyperplanes);
  if (set_card(Face)< n_size - 2) {
    *adjacent = FALSE;
    return;
  }
  else if (NondegAssumed) {
  	*adjacent = TRUE;
  	return;
  }
  TempRay = FirstRay;
  while (TempRay != NULL && *adjacent) {
    if (TempRay != *RP1 && TempRay != *RP2) {
    	set_int(Face1, TempRay->ZeroSet, AddedHyperplanes);
      	if (set_subset(Face, Face1)) *adjacent = FALSE;
    }
    TempRay = TempRay->Next;
  }
}

void Eliminate(colrange n_size, RayRecord **Ptr)
{
  /*eliminate the record pointed by Ptr^.Next*/
  RayRecord *TempPtr;

  TempPtr = (*Ptr)->Next;
  (*Ptr)->Next = (*Ptr)->Next->Next;
  if (TempPtr == FirstRay)   /*Update the first pointer*/
    FirstRay = (*Ptr)->Next;
  if (TempPtr == LastRay)   /*Update the last pointer*/
    LastRay = *Ptr;
  free(TempPtr->Ray);          /* free the ray vector memory */
  set_free(TempPtr->ZeroSet);  /* free the ZeroSet memory */
  free(TempPtr);   /* free the RayRecord structure memory */
  RayCount--; 
}

void DDInit(rowrange m_size, colrange n_size, Amatrix A, Bmatrix InitialRays,
    rowindex ordervec)
{
  Error=None;
  CompStatus=InProgress;
  SetInequalitySets(m_size, EqualityIndex);
  set_initialize(&InitialHyperplanes,m_size);
  set_initialize(&AddedHyperplanes,m_size);
  set_initialize(&WeaklyAddedHyperplanes,m_size);
  set_initialize(&Face, m_size);   /* used in CheckAdjacency  */
  set_initialize(&Face1, m_size);  /* used in CheckAdjacency  */
  ComputeRowOrderVector(m_size, n_size, A, ordervec, HyperplaneOrder);
  RecomputeRowOrder=FALSE;
  InitializeBmatrix(n_size, InitialRays);
  RayCount = 0;
  TotalRayCount = 0;
  FeasibleRayCount = 0;
  WeaklyFeasibleRayCount = 0;
  VertexCount = 0;
  EdgeCount=0; /* active edge count */
  TotalEdgeCount=0; /* active edge count */
}

void DDMain(rowrange m_input, colrange n_input, rowrange m_size,
            colrange n_size, Amatrix A, rowrange *Iteration, rowindex ordervec)
{
rowrange hh, itemp, otemp;

*Iteration = n_size + 1;
while (*Iteration <= m_size) 
  {
  SelectNextHyperplane(m_size, n_size, A, HyperplaneOrder, 
                 WeaklyAddedHyperplanes, &hh, &RecomputeRowOrder, ordervec);
  if (set_member(hh,NonequalitySet))
    {  /* Skip the row hh */
    set_addelem(WeaklyAddedHyperplanes, hh);
    } 
  else 
    {
    if (PreOrderedRun)
      AddNewHyperplane2(m_size, n_size, A, hh, *Iteration, ordervec);
    else
      {
      AddNewHyperplane1(m_size, n_size, A, hh, *Iteration, ordervec);
      }

    set_addelem(AddedHyperplanes, hh);
    set_addelem(WeaklyAddedHyperplanes, hh);
    }
  if (!PreOrderedRun)
    {
    for (itemp=1; ordervec[itemp]!=hh; itemp++);
    otemp=ordervec[*Iteration];
    ordervec[*Iteration]=hh;   /* store the dynamic ordering in ordervec */
    ordervec[itemp]=otemp;     /* store the dynamic ordering in ordervec */
    }

  if (CompStatus==AllFound||CompStatus==RegionEmpty) 
    {
    set_addelem(AddedHyperplanes, hh);
    goto _L99;
    }
  (*Iteration)++;
  }
_L99:;
}

void InitialDataSetup(rowrange m_size, colrange n_size, 
    Amatrix A, Bmatrix InitialRays, colindex InitialRayIndex, rowindex ordervec)
{
  long j, r;
  Arow Vector1,Vector2;
  rowset ZSet;

  RecomputeRowOrder=FALSE;
  ArtificialRay = NULL;
  FirstRay = NULL;
  LastRay = NULL;
  set_initialize(&ZSet,m_size);
  AddArtificialRay(m_size, n_size, A, ordervec);
  set_copy(AddedHyperplanes, InitialHyperplanes);
  set_copy(WeaklyAddedHyperplanes, InitialHyperplanes);
  UpdateRowOrderVector(m_size, n_size, InitialHyperplanes, ordervec);
  for (r = 1; r <= n_size; r++) {
    for (j = 0; j < n_size; j++){
      Vector1[j] = InitialRays[j][r-1];
      Vector2[j] = -InitialRays[j][r-1];
    }
    Normalize(n_size, Vector1);
    Normalize(n_size, Vector2);
    ZeroIndexSet(m_size, n_size, A, Vector1, ZSet);
    if (set_subset(EqualitySet, ZSet)){
      AddRay(m_size, n_size, A, Vector1, ordervec);
      if (InitialRayIndex[r]==0) {
        AddRay(m_size, n_size, A, Vector2, ordervec);
      }
    }
  }
  CreateInitialEdges(m_size, n_size, ordervec);
  set_free(ZSet);
}

/* TODO - get rid on n_input - always DIM+1 */
gint DDEnumerate(rowrange m_input, colrange n_input, 
    rowrange m_size, colrange n_size, Amatrix A, struct model_pak *data)
{
Bmatrix InitRays;
colindex InitRayIndex;
rowrange Iteration=0;
rowindex OrderVector;

OrderVector=(long *)calloc(m_size+1, sizeof *OrderVector);
DDInit(m_size, n_size, A, InitRays, OrderVector);
FindInitialRays(m_size, n_size, A, OrderVector, 
    InitialHyperplanes, InitRays, InitRayIndex, &found);

/* removed unecessary stuff, Sean Fleming Feb. 2001 */
if (found) 
  {
  InitialDataSetup(m_size, n_size, A, InitRays, InitRayIndex, OrderVector);
  DDMain(m_input, n_input, m_size, n_size, A, &Iteration, OrderVector);
/* CDD -> GDIS */
  save_vertex(data);
  if (data->num_vertices)
    {
    save_adj(data, A);
    save_facet(data);
    }
  FreeDDMemory(OrderVector);
  } 
else 
  {
/* oh,oh... */
/*
  printf("Bad or insufficient input planes.\n");
*/
  return(1);
  }
return(0);
}

