from libdesklets.controls import Control
from IBoxmail import IBoxmail

import os, mailbox
from os.path import getsize


class Boxmail(Control, IBoxmail):

    def __init__(self):
        self.__boxmail_path = '/var/mail/user'
        self.__mailapp = 'thunderbird'
        self.__updateinterval = 300000
        self.__mails_count = (-1, -1)
        self.__boxmail_size = -1
        self.__subjects = None
        
        self.__timerID = self._add_timer(self.__updateinterval, self.__checkmail)
        Control.__init__(self)

    def __set_boxmail_path(self, path):
        self.__boxmail_path = path

    def __set_mailapp(self, app):
        self.__mailapp = app

    def __set_update(self, update): 
        self.__updateinterval = update * 60000
        #self._remove_timer(self.__timerID)
        self.__timerID = self._add_timer(self.__updateinterval, self.__checkmail)

    def __get_mail(self):
        subjects = []
        msgcount = newmsgcount = 0
        try:
            boxmailsize = getsize(self.__boxmail_path)
            mb = mailbox.PortableUnixMailbox(file(self.__boxmail_path))
            for m in mb:
                msgcount += 1
                status = m.get('status', 'N')
                if status.find('N') != -1:
                    newmsgcount += 1
                    subjects.append(m.getheader('subject')) # only new msgs
            subjects.reverse() # last mails above
        except (OSError, IOError), msg:
            print 'in get_subjects: error: %s' % (msg, )
            newmsgcount, msgcount = -1, -1
            boxmailsize = 0
            subjects = ['Can\'t open mailbox file',
                        'please, check it',
                        '%s' % msg]
        self.__mails_count = (newmsgcount, msgcount)
        self.__boxmail_size = boxmailsize
        self.__subjects = subjects
            
    def __get_mails_count(self):
        return self.__mails_count

    def __get_boxmail_size(self):
        return self.__boxmail_size

    def __get_subjects(self):
        return self.__subjects

    def __launch(self):
        """ launch mail application """
        os.system(self.__mailapp + " &")

    def __checkmail(self):
        """ should not be used often, normally gets called by the timer
        only use it when you want to force a new check (eg. at startup)
        """
        self.__get_mail()
        self._update('mails_count')
        self._update('boxmail_size')
        self._update('subjects')
        return True

    boxmail_path = property(fset=__set_boxmail_path, doc = 'Set mailbox file')
    mailapp = property(fset=__set_mailapp, doc = 'Set the prefered mail application')
    updateinterval = property(fset=__set_update, doc='Set the update period (in seconds)')
    mails_count = property(fget=__get_mails_count, doc = 'Get mail count')
    boxmail_size = property(fget=__get_boxmail_size, doc = 'Get mailbox size')
    subjects = property(fget=__get_subjects, doc = 'Get the subjects of messages')
    launch = property(fget=__launch, doc = 'Launch the mail application')
    checkmail = property(fget=__checkmail, doc='Check for new mail')


def get_class():
    return Boxmail
