
interval = get_config("interval",1000)
cf_c_icon = "imonc"
imond_version = ic.imond_version


def setup_local():
    Dsp.icon.uri = "gfx/imonc/" + cf_c_icon + ".png"

def human_readable(value):
	if value >= (1024**4):
		return "%6.2fT" % (value/(1024.0**4))
	if value >= (1024**3):
		return "%6.2fG" % (value/(1024.0**3))
	if value >= (1024**2):
		return "%6.2fM" % (value/(1024.0**2))
	if value >= 1000:
		return "%6.2fK" % (value/1024.0)
	else : return "%6iB" % value

def _do_tick():
	try:
		global imond_version
		cpu = int(ic.cpu)

		Dsp.l_near.value = "In:\nOut:\nCPU:"
		(in_t, out_t) = ic.rate
		Dsp.ic_in_plotter.value = in_t
		Dsp.ic_out_plotter.value = out_t
		Dsp.ic_cpu_plotter.value = cpu
		Dsp.l_far.value = "%s\n%s\n %i%%" % (human_readable(in_t), human_readable(out_t), cpu)
	except:
		print "tick failed"

	add_timer(interval, _do_tick)
	return False

def update():
    d, t = ("", 0)
    for i in system.net_devices:
        system.iface = i
        a = system.net_load.address
        if a != "0.0.0.0" and i != "lo":
            d += "%s\n"%i
            di, do = system.net_speed
            t += di + do
    Dsp.l_near.value = d
    if d != "":
        Dsp.l_far.value = "%s/s"%normalize(t)
        p = Unit(0, PERCENT)
    else:
        Dsp.l_far.value = ""
        p = Unit(100, PERCENT)
    Dsp.graph.x = p
    Dsp.graph.value = t
    add_timer(int(cf_c_update*1000), update)

watch_prefs(None, None)
add_timer(interval, _do_tick)
